/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.tools.nodetool.stats;

import com.google.common.collect.ArrayListMultimap;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.management.InstanceNotFoundException;
import org.apache.cassandra.db.ColumnFamilyStoreMBean;
import org.apache.cassandra.io.util.FileUtils;
import org.apache.cassandra.metrics.CassandraMetricsRegistry;
import org.apache.cassandra.tools.NodeProbe;
import org.apache.cassandra.tools.nodetool.stats.StatsHolder;
import org.apache.cassandra.tools.nodetool.stats.StatsKeyspace;
import org.apache.cassandra.tools.nodetool.stats.StatsTable;

public class TableStatsHolder
implements StatsHolder {
    public final List<StatsKeyspace> keyspaces = new ArrayList<StatsKeyspace>();
    public final int numberOfTables;

    public TableStatsHolder(NodeProbe probe, boolean humanReadable, boolean ignore, List<String> tableNames) {
        this.numberOfTables = probe.getNumberOfTables();
        this.initializeKeyspaces(probe, humanReadable, ignore, tableNames);
    }

    @Override
    public Map<String, Object> convert2Map() {
        HashMap<String, Object> mpRet = new HashMap<String, Object>();
        mpRet.put("total_number_of_tables", this.numberOfTables);
        for (StatsKeyspace keyspace : this.keyspaces) {
            HashMap<String, Serializable> mpKeyspace = new HashMap<String, Serializable>();
            mpKeyspace.put("read_latency", Double.valueOf(keyspace.readLatency()));
            mpKeyspace.put("read_count", Long.valueOf(keyspace.readCount));
            mpKeyspace.put("read_latency_ms", Double.valueOf(keyspace.readLatency()));
            mpKeyspace.put("write_count", Long.valueOf(keyspace.writeCount));
            mpKeyspace.put("write_latency_ms", Double.valueOf(keyspace.writeLatency()));
            mpKeyspace.put("pending_flushes", Integer.valueOf(keyspace.pendingFlushes));
            List<StatsTable> tables = keyspace.tables;
            HashMap mpTables = new HashMap();
            for (StatsTable table : tables) {
                HashMap<String, Object> mpTable = new HashMap<String, Object>();
                mpTable.put("sstable_count", table.sstableCount);
                mpTable.put("sstables_in_each_level", table.sstablesInEachLevel);
                mpTable.put("space_used_live", table.spaceUsedLive);
                mpTable.put("space_used_total", table.spaceUsedTotal);
                mpTable.put("space_used_by_snapshots_total", table.spaceUsedBySnapshotsTotal);
                if (table.offHeapUsed) {
                    mpTable.put("off_heap_memory_used_total", table.offHeapMemoryUsedTotal);
                }
                mpTable.put("sstable_compression_ratio", table.sstableCompressionRatio);
                mpTable.put("number_of_partitions_estimate", table.numberOfPartitionsEstimate);
                mpTable.put("memtable_cell_count", table.memtableCellCount);
                mpTable.put("memtable_data_size", table.memtableDataSize);
                if (table.memtableOffHeapUsed) {
                    mpTable.put("memtable_off_heap_memory_used", table.memtableOffHeapMemoryUsed);
                }
                mpTable.put("memtable_switch_count", table.memtableSwitchCount);
                mpTable.put("speculative_retries", table.speculativeRetries);
                mpTable.put("local_read_count", table.localReadCount);
                mpTable.put("local_read_latency_ms", String.format("%01.3f", table.localReadLatencyMs));
                mpTable.put("local_write_count", table.localWriteCount);
                mpTable.put("local_write_latency_ms", String.format("%01.3f", table.localWriteLatencyMs));
                mpTable.put("pending_flushes", table.pendingFlushes);
                mpTable.put("percent_repaired", table.percentRepaired);
                mpTable.put("bloom_filter_false_positives", table.bloomFilterFalsePositives);
                mpTable.put("bloom_filter_false_ratio", String.format("%01.5f", table.bloomFilterFalseRatio));
                mpTable.put("bloom_filter_space_used", table.bloomFilterSpaceUsed);
                if (table.bloomFilterOffHeapUsed) {
                    mpTable.put("bloom_filter_off_heap_memory_used", table.bloomFilterOffHeapMemoryUsed);
                }
                if (table.indexSummaryOffHeapUsed) {
                    mpTable.put("index_summary_off_heap_memory_used", table.indexSummaryOffHeapMemoryUsed);
                }
                if (table.compressionMetadataOffHeapUsed) {
                    mpTable.put("compression_metadata_off_heap_memory_used", table.compressionMetadataOffHeapMemoryUsed);
                }
                mpTable.put("compacted_partition_minimum_bytes", table.compactedPartitionMinimumBytes);
                mpTable.put("compacted_partition_maximum_bytes", table.compactedPartitionMaximumBytes);
                mpTable.put("compacted_partition_mean_bytes", table.compactedPartitionMeanBytes);
                mpTable.put("average_live_cells_per_slice_last_five_minutes", table.averageLiveCellsPerSliceLastFiveMinutes);
                mpTable.put("maximum_live_cells_per_slice_last_five_minutes", table.maximumLiveCellsPerSliceLastFiveMinutes);
                mpTable.put("average_tombstones_per_slice_last_five_minutes", table.averageTombstonesPerSliceLastFiveMinutes);
                mpTable.put("maximum_tombstones_per_slice_last_five_minutes", table.maximumTombstonesPerSliceLastFiveMinutes);
                mpTable.put("dropped_mutations", table.droppedMutations);
                mpTables.put(table.name, mpTable);
            }
            mpKeyspace.put("tables", mpTables);
            mpRet.put(keyspace.name, mpKeyspace);
        }
        return mpRet;
    }

    private void initializeKeyspaces(NodeProbe probe, boolean humanReadable, boolean ignore, List<String> tableNames) {
        OptionFilter filter = new OptionFilter(ignore, tableNames);
        ArrayListMultimap selectedTableMbeans = ArrayListMultimap.create();
        HashMap<String, StatsKeyspace> keyspaceStats = new HashMap<String, StatsKeyspace>();
        Iterator<Map.Entry<String, ColumnFamilyStoreMBean>> tableMBeans = probe.getColumnFamilyStoreMBeanProxies();
        while (tableMBeans.hasNext()) {
            Map.Entry<String, ColumnFamilyStoreMBean> entry = tableMBeans.next();
            String keyspaceName = entry.getKey();
            ColumnFamilyStoreMBean tableProxy = entry.getValue();
            if (!filter.isKeyspaceIncluded(keyspaceName)) continue;
            StatsKeyspace stats = (StatsKeyspace)keyspaceStats.get(keyspaceName);
            if (stats == null) {
                stats = new StatsKeyspace(probe, keyspaceName);
                keyspaceStats.put(keyspaceName, stats);
            }
            stats.add(tableProxy);
            if (!filter.isTableIncluded(keyspaceName, tableProxy.getTableName())) continue;
            selectedTableMbeans.put((Object)keyspaceName, (Object)tableProxy);
        }
        filter.verifyKeyspaces(probe.getKeyspaces());
        filter.verifyTables();
        for (Map.Entry entry : selectedTableMbeans.asMap().entrySet()) {
            String keyspaceName = (String)entry.getKey();
            Collection tables = (Collection)entry.getValue();
            StatsKeyspace statsKeyspace = (StatsKeyspace)keyspaceStats.get(keyspaceName);
            for (ColumnFamilyStoreMBean table : tables) {
                double localWLatency;
                double localRLatency;
                Double percentRepaired;
                Long offHeapSize;
                Long compressionMetadataOffHeapSize;
                Long indexSummaryOffHeapSize;
                Long bloomFilterOffHeapSize;
                Long memtableOffHeapSize;
                StatsTable statsTable;
                String tableName;
                block16: {
                    tableName = table.getTableName();
                    statsTable = new StatsTable();
                    statsTable.name = tableName;
                    statsTable.isIndex = tableName.contains(".");
                    statsTable.sstableCount = probe.getColumnFamilyMetric(keyspaceName, tableName, "LiveSSTableCount");
                    int[] leveledSStables = table.getSSTableCountPerLevel();
                    if (leveledSStables != null) {
                        statsTable.isLeveledSstable = true;
                        for (int level = 0; level < leveledSStables.length; ++level) {
                            int count = leveledSStables[level];
                            long maxCount = 4L;
                            if (level > 0) {
                                maxCount = (long)Math.pow(table.getLevelFanoutSize(), level);
                            }
                            statsTable.sstablesInEachLevel.add(count + ((long)count > maxCount ? "/" + maxCount : ""));
                        }
                    }
                    memtableOffHeapSize = null;
                    bloomFilterOffHeapSize = null;
                    indexSummaryOffHeapSize = null;
                    compressionMetadataOffHeapSize = null;
                    offHeapSize = null;
                    percentRepaired = null;
                    try {
                        memtableOffHeapSize = (Long)probe.getColumnFamilyMetric(keyspaceName, tableName, "MemtableOffHeapSize");
                        bloomFilterOffHeapSize = (Long)probe.getColumnFamilyMetric(keyspaceName, tableName, "BloomFilterOffHeapMemoryUsed");
                        indexSummaryOffHeapSize = (Long)probe.getColumnFamilyMetric(keyspaceName, tableName, "IndexSummaryOffHeapMemoryUsed");
                        compressionMetadataOffHeapSize = (Long)probe.getColumnFamilyMetric(keyspaceName, tableName, "CompressionMetadataOffHeapMemoryUsed");
                        offHeapSize = memtableOffHeapSize + bloomFilterOffHeapSize + indexSummaryOffHeapSize + compressionMetadataOffHeapSize;
                        percentRepaired = (Double)probe.getColumnFamilyMetric(keyspaceName, tableName, "PercentRepaired");
                    }
                    catch (RuntimeException e) {
                        if (e.getCause() instanceof InstanceNotFoundException) break block16;
                        throw e;
                    }
                }
                statsTable.spaceUsedLive = this.format((Long)probe.getColumnFamilyMetric(keyspaceName, tableName, "LiveDiskSpaceUsed"), humanReadable);
                statsTable.spaceUsedTotal = this.format((Long)probe.getColumnFamilyMetric(keyspaceName, tableName, "TotalDiskSpaceUsed"), humanReadable);
                statsTable.spaceUsedBySnapshotsTotal = this.format((Long)probe.getColumnFamilyMetric(keyspaceName, tableName, "SnapshotsSize"), humanReadable);
                if (offHeapSize != null) {
                    statsTable.offHeapUsed = true;
                    statsTable.offHeapMemoryUsedTotal = this.format(offHeapSize, humanReadable);
                }
                if (percentRepaired != null) {
                    statsTable.percentRepaired = (double)Math.round(100.0 * percentRepaired) / 100.0;
                }
                statsTable.sstableCompressionRatio = probe.getColumnFamilyMetric(keyspaceName, tableName, "CompressionRatio");
                Object estimatedPartitionCount = probe.getColumnFamilyMetric(keyspaceName, tableName, "EstimatedPartitionCount");
                if (Long.valueOf(-1L).equals(estimatedPartitionCount)) {
                    estimatedPartitionCount = 0L;
                }
                statsTable.numberOfPartitionsEstimate = estimatedPartitionCount;
                statsTable.memtableCellCount = probe.getColumnFamilyMetric(keyspaceName, tableName, "MemtableColumnsCount");
                statsTable.memtableDataSize = this.format((Long)probe.getColumnFamilyMetric(keyspaceName, tableName, "MemtableLiveDataSize"), humanReadable);
                if (memtableOffHeapSize != null) {
                    statsTable.memtableOffHeapUsed = true;
                    statsTable.memtableOffHeapMemoryUsed = this.format(memtableOffHeapSize, humanReadable);
                }
                statsTable.memtableSwitchCount = probe.getColumnFamilyMetric(keyspaceName, tableName, "MemtableSwitchCount");
                statsTable.speculativeRetries = probe.getColumnFamilyMetric(keyspaceName, tableName, "SpeculativeRetries");
                statsTable.localReadCount = ((CassandraMetricsRegistry.JmxTimerMBean)probe.getColumnFamilyMetric(keyspaceName, tableName, "ReadLatency")).getCount();
                double localReadLatency = ((CassandraMetricsRegistry.JmxTimerMBean)probe.getColumnFamilyMetric(keyspaceName, tableName, "ReadLatency")).getMean() / 1000.0;
                statsTable.localReadLatencyMs = localRLatency = localReadLatency > 0.0 ? localReadLatency : Double.NaN;
                statsTable.localWriteCount = ((CassandraMetricsRegistry.JmxTimerMBean)probe.getColumnFamilyMetric(keyspaceName, tableName, "WriteLatency")).getCount();
                double localWriteLatency = ((CassandraMetricsRegistry.JmxTimerMBean)probe.getColumnFamilyMetric(keyspaceName, tableName, "WriteLatency")).getMean() / 1000.0;
                statsTable.localWriteLatencyMs = localWLatency = localWriteLatency > 0.0 ? localWriteLatency : Double.NaN;
                statsTable.pendingFlushes = probe.getColumnFamilyMetric(keyspaceName, tableName, "PendingFlushes");
                statsTable.bloomFilterFalsePositives = probe.getColumnFamilyMetric(keyspaceName, tableName, "BloomFilterFalsePositives");
                statsTable.bloomFilterFalseRatio = probe.getColumnFamilyMetric(keyspaceName, tableName, "RecentBloomFilterFalseRatio");
                statsTable.bloomFilterSpaceUsed = this.format((Long)probe.getColumnFamilyMetric(keyspaceName, tableName, "BloomFilterDiskSpaceUsed"), humanReadable);
                if (bloomFilterOffHeapSize != null) {
                    statsTable.bloomFilterOffHeapUsed = true;
                    statsTable.bloomFilterOffHeapMemoryUsed = this.format(bloomFilterOffHeapSize, humanReadable);
                }
                if (indexSummaryOffHeapSize != null) {
                    statsTable.indexSummaryOffHeapUsed = true;
                    statsTable.indexSummaryOffHeapMemoryUsed = this.format(indexSummaryOffHeapSize, humanReadable);
                }
                if (compressionMetadataOffHeapSize != null) {
                    statsTable.compressionMetadataOffHeapUsed = true;
                    statsTable.compressionMetadataOffHeapMemoryUsed = this.format(compressionMetadataOffHeapSize, humanReadable);
                }
                statsTable.compactedPartitionMinimumBytes = (Long)probe.getColumnFamilyMetric(keyspaceName, tableName, "MinPartitionSize");
                statsTable.compactedPartitionMaximumBytes = (Long)probe.getColumnFamilyMetric(keyspaceName, tableName, "MaxPartitionSize");
                statsTable.compactedPartitionMeanBytes = (Long)probe.getColumnFamilyMetric(keyspaceName, tableName, "MeanPartitionSize");
                CassandraMetricsRegistry.JmxHistogramMBean histogram = (CassandraMetricsRegistry.JmxHistogramMBean)probe.getColumnFamilyMetric(keyspaceName, tableName, "LiveScannedHistogram");
                statsTable.averageLiveCellsPerSliceLastFiveMinutes = histogram.getMean();
                statsTable.maximumLiveCellsPerSliceLastFiveMinutes = histogram.getMax();
                histogram = (CassandraMetricsRegistry.JmxHistogramMBean)probe.getColumnFamilyMetric(keyspaceName, tableName, "TombstoneScannedHistogram");
                statsTable.averageTombstonesPerSliceLastFiveMinutes = histogram.getMean();
                statsTable.maximumTombstonesPerSliceLastFiveMinutes = histogram.getMax();
                statsTable.droppedMutations = this.format((Long)probe.getColumnFamilyMetric(keyspaceName, tableName, "DroppedMutations"), humanReadable);
                statsKeyspace.tables.add(statsTable);
            }
            this.keyspaces.add(statsKeyspace);
        }
    }

    private String format(long bytes, boolean humanReadable) {
        return humanReadable ? FileUtils.stringifyFileSize(bytes) : Long.toString(bytes);
    }

    private static class OptionFilter {
        private final Map<String, List<String>> filter = new HashMap<String, List<String>>();
        private final Map<String, List<String>> verifier = new HashMap<String, List<String>>();
        private final List<String> filterList = new ArrayList<String>();
        private final boolean ignoreMode;

        OptionFilter(boolean ignoreMode, List<String> filterList) {
            this.filterList.addAll(filterList);
            this.ignoreMode = ignoreMode;
            for (String s : filterList) {
                String[] keyValues = s.split("\\.", 2);
                if (!this.filter.containsKey(keyValues[0])) {
                    this.filter.put(keyValues[0], new ArrayList());
                    this.verifier.put(keyValues[0], new ArrayList());
                }
                if (keyValues.length != 2) continue;
                this.filter.get(keyValues[0]).add(keyValues[1]);
                this.verifier.get(keyValues[0]).add(keyValues[1]);
            }
        }

        public boolean isTableIncluded(String keyspace, String table) {
            if (this.filterList.isEmpty()) {
                return !this.ignoreMode;
            }
            List<String> tables = this.filter.get(keyspace);
            if (tables == null) {
                return this.ignoreMode;
            }
            if (tables.isEmpty()) {
                return !this.ignoreMode;
            }
            this.verifier.get(keyspace).remove(table);
            return this.ignoreMode ^ tables.contains(table);
        }

        public boolean isKeyspaceIncluded(String keyspace) {
            if (this.filterList.isEmpty()) {
                return !this.ignoreMode;
            }
            return this.filter.get(keyspace) != null || this.ignoreMode;
        }

        public void verifyKeyspaces(List<String> keyspaces) {
            for (String ks : this.verifier.keySet()) {
                if (keyspaces.contains(ks)) continue;
                throw new IllegalArgumentException("Unknown keyspace: " + ks);
            }
        }

        public void verifyTables() {
            for (String ks : this.filter.keySet()) {
                if (this.verifier.get(ks).isEmpty()) continue;
                throw new IllegalArgumentException("Unknown tables: " + this.verifier.get(ks) + " in keyspace: " + ks);
            }
        }
    }
}

