/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.service.deploy.worker;

import com.google.common.base.Throwables;
import com.google.protobuf.GeneratedMessageV3;
import com.google.protobuf.ProtocolStringList;
import io.netty.channel.Channel;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import org.apache.celeborn.common.CelebornConf;
import org.apache.celeborn.common.CelebornConf$;
import org.apache.celeborn.common.exception.CelebornIOException;
import org.apache.celeborn.common.internal.Logging;
import org.apache.celeborn.common.meta.DiskFileInfo;
import org.apache.celeborn.common.meta.FileInfo;
import org.apache.celeborn.common.meta.FileMeta;
import org.apache.celeborn.common.meta.MapFileMeta;
import org.apache.celeborn.common.meta.MemoryFileInfo;
import org.apache.celeborn.common.meta.ReduceFileMeta;
import org.apache.celeborn.common.meta.TimeWindow;
import org.apache.celeborn.common.network.buffer.ChunkBuffers;
import org.apache.celeborn.common.network.buffer.FileChunkBuffers;
import org.apache.celeborn.common.network.buffer.ManagedBuffer;
import org.apache.celeborn.common.network.buffer.MemoryChunkBuffers;
import org.apache.celeborn.common.network.buffer.NioManagedBuffer;
import org.apache.celeborn.common.network.client.RpcResponseCallback;
import org.apache.celeborn.common.network.client.TransportClient;
import org.apache.celeborn.common.network.protocol.BufferStreamEnd;
import org.apache.celeborn.common.network.protocol.ChunkFetchFailure;
import org.apache.celeborn.common.network.protocol.ChunkFetchRequest;
import org.apache.celeborn.common.network.protocol.ChunkFetchSuccess;
import org.apache.celeborn.common.network.protocol.Message;
import org.apache.celeborn.common.network.protocol.OpenStream;
import org.apache.celeborn.common.network.protocol.OpenStreamWithCredit;
import org.apache.celeborn.common.network.protocol.ReadAddCredit;
import org.apache.celeborn.common.network.protocol.RequestMessage;
import org.apache.celeborn.common.network.protocol.RpcRequest;
import org.apache.celeborn.common.network.protocol.RpcResponse;
import org.apache.celeborn.common.network.protocol.StreamChunkSlice;
import org.apache.celeborn.common.network.protocol.StreamHandle;
import org.apache.celeborn.common.network.protocol.TransportMessage;
import org.apache.celeborn.common.network.server.BaseMessageHandler;
import org.apache.celeborn.common.network.util.NettyUtils;
import org.apache.celeborn.common.network.util.TransportConf;
import org.apache.celeborn.common.protocol.MessageType;
import org.apache.celeborn.common.protocol.PbBufferStreamEnd;
import org.apache.celeborn.common.protocol.PbChunkFetchRequest;
import org.apache.celeborn.common.protocol.PbOpenStream;
import org.apache.celeborn.common.protocol.PbOpenStreamList;
import org.apache.celeborn.common.protocol.PbOpenStreamListResponse;
import org.apache.celeborn.common.protocol.PbReadAddCredit;
import org.apache.celeborn.common.protocol.PbStreamChunkSlice;
import org.apache.celeborn.common.protocol.PbStreamHandler;
import org.apache.celeborn.common.protocol.PbStreamHandlerOpt;
import org.apache.celeborn.common.protocol.StreamType;
import org.apache.celeborn.common.protocol.message.StatusCode;
import org.apache.celeborn.common.util.ExceptionUtils;
import org.apache.celeborn.common.util.Utils$;
import org.apache.celeborn.service.deploy.worker.Worker;
import org.apache.celeborn.service.deploy.worker.WorkerSource;
import org.apache.celeborn.service.deploy.worker.WorkerSource$;
import org.apache.celeborn.service.deploy.worker.storage.ChunkStreamManager;
import org.apache.celeborn.service.deploy.worker.storage.CreditStreamManager;
import org.apache.celeborn.service.deploy.worker.storage.PartitionFilesSorter;
import org.apache.celeborn.service.deploy.worker.storage.StorageManager;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\rub\u0001B\u00193\u0001}B\u0001\u0002\u0015\u0001\u0003\u0006\u0004%\t!\u0015\u0005\t-\u0002\u0011\t\u0011)A\u0005%\"Aq\u000b\u0001BC\u0002\u0013\u0005\u0001\f\u0003\u0005`\u0001\t\u0005\t\u0015!\u0003Z\u0011!\u0001\u0007A!b\u0001\n\u0003\t\u0007\u0002\u00034\u0001\u0005\u0003\u0005\u000b\u0011\u00022\t\u000b\u001d\u0004A\u0011\u00015\t\u000f5\u0004!\u0019!C\u0001]\"1Q\u000f\u0001Q\u0001\n=DqA\u001e\u0001C\u0002\u0013\u0005q\u000fC\u0004\u0002\u0004\u0001\u0001\u000b\u0011\u0002=\t\u0013\u0005\u0015\u0001A1A\u0005\u0002\u0005\u001d\u0001\u0002CA\b\u0001\u0001\u0006I!!\u0003\t\u0017\u0005E\u0001\u00011AA\u0002\u0013\u0005\u00111\u0003\u0005\f\u00037\u0001\u0001\u0019!a\u0001\n\u0003\ti\u0002C\u0006\u0002*\u0001\u0001\r\u0011!Q!\n\u0005U\u0001bCA\u0016\u0001\u0001\u0007\t\u0019!C\u0001\u0003[A1\"!\u000e\u0001\u0001\u0004\u0005\r\u0011\"\u0001\u00028!Y\u00111\b\u0001A\u0002\u0003\u0005\u000b\u0015BA\u0018\u0011%\ti\u0004\u0001a\u0001\n\u0003\ty\u0004C\u0005\u0002Z\u0001\u0001\r\u0011\"\u0001\u0002\\!A\u0011q\f\u0001!B\u0013\t\t\u0005C\u0004\u0002b\u0001!\t!a\u0019\t\u000f\u00055\u0004\u0001\"\u0001\u0002p!9\u00111\u0014\u0001\u0005B\u0005u\u0005bBAN\u0001\u0011\u0005\u0013q\u0019\u0005\b\u0003\u001b\u0004A\u0011BAh\u0011\u001d\ty\u000e\u0001C\u0005\u0003CDq!!;\u0001\t\u0013\tY\u000fC\u0005\u0003\u0016\u0001\t\n\u0011\"\u0003\u0003\u0018!9!Q\u0006\u0001\u0005\n\t=\u0002\"\u0003B&\u0001E\u0005I\u0011\u0002B\f\u0011\u001d\u0011i\u0005\u0001C\u0005\u0005\u001fB\u0011B!\u001f\u0001#\u0003%IAa\u001f\t\u0013\t}\u0004!%A\u0005\n\t\u0005\u0005b\u0002BC\u0001\u0011%!q\u0011\u0005\b\u0005+\u0003A\u0011\u0002BL\u0011\u001d\u0011)\f\u0001C\u0005\u0005oCqAa1\u0001\t\u0003\u0011)\rC\u0004\u0003D\u0002!\tAa3\t\u000f\tm\u0007\u0001\"\u0001\u0003^\"9!q\u001d\u0001\u0005\u0002\t%\bb\u0002B~\u0001\u0011\u0005#Q \u0005\b\u0005\u007f\u0004A\u0011IB\u0001\u0011\u001d\u0019)\u0001\u0001C!\u0007\u000fAqaa\u0003\u0001\t\u0003\u001ai\u0001C\u0004\u0004(\u0001!\ta!\u000b\t\u000f\rU\u0002\u0001\"\u0001\u00048\taa)\u001a;dQ\"\u000bg\u000e\u001a7fe*\u00111\u0007N\u0001\u0007o>\u00148.\u001a:\u000b\u0005U2\u0014A\u00023fa2|\u0017P\u0003\u00028q\u000591/\u001a:wS\u000e,'BA\u001d;\u0003!\u0019W\r\\3c_Jt'BA\u001e=\u0003\u0019\t\u0007/Y2iK*\tQ(A\u0002pe\u001e\u001c\u0001aE\u0002\u0001\u0001*\u0003\"!\u0011%\u000e\u0003\tS!a\u0011#\u0002\rM,'O^3s\u0015\t)e)A\u0004oKR<xN]6\u000b\u0005\u001dC\u0014AB2p[6|g.\u0003\u0002J\u0005\n\u0011\")Y:f\u001b\u0016\u001c8/Y4f\u0011\u0006tG\r\\3s!\tYe*D\u0001M\u0015\tie)\u0001\u0005j]R,'O\\1m\u0013\tyEJA\u0004M_\u001e<\u0017N\\4\u0002\t\r|gNZ\u000b\u0002%B\u00111\u000bV\u0007\u0002\r&\u0011QK\u0012\u0002\r\u0007\u0016dWMY8s]\u000e{gNZ\u0001\u0006G>tg\rI\u0001\u000eiJ\fgn\u001d9peR\u001cuN\u001c4\u0016\u0003e\u0003\"AW/\u000e\u0003mS!\u0001\u0018#\u0002\tU$\u0018\u000e\\\u0005\u0003=n\u0013Q\u0002\u0016:b]N\u0004xN\u001d;D_:4\u0017A\u0004;sC:\u001c\bo\u001c:u\u0007>tg\rI\u0001\ro>\u00148.\u001a:T_V\u00148-Z\u000b\u0002EB\u00111\rZ\u0007\u0002e%\u0011QM\r\u0002\r/>\u00148.\u001a:T_V\u00148-Z\u0001\u000eo>\u00148.\u001a:T_V\u00148-\u001a\u0011\u0002\rqJg.\u001b;?)\u0011I'n\u001b7\u0011\u0005\r\u0004\u0001\"\u0002)\b\u0001\u0004\u0011\u0006\"B,\b\u0001\u0004I\u0006\"\u00021\b\u0001\u0004\u0011\u0017AE2ik:\\7\u000b\u001e:fC6l\u0015M\\1hKJ,\u0012a\u001c\t\u0003aNl\u0011!\u001d\u0006\u0003eJ\nqa\u001d;pe\u0006<W-\u0003\u0002uc\n\u00112\t[;oWN#(/Z1n\u001b\u0006t\u0017mZ3s\u0003M\u0019\u0007.\u001e8l'R\u0014X-Y7NC:\fw-\u001a:!\u0003ai\u0017\r_\"ik:\\')Z5oOR\u0013\u0018M\\:gKJ\u0014X\rZ\u000b\u0002qB\u0019\u0011\u0010 @\u000e\u0003iT\u0011a_\u0001\u0006g\u000e\fG.Y\u0005\u0003{j\u0014aa\u00149uS>t\u0007CA=\u0000\u0013\r\t\tA\u001f\u0002\u0005\u0019>tw-A\rnCb\u001c\u0005.\u001e8l\u0005\u0016Lgn\u001a+sC:\u001ch-\u001a:sK\u0012\u0004\u0013aE2sK\u0012LGo\u0015;sK\u0006lW*\u00198bO\u0016\u0014XCAA\u0005!\r\u0001\u00181B\u0005\u0004\u0003\u001b\t(aE\"sK\u0012LGo\u0015;sK\u0006lW*\u00198bO\u0016\u0014\u0018\u0001F2sK\u0012LGo\u0015;sK\u0006lW*\u00198bO\u0016\u0014\b%\u0001\bti>\u0014\u0018mZ3NC:\fw-\u001a:\u0016\u0005\u0005U\u0001c\u00019\u0002\u0018%\u0019\u0011\u0011D9\u0003\u001dM#xN]1hK6\u000bg.Y4fe\u0006\u00112\u000f^8sC\u001e,W*\u00198bO\u0016\u0014x\fJ3r)\u0011\ty\"!\n\u0011\u0007e\f\t#C\u0002\u0002$i\u0014A!\u00168ji\"I\u0011qE\b\u0002\u0002\u0003\u0007\u0011QC\u0001\u0004q\u0012\n\u0014aD:u_J\fw-Z'b]\u0006<WM\u001d\u0011\u0002!A\f'\u000f^5uS>t7oU8si\u0016\u0014XCAA\u0018!\r\u0001\u0018\u0011G\u0005\u0004\u0003g\t(\u0001\u0006)beRLG/[8o\r&dWm]*peR,'/\u0001\u000bqCJ$\u0018\u000e^5p]N\u001cvN\u001d;fe~#S-\u001d\u000b\u0005\u0003?\tI\u0004C\u0005\u0002(I\t\t\u00111\u0001\u00020\u0005\t\u0002/\u0019:uSRLwN\\:T_J$XM\u001d\u0011\u0002\u0015I,w-[:uKJ,G-\u0006\u0002\u0002BA!\u0011\u0010`A\"!\u0011\t)%!\u0016\u000e\u0005\u0005\u001d#\u0002BA%\u0003\u0017\na!\u0019;p[&\u001c'\u0002BA'\u0003\u001f\n!bY8oGV\u0014(/\u001a8u\u0015\ra\u0016\u0011\u000b\u0006\u0003\u0003'\nAA[1wC&!\u0011qKA$\u00055\tEo\\7jG\n{w\u000e\\3b]\u0006q!/Z4jgR,'/\u001a3`I\u0015\fH\u0003BA\u0010\u0003;B\u0011\"a\n\u0016\u0003\u0003\u0005\r!!\u0011\u0002\u0017I,w-[:uKJ,G\rI\u0001\u0005S:LG\u000f\u0006\u0003\u0002 \u0005\u0015\u0004BB\u001a\u0018\u0001\u0004\t9\u0007E\u0002d\u0003SJ1!a\u001b3\u0005\u00199vN]6fe\u0006qq-\u001a;SC^4\u0015\u000e\\3J]\u001a|GCBA9\u0003{\n9\n\u0005\u0003\u0002t\u0005eTBAA;\u0015\r\t9HR\u0001\u0005[\u0016$\u0018-\u0003\u0003\u0002|\u0005U$\u0001\u0003$jY\u0016LeNZ8\t\u000f\u0005}\u0004\u00041\u0001\u0002\u0002\u0006Q1\u000f[;gM2,7*Z=\u0011\t\u0005\r\u0015\u0011\u0013\b\u0005\u0003\u000b\u000bi\tE\u0002\u0002\bjl!!!#\u000b\u0007\u0005-e(\u0001\u0004=e>|GOP\u0005\u0004\u0003\u001fS\u0018A\u0002)sK\u0012,g-\u0003\u0003\u0002\u0014\u0006U%AB*ue&twMC\u0002\u0002\u0010jDq!!'\u0019\u0001\u0004\t\t)\u0001\u0005gS2,g*Y7f\u0003\u001d\u0011XmY3jm\u0016$\u0002\"a\b\u0002 \u00065\u0016Q\u0018\u0005\b\u0003CK\u0002\u0019AAR\u0003\u0019\u0019G.[3oiB!\u0011QUAU\u001b\t\t9KC\u0002\u0002\"\u0012KA!a+\u0002(\nyAK]1ogB|'\u000f^\"mS\u0016tG\u000fC\u0004\u00020f\u0001\r!!-\u0002\u00075\u001cx\r\u0005\u0003\u00024\u0006eVBAA[\u0015\r\t9\fR\u0001\taJ|Go\\2pY&!\u00111XA[\u00059\u0011V-];fgRlUm]:bO\u0016Dq!a0\u001a\u0001\u0004\t\t-\u0001\u0005dC2d'-Y2l!\u0011\t)+a1\n\t\u0005\u0015\u0017q\u0015\u0002\u0014%B\u001c'+Z:q_:\u001cXmQ1mY\n\f7m\u001b\u000b\u0007\u0003?\tI-a3\t\u000f\u0005\u0005&\u00041\u0001\u0002$\"9\u0011q\u0016\u000eA\u0002\u0005E\u0016\u0001\u00055b]\u0012dWM\u00159d%\u0016\fX/Z:u)!\ty\"!5\u0002T\u0006u\u0007bBAQ7\u0001\u0007\u00111\u0015\u0005\b\u0003+\\\u0002\u0019AAl\u0003)\u0011\bo\u0019*fcV,7\u000f\u001e\t\u0005\u0003g\u000bI.\u0003\u0003\u0002\\\u0006U&A\u0003*qGJ+\u0017/^3ti\"9\u0011qX\u000eA\u0002\u0005\u0005\u0017A\u00065b]\u0012dW\rT3hC\u000eL(\u000b]2NKN\u001c\u0018mZ3\u0015\u0011\u0005}\u00111]As\u0003ODq!!)\u001d\u0001\u0004\t\u0019\u000bC\u0004\u0002Vr\u0001\r!a6\t\u000f\u0005}F\u00041\u0001\u0002B\u0006q\u0002.\u00198eY\u0016\u0014V\rZ;dK>\u0003XM\\*ue\u0016\fW.\u00138uKJt\u0017\r\u001c\u000b\u000f\u0003[\f90!?\u0002|\u0006u(q\u0001B\u0006!\u0011\ty/a=\u000e\u0005\u0005E(bAA\\\r&!\u0011Q_Ay\u0005I\u0001&m\u0015;sK\u0006l\u0007*\u00198eY\u0016\u0014x\n\u001d;\t\u000f\u0005\u0005V\u00041\u0001\u0002$\"9\u0011qP\u000fA\u0002\u0005\u0005\u0005bBAM;\u0001\u0007\u0011\u0011\u0011\u0005\b\u0003\u007fl\u0002\u0019\u0001B\u0001\u0003)\u0019H/\u0019:u\u0013:$W\r\u001f\t\u0004s\n\r\u0011b\u0001B\u0003u\n\u0019\u0011J\u001c;\t\u000f\t%Q\u00041\u0001\u0003\u0002\u0005AQM\u001c3J]\u0012,\u0007\u0010C\u0005\u0003\u000eu\u0001\n\u00111\u0001\u0003\u0010\u0005\u0001\"/Z1e\u0019>\u001c\u0017\r\\*ik\u001a4G.\u001a\t\u0004s\nE\u0011b\u0001B\nu\n9!i\\8mK\u0006t\u0017\u0001\u000b5b]\u0012dWMU3ek\u000e,w\n]3o'R\u0014X-Y7J]R,'O\\1mI\u0011,g-Y;mi\u00122TC\u0001B\rU\u0011\u0011yAa\u0007,\u0005\tu\u0001\u0003\u0002B\u0010\u0005Si!A!\t\u000b\t\t\r\"QE\u0001\nk:\u001c\u0007.Z2lK\u0012T1Aa\n{\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0005W\u0011\tCA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\f\u0001\u0004[1oI2,w\n]3o'R\u0014X-Y7J]R,'O\\1m)Y\tyB!\r\u00034\tU\"q\u0007B\u001d\u0005w\u0011yDa\u0011\u0003H\t%\u0003bBAQ?\u0001\u0007\u00111\u0015\u0005\b\u0003\u007fz\u0002\u0019AAA\u0011\u001d\tIj\ba\u0001\u0003\u0003Cq!a@ \u0001\u0004\u0011\t\u0001C\u0004\u0003\n}\u0001\rA!\u0001\t\u000f\tur\u00041\u0001\u0003\u0002\u0005i\u0011N\\5uS\u0006d7I]3eSRDaA!\u0011 \u0001\u0004q\u0018\u0001\u0004:qGJ+\u0017/^3ti&#\u0007b\u0002B#?\u0001\u0007!qB\u0001\tSNdUmZ1ds\"I!QB\u0010\u0011\u0002\u0003\u0007!q\u0002\u0005\b\u0003\u007f{\u0002\u0019AAa\u0003\tB\u0017M\u001c3mK>\u0003XM\\*ue\u0016\fW.\u00138uKJt\u0017\r\u001c\u0013eK\u001a\fW\u000f\u001c;%s\u0005\tR.Y6f'R\u0014X-Y7IC:$G.\u001a:\u0015\u0015\tE#q\u000bB.\u0005?\u0012)\b\u0005\u0003\u0002p\nM\u0013\u0002\u0002B+\u0003c\u0014q\u0002\u00152TiJ,\u0017-\u001c%b]\u0012dWM\u001d\u0005\u0007\u00053\n\u0003\u0019\u0001@\u0002\u0011M$(/Z1n\u0013\u0012DqA!\u0018\"\u0001\u0004\u0011\t!A\u0005ok6\u001c\u0005.\u001e8lg\"I!\u0011M\u0011\u0011\u0002\u0003\u0007!1M\u0001\b_\u001a47/\u001a;t!\u0019\u0011)Ga\u001a\u0003l5\u0011\u0011qJ\u0005\u0005\u0005S\nyE\u0001\u0003MSN$\b\u0003\u0002B7\u0005gj!Aa\u001c\u000b\t\tE\u0014\u0011K\u0001\u0005Y\u0006tw-\u0003\u0003\u0002\u0002\t=\u0004\"\u0003B<CA\u0005\t\u0019AAA\u0003!1\u0017\u000e\\3qCRD\u0017aG7bW\u0016\u001cFO]3b[\"\u000bg\u000e\u001a7fe\u0012\"WMZ1vYR$3'\u0006\u0002\u0003~)\"!1\rB\u000e\u0003mi\u0017m[3TiJ,\u0017-\u001c%b]\u0012dWM\u001d\u0013eK\u001a\fW\u000f\u001c;%iU\u0011!1\u0011\u0016\u0005\u0003\u0003\u0013Y\"\u0001\nsKBd\u0017p\u0015;sK\u0006l\u0007*\u00198eY\u0016\u0014HCCA\u0010\u0005\u0013\u0013YIa$\u0003\u0014\"9\u0011\u0011\u0015\u0013A\u0002\u0005\r\u0006B\u0002BGI\u0001\u0007a0A\u0005sKF,Xm\u001d;JI\"9!\u0011\u0013\u0013A\u0002\tE\u0013a\u00049c'R\u0014X-Y7IC:$G.\u001a:\t\u000f\t\u0015C\u00051\u0001\u0003\u0010\u0005!\u0002.\u00198eY\u0016\u0014\u0006oY%P\u000bb\u001cW\r\u001d;j_:$b\"a\b\u0003\u001a\nm%Q\u0014BP\u0005C\u0013\t\fC\u0004\u0002\"\u0016\u0002\r!a)\t\r\t5U\u00051\u0001\u007f\u0011\u001d\ty(\na\u0001\u0003\u0003Cq!!'&\u0001\u0004\t\t\tC\u0004\u0003$\u0016\u0002\rA!*\u0002\u0007%|W\r\u0005\u0003\u0003(\n5VB\u0001BU\u0015\u0011\u0011Y+!\u0015\u0002\u0005%|\u0017\u0002\u0002BX\u0005S\u00131\"S(Fq\u000e,\u0007\u000f^5p]\"9!1W\u0013A\u0002\u0005\u0005\u0017a\u0003:qG\u000e\u000bG\u000e\u001c2bG.\f!\u0003[1oI2,'\u000b]2Fq\u000e,\u0007\u000f^5p]RQ\u0011q\u0004B]\u0005w\u0013iLa0\t\u000f\u0005\u0005f\u00051\u0001\u0002$\"1!Q\u0012\u0014A\u0002yDqAa)'\u0001\u0004\u0011)\u000bC\u0004\u0003B\u001a\u0002\r!!1\u0002'I\u00048MU3ta>t7/Z\"bY2\u0014\u0017mY6\u00023!\fg\u000e\u001a7f\u000b:$7\u000b\u001e:fC64%o\\7DY&,g\u000e\u001e\u000b\u0007\u0003?\u00119M!3\t\u000f\u0005\u0005v\u00051\u0001\u0002$\"1!\u0011L\u0014A\u0002y$\u0002\"a\b\u0003N\n='\u0011\u001b\u0005\b\u0003CC\u0003\u0019AAR\u0011\u0019\u0011I\u0006\u000ba\u0001}\"9!1\u001b\u0015A\u0002\tU\u0017AC:ue\u0016\fW\u000eV=qKB!\u0011q\u001eBl\u0013\u0011\u0011I.!=\u0003\u0015M#(/Z1n)f\u0004X-A\niC:$G.\u001a*fC\u0012\fE\rZ\"sK\u0012LG\u000f\u0006\u0005\u0002 \t}'\u0011\u001dBs\u0011\u001d\t\t+\u000ba\u0001\u0003GCqAa9*\u0001\u0004\u0011\t!\u0001\u0004de\u0016$\u0017\u000e\u001e\u0005\u0007\u00053J\u0003\u0019\u0001@\u0002/!\fg\u000e\u001a7f\u0007\",hn\u001b$fi\u000eD'+Z9vKN$H\u0003CA\u0010\u0005W\u0014iOa>\t\u000f\u0005\u0005&\u00061\u0001\u0002$\"9!q\u001e\u0016A\u0002\tE\u0018\u0001E:ue\u0016\fWn\u00115v].\u001cF.[2f!\u0011\t\u0019La=\n\t\tU\u0018Q\u0017\u0002\u0011'R\u0014X-Y7DQVt7n\u00157jG\u0016DqA!?+\u0001\u0004\t\t,A\u0002sKF\fqb\u00195fG.\u0014VmZ5ti\u0016\u0014X\r\u001a\u000b\u0003\u0005\u001f\tQb\u00195b]:,G.Q2uSZ,G\u0003BA\u0010\u0007\u0007Aq!!)-\u0001\u0004\t\u0019+A\bdQ\u0006tg.\u001a7J]\u0006\u001cG/\u001b<f)\u0011\tyb!\u0003\t\u000f\u0005\u0005V\u00061\u0001\u0002$\u0006yQ\r_2faRLwN\\\"bk\u001eDG\u000f\u0006\u0004\u0002 \r=1Q\u0005\u0005\b\u0007#q\u0003\u0019AB\n\u0003\u0015\u0019\u0017-^:f!\u0011\u0019)ba\b\u000f\t\r]11\u0004\b\u0005\u0003\u000f\u001bI\"C\u0001|\u0013\r\u0019iB_\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\u0019\tca\t\u0003\u0013QC'o\\<bE2,'bAB\u000fu\"9\u0011\u0011\u0015\u0018A\u0002\u0005\r\u0016\u0001G2mK\u0006tW\u000f]#ya&\u0014X\rZ*ik\u001a4G.Z&fsR!\u0011qDB\u0016\u0011\u001d\u0019ic\fa\u0001\u0007_\t!#\u001a=qSJ,Gm\u00155vM\u001adWmS3zgB1!QMB\u0019\u0003\u0003KAaa\r\u0002P\t9\u0001*Y:i'\u0016$\u0018aE:fiB\u000b'\u000f^5uS>t7oU8si\u0016\u0014H\u0003BA\u0010\u0007sAqaa\u000f1\u0001\u0004\ty#\u0001\u000bqCJ$\u0018\u000e^5p]\u001aKG.Z:T_J$XM\u001d")
public class FetchHandler
extends BaseMessageHandler
implements Logging {
    private final CelebornConf conf;
    private final TransportConf transportConf;
    private final WorkerSource workerSource;
    private final ChunkStreamManager chunkStreamManager;
    private final Option<Object> maxChunkBeingTransferred;
    private final CreditStreamManager creditStreamManager;
    private StorageManager storageManager;
    private PartitionFilesSorter partitionsSorter;
    private Option<AtomicBoolean> registered;
    private transient Logger log;
    private volatile transient boolean bitmap$trans$0;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    private Logger log$lzycompute() {
        FetchHandler fetchHandler = this;
        synchronized (fetchHandler) {
            if (!this.bitmap$trans$0) {
                this.log = Logging.log$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.log;
    }

    public Logger log() {
        if (!this.bitmap$trans$0) {
            return this.log$lzycompute();
        }
        return this.log;
    }

    public CelebornConf conf() {
        return this.conf;
    }

    public TransportConf transportConf() {
        return this.transportConf;
    }

    public WorkerSource workerSource() {
        return this.workerSource;
    }

    public ChunkStreamManager chunkStreamManager() {
        return this.chunkStreamManager;
    }

    public Option<Object> maxChunkBeingTransferred() {
        return this.maxChunkBeingTransferred;
    }

    public CreditStreamManager creditStreamManager() {
        return this.creditStreamManager;
    }

    public StorageManager storageManager() {
        return this.storageManager;
    }

    public void storageManager_$eq(StorageManager x$1) {
        this.storageManager = x$1;
    }

    public PartitionFilesSorter partitionsSorter() {
        return this.partitionsSorter;
    }

    public void partitionsSorter_$eq(PartitionFilesSorter x$1) {
        this.partitionsSorter = x$1;
    }

    public Option<AtomicBoolean> registered() {
        return this.registered;
    }

    public void registered_$eq(Option<AtomicBoolean> x$1) {
        this.registered = x$1;
    }

    public void init(Worker worker) {
        this.workerSource().addGauge(WorkerSource$.MODULE$.ACTIVE_CHUNK_STREAM_COUNT(), this.workerSource().addGauge$default$2(), (Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> this.chunkStreamManager().getStreamsCount());
        this.workerSource().addGauge(WorkerSource$.MODULE$.ACTIVE_CREDIT_STREAM_COUNT(), this.workerSource().addGauge$default$2(), (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> this.creditStreamManager().getStreamsCount());
        this.workerSource().addGauge(WorkerSource$.MODULE$.ACTIVE_MAP_PARTITION_COUNT(), this.workerSource().addGauge$default$2(), (Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> this.creditStreamManager().getActiveMapPartitionCount());
        this.storageManager_$eq(worker.storageManager());
        this.partitionsSorter_$eq(worker.partitionsSorter());
        this.registered_$eq((Option<AtomicBoolean>)new Some((Object)worker.registered()));
    }

    public FileInfo getRawFileInfo(String shuffleKey, String fileName) {
        FileInfo fileInfo = this.storageManager().getFileInfo(shuffleKey, fileName);
        if (fileInfo == null) {
            String errMsg = new StringBuilder(26).append("Could not find file ").append(fileName).append(" for ").append(shuffleKey).append(".").toString();
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> errMsg);
            throw new FileNotFoundException(errMsg);
        }
        return fileInfo;
    }

    public void receive(TransportClient client, RequestMessage msg, RpcResponseCallback callback) {
        this.handleRpcRequest(client, (RpcRequest)msg, callback);
    }

    public void receive(TransportClient client, RequestMessage msg) {
        RequestMessage requestMessage = msg;
        if (requestMessage instanceof BufferStreamEnd) {
            BufferStreamEnd bufferStreamEnd = (BufferStreamEnd)requestMessage;
            this.handleEndStreamFromClient(client, bufferStreamEnd.getStreamId());
            return;
        }
        if (requestMessage instanceof ReadAddCredit) {
            ReadAddCredit readAddCredit = (ReadAddCredit)requestMessage;
            this.handleReadAddCredit(client, readAddCredit.getCredit(), readAddCredit.getStreamId());
            return;
        }
        if (requestMessage instanceof ChunkFetchRequest) {
            ChunkFetchRequest chunkFetchRequest = (ChunkFetchRequest)requestMessage;
            this.handleChunkFetchRequest(client, chunkFetchRequest.streamChunkSlice, (RequestMessage)chunkFetchRequest);
            return;
        }
        if (requestMessage != null) {
            RequestMessage requestMessage2 = requestMessage;
            throw new IllegalArgumentException(new StringBuilder(25).append("Unknown message type id: ").append(requestMessage2.type().id()).toString());
        }
        throw new MatchError((Object)requestMessage);
    }

    private void handleRpcRequest(TransportClient client, RpcRequest rpcRequest, RpcResponseCallback callback) {
        GeneratedMessageV3 message = null;
        try {
            message = TransportMessage.fromByteBuffer((ByteBuffer)rpcRequest.body().nioByteBuffer()).getParsedPayload();
        }
        catch (CelebornIOException exception) {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Handle request with legacy RPCs", exception);
            this.handleLegacyRpcMessage(client, rpcRequest, callback);
            return;
        }
        GeneratedMessageV3 generatedMessageV3 = message;
        if (generatedMessageV3 instanceof PbOpenStream) {
            PbOpenStream pbOpenStream = (PbOpenStream)generatedMessageV3;
            this.handleOpenStreamInternal(client, pbOpenStream.getShuffleKey(), pbOpenStream.getFileName(), pbOpenStream.getStartIndex(), pbOpenStream.getEndIndex(), pbOpenStream.getInitialCredit(), rpcRequest.requestId, false, pbOpenStream.getReadLocalShuffle(), callback);
            return;
        }
        if (generatedMessageV3 instanceof PbOpenStreamList) {
            PbOpenStreamList pbOpenStreamList = (PbOpenStreamList)generatedMessageV3;
            String shuffleKey = pbOpenStreamList.getShuffleKey();
            ProtocolStringList files = pbOpenStreamList.getFileNameList();
            List startIndices = pbOpenStreamList.getStartIndexList();
            List endIndices = pbOpenStreamList.getEndIndexList();
            List readLocalFlags = pbOpenStreamList.getReadLocalShuffleList();
            PbOpenStreamListResponse.Builder pbOpenStreamListResponse = PbOpenStreamListResponse.newBuilder();
            this.checkAuth(client, (String)Utils$.MODULE$.splitShuffleKey(shuffleKey)._1());
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), files.size()).foreach((Function1 & Serializable & scala.Serializable)idx -> FetchHandler.$anonfun$handleRpcRequest$2(this, client, shuffleKey, files, startIndices, endIndices, readLocalFlags, pbOpenStreamListResponse, BoxesRunTime.unboxToInt((Object)idx)));
            client.getChannel().writeAndFlush((Object)new RpcResponse(rpcRequest.requestId, (ManagedBuffer)new NioManagedBuffer(new TransportMessage(MessageType.BATCH_OPEN_STREAM_RESPONSE, pbOpenStreamListResponse.build().toByteArray()).toByteBuffer())));
            return;
        }
        if (generatedMessageV3 instanceof PbBufferStreamEnd) {
            PbBufferStreamEnd pbBufferStreamEnd = (PbBufferStreamEnd)generatedMessageV3;
            this.handleEndStreamFromClient(client, pbBufferStreamEnd.getStreamId(), pbBufferStreamEnd.getStreamType());
            return;
        }
        if (generatedMessageV3 instanceof PbReadAddCredit) {
            PbReadAddCredit pbReadAddCredit = (PbReadAddCredit)generatedMessageV3;
            this.handleReadAddCredit(client, pbReadAddCredit.getCredit(), pbReadAddCredit.getStreamId());
            return;
        }
        if (generatedMessageV3 instanceof PbChunkFetchRequest) {
            PbChunkFetchRequest pbChunkFetchRequest = (PbChunkFetchRequest)generatedMessageV3;
            this.handleChunkFetchRequest(client, StreamChunkSlice.fromProto((PbStreamChunkSlice)pbChunkFetchRequest.getStreamChunkSlice()), (RequestMessage)rpcRequest);
            return;
        }
        if (generatedMessageV3 != null) {
            GeneratedMessageV3 generatedMessageV32 = generatedMessageV3;
            this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(16).append("Unknown message ").append(generatedMessageV32).toString());
            return;
        }
        throw new MatchError((Object)generatedMessageV3);
    }

    private void handleLegacyRpcMessage(TransportClient client, RpcRequest rpcRequest, RpcResponseCallback callback) {
        block4: {
            try {
                Message message = Message.decode((ByteBuffer)rpcRequest.body().nioByteBuffer());
                Message.Type type = message.type();
                if (Message.Type.OPEN_STREAM.equals(type)) {
                    OpenStream openStream = (OpenStream)message;
                    this.handleOpenStreamInternal(client, new String(openStream.shuffleKey, StandardCharsets.UTF_8), new String(openStream.fileName, StandardCharsets.UTF_8), openStream.startMapIndex, openStream.endMapIndex, 0, rpcRequest.requestId, true, false, callback);
                    break block4;
                }
                if (Message.Type.OPEN_STREAM_WITH_CREDIT.equals(type)) {
                    OpenStreamWithCredit openStreamWithCredit = (OpenStreamWithCredit)message;
                    this.handleOpenStreamInternal(client, new String(openStreamWithCredit.shuffleKey, StandardCharsets.UTF_8), new String(openStreamWithCredit.fileName, StandardCharsets.UTF_8), openStreamWithCredit.startIndex, openStreamWithCredit.endIndex, openStreamWithCredit.initialCredit, rpcRequest.requestId, true, false, callback);
                    break block4;
                }
                this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(37).append("Received an unknown message type id: ").append(message.type().id()).toString());
            }
            catch (Exception e) {
                this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Catch an error when handle legacy rpc message.", e);
            }
        }
    }

    private PbStreamHandlerOpt handleReduceOpenStreamInternal(TransportClient client, String shuffleKey, String fileName, int startIndex, int endIndex, boolean readLocalShuffle) {
        PbStreamHandlerOpt pbStreamHandlerOpt;
        try {
            try {
                PbStreamHandler pbStreamHandler;
                this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(68).append("Received open stream request ").append(shuffleKey).append(" ").append(fileName).append(" ").append(startIndex).append(" ").append(endIndex).append(" get file name ").append(fileName).append(" from client channel ").append(NettyUtils.getRemoteAddress((Channel)client.getChannel())).toString());
                FileInfo fileInfo = this.getRawFileInfo(shuffleKey, fileName);
                long streamId = this.chunkStreamManager().nextStreamId();
                if (endIndex != Integer.MAX_VALUE || endIndex == Integer.MAX_VALUE && !fileInfo.addStream(streamId)) {
                    fileInfo = this.partitionsSorter().getSortedFileInfo(shuffleKey, fileName, fileInfo, startIndex, endIndex);
                }
                ReduceFileMeta meta = fileInfo.getReduceFileMeta();
                if (readLocalShuffle && !(fileInfo instanceof MemoryFileInfo)) {
                    this.chunkStreamManager().registerStream(streamId, shuffleKey, fileName);
                    pbStreamHandler = this.makeStreamHandler(streamId, meta.getNumChunks(), meta.getChunkOffsets(), ((DiskFileInfo)fileInfo).getFilePath());
                } else {
                    DiskFileInfo diskFileInfo;
                    FileInfo fileInfo2 = fileInfo;
                    if (fileInfo2 instanceof DiskFileInfo && (diskFileInfo = (DiskFileInfo)fileInfo2).isHdfs()) {
                        this.chunkStreamManager().registerStream(streamId, shuffleKey, fileName);
                        pbStreamHandler = this.makeStreamHandler(streamId, 0, this.makeStreamHandler$default$3(), this.makeStreamHandler$default$4());
                    } else {
                        TimeWindow timeWindow;
                        FileChunkBuffers fileChunkBuffers;
                        FileInfo fileInfo3 = fileInfo;
                        if (fileInfo3 instanceof DiskFileInfo) {
                            DiskFileInfo diskFileInfo2 = (DiskFileInfo)fileInfo3;
                            fileChunkBuffers = new FileChunkBuffers(diskFileInfo2, this.transportConf());
                        } else if (fileInfo3 instanceof MemoryFileInfo) {
                            MemoryFileInfo memoryFileInfo = (MemoryFileInfo)fileInfo3;
                            fileChunkBuffers = new MemoryChunkBuffers(memoryFileInfo);
                        } else {
                            throw new MatchError((Object)fileInfo3);
                        }
                        FileChunkBuffers managedBuffer = fileChunkBuffers;
                        FileInfo fileInfo4 = fileInfo;
                        if (fileInfo4 instanceof DiskFileInfo) {
                            DiskFileInfo diskFileInfo3 = (DiskFileInfo)fileInfo4;
                            timeWindow = this.storageManager().getFetchTimeMetric(diskFileInfo3.getFile());
                        } else {
                            timeWindow = null;
                        }
                        TimeWindow fetchTimeMetric = timeWindow;
                        this.chunkStreamManager().registerStream(streamId, shuffleKey, (ChunkBuffers)managedBuffer, fileName, fetchTimeMetric);
                        if (meta.getNumChunks() == 0) {
                            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(74).append("StreamId ").append(streamId).append(", fileName ").append(fileName).append(", mapRange ").append("[").append(startIndex).append("-").append(endIndex).append("] is empty. Received from client channel ").append(NettyUtils.getRemoteAddress((Channel)client.getChannel())).toString());
                        } else {
                            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(77).append("StreamId ").append(streamId).append(", fileName ").append(fileName).append(", numChunks ").append(meta.getNumChunks()).append(", ").append("mapRange [").append(startIndex).append("-").append(endIndex).append("]. Received from client channel ").append(NettyUtils.getRemoteAddress((Channel)client.getChannel())).toString());
                        }
                        pbStreamHandler = this.makeStreamHandler(streamId, meta.getNumChunks(), this.makeStreamHandler$default$3(), this.makeStreamHandler$default$4());
                    }
                }
                PbStreamHandler streamHandler = pbStreamHandler;
                this.workerSource().incCounter(WorkerSource$.MODULE$.OPEN_STREAM_SUCCESS_COUNT());
                pbStreamHandlerOpt = PbStreamHandlerOpt.newBuilder().setStreamHandler(streamHandler).setStatus((int)StatusCode.SUCCESS.getValue()).build();
            }
            catch (IOException e) {
                String msg = new StringBuilder(54).append("Read file: ").append(fileName).append(" with shuffleKey: ").append(shuffleKey).append(" error from ").append(NettyUtils.getRemoteAddress((Channel)client.getChannel())).append(", Exception: ").append(e.getMessage()).toString();
                pbStreamHandlerOpt = PbStreamHandlerOpt.newBuilder().setStatus((int)StatusCode.OPEN_STREAM_FAILED.getValue()).setErrorMsg(msg).build();
            }
        }
        finally {
            this.workerSource().stopTimer(WorkerSource$.MODULE$.OPEN_STREAM_TIME(), shuffleKey);
        }
        return pbStreamHandlerOpt;
    }

    private boolean handleReduceOpenStreamInternal$default$6() {
        return false;
    }

    private void handleOpenStreamInternal(TransportClient client, String shuffleKey, String fileName, int startIndex, int endIndex, int initialCredit, long rpcRequestId, boolean isLegacy, boolean readLocalShuffle, RpcResponseCallback callback) {
        this.checkAuth(client, (String)Utils$.MODULE$.splitShuffleKey(shuffleKey)._1());
        this.workerSource().recordAppActiveConnection(client, shuffleKey);
        this.workerSource().startTimer(WorkerSource$.MODULE$.OPEN_STREAM_TIME(), shuffleKey);
        try {
            try {
                FileInfo fileInfo = this.getRawFileInfo(shuffleKey, fileName);
                FileMeta fileMeta = fileInfo.getFileMeta();
                if (fileMeta instanceof ReduceFileMeta) {
                    PbStreamHandlerOpt pbStreamHandlerOpt = this.handleReduceOpenStreamInternal(client, shuffleKey, fileName, startIndex, endIndex, readLocalShuffle);
                    if (pbStreamHandlerOpt.getStatus() != StatusCode.SUCCESS.getValue()) {
                        throw new CelebornIOException(pbStreamHandlerOpt.getErrorMsg());
                    }
                    this.org$apache$celeborn$service$deploy$worker$FetchHandler$$replyStreamHandler(client, rpcRequestId, pbStreamHandlerOpt.getStreamHandler(), isLegacy);
                } else if (fileMeta instanceof MapFileMeta) {
                    Consumer<Long> creditStreamHandler = new Consumer<Long>(this, client, rpcRequestId, isLegacy){
                        private final /* synthetic */ FetchHandler $outer;
                        private final TransportClient client$3;
                        private final long rpcRequestId$1;
                        private final boolean isLegacy$1;

                        public Consumer<Long> andThen(Consumer<? super Long> x$1) {
                            return Consumer.super.andThen(x$1);
                        }

                        public void accept(Long streamId) {
                            PbStreamHandler pbStreamHandler = PbStreamHandler.newBuilder().setStreamId(Predef$.MODULE$.Long2long(streamId)).setNumChunks(0).build();
                            this.$outer.org$apache$celeborn$service$deploy$worker$FetchHandler$$replyStreamHandler(this.client$3, this.rpcRequestId$1, pbStreamHandler, this.isLegacy$1);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.client$3 = client$3;
                            this.rpcRequestId$1 = rpcRequestId$1;
                            this.isLegacy$1 = isLegacy$1;
                        }
                    };
                    BoxesRunTime.boxToLong((long)this.creditStreamManager().registerStream(creditStreamHandler, client.getChannel(), shuffleKey, initialCredit, startIndex, endIndex, (DiskFileInfo)fileInfo));
                } else {
                    throw new MatchError((Object)fileMeta);
                }
                this.workerSource().incCounter(WorkerSource$.MODULE$.OPEN_STREAM_SUCCESS_COUNT());
            }
            catch (IOException e) {
                this.workerSource().incCounter(WorkerSource$.MODULE$.OPEN_STREAM_FAIL_COUNT());
                this.handleRpcIOException(client, rpcRequestId, shuffleKey, fileName, e, callback);
            }
        }
        finally {
            this.workerSource().stopTimer(WorkerSource$.MODULE$.OPEN_STREAM_TIME(), shuffleKey);
        }
    }

    private boolean handleOpenStreamInternal$default$9() {
        return false;
    }

    private PbStreamHandler makeStreamHandler(long streamId, int numChunks, List<Long> offsets, String filepath) {
        PbStreamHandler.Builder pbStreamHandlerBuilder = PbStreamHandler.newBuilder().setStreamId(streamId).setNumChunks(numChunks);
        Object object = offsets != null ? pbStreamHandlerBuilder.addAllChunkOffsets(offsets) : BoxedUnit.UNIT;
        Object object2 = new StringOps(Predef$.MODULE$.augmentString(filepath)).nonEmpty() ? pbStreamHandlerBuilder.setFullPath(filepath) : BoxedUnit.UNIT;
        return pbStreamHandlerBuilder.build();
    }

    private List<Long> makeStreamHandler$default$3() {
        return null;
    }

    private String makeStreamHandler$default$4() {
        return "";
    }

    public void org$apache$celeborn$service$deploy$worker$FetchHandler$$replyStreamHandler(TransportClient client, long requestId, PbStreamHandler pbStreamHandler, boolean isLegacy) {
        if (isLegacy) {
            client.getChannel().writeAndFlush((Object)new RpcResponse(requestId, (ManagedBuffer)new NioManagedBuffer(new StreamHandle(pbStreamHandler.getStreamId(), pbStreamHandler.getNumChunks()).toByteBuffer())));
            return;
        }
        client.getChannel().writeAndFlush((Object)new RpcResponse(requestId, (ManagedBuffer)new NioManagedBuffer(new TransportMessage(MessageType.STREAM_HANDLER, pbStreamHandler.toByteArray()).toByteBuffer())));
    }

    private void handleRpcIOException(TransportClient client, long requestId, String shuffleKey, String fileName, IOException ioe, RpcResponseCallback rpcCallback) {
        this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(41).append("Read file: ").append(fileName).append(" with shuffleKey: ").append(shuffleKey).append(" error from ").append(NettyUtils.getRemoteAddress((Channel)client.getChannel())).toString(), ioe);
        this.handleRpcException(client, requestId, ioe, rpcCallback);
    }

    private void handleRpcException(TransportClient client, long requestId, IOException ioe, RpcResponseCallback rpcResponseCallback) {
        rpcResponseCallback.onFailure(ExceptionUtils.wrapIOExceptionToUnRetryable((Throwable)ioe));
    }

    public void handleEndStreamFromClient(TransportClient client, long streamId) {
        this.handleEndStreamFromClient(client, streamId, StreamType.CreditStream);
    }

    public void handleEndStreamFromClient(TransportClient client, long streamId, StreamType streamType) {
        StreamType streamType2 = streamType;
        if (StreamType.ChunkStream.equals(streamType2)) {
            ChunkStreamManager.StreamState streamState = this.chunkStreamManager().getStreamState(streamId);
            Tuple2 tuple2 = new Tuple2((Object)streamState.shuffleKey, (Object)streamState.fileName);
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String shuffleKey = (String)tuple2._1();
            String fileName = (String)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)shuffleKey, (Object)fileName);
            String shuffleKey2 = (String)tuple22._1();
            String fileName2 = (String)tuple22._2();
            this.workerSource().recordAppActiveConnection(client, shuffleKey2);
            this.getRawFileInfo(shuffleKey2, fileName2).closeStream(streamId);
            return;
        }
        if (StreamType.CreditStream.equals(streamType2)) {
            String shuffleKey = this.creditStreamManager().getStreamShuffleKey(Predef$.MODULE$.long2Long(streamId));
            if (shuffleKey != null) {
                this.workerSource().recordAppActiveConnection(client, shuffleKey);
                this.creditStreamManager().notifyStreamEndByClient(streamId);
                return;
            }
            return;
        }
        this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(55).append("Received a PbBufferStreamEnd message with unknown type ").append(streamType).toString());
    }

    public void handleReadAddCredit(TransportClient client, int credit, long streamId) {
        String shuffleKey = this.creditStreamManager().getStreamShuffleKey(Predef$.MODULE$.long2Long(streamId));
        if (shuffleKey != null) {
            this.workerSource().recordAppActiveConnection(client, shuffleKey);
            this.creditStreamManager().addCredit(credit, streamId);
            return;
        }
    }

    public void handleChunkFetchRequest(TransportClient client, StreamChunkSlice streamChunkSlice, RequestMessage req) {
        Object object = new Object();
        try {
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(34).append("Received req from ").append(NettyUtils.getRemoteAddress((Channel)client.getChannel())).append(" to fetch block ").append(streamChunkSlice).toString());
            this.workerSource().recordAppActiveConnection(client, (String)this.chunkStreamManager().getShuffleKeyAndFileName(streamChunkSlice.streamId)._1());
            this.maxChunkBeingTransferred().foreach((Function1)(JFunction1.mcVJ.sp & Serializable & scala.Serializable)threshold -> {
                long chunksBeingTransferred = this.chunkStreamManager().chunksBeingTransferred();
                if (chunksBeingTransferred > threshold) {
                    String message = new StringBuilder(70).append("Worker is too busy. The number of chunks being transferred ").append(chunksBeingTransferred).append(" exceeds ").append(CelebornConf$.MODULE$.MAX_CHUNKS_BEING_TRANSFERRED().key()).append(" ").append(Utils$.MODULE$.bytesToString(threshold)).append(".").toString();
                    this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> message);
                    this.workerSource().incCounter(WorkerSource$.MODULE$.FETCH_CHUNK_FAIL_COUNT());
                    client.getChannel().writeAndFlush((Object)new ChunkFetchFailure(streamChunkSlice, message));
                    throw new NonLocalReturnControl.mcV.sp(object, BoxedUnit.UNIT);
                }
            });
            String reqStr = req.toString();
            this.workerSource().startTimer(WorkerSource$.MODULE$.FETCH_CHUNK_TIME(), reqStr);
            TimeWindow fetchTimeMetric = this.chunkStreamManager().getFetchTimeMetric(streamChunkSlice.streamId);
            long fetchBeginTime = System.nanoTime();
            try {
                ManagedBuffer buf = this.chunkStreamManager().getChunk(streamChunkSlice.streamId, streamChunkSlice.chunkIndex, streamChunkSlice.offset, streamChunkSlice.len);
                this.chunkStreamManager().chunkBeingSent(streamChunkSlice.streamId);
                client.getChannel().writeAndFlush((Object)new ChunkFetchSuccess(streamChunkSlice, buf)).addListener((GenericFutureListener)new GenericFutureListener<Future<? super Void>>(this, streamChunkSlice, fetchTimeMetric, fetchBeginTime, reqStr){
                    private final /* synthetic */ FetchHandler $outer;
                    private final StreamChunkSlice streamChunkSlice$1;
                    private final TimeWindow fetchTimeMetric$1;
                    private final long fetchBeginTime$1;
                    private final String reqStr$1;

                    public void operationComplete(Future<? super Void> future) {
                        if (future.isSuccess()) {
                            if (this.$outer.log().isDebugEnabled()) {
                                this.$outer.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(53).append("Sending ChunkFetchSuccess operation succeeded, chunk ").append($this.streamChunkSlice$1).toString());
                            }
                        } else {
                            this.$outer.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(50).append("Sending ChunkFetchSuccess operation failed, chunk ").append($this.streamChunkSlice$1).toString(), future.cause());
                        }
                        this.$outer.workerSource().incCounter(WorkerSource$.MODULE$.FETCH_CHUNK_SUCCESS_COUNT());
                        this.$outer.chunkStreamManager().chunkSent(this.streamChunkSlice$1.streamId);
                        if (this.fetchTimeMetric$1 != null) {
                            this.fetchTimeMetric$1.update(System.nanoTime() - this.fetchBeginTime$1);
                        }
                        this.$outer.workerSource().stopTimer(WorkerSource$.MODULE$.FETCH_CHUNK_TIME(), this.reqStr$1);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.streamChunkSlice$1 = streamChunkSlice$1;
                        this.fetchTimeMetric$1 = fetchTimeMetric$1;
                        this.fetchBeginTime$1 = fetchBeginTime$1;
                        this.reqStr$1 = reqStr$1;
                    }

                    private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                        return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$operationComplete$1(org.apache.celeborn.service.deploy.worker.FetchHandler$$anon$2 ), $anonfun$operationComplete$2(org.apache.celeborn.service.deploy.worker.FetchHandler$$anon$2 )}, serializedLambda);
                    }
                });
            }
            catch (Exception e) {
                this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(38).append("Error opening block ").append(streamChunkSlice).append(" for request from ").append(NettyUtils.getRemoteAddress((Channel)client.getChannel())).toString(), e);
                this.workerSource().incCounter(WorkerSource$.MODULE$.FETCH_CHUNK_FAIL_COUNT());
                client.getChannel().writeAndFlush((Object)new ChunkFetchFailure(streamChunkSlice, Throwables.getStackTraceAsString((Throwable)e)));
                this.workerSource().stopTimer(WorkerSource$.MODULE$.FETCH_CHUNK_TIME(), reqStr);
            }
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                ex.value$mcV$sp();
            }
            throw ex;
        }
    }

    public boolean checkRegistered() {
        return this.registered().exists((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.get()));
    }

    public void channelActive(TransportClient client) {
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(15).append("channel active ").append(client.getSocketAddress()).toString());
        this.workerSource().connectionActive(client);
        super.channelActive(client);
    }

    public void channelInactive(TransportClient client) {
        this.workerSource().connectionInactive(client);
        this.creditStreamManager().connectionTerminated(client.getChannel());
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(17).append("channel inactive ").append(client.getSocketAddress()).toString());
    }

    public void exceptionCaught(Throwable cause, TransportClient client) {
        this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(17).append("exception caught ").append(client.getSocketAddress()).toString(), cause);
    }

    public void cleanupExpiredShuffleKey(HashSet<String> expiredShuffleKeys) {
        this.chunkStreamManager().cleanupExpiredShuffleKey(expiredShuffleKeys);
        if (this.partitionsSorter() != null) {
            this.partitionsSorter().cleanupExpiredShuffleKey(expiredShuffleKeys);
            return;
        }
    }

    public void setPartitionsSorter(PartitionFilesSorter partitionFilesSorter) {
        this.partitionsSorter_$eq(partitionFilesSorter);
    }

    public static final /* synthetic */ PbOpenStreamListResponse.Builder $anonfun$handleRpcRequest$2(FetchHandler $this, TransportClient client$1, String shuffleKey$1, ProtocolStringList files$1, List startIndices$1, List endIndices$1, List readLocalFlags$1, PbOpenStreamListResponse.Builder pbOpenStreamListResponse$1, int idx) {
        PbStreamHandlerOpt pbStreamHandlerOpt;
        block0: {
            pbStreamHandlerOpt = $this.handleReduceOpenStreamInternal(client$1, shuffleKey$1, (String)files$1.get(idx), Predef$.MODULE$.Integer2int((Integer)startIndices$1.get(idx)), Predef$.MODULE$.Integer2int((Integer)endIndices$1.get(idx)), Predef$.MODULE$.Boolean2boolean((Boolean)readLocalFlags$1.get(idx)));
            if (pbStreamHandlerOpt.getStatus() == StatusCode.SUCCESS.getValue()) break block0;
            $this.workerSource().incCounter(WorkerSource$.MODULE$.OPEN_STREAM_FAIL_COUNT());
        }
        return pbOpenStreamListResponse$1.addStreamHandlerOpt(pbStreamHandlerOpt);
    }

    public FetchHandler(CelebornConf conf, TransportConf transportConf, WorkerSource workerSource) {
        this.conf = conf;
        this.transportConf = transportConf;
        this.workerSource = workerSource;
        Logging.$init$((Logging)this);
        this.chunkStreamManager = new ChunkStreamManager();
        this.maxChunkBeingTransferred = conf.shuffleIoMaxChunksBeingTransferred();
        this.creditStreamManager = new CreditStreamManager(conf.partitionReadBuffersMin(), conf.partitionReadBuffersMax(), conf.creditStreamThreadsPerMountpoint(), conf.readBuffersToTriggerReadMin());
        this.registered = None$.MODULE$;
    }
}

