/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.shaded.org.roaringbitmap;

import java.util.function.Supplier;
import org.apache.celeborn.shaded.org.roaringbitmap.AppendableStorage;
import org.apache.celeborn.shaded.org.roaringbitmap.BitmapDataProvider;
import org.apache.celeborn.shaded.org.roaringbitmap.RoaringBitmapWriter;
import org.apache.celeborn.shaded.org.roaringbitmap.Util;
import org.apache.celeborn.shaded.org.roaringbitmap.WordStorage;

public class ContainerAppender<C extends WordStorage<C>, T extends BitmapDataProvider & AppendableStorage<C>>
implements RoaringBitmapWriter<T> {
    private final boolean doPartialSort;
    private final boolean runCompress;
    private final Supplier<C> newContainer;
    private final Supplier<T> newUnderlying;
    private C container;
    private T underlying;
    private int currentKey;

    ContainerAppender(boolean doPartialSort, boolean runCompress, Supplier<T> newUnderlying, Supplier<C> newContainer) {
        this.doPartialSort = doPartialSort;
        this.runCompress = runCompress;
        this.newUnderlying = newUnderlying;
        this.underlying = (BitmapDataProvider)newUnderlying.get();
        this.newContainer = newContainer;
        this.container = (WordStorage)newContainer.get();
    }

    @Override
    public T getUnderlying() {
        return this.underlying;
    }

    @Override
    public void add(int value) {
        WordStorage tmp;
        char key = Util.highbits(value);
        if (key != this.currentKey) {
            if (key < this.currentKey) {
                this.underlying.add(value);
                return;
            }
            this.appendToUnderlying();
            this.currentKey = key;
        }
        if ((tmp = (WordStorage)this.container.add(Util.lowbits(value))) != this.container) {
            this.container = tmp;
        }
    }

    @Override
    public void add(long min, long max) {
        this.appendToUnderlying();
        this.underlying.add(min, max);
        int mark = (int)((max >>> 16) + 1L);
        if (this.currentKey < mark) {
            this.currentKey = mark;
        }
    }

    @Override
    public void addMany(int ... values) {
        if (this.doPartialSort) {
            Util.partialRadixSort(values);
        }
        for (int i : values) {
            this.add(i);
        }
    }

    @Override
    public void flush() {
        this.currentKey += this.appendToUnderlying();
    }

    @Override
    public void reset() {
        this.currentKey = 0;
        this.container = (WordStorage)this.newContainer.get();
        this.underlying = (BitmapDataProvider)this.newUnderlying.get();
    }

    private int appendToUnderlying() {
        if (!this.container.isEmpty()) {
            assert (this.currentKey <= 65535);
            ((AppendableStorage)this.underlying).append((char)this.currentKey, this.runCompress ? (WordStorage)this.container.runOptimize() : this.container);
            this.container = (WordStorage)this.newContainer.get();
            return 1;
        }
        return 0;
    }
}

