/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.shell.cli.sh.election;

import java.io.IOException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.ratis.client.RaftClient;
import org.apache.ratis.protocol.RaftClientReply;
import org.apache.ratis.protocol.RaftPeer;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.shell.cli.RaftUtils;
import org.apache.ratis.shell.cli.sh.command.AbstractRatisCommand;
import org.apache.ratis.shell.cli.sh.command.Context;

public class ResumeCommand
extends AbstractRatisCommand {
    public static final String ADDRESS_OPTION_NAME = "address";

    public ResumeCommand(Context context) {
        super(context);
    }

    @Override
    public String getCommandName() {
        return "resume";
    }

    @Override
    public int run(CommandLine cl) throws IOException {
        super.run(cl);
        String strAddr = cl.getOptionValue(ADDRESS_OPTION_NAME);
        RaftPeerId peerId = this.getRaftGroup().getPeers().stream().filter(p -> p.getAddress().equals(strAddr)).findAny().map(RaftPeer::getId).orElse(null);
        if (peerId == null) {
            this.printf("Can't find a sever with the address:%s", strAddr);
            return -1;
        }
        try (RaftClient raftClient = RaftUtils.createClient(this.getRaftGroup());){
            RaftClientReply reply = raftClient.getLeaderElectionManagementApi(peerId).resume();
            this.processReply(reply, () -> String.format("Failed to resume leader election on peer %s", strAddr));
            this.printf(String.format("Successful pause leader election on peer %s", strAddr), new Object[0]);
        }
        return 0;
    }

    @Override
    public String getUsage() {
        return String.format("%s -%s <HOSTNAME:PORT> -%s <PEER0_HOST:PEER0_PORT,PEER1_HOST:PEER1_PORT,PEER2_HOST:PEER2_PORT> [-%s <RAFT_GROUP_ID>]", this.getCommandName(), ADDRESS_OPTION_NAME, "peers", "groupid");
    }

    @Override
    public String getDescription() {
        return ResumeCommand.description();
    }

    @Override
    public Options getOptions() {
        return super.getOptions().addOption(Option.builder().option(ADDRESS_OPTION_NAME).hasArg().required().desc("Server address that will be resumed its leader election").build());
    }

    public static String description() {
        return "Resume leader election to the server <hostname>:<port>";
    }
}

