/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.service.deploy.master;

import org.apache.celeborn.common.meta.ApplicationMeta;
import org.apache.celeborn.common.network.sasl.SecretRegistry;
import org.apache.celeborn.service.deploy.master.clustermeta.AbstractMetaManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MasterSecretRegistryImpl
implements SecretRegistry {
    private static final Logger LOG = LoggerFactory.getLogger(MasterSecretRegistryImpl.class);
    private AbstractMetaManager statusSystem;

    public void register(String appId, String secret) {
        LOG.info("Persisting metadata for appId: {}", (Object)appId);
        this.statusSystem.handleApplicationMeta(new ApplicationMeta(appId, secret));
    }

    public void unregister(String appId) {
        LOG.info("Removing metadata for appId: {}", (Object)appId);
        this.statusSystem.removeApplicationMeta(appId);
    }

    public String getSecretKey(String appId) {
        String secret = null;
        LOG.debug("Fetching secret from metadata manager for appId: {}", (Object)appId);
        ApplicationMeta applicationMeta = this.statusSystem.applicationMetas.get(appId);
        if (applicationMeta != null) {
            secret = applicationMeta.secret();
        }
        return secret;
    }

    public boolean isRegistered(String appId) {
        LOG.info("Fetching registration status from metadata manager for appId: {}", (Object)appId);
        return this.statusSystem.applicationMetas.containsKey(appId);
    }

    void setMetadataHandler(AbstractMetaManager statusSystem) {
        this.statusSystem = statusSystem;
    }
}

