/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.client.read;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.celeborn.client.ShuffleClient;
import org.apache.celeborn.client.read.MetricsCallback;
import org.apache.celeborn.client.read.PartitionReader;
import org.apache.celeborn.common.CelebornConf;
import org.apache.celeborn.common.network.client.TransportClient;
import org.apache.celeborn.common.network.client.TransportClientFactory;
import org.apache.celeborn.common.network.protocol.TransportMessage;
import org.apache.celeborn.common.protocol.MessageType;
import org.apache.celeborn.common.protocol.PartitionLocation;
import org.apache.celeborn.common.protocol.PbBufferStreamEnd;
import org.apache.celeborn.common.protocol.PbOpenStream;
import org.apache.celeborn.common.protocol.PbStreamHandler;
import org.apache.celeborn.common.protocol.StreamType;
import org.apache.celeborn.common.util.ShuffleBlockInfoUtils;
import org.apache.celeborn.common.util.ThreadUtils;
import org.apache.celeborn.common.util.Utils;
import org.apache.celeborn.shaded.io.netty.buffer.ByteBuf;
import org.apache.celeborn.shaded.io.netty.buffer.Unpooled;
import org.apache.celeborn.shaded.io.netty.util.ReferenceCounted;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DfsPartitionReader
implements PartitionReader {
    private static Logger logger = LoggerFactory.getLogger(DfsPartitionReader.class);
    private CelebornConf conf;
    PartitionLocation location;
    private final long shuffleChunkSize;
    private final int fetchMaxReqsInFlight;
    private final LinkedBlockingQueue<ByteBuf> results;
    private final AtomicReference<IOException> exception = new AtomicReference();
    private volatile boolean closed = false;
    private ExecutorService fetchThread;
    private boolean fetchThreadStarted;
    private FSDataInputStream hdfsInputStream;
    private int numChunks = 0;
    private int returnedChunks = 0;
    private int currentChunkIndex = 0;
    private final List<Long> chunkOffsets = new ArrayList<Long>();
    private TransportClient client;
    private PbStreamHandler streamHandler;
    private MetricsCallback metricsCallback;

    public DfsPartitionReader(CelebornConf conf, String shuffleKey, PartitionLocation location, PbStreamHandler pbStreamHandler, TransportClientFactory clientFactory, int startMapIndex, int endMapIndex, MetricsCallback metricsCallback) throws IOException {
        this.conf = conf;
        this.shuffleChunkSize = conf.dfsReadChunkSize();
        this.fetchMaxReqsInFlight = conf.clientFetchMaxReqsInFlight();
        this.results = new LinkedBlockingQueue();
        this.metricsCallback = metricsCallback;
        this.location = location;
        long fetchTimeoutMs = conf.clientFetchTimeoutMs();
        try {
            this.client = clientFactory.createClient(location.getHost(), location.getFetchPort());
            if (pbStreamHandler == null) {
                TransportMessage openStream = new TransportMessage(MessageType.OPEN_STREAM, PbOpenStream.newBuilder().setShuffleKey(shuffleKey).setFileName(location.getFileName()).setStartIndex(startMapIndex).setEndIndex(endMapIndex).build().toByteArray());
                ByteBuffer response = this.client.sendRpcSync(openStream.toByteBuffer(), fetchTimeoutMs);
                this.streamHandler = (PbStreamHandler)TransportMessage.fromByteBuffer(response).getParsedPayload();
            } else {
                this.streamHandler = pbStreamHandler;
            }
        }
        catch (IOException | InterruptedException e) {
            throw new IOException("read shuffle file from DFS failed, filePath: " + location.getStorageInfo().getFilePath(), e);
        }
        if (endMapIndex != Integer.MAX_VALUE) {
            this.hdfsInputStream = ShuffleClient.getHdfsFs(conf).open(new Path(Utils.getSortedFilePath(location.getStorageInfo().getFilePath())));
            this.chunkOffsets.addAll(this.getChunkOffsetsFromSortedIndex(conf, location, startMapIndex, endMapIndex));
        } else {
            this.hdfsInputStream = ShuffleClient.getHdfsFs(conf).open(new Path(location.getStorageInfo().getFilePath()));
            this.chunkOffsets.addAll(this.getChunkOffsetsFromUnsortedIndex(conf, location));
        }
        logger.debug("DFS {} index count:{} offsets:{}", new Object[]{location.getStorageInfo().getFilePath(), this.chunkOffsets.size(), this.chunkOffsets});
        if (this.chunkOffsets.size() > 1) {
            this.numChunks = this.chunkOffsets.size() - 1;
            this.fetchThread = ThreadUtils.newDaemonSingleThreadExecutor("celeborn-client-dfs-partition-fetcher" + location.getStorageInfo().getFilePath());
            logger.debug("Start dfs read on location {}", (Object)location);
            ShuffleClient.incrementTotalReadCounter();
        }
    }

    private List<Long> getChunkOffsetsFromUnsortedIndex(CelebornConf conf, PartitionLocation location) throws IOException {
        ArrayList<Long> offsets;
        try (FSDataInputStream indexInputStream = ShuffleClient.getHdfsFs(conf).open(new Path(Utils.getIndexFilePath(location.getStorageInfo().getFilePath())));){
            offsets = new ArrayList<Long>();
            int offsetCount = indexInputStream.readInt();
            for (int i = 0; i < offsetCount; ++i) {
                offsets.add(indexInputStream.readLong());
            }
        }
        return offsets;
    }

    private List<Long> getChunkOffsetsFromSortedIndex(CelebornConf conf, PartitionLocation location, int startMapIndex, int endMapIndex) throws IOException {
        ArrayList<Long> offsets;
        String indexPath = Utils.getIndexFilePath(location.getStorageInfo().getFilePath());
        try (FSDataInputStream indexInputStream = ShuffleClient.getHdfsFs(conf).open(new Path(indexPath));){
            logger.debug("read sorted index {}", (Object)indexPath);
            long indexSize = ShuffleClient.getHdfsFs(conf).getFileStatus(new Path(indexPath)).getLen();
            byte[] indexBuffer = new byte[(int)indexSize];
            indexInputStream.readFully(0L, indexBuffer);
            offsets = new ArrayList<Long>(ShuffleBlockInfoUtils.getChunkOffsetsFromShuffleBlockInfos(startMapIndex, endMapIndex, this.shuffleChunkSize, ShuffleBlockInfoUtils.parseShuffleBlockInfosFromByteBuffer(indexBuffer), false));
        }
        return offsets;
    }

    @Override
    public boolean hasNext() {
        logger.debug("check has next current index: {} chunks {}", (Object)this.returnedChunks, (Object)this.numChunks);
        return this.returnedChunks < this.numChunks;
    }

    @Override
    public ByteBuf next() throws IOException, InterruptedException {
        ByteBuf chunk = null;
        if (!this.fetchThreadStarted) {
            this.fetchThreadStarted = true;
            this.fetchThread.submit(() -> {
                try {
                    while (!this.closed && this.currentChunkIndex < this.numChunks) {
                        while (this.results.size() >= this.fetchMaxReqsInFlight) {
                            Thread.sleep(50L);
                        }
                        long offset = this.chunkOffsets.get(this.currentChunkIndex);
                        long length = this.chunkOffsets.get(this.currentChunkIndex + 1) - offset;
                        logger.debug("read {} offset {} length {}", new Object[]{this.currentChunkIndex, offset, length});
                        byte[] buffer = new byte[(int)length];
                        try {
                            this.hdfsInputStream.readFully(offset, buffer);
                        }
                        catch (IOException e) {
                            logger.warn("read HDFS {} failed will retry, error detail {}", (Object)this.location.getStorageInfo().getFilePath(), (Object)e);
                            try {
                                this.hdfsInputStream.close();
                                this.hdfsInputStream = ShuffleClient.getHdfsFs(this.conf).open(new Path(Utils.getSortedFilePath(this.location.getStorageInfo().getFilePath())));
                                this.hdfsInputStream.readFully(offset, buffer);
                            }
                            catch (IOException ex) {
                                logger.warn("retry read HDFS {} failed, error detail {} ", (Object)this.location.getStorageInfo().getFilePath(), (Object)e);
                                this.exception.set(ex);
                                break;
                            }
                        }
                        this.results.put(Unpooled.wrappedBuffer(buffer));
                        logger.debug("add index {} to results", (Object)this.currentChunkIndex++);
                    }
                }
                catch (Exception e) {
                    logger.warn("Fetch thread is cancelled.", (Throwable)e);
                }
                logger.debug("fetch {} is done.", (Object)this.location.getStorageInfo().getFilePath());
            });
        }
        try {
            while (chunk == null) {
                this.checkException();
                Long startFetchWait = System.nanoTime();
                chunk = this.results.poll(500L, TimeUnit.MILLISECONDS);
                this.metricsCallback.incReadTime(TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startFetchWait));
                logger.debug("poll result with result size: {}", (Object)this.results.size());
            }
        }
        catch (InterruptedException e) {
            logger.error("PartitionReader thread interrupted while fetching data.");
            throw e;
        }
        ++this.returnedChunks;
        return chunk;
    }

    private void checkException() throws IOException {
        IOException e = this.exception.get();
        if (e != null) {
            throw e;
        }
    }

    @Override
    public void close() {
        this.closed = true;
        if (this.fetchThread != null) {
            this.fetchThread.shutdownNow();
        }
        try {
            this.hdfsInputStream.close();
        }
        catch (IOException e) {
            logger.warn("close HDFS input stream failed.", (Throwable)e);
        }
        if (this.results.size() > 0) {
            this.results.forEach(ReferenceCounted::release);
        }
        this.results.clear();
        this.closeStream();
    }

    private void closeStream() {
        if (this.client != null && this.client.isActive()) {
            TransportMessage bufferStreamEnd = new TransportMessage(MessageType.BUFFER_STREAM_END, PbBufferStreamEnd.newBuilder().setStreamType(StreamType.ChunkStream).setStreamId(this.streamHandler.getStreamId()).build().toByteArray());
            this.client.sendRpc(bufferStreamEnd.toByteBuffer());
        }
    }

    @Override
    public PartitionLocation getLocation() {
        return this.location;
    }
}

