/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.common.network.protocol;

import io.netty.buffer.ByteBuf;
import java.util.Objects;
import org.apache.celeborn.common.network.buffer.ManagedBuffer;
import org.apache.celeborn.common.network.buffer.NettyManagedBuffer;
import org.apache.celeborn.common.network.protocol.Encoders;
import org.apache.celeborn.common.network.protocol.Message;
import org.apache.celeborn.common.network.protocol.RequestMessage;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

public final class PushData
extends RequestMessage {
    public long requestId;
    public final byte mode;
    public final String shuffleKey;
    public final String partitionUniqueId;

    public PushData(byte mode, String shuffleKey, String partitionUniqueId, ManagedBuffer body) {
        this(0L, mode, shuffleKey, partitionUniqueId, body);
    }

    private PushData(long requestId, byte mode, String shuffleKey, String partitionUniqueId, ManagedBuffer body) {
        super(body);
        this.requestId = requestId;
        this.mode = mode;
        this.shuffleKey = shuffleKey;
        this.partitionUniqueId = partitionUniqueId;
    }

    @Override
    public Message.Type type() {
        return Message.Type.PUSH_DATA;
    }

    @Override
    public int encodedLength() {
        return 9 + Encoders.Strings.encodedLength(this.shuffleKey) + Encoders.Strings.encodedLength(this.partitionUniqueId);
    }

    @Override
    public void encode(ByteBuf buf) {
        buf.writeLong(this.requestId);
        buf.writeByte((int)this.mode);
        Encoders.Strings.encode(buf, this.shuffleKey);
        Encoders.Strings.encode(buf, this.partitionUniqueId);
    }

    public static PushData decode(ByteBuf buf) {
        return PushData.decode(buf, true);
    }

    public static PushData decode(ByteBuf buf, boolean decodeBody) {
        long requestId = buf.readLong();
        byte mode = buf.readByte();
        String shuffleKey = Encoders.Strings.decode(buf);
        String partitionUniqueId = Encoders.Strings.decode(buf);
        if (decodeBody) {
            return new PushData(requestId, mode, shuffleKey, partitionUniqueId, new NettyManagedBuffer(buf));
        }
        return new PushData(requestId, mode, shuffleKey, partitionUniqueId, NettyManagedBuffer.EmptyBuffer);
    }

    public int hashCode() {
        return Objects.hash(this.requestId, this.mode, this.shuffleKey, this.partitionUniqueId, this.body());
    }

    public boolean equals(Object other) {
        if (other instanceof PushData) {
            PushData o = (PushData)other;
            return this.requestId == o.requestId && this.mode == o.mode && this.shuffleKey.equals(o.shuffleKey) && this.partitionUniqueId.equals(o.partitionUniqueId) && super.equals(o);
        }
        return false;
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("requestId", this.requestId).append("mode", this.mode).append("shuffleKey", (Object)this.shuffleKey).append("partitionUniqueId", (Object)this.partitionUniqueId).append("body size", this.body().size()).toString();
    }
}

