/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.server.common.service.config;

import java.io.IOException;
import java.util.List;
import org.apache.celeborn.common.CelebornConf;
import org.apache.celeborn.server.common.service.config.DynamicConfig;
import org.apache.celeborn.server.common.service.config.SystemConfig;
import org.apache.celeborn.server.common.service.config.TenantConfig;

public interface ConfigService {
    public CelebornConf getCelebornConf();

    public SystemConfig getSystemConfigFromCache();

    public List<TenantConfig> listRawTenantConfigsFromCache();

    public TenantConfig getRawTenantConfigFromCache(String var1);

    default public DynamicConfig getTenantConfigFromCache(String tenantId) {
        TenantConfig tenantConfig = this.getRawTenantConfigFromCache(tenantId);
        if (tenantConfig == null || tenantConfig.getConfigs().isEmpty()) {
            return this.getSystemConfigFromCache();
        }
        return tenantConfig;
    }

    public List<TenantConfig> listRawTenantUserConfigsFromCache();

    public TenantConfig getRawTenantUserConfigFromCache(String var1, String var2);

    default public DynamicConfig getTenantUserConfigFromCache(String tenantId, String userId) {
        TenantConfig tenantConfig = this.getRawTenantUserConfigFromCache(tenantId, userId);
        if (tenantConfig == null || tenantConfig.getConfigs().isEmpty()) {
            return this.getTenantConfigFromCache(tenantId);
        }
        return tenantConfig;
    }

    public void refreshCache() throws IOException;

    public void shutdown();
}

