//
// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.
//
package org.apache.cloudstack.reservation.dao;

import org.apache.cloudstack.reservation.ReservationVO;

import com.cloud.configuration.Resource;
import com.cloud.utils.db.GenericDao;

import java.util.Date;
import java.util.List;

public interface ReservationDao extends GenericDao<ReservationVO, Long> {
    long getAccountReservation(Long account, Resource.ResourceType resourceType, String tag);
    long getDomainReservation(Long domain, Resource.ResourceType resourceType, String tag);
    void setResourceId(Resource.ResourceType type, Long resourceId);
    List<ReservationVO> getReservationsForAccount(long accountId, Resource.ResourceType type, String tag);
    void removeByIds(List<Long> reservationIds);

    int removeByMsId(long managementServerId);

    int removeStaleReservations(Long accountId, Resource.ResourceType resourceType, String tag, Date createdBefore);
}
