/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.fileupload2.core;

import java.io.UnsupportedEncodingException;
import org.apache.commons.fileupload2.core.MimeUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public final class MimeUtilityTestCase {
    private static void assertEncoded(String expected, String encoded) throws Exception {
        Assertions.assertEquals((Object)expected, (Object)MimeUtils.decodeText((String)encoded));
    }

    @Test
    void testDecodeInvalidEncoding() {
        Assertions.assertThrows(UnsupportedEncodingException.class, () -> MimeUtils.decodeText((String)"=?invalid?B?xyz-?="));
    }

    @Test
    void testDecodeIso88591Base64Encoded() throws Exception {
        MimeUtilityTestCase.assertEncoded("If you can read this you understand the example.", "=?ISO-8859-1?B?SWYgeW91IGNhbiByZWFkIHRoaXMgeW8=?= =?ISO-8859-2?B?dSB1bmRlcnN0YW5kIHRoZSBleGFtcGxlLg==?=\"\r\n");
    }

    @Test
    void testDecodeIso88591Base64EncodedWithWhiteSpace() throws Exception {
        MimeUtilityTestCase.assertEncoded("If you can read this you understand the example.", "=?ISO-8859-1?B?SWYgeW91IGNhbiByZWFkIHRoaXMgeW8=?=\t  \r\n   =?ISO-8859-2?B?dSB1bmRlcnN0YW5kIHRoZSBleGFtcGxlLg==?=\"\r\n");
    }

    @Test
    void testDecodeUtf8Base64Encoded() throws Exception {
        MimeUtilityTestCase.assertEncoded(" h\u00e9! \u00e0\u00e8\u00f4u !!!", "=?UTF-8?B?IGjDqSEgw6DDqMO0dSAhISE=?=");
    }

    @Test
    void testDecodeUtf8QuotedPrintableEncoded() throws Exception {
        MimeUtilityTestCase.assertEncoded(" h\u00e9! \u00e0\u00e8\u00f4u !!!", "=?UTF-8?Q?_h=C3=A9!_=C3=A0=C3=A8=C3=B4u_!!!?=");
    }

    @Test
    void testNoNeedToDecode() throws Exception {
        MimeUtilityTestCase.assertEncoded("abc", "abc");
    }
}

