/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jxpath.ri.model.beans;

import java.util.Locale;
import org.apache.commons.jxpath.JXPathContext;
import org.apache.commons.jxpath.ri.QName;
import org.apache.commons.jxpath.ri.model.NodePointer;
import org.apache.commons.jxpath.ri.model.beans.NullPropertyPointer;
import org.apache.commons.jxpath.ri.model.beans.PropertyOwnerPointer;
import org.apache.commons.jxpath.ri.model.beans.PropertyPointer;

public class NullPointer
extends PropertyOwnerPointer {
    private static final long serialVersionUID = 2193425983220679887L;
    private final QName qName;
    private final String id;

    public NullPointer(Locale locale, String id) {
        super(null, locale);
        this.id = id;
        this.qName = null;
    }

    public NullPointer(NodePointer parent, QName qName) {
        super(parent);
        this.qName = qName;
        this.id = null;
    }

    public NullPointer(QName qName, Locale locale) {
        super(null, locale);
        this.qName = qName;
        this.id = null;
    }

    @Override
    public String asPath() {
        if (this.id != null) {
            return "id(" + this.id + ")";
        }
        return this.parent == null ? "null()" : super.asPath();
    }

    @Override
    public NodePointer createChild(JXPathContext context, QName qName, int index) {
        return this.createPath(context).createChild(context, qName, index);
    }

    @Override
    public NodePointer createChild(JXPathContext context, QName qName, int index, Object value) {
        return this.createPath(context).createChild(context, qName, index, value);
    }

    @Override
    public NodePointer createPath(JXPathContext context) {
        if (this.parent != null) {
            return this.parent.createPath(context).getValuePointer();
        }
        throw new UnsupportedOperationException("Cannot create the root object: " + this.asPath());
    }

    @Override
    public NodePointer createPath(JXPathContext context, Object value) {
        if (this.parent != null) {
            return this.parent.createPath(context, value).getValuePointer();
        }
        throw new UnsupportedOperationException("Cannot create the root object: " + this.asPath());
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof NullPointer)) {
            return false;
        }
        NullPointer other = (NullPointer)object;
        return this.qName == other.qName || this.qName != null && this.qName.equals(other.qName);
    }

    @Override
    public Object getBaseValue() {
        return null;
    }

    @Override
    public int getLength() {
        return 0;
    }

    @Override
    public QName getName() {
        return this.qName;
    }

    @Override
    public PropertyPointer getPropertyPointer() {
        return new NullPropertyPointer(this);
    }

    public int hashCode() {
        return this.qName == null ? 0 : this.qName.hashCode();
    }

    @Override
    public boolean isActual() {
        return false;
    }

    @Override
    public boolean isCollection() {
        return false;
    }

    @Override
    public boolean isLeaf() {
        return true;
    }
}

