/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rat.commandline;

import java.io.File;
import org.apache.commons.cli.Converter;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.rat.ConfigurationException;
import org.apache.rat.report.claim.ClaimStatistic;

public final class Converters {
    public static final Converter<File, NullPointerException> FILE_CONVERTER = s -> new File(s).getAbsoluteFile();
    public static final Converter<Pair<ClaimStatistic.Counter, Integer>, ConfigurationException> COUNTER_CONVERTER = arg -> {
        String[] parts = arg.split(":");
        try {
            ClaimStatistic.Counter counter = ClaimStatistic.Counter.valueOf(parts[0].toUpperCase());
            Integer limit = Integer.parseInt(parts[1]);
            return Pair.of(counter, limit);
        }
        catch (NumberFormatException e) {
            throw new ConfigurationException(String.format("'%s' is not a valid integer", parts[1]), e);
        }
        catch (IllegalArgumentException e) {
            throw new ConfigurationException(String.format("'%s' is not a valid Counter", parts[0]), e);
        }
    };

    private Converters() {
    }
}

