/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.metadata.resolver.impl;

import com.google.common.io.BaseEncoding;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.resolver.CriteriaSet;
import org.opensaml.saml.common.binding.artifact.SAMLArtifact;
import org.opensaml.saml.common.binding.artifact.SAMLSourceIDArtifact;
import org.opensaml.saml.criterion.ArtifactCriterion;
import org.opensaml.saml.metadata.resolver.impl.MetadataQueryProtocolRequestURLBuilder;

public class SAMLArtifactURLBuilder
implements MetadataQueryProtocolRequestURLBuilder.MetadataQueryProtocolURLBuilder {
    @Nonnull
    private static final BaseEncoding HEX = BaseEncoding.base16().lowerCase();

    @Override
    @Nullable
    public String buildURL(@Nonnull String baseURL, @Nullable CriteriaSet criteria) {
        ArtifactCriterion artifactCriterion;
        ArtifactCriterion artifactCriterion2 = artifactCriterion = criteria != null ? (ArtifactCriterion)criteria.get(ArtifactCriterion.class) : null;
        if (artifactCriterion == null) {
            return null;
        }
        SAMLArtifact sAMLArtifact = artifactCriterion.getArtifact();
        if (sAMLArtifact instanceof SAMLSourceIDArtifact) {
            SAMLSourceIDArtifact art = (SAMLSourceIDArtifact)sAMLArtifact;
            return this.buildFromSourceID(baseURL, art);
        }
        return null;
    }

    @Nullable
    private String buildFromSourceID(@Nonnull String baseURL, @Nonnull SAMLSourceIDArtifact sourceIDArtifact) {
        return baseURL + "entities/%7Bsha1%7D" + HEX.encode(sourceIDArtifact.getSourceID());
    }
}

