/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.protocol.core.impl.wireformat;

import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionXAResponseMessage;

public class SessionXAResponseMessage_V2
extends SessionXAResponseMessage {
    private long correlationID;

    public SessionXAResponseMessage_V2(long correlationID, boolean isError, int responseCode, String message) {
        super(isError, responseCode, message);
        this.correlationID = correlationID;
    }

    public SessionXAResponseMessage_V2() {
    }

    @Override
    public long getCorrelationID() {
        return this.correlationID;
    }

    @Override
    public void encodeRest(ActiveMQBuffer buffer) {
        super.encodeRest(buffer);
        buffer.writeLong(this.correlationID);
    }

    @Override
    public void decodeRest(ActiveMQBuffer buffer) {
        super.decodeRest(buffer);
        this.correlationID = buffer.readableBytes() >= 8 ? buffer.readLong() : -1L;
    }

    @Override
    public final boolean isResponse() {
        return true;
    }

    @Override
    public final boolean isResponseAsync() {
        return true;
    }

    @Override
    protected String getPacketString() {
        StringBuffer buff = new StringBuffer(super.getPacketString());
        buff.append(", error=" + this.error);
        buff.append(", message=" + this.message);
        buff.append(", responseCode=" + this.responseCode);
        buff.append(", correlationID=" + this.correlationID);
        return buff.toString();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (int)(this.correlationID ^ this.correlationID >>> 32);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof SessionXAResponseMessage_V2)) {
            return false;
        }
        SessionXAResponseMessage_V2 other = (SessionXAResponseMessage_V2)obj;
        return this.correlationID == other.correlationID;
    }
}

