---
{
    "title": "SET-PROPERTY",
    "language": "en"
}
---

<!--
Licensed to the Apache Software Foundation (ASF) under one
or more contributor license agreements.  See the NOTICE file
distributed with this work for additional information
regarding copyright ownership.  The ASF licenses this file
to you under the Apache License, Version 2.0 (the
"License"); you may not use this file except in compliance
with the License.  You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing,
software distributed under the License is distributed on an
"AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
KIND, either express or implied.  See the License for the
specific language governing permissions and limitations
under the License.
-->

## SET-PROPERTY

### Name

SET PROPERTY

### Description

Set user attributes, including resources assigned to users, importing clusters, etc.

```sql
SET PROPERTY [FOR 'user'] 'key' = 'value' [, 'key' = 'value']
````

The user attribute set here is for user, not user_identity. That is, if two users 'jack'@'%' and 'jack'@'192.%' are created through the CREATE USER statement, the SET PROPERTY statement can only be used for the user jack, not 'jack'@'% ' or 'jack'@'192.%'

key:

Super user privileges:

 max_user_connections: The maximum number of connections.

 max_query_instances: The number of instances that a user can use to execute a query at the same time.

 sql_block_rules: Set sql block rules. Once set, queries sent by this user will be rejected if they match the rules.

 cpu_resource_limit: Limit the cpu resources for queries. See the introduction to the session variable `cpu_resource_limit` for details. -1 means not set.

 exec_mem_limit: Limit the memory usage of the query. See the introduction to the session variable `exec_mem_limit` for details. -1 means not set.

 resource.cpu_share: CPU resource allocation. (obsolete)

 load_cluster.{cluster_name}.priority: Assign priority to the specified cluster, which can be HIGH or NORMAL

 resource_tags: Specifies the user's resource tag permissions.

 query_timeout: Specifies the user's query timeout permissions.

    Note: If the attributes `cpu_resource_limit`, `exec_mem_limit` are not set, the value in the session variable will be used by default.

Ordinary user rights:

 quota.normal: resource allocation at the normal level.

 quota.high: High-level resource allocation.

 quota.low: resource allocation at low level.

 load_cluster.{cluster_name}.hadoop_palo_path: The hadoop directory used by palo, which needs to store the etl program and the intermediate data generated by etl for Doris to import. After the import is completed, the intermediate will be automatically cleaned up

Data, etl program automatically retains the next use.

 load_cluster.{cluster_name}.hadoop_configs: The configuration of hadoop, where fs.default.name, mapred.job.tracker, hadoop.job.ugi must be filled in.

 load_cluster.{cluster_name}.hadoop_http_port: hadoop hdfs name node http port. Where hdfs defaults to 8070, afs defaults to 8010.

 default_load_cluster: The default import cluster.

### Example

1. Modify the maximum number of user jack connections to 1000

   ```sql
   SET PROPERTY FOR 'jack' 'max_user_connections' = '1000';
   ````

2. Modify the cpu_share of user jack to 1000

   ```sql
   SET PROPERTY FOR 'jack' 'resource.cpu_share' = '1000';
   ````

3. Modify the weight of the jack user's normal group

   ```sql
   SET PROPERTY FOR 'jack' 'quota.normal' = '400';
   ````

4. Add import cluster for user jack

   ```sql
   SET PROPERTY FOR 'jack'
       'load_cluster.{cluster_name}.hadoop_palo_path' = '/user/doris/doris_path',
       'load_cluster.{cluster_name}.hadoop_configs' = 'fs.default.name=hdfs://dpp.cluster.com:port;mapred.job.tracker=dpp.cluster.com:port;hadoop.job.ugi=user ,password;mapred.job.queue.name=job_queue_name_in_hadoop;mapred.job.priority=HIGH;';
   ````

5. Delete the imported cluster under user jack.

   ```sql
   SET PROPERTY FOR 'jack' 'load_cluster.{cluster_name}' = '';
   ````

6. Modify the default import cluster of user jack

   ```sql
   SET PROPERTY FOR 'jack' 'default_load_cluster' = '{cluster_name}';
   ````

7. Change the cluster priority of user jack to HIGH

   ```sql
   SET PROPERTY FOR 'jack' 'load_cluster.{cluster_name}.priority' = 'HIGH';
   ````

8. Modify the number of available instances for user jack's query to 3000

   ```sql
   SET PROPERTY FOR 'jack' 'max_query_instances' = '3000';
   ````

9. Modify the sql block rule of user jack

   ```sql
   SET PROPERTY FOR 'jack' 'sql_block_rules' = 'rule1, rule2';
   ````

10. Modify the cpu usage limit of user jack

    ```sql
    SET PROPERTY FOR 'jack' 'cpu_resource_limit' = '2';
    ````

11. Modify the user's resource tag permissions

    ```sql
    SET PROPERTY FOR 'jack' 'resource_tags.location' = 'group_a, group_b';
    ````

12. Modify the user's query memory usage limit, in bytes

    ```sql
    SET PROPERTY FOR 'jack' 'exec_mem_limit' = '2147483648';
    ````

13. Modify the user's query timeout limit, in second

    ```sql
    SET PROPERTY FOR 'jack' 'query_timeout' = '500';
    ````

### Keywords

    SET, PROPERTY

### Best Practice

