// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

suite("fold_constant_string_arithmatic") {
    sql "set enable_nereids_planner=true"
    sql "set enable_fallback_to_original_planner=false"
    sql "set enable_fold_constant_by_be=false"

    // append_trailing_char_if_absent
    testFoldConst("select append_trailing_char_if_absent('', '!')")
    testFoldConst("select append_trailing_char_if_absent(12345, '!')")
    testFoldConst("select append_trailing_char_if_absent('a','c')")
    testFoldConst("select append_trailing_char_if_absent('ac','c')")
    testFoldConst("select append_trailing_char_if_absent(cast('a' as string), cast('c' as string))")
    testFoldConst("select append_trailing_char_if_absent(cast('ac' as string), cast('c' as string))")
    testFoldConst("select append_trailing_char_if_absent('hello!', '!')")
//    testFoldConst("select append_trailing_char_if_absent('hello', '😊')")
//    testFoldConst("select append_trailing_char_if_absent('hello😊', '😊')")
//    testFoldConst("select append_trailing_char_if_absent('hello😊', '(ಥ _ ಥ)')")
    testFoldConst("select append_trailing_char_if_absent('hello', ' ')")
    testFoldConst("select append_trailing_char_if_absent('hello', '')")
    testFoldConst("select append_trailing_char_if_absent('hello', '?')")
    testFoldConst("select append_trailing_char_if_absent('hello?', '!')")
    testFoldConst("select append_trailing_char_if_absent('hello', '1')")
    testFoldConst("select append_trailing_char_if_absent('hello', 1)")
    testFoldConst("select append_trailing_char_if_absent('hello', 'ab')")
    testFoldConst("select append_trailing_char_if_absent('hello', NULL)")
    testFoldConst("select append_trailing_char_if_absent('hello', 'ell')")
    testFoldConst("select append_trailing_char_if_absent('hello', 'ello')")
    testFoldConst("select append_trailing_char_if_absent('ello', 'hello')")
    testFoldConst("select append_trailing_char_if_absent('it','a')")
    testFoldConst("select append_trailing_char_if_absent(NULL, '!')")
    testFoldConst("select append_trailing_char_if_absent('This is a very long string', '.')")
    testFoldConst("select append_trailing_char_if_absent('Привет', '!')")
    testFoldConst("select append_trailing_char_if_absent('Привет', 'вет')")
    testFoldConst("select append_trailing_char_if_absent('こんにちは', '!')")
    testFoldConst("select append_trailing_char_if_absent('\n\t', '\n')")
    testFoldConst("select append_trailing_char_if_absent('こんにちは', 'ちは')")
    testFoldConst("select append_trailing_char_if_absent('中文', '文')")
    testFoldConst("select append_trailing_char_if_absent('中', '文')")
    testFoldConst("select append_trailing_char_if_absent('', '文')")
    
    // ascii
    testFoldConst("select ascii('!')")
    testFoldConst("select ascii('1')")
    testFoldConst("select ascii('a')")
    testFoldConst("select ascii('A')")
    testFoldConst("select ascii('こ')")
    testFoldConst("select ascii('안')")
    testFoldConst("select ascii('안こ')")
    testFoldConst("select ascii('')")
    testFoldConst("select ascii('中')")

    // bin
    testFoldConst("select bin(5)")
    testFoldConst("select bin(-5)")
    testFoldConst("select bin(9223372036854775807)")
    testFoldConst("select bin(9223372036854775808)")
    testFoldConst("select bin(-9223372036854775809)")

    // bit_length
    testFoldConst("select bit_length('abc')")
    testFoldConst("select bit_length(cast('abc' as string))")
    testFoldConst("select bit_length('こんにちは世界')")
    testFoldConst("select bit_length('안녕하세요 세계!')")
    testFoldConst("select bit_length('')")

    // char
    testFoldConst("select char(65)")
    testFoldConst("select char(-1)")
    testFoldConst("select char(65535)")

    // character_length
    testFoldConst("select character_length(cast('Hello World' as string))")
    testFoldConst("select character_length('Hello World')")
    testFoldConst("select character_length('你好 世界')")
    testFoldConst("select character_length(' Hello World')")
    testFoldConst("select character_length('  你好 世界')")
    testFoldConst("select character_length('Hello World  ')")
    testFoldConst("select character_length('  你好 世界  ')")
    testFoldConst("select char_length('abc')")
    testFoldConst("select char_length(cast('abc' as string))")
    testFoldConst("select char_length('你好 世界')")
    testFoldConst("select char_length('  abc')")
    testFoldConst("select char_length('  你好 世界')")
    testFoldConst("select char_length('你好 世界  ')")

    // concat
    testFoldConst("select concat('a', 'b')")
    testFoldConst("select concat('a', 'b', 'c')")
    testFoldConst("select concat('a', null, 'c')")
    testFoldConst("select concat('Hello', NULL, 'World')")
    testFoldConst("select concat('Hello', ' ', 'World')")
    testFoldConst("select concat('你好', ' ', '世界')")
    testFoldConst("select concat('', '你好', ' ', '世界')")
    testFoldConst("select concat('你好', ' ', '世界', '')")

    // concat_ws
    testFoldConst("select concat_ws('-', '2024', '09', '02')")
    testFoldConst("select concat_ws('', '2024', '09', '02')")
    testFoldConst("select concat_ws('-', '', '2024', '09', '02')")
    testFoldConst("select concat_ws(NULL, ['d', 'is'])")
    testFoldConst("select concat_ws(NULL, 'd', 'is')")
    testFoldConst("select concat_ws('or', ['d', '','is'])")
    testFoldConst("select concat_ws('or', ['d', 'is'])")
    testFoldConst("select concat_ws('or', 'd', 'is')")
    testFoldConst("select concat_ws('or', ['d', NULL,'is'])")
    testFoldConst("select concat_ws('or', 'd', NULL,'is')")
    testFoldConst("select concat_ws(' ', '你好', '世界')")
    testFoldConst("select concat_ws(' ', [])")

    // elt
    testFoldConst("select elt(0, cast('hello' as string), cast('doris' as string))")
    testFoldConst("select elt(0, 'hello', 'doris')")
    testFoldConst("select elt(1, cast('hello' as string), cast('doris' as string))")
    testFoldConst("select elt(1, 'hello', 'doris')")
    testFoldConst("select elt(2, cast('hello' as string), cast('doris' as string))")
    testFoldConst("select elt(2, 'hello', 'doris')")
    testFoldConst("select elt(3, cast('hello' as string), cast('doris' as string))")
    testFoldConst("select elt(3, 'hello', 'doris')")
    testFoldConst("select c1, c2, elt(c1, c2) from (select number as c1, 'varchar' as c2 from numbers('number'='5') where number > 0) a")

    // ends_with
    testFoldConst("select ends_with(cast('Hello doris' as string), cast('doris' as string))")
    testFoldConst("select ends_with('Hello doris', 'doris')")
    testFoldConst("select ends_with('こんにちは世界！안녕하세요 세계', '안녕하세요 세계')")
    testFoldConst("select ends_with('안녕하세요 세계こんにちは世界！', 'こんにちは世界！')")
    testFoldConst("select ends_with('안녕하세요 세계こんにちは世界', 'こんにちは世界')")
    testFoldConst("select ends_with('안녕하세요 세계こんにちは世界', 'こんにちは')")
    testFoldConst("select ends_with('Hello doris', '')")
    testFoldConst("select ends_with('', 'Hello doris')")
    testFoldConst("select ends_with(null, 'Hello doris')")
    testFoldConst("select ends_with('Hello doris', null)")
    testFoldConst("select ends_with(' ', '')")
    testFoldConst("select ends_with(' ', ' ')")
    testFoldConst("select ends_with('', ' ')")
    testFoldConst("select ends_with('', '')")

    // field
    testFoldConst("select field('b', 'a', 'b', 'c')")
    testFoldConst("select field('d', 'a', 'b', 'c')")
    testFoldConst("select field('こ', 'ん', 'に', 'ち', 'こ')")
    testFoldConst("select field('=', '+', '=', '=', 'こ')")
    testFoldConst("select field('==', '+', '=', '==', 'こ')")
    testFoldConst("select field('=', '+', '==', '==', 'こ')")

    // find_in_set
    testFoldConst("select find_in_set('a', null)")
    testFoldConst("select find_in_set('b', 'a,b,c')")
    testFoldConst("select find_in_set('b', ' a,b,c')")
    testFoldConst("select find_in_set('b', 'a ,b,c')")
    testFoldConst("select find_in_set('b', 'a, b,c')")
    testFoldConst("select find_in_set('b', 'a,b,c ')")
    testFoldConst("select find_in_set('a,b,c ', 'a,b,c')")
    testFoldConst("select find_in_set('b', 'a,b,c')")
    testFoldConst("select find_in_set(cast('a' as string), NULL)")
    testFoldConst("select find_in_set(cast('b' as string), cast('a,b,c' as string))")
    testFoldConst("select find_in_set(cast('b' as string), cast('a,b,c' as string))")
    testFoldConst("select find_in_set(cast('d' as string), cast('a,b,c' as string))")
    testFoldConst("select find_in_set(cast('d' as string), cast('a,b,c' as string))")
    testFoldConst("select find_in_set('d', 'a,b,c')")
    testFoldConst("select find_in_set('d', 'a,b,c')")
    testFoldConst("select find_in_set(null, 'a,b,c')")
    testFoldConst("select find_in_set(NULL, cast('a,b,c' as string))")
    testFoldConst("SELECT find_in_set('A', '哈哈哈AAA')")
    testFoldConst("SELECT find_in_set('哈','哈哈哈AAA')")
    testFoldConst("SELECT find_in_set(' ','哈哈哈AAA')")
    testFoldConst("SELECT find_in_set('','哈哈哈AAA')")
    testFoldConst("SELECT find_in_set(',','a,')")
    testFoldConst("SELECT find_in_set(',','哈哈哈AAA')")

    // hex
    testFoldConst("select hex('@')")
    testFoldConst("select hex('1')")
    testFoldConst("select hex(-1)")
    testFoldConst("select hex(-1)")
    testFoldConst("select hex('12')")
    testFoldConst("select hex(12)")
    testFoldConst("select hex(12)")
    testFoldConst("select hex(-255)")
    testFoldConst("select hex(-255)")
    testFoldConst("select hex(255)")
    testFoldConst("select hex(255)")
    testFoldConst("select hex('A')")
    testFoldConst("select hex(cast('12' as string))")
    testFoldConst("select hex(cast('1' as string))")
    testFoldConst("select hex(cast('A' as string))")
    testFoldConst("select hex(cast('@' as string))")
    testFoldConst("select hex(cast('hello,doris' as string))")
    testFoldConst("select hex('hello,doris')")

    // ifnull
    testFoldConst("select ifnull(null,3)")
    testFoldConst("select ifnull(3,null)")
    testFoldConst("select ifnull(null,null)")

    // initcap
    // testFoldConst("select initcap('AbC123abc abc.abc,?|abc')")
    // testFoldConst("select initcap(cast('AbC123abc abc.abc,?|abc' as string))")
    // testFoldConst("select initcap(cast('hello world' as string))")
    // testFoldConst("select initcap('hello world')")
    // testFoldConst("select initcap(' hello world')")
    // testFoldConst("select initcap('こんにちは')")
    // testFoldConst("select initcap('上海天津北京杭州')")
    // testFoldConst("select initcap('ab')")
    // testFoldConst("select initcap('aBc')")
    // testFoldConst("select initcap('a,b,c')")
    // testFoldConst("select initcap('a;b;c')")
    // testFoldConst("select initcap(null)")
    // testFoldConst("select initcap('')")
    // testFoldConst("select initcap(123)")
    // testFoldConst("select initcap(0)")
    // testFoldConst("select initcap(true)")
    // testFoldConst("select initcap(' a ')")
    // testFoldConst("select initcap('中文字')")
    // testFoldConst("select initcap('<d83d><dc3c>abc')")
    // testFoldConst("select initcap('2023-01-01')")
    // testFoldConst("select initcap('aBcDeF')")
    // testFoldConst("select initcap('hello world!')")
    // testFoldConst("select initcap('123abcDEF')")
    // testFoldConst("select initcap(' ')")
    // testFoldConst("select initcap('null')")
    // testFoldConst("select initcap('ärger')")
    // testFoldConst("select initcap('über')")
    // testFoldConst("select initcap('a1!b2@c3#')")
    // testFoldConst("select initcap('john o''connor')")
    // testFoldConst("select initcap('mcdonald''s')")
    // testFoldConst("select initcap('abc-def')")
    // testFoldConst("select initcap('foo_bar')")
    // testFoldConst("select initcap(' test ')")
    // testFoldConst("select initcap('xyz,zyx')")
    // testFoldConst("select initcap('123 456')")
    // testFoldConst("select initcap('.,abc')")
    // testFoldConst("select initcap('[]test')")
    // testFoldConst("select initcap('<d83d><dc3c><d83d><dc3b>')")
    // testFoldConst("select initcap('aaAAaa')")
    // testFoldConst("select initcap(substring('abcd', 2))")
    // testFoldConst("select initcap(concat('a', '-test'))")
    // testFoldConst("select initcap('hello world')")
    // testFoldConst("select initcap('mixedCASE')")
    // testFoldConst("select initcap('UPPERCASE')")
    // testFoldConst("select initcap('lowercase')")
    // testFoldConst("select initcap('multiple spaces')")
    // testFoldConst("select initcap('hyphenated-word')")
    // testFoldConst("select initcap('under_score')")
    // testFoldConst("select initcap('dot.test')")
    // testFoldConst("select initcap('colon:test')")
    // testFoldConst("select initcap('semi;test')")
    // testFoldConst("select initcap('quote''test')")
    // testFoldConst("select initcap('slash/test')")
    // testFoldConst("select initcap('emoji<d83d><dc3c>test')")
    // testFoldConst("select initcap('数字123test')")
    // testFoldConst("select initcap(' leading space')")
    // testFoldConst("select initcap('trailing space ')")
    // testFoldConst("select initcap(' multiple ')")
    // testFoldConst("select initcap('a.b.c.d')")
    // testFoldConst("select initcap('test-123-test')")
    // testFoldConst("select initcap('mixed_separators-here')")
    // testFoldConst("select initcap('ÄÖÜäöü')")
    // testFoldConst("select initcap('àçèñ')")
    // testFoldConst("select initcap('')")
    // testFoldConst("select initcap(' ')")
    // testFoldConst("select initcap('9am')")
    // testFoldConst("select initcap('sign')")
    // testFoldConst("select initcap('hash#tag')")
    // testFoldConst("select initcap('at@sign')")
    // testFoldConst("select initcap('caret^test')")
    // testFoldConst("select initcap('amp&test')")
    // testFoldConst("select initcap('star*test')")
    // testFoldConst("select initcap('plus+test')")
    // testFoldConst("select initcap('minus-test')")
    // testFoldConst("select initcap('equals=test')")
    // testFoldConst("select initcap('tilde~test')")
    // testFoldConst("select initcap('backtick`test')")
    // testFoldConst("select initcap('pipe|test')")
    // testFoldConst("select initcap('brace{test')")
    // testFoldConst("select initcap('bracket[test')")
    // testFoldConst("select initcap('less<test')")
    // testFoldConst("select initcap('greater>test')")
    // testFoldConst("select initcap('slash/test')")
    // testFoldConst("select initcap('question?test')")
    // testFoldConst("select initcap('space test')")
    // testFoldConst("select initcap('emoji<d83d><dc3c>mix')")
    // testFoldConst("select initcap('unicodeñtest')")
    // testFoldConst("select initcap('ÆØÅtest')")
    // testFoldConst("select initcap('çédîñ')")
    // testFoldConst("select initcap('русский')")
    // testFoldConst("select initcap('日本語')")
    // testFoldConst("select initcap('한글')")
    // testFoldConst("select initcap('ﺎﻠﻋﺮﺒﻳﺓ')")
    // testFoldConst("select initcap('<d83d><de0a>test')")
    // testFoldConst("select initcap('<d834><dd1e>music')")
    // testFoldConst("select initcap('<d83c><dd71>button')")
    // testFoldConst("select initcap('<d83c><ddfa><d83c><ddf8>flag')")
    // testFoldConst("select initcap('<d83d><dc68><d83d><dc69><d83d><dc67><d83d><dc66>family')")
    // testFoldConst("select initcap('<d83d><dd25>fire')")
    // testFoldConst("select initcap('<d83d><de80>rocket')")
    // testFoldConst("select initcap('<d83d><dcc5>2023')")
    // testFoldConst("select initcap('√square')")
    // testFoldConst("select initcap('∞infinity')")
    // testFoldConst("select initcap('µmicro')")
    // testFoldConst("select initcap('¶pilcrow')")
    // testFoldConst("select initcap('©copyright')")
    // testFoldConst("select initcap('®registered')")
    // testFoldConst("select initcap('™trademark')")
    // testFoldConst("select initcap('§section')")
    // testFoldConst("select initcap('°degree')")
    // testFoldConst("select initcap('±plusminus')")
    // testFoldConst("select initcap('×multiply')")
    // testFoldConst("select initcap('÷divide')")
    // testFoldConst("select initcap('¹superscript')")
    // testFoldConst("select initcap('₂subscript')")
    // testFoldConst("select initcap('Ωomega')")
    // testFoldConst("select initcap('∆delta')")
    // testFoldConst("select initcap('∑sum')")
    // testFoldConst("select initcap('∏product')")
    // testFoldConst("select initcap('∫integral')")
    // testFoldConst("select initcap('⌘command')")
    // testFoldConst("select initcap('⌥option')")
    // testFoldConst("select initcap('⇧shift')")
    // testFoldConst("select initcap('⌃control')")
    // testFoldConst("select initcap('⌦delete')")
    // testFoldConst("select initcap('⇨arrow')")
    // testFoldConst("select initcap('★star')")
    // testFoldConst("select initcap('☀sun')")
    // testFoldConst("select initcap('☔ umbrella')")
    // testFoldConst("select initcap('☎phone')")
    // testFoldConst("select initcap('✉email')")
    // testFoldConst("select initcap('✓check')")
    // testFoldConst("select initcap('✗cross')")
    // testFoldConst("select initcap('⚠warning')")
    // testFoldConst("select initcap('⏰ clock')")
    // testFoldConst("select initcap('<d83c><df82>cake')")
    // testFoldConst("select initcap('<d83c><df89>party')")
    // testFoldConst("select initcap('⚡ bolt')")
    // testFoldConst("select initcap('⛔ forbidden')")
    // testFoldConst("select initcap('✅ check')")
    // testFoldConst("select initcap('✈plane')")
    // testFoldConst("select initcap('❤heart')")
    // testFoldConst("select initcap('⏩ fast')")
    // testFoldConst("select initcap('<d83d><dd11>key')")

    // instr
    testFoldConst("select instr('上海天津北京杭州', '北京')")
    testFoldConst("select instr('abc', 'b')")
    testFoldConst("select instr('abc', 'd')")
    testFoldConst("select instr('abc', 'abcd')")
    testFoldConst("select instr('abc', null)")
    testFoldConst("select instr(cast('Hello' as string), cast('World' as string))")
    testFoldConst("select instr(cast('Hello World' as string), cast('World' as string))")
    testFoldConst("select instr('foobar', '')")
    testFoldConst("select instr('Hello', 'World')")
    testFoldConst("select instr('Hello World', 'World')")
    testFoldConst("select instr(null, 'a')")
    testFoldConst("select instr(NULL, cast('a' as string))")
    testFoldConst("select instr('', 'World')")

    // lcase
    testFoldConst("select lcase('AbC123')")
    testFoldConst("select lcase(cast('AbC123' as string))")
    testFoldConst("select lcase('上海天津北京杭州')")
    testFoldConst("select lcase('こんにちは')")

    // left
    testFoldConst("select left(CAST('good morning' AS STRING), 120)")
    testFoldConst("select left(CAST('good morning' AS STRING), -5)")
    testFoldConst("select left(CAST('good morning' AS STRING), NULL)")
    testFoldConst("select left(cast('Hello' as string), 10)")
    testFoldConst("select left(cast('Hello doris' as string), 5)")
    testFoldConst("select left(CAST('Hello doris' AS STRING), 5)")
    testFoldConst("select left(cast('Hello World' as string), 5)")
    testFoldConst("select left(CAST(NULL AS STRING), 1)")
    testFoldConst("select left('good morning', 120)")
    testFoldConst("select left('good morning', -5)")
    testFoldConst("select left('good morning', NULL)")
    testFoldConst("select left('Hello', 10)")
    testFoldConst("select left('', 10)")
    testFoldConst("select left(' Hello', 10)")
    testFoldConst("select left('Hello doris', 5)")
    testFoldConst("select left('Hello doris',5)")
    testFoldConst("select left('Hello World', 5)")
    testFoldConst("select left(NULL, 1)")
    testFoldConst("select left('上海天津北京杭州', 5)")
    testFoldConst("select left('上海天津北京杭州', -5)")
    testFoldConst("select left('上海天津北京杭州', 0)")
    testFoldConst("select left('20250409'-10000, 6)")


    // length
    testFoldConst("select length('你')")
    testFoldConst("select length('abc')")
    testFoldConst("select length(cast('abc' as string))")
    testFoldConst("select length(cast('Hello World' as string))")
    testFoldConst("select length('Hello World')")
    testFoldConst("select length('')")
    testFoldConst("select length(' Hello World')")
    testFoldConst("select length(space(10))")

    // locate
    testFoldConst("select locate('北京', '上海天津北京杭州')")
    testFoldConst("select locate('上海天津北京杭州', '北京')")
    testFoldConst("select locate('bar', 'foobarbar')")
    testFoldConst("select locate(cast('北京' as string), cast('上海天津北京杭州' as string))")
    testFoldConst("select locate(cast('' as string), cast('foobar' as string))")
    testFoldConst("select locate(cast('bar' as string), cast('foobarbar' as string))")
    testFoldConst("select locate(cast('World' as string), cast('Hello' as string))")
    testFoldConst("select locate(cast('World' as string), cast('Hello World' as string))")
    testFoldConst("select locate(cast('xbar' as string), cast('foobar' as string))")
    testFoldConst("select locate('', 'foobar')")
    testFoldConst("select locate('World', 'Hello')")
    testFoldConst("select locate('World', 'Hello World')")
    testFoldConst("select locate('xbar', 'foobar')")
    testFoldConst("select locate('北京', '上海天津北京杭州', 4)")
    testFoldConst("select locate('北京', '上海天津北京杭州', 5)")
    testFoldConst("select locate('北京', '上海天津北京杭州', -4)")
    testFoldConst("select locate('北京', '上海天津北京杭州', -5)")
    testFoldConst("select locate('2', '   123  ', 1)")
    testFoldConst("select locate('bc', 'abcbcbc', 4)")
    testFoldConst("select locate('a', 'a')")
    testFoldConst("select locate('', '')")
    testFoldConst("select locate('', '', 2)")
    testFoldConst("select locate('abc', 'abcd')")
    testFoldConst("select locate('', 'hello', 5)")
    testFoldConst("select locate('', 'hello', 6)")
    testFoldConst("select locate('', '哈哈😊😂🤣🤣😄')")
    testFoldConst("select locate('', '哈哈😊😂🤣🤣😄', 26)")
    testFoldConst("select locate('', '哈哈😊😂🤣🤣😄', 27)")
    testFoldConst("select locate('🤣🤣', '哈哈😊😂🤣🤣😄', 5)")
    testFoldConst("select locate('🤣🤣🤣', '哈哈😊😂🤣🤣😄', 5)")
    testFoldConst("select locate('🤣', '哈哈😊😂🤣🤣😄', 6)")
    testFoldConst("select locate('😅', '哈哈😊😂🤣🤣😄', 6)")
    testFoldConst("select locate('안녕', '哈哈こんにち안녕하세', 6)")
    testFoldConst("select locate('하세', '哈哈こんにち안녕하세', 9)")
    testFoldConst("select locate('세', '哈哈こんにち안녕하세', 11)")

    // lower
    testFoldConst("select lower('AbC123')")
    testFoldConst("select lower(cast('AbC123' as string))")
    testFoldConst("select lower(cast('Hello World' as string))")
    testFoldConst("select lower('Hello World')")
    testFoldConst("select lower('ÀÇ')")
//    testFoldConst("SELECT LOWER('İstanbul')")
    testFoldConst("SELECT LOWER('KIZILAY')")
    testFoldConst("SELECT LOWER('GROSSE')")
    testFoldConst("SELECT LOWER('ǅ')")
    testFoldConst("SELECT LOWER('Å')")
//    testFoldConst("SELECT LOWER('ΣΟΦΟΣ')")

    // lpad
    testFoldConst("select lpad(cast('hi' as string), 1, cast('xy' as string))")
    testFoldConst("select lpad(cast('hi' as string), 5, cast('xy' as string))")
    testFoldConst("select lpad('hi', 1, 'xy')")
    testFoldConst("select lpad('hi', 5, 'xy')")
    testFoldConst("select lpad('hi', 1, '')")
    testFoldConst("select lpad('', 1, 'xy')")
    testFoldConst("select lpad('hi', 1, ' ')")
    testFoldConst("select lpad(' ', 1, 'xy')")
    testFoldConst("select lpad(cast('北京' as string), 1, cast('杭州' as string))")
    testFoldConst("select lpad(cast('北京' as string), 5, cast('杭州' as string))")

    // ltrim
    testFoldConst("select ltrim(' 11111', 11)")
    testFoldConst("select ltrim('11111 ', 11)")
    testFoldConst("select ltrim('   ab d')")
    testFoldConst("select ltrim(cast(' 11111' as string), cast(11 as string))")
    testFoldConst("select ltrim(cast('11111 ' as string), cast(11 as string))")
    testFoldConst("select ltrim(cast('   ab d' as string))")
    testFoldConst("select ltrim(cast('Hello' as string))")
    testFoldConst("select ltrim(cast('  Hello World  ' as string))")
    testFoldConst("select ltrim('Hello')")
    testFoldConst("select ltrim('  Hello World  ')")
    testFoldConst("select ltrim('  上海天津北京杭州  ')")

    // md5
    testFoldConst("select md5(cast('Hello World' as string))")
    testFoldConst("select md5('Hello World')")
    testFoldConst("select md5(' Hello World')")
    testFoldConst("select md5('Hello World ')")
    testFoldConst("select md5('')")
    testFoldConst("select md5('こんにちは')")
    testFoldConst("select md5sum('Hello World')")
    testFoldConst("select md5sum('こんにちは')")
    testFoldConst("select md5sum('===*+-')")

    // money_format
    testFoldConst("select money_format(1123.4)")
    testFoldConst("select money_format(1123.456)")
    testFoldConst("select money_format(17014116)")
    testFoldConst("select money_format(truncate(1000,10))")
    testFoldConst("select money_format(-1123.4)")
    testFoldConst("select money_format(-1123.456)")
    testFoldConst("select money_format(-17014116)")
    testFoldConst("select money_format(-truncate(1000,10))")

    // not_null_or_empty
    testFoldConst("select not_null_or_empty('')")
    testFoldConst("select not_null_or_empty('a')")
    testFoldConst("select not_null_or_empty(cast('a' as string))")
    testFoldConst("select not_null_or_empty(cast('' as string))")
    testFoldConst("select not_null_or_empty(cast('       ' as string))")
    testFoldConst("select not_null_or_empty(null)")
    testFoldConst("select not_null_or_empty(NULL)")
    testFoldConst("select not_null_or_empty('\b')")
    testFoldConst("select not_null_or_empty(' \b')")

    // null_or_empty
    testFoldConst("select null_or_empty('')")
    testFoldConst("select null_or_empty('a')")
    testFoldConst("select null_or_empty(cast('a' as string))")
    testFoldConst("select null_or_empty(cast('' as string))")
    testFoldConst("select null_or_empty(null)")
    testFoldConst("select null_or_empty(NULL)")
    testFoldConst("select null_or_empty('\b')")
    testFoldConst("select null_or_empty(' \b')")
    
    // parse_url
    testFoldConst("select parse_url(cast('http://www.example.com/path?query=abc' as string), cast('HOST' as string))")
    testFoldConst("select parse_url('http://www.example.com/path?query=abc', 'HOST')")
    testFoldConst("select parse_url('http://www.example.com/path?query=abc', 'QUERY')")
    testFoldConst("select parse_url('http://www.example.com/path?query=こんにちは', 'QUERY')")
    testFoldConst("select parse_url(\"http://www.example.com/path?query=a\b\'\", 'QUERY')")
    testFoldConst("select parse_url(\"http://www.example.com/path.query=a\b\'\", 'QUERY')")
    testFoldConst("select PARSE_URL('http://example.com', 'PROTOCOL')")
    testFoldConst("select PARSE_URL('http://example.com', 'protocol')")
    testFoldConst("select PARSE_URL('http://example.com', 'Protocol')")
    testFoldConst("select PARSE_URL('http://example.com', 'HOST')")
    testFoldConst("select PARSE_URL('http://example.com', 'host')")
    testFoldConst("select PARSE_URL('http://example.com', 'Host')")
    testFoldConst("select PARSE_URL('http://example.com', 'PATH')")
    testFoldConst("select PARSE_URL('http://example.com/path/to/resource', 'path')")
    testFoldConst("select PARSE_URL('http://example.com/path/to/resource', 'Path')")
    testFoldConst("select PARSE_URL('http://example.com/path/to/resource', 'PATH')")
    testFoldConst("select PARSE_URL('http://example.com/path/to/resource?query=string', 'QUERY')")
    testFoldConst("select PARSE_URL('http://example.com/path/to/resource?query=string', 'query')")
    testFoldConst("select PARSE_URL('http://example.com/path/to/resource?query=string', 'Query')")
    testFoldConst("select PARSE_URL('http://user:pwd@example.com', 'AUTHORITY')")
    testFoldConst("select PARSE_URL('http://user:pwd@example.com', 'authority')")
    testFoldConst("select PARSE_URL('http://user:pwd@example.com', 'Authority')")
    testFoldConst("select PARSE_URL('http://user:pwd@example.com/path/to/resource', 'FILE')")
    testFoldConst("select PARSE_URL('http://user:pwd@example.com/path/to/resource', 'file')")
    testFoldConst("select PARSE_URL('http://user:pwd@example.com/path/to/resource', 'File')")
    testFoldConst("select PARSE_URL('http://user:pwd@example.com/path/to/resource', 'USERINFO')")
    testFoldConst("select PARSE_URL('http://user:pwd@example.com/path/to/resource', 'userinfo')")
    testFoldConst("select PARSE_URL('http://user:pwd@example.com/path/to/resource', 'UserInfo')")
//    testFoldConst("select PARSE_URL('http://user:pwd@example.com:8080/path/to/resource', 'PORT')")
//    testFoldConst("select PARSE_URL('http://user:pwd@example.com:8080/path/to/resource', 'port')")
//    testFoldConst("select PARSE_URL('http://user:pwd@example.com:8080/path/to/resource', 'Port')")
    testFoldConst("select PARSE_URL('invalid-url', 'PROTOCOL')")
    testFoldConst("select PARSE_URL('invalid-url', 'HOST')")
//    testFoldConst("select PARSE_URL('invalid-url', 'PATH')")
    testFoldConst("select PARSE_URL('', 'PROTOCOL')")
    testFoldConst("select PARSE_URL(null, 'PROTOCOL')")
    testFoldConst("select PARSE_URL('https://example.com', 'PROTOCOL')")
    testFoldConst("select PARSE_URL('ftp://example.com', 'PROTOCOL')")
    testFoldConst("select PARSE_URL('http://example.com/path?query=1#fragment', 'QUERY')")
    testFoldConst("select PARSE_URL('http://user:pwd@example.com/path/to/resource', 'AUTHORITY')")
    testFoldConst("select PARSE_URL('http://user:pwd@example.com/path/to/resource', 'FILE')")
    testFoldConst("select PARSE_URL('http://user:pwd@example.com/path/to/resource', 'USERINFO')")
//    testFoldConst("select PARSE_URL('http://user:pwd@example.com:8080/path/to/resource', 'PORT')")
    testFoldConst("select PARSE_URL('http://example.com/path/to/resource?query=string&another=param', 'QUERY')")
    testFoldConst("select PARSE_URL('http://example.com/path/to/resource?query=string&another=param', 'QUERY')")
    testFoldConst("select PARSE_URL('http://example.com/path/to/resource?query=string&another=param', 'QUERY')")
    testFoldConst("select PARSE_URL('http://user:pwd@www.baidu.com', 'USERINFO')")
    testFoldConst("select PARSE_URL('http://user:pwd@www.baidu.com', 'userinfo')")
    testFoldConst("select PARSE_URL('http://user:pwd@www.baidu.com', 'UserInfo')")
    testFoldConst("select PARSE_URL('http://user:pwd@www.baidu.com/path/to/resource', 'PATH')")
    testFoldConst("select PARSE_URL('http://user:pwd@www.baidu.com/path/to/resource', 'path')")
    testFoldConst("select PARSE_URL('http://user:pwd@www.baidu.com/path/to/resource', 'Path')")
    testFoldConst("select PARSE_URL('http://user:pwd@www.baidu.com/path/to/resource?query=string', 'QUERY')")
    testFoldConst("select PARSE_URL('http://user:pwd@www.baidu.com/path/to/resource?query=string', 'query')")
    testFoldConst("select PARSE_URL('http://user:pwd@www.baidu.com/path/to/resource?query=string', 'Query')")
//    testFoldConst("select PARSE_URL('http://user:pwd@www.baidu.com:8080/path/to/resource', 'PORT')")
//    testFoldConst("select PARSE_URL('http://user:pwd@www.baidu.com:8080/path/to/resource', 'port')")
//    testFoldConst("select PARSE_URL('http://user:pwd@www.baidu.com:8080/path/to/resource', 'Port')")
    testFoldConst("select PARSE_URL('http://example.com/path/to/resource#fragment', 'PATH')")
    testFoldConst("select PARSE_URL('http://example.com/path/to/resource#fragment', 'path')")
    testFoldConst("select PARSE_URL('http://example.com/path/to/resource#fragment', 'Path')")
    testFoldConst("select PARSE_URL('http://example.com/path/to/resource#fragment', 'QUERY')")
    testFoldConst("select PARSE_URL('http://example.com/path/to/resource#fragment', 'query')")
    testFoldConst("select PARSE_URL('http://example.com/path/to/resource#fragment', 'Query')")
    testFoldConst("select PARSE_URL('http://example.com/path/to/resource#fragment', 'AUTHORITY')")
    testFoldConst("select PARSE_URL('http://example.com/path/to/resource#fragment', 'authority')")
    testFoldConst("select PARSE_URL('http://example.com/path/to/resource#fragment', 'Authority')")
    testFoldConst("select PARSE_URL('http://example.com/path/to/resource#fragment', 'FILE')")
    testFoldConst("select PARSE_URL('http://example.com/path/to/resource#fragment', 'file')")
    testFoldConst("select PARSE_URL('http://example.com/path/to/resource#fragment', 'File')")
    testFoldConst("select PARSE_URL('http://user:pwd@www.baidu.com/path/to/resource?query=string&another=param#fragment', 'QUERY')")
    testFoldConst("select PARSE_URL('http://user:pwd@www.baidu.com/path/to/resource?query=string&another=param#fragment', 'query')")
    testFoldConst("select PARSE_URL('http://user:pwd@www.baidu.com/path/to/resource?query=string&another=param#fragment', 'Query')")
    testFoldConst("select PARSE_URL('http://user:pwd@www.baidu.com?a=b', 'USERINFO')")
    testFoldConst("select PARSE_URL('https://www.example.com/path/to/file?query=string#fragment', 'protocol')")
    testFoldConst("select PARSE_URL('ftp://username:password@hostname:21/path/to/file', 'Host')")
    testFoldConst("select PARSE_URL('http://example.com:8080/path?query=string#frag', 'path')")
    testFoldConst("select PARSE_URL('http://user:pwd@www.test.com/path?query=string#frag', 'ref')")
    testFoldConst("select PARSE_URL('http://user:pwd@www.test.com/path?query=string#frag', 'AUTHORITY')")
    testFoldConst("select PARSE_URL('http://user:pwd@www.test.com/path?query=string#frag', 'file')")
    testFoldConst("select PARSE_URL('http://user:pwd@www.test.com/path?query=string#frag', 'USERINFO')")
//    testFoldConst("select PARSE_URL('http://user:pwd@www.test.com:8080/path?query=string#frag', 'port')")
    testFoldConst("select PARSE_URL('http://user:pwd@www.test.com/path?query=string#frag', 'QUERY')")
    testFoldConst("select PARSE_URL('http://user:pwd@www.test.com/path?query=string#frag', 'Protocol')")
    testFoldConst("select PARSE_URL('http://user:pwd@www.test.com/path?query=string#frag', 'host')")
    testFoldConst("select PARSE_URL('http://user:pwd@www.test.com/path?query=string#frag', 'Path')")
    testFoldConst("select PARSE_URL('http://user:pwd@www.test.com/path?query=string#frag', 'Ref')")
    testFoldConst("select PARSE_URL('http://user:pwd@www.test.com/path?query=string#frag', 'Authority')")
    testFoldConst("select PARSE_URL('http://user:pwd@www.test.com/path?query=string#frag', 'File')")
    testFoldConst("select PARSE_URL('http://user:pwd@www.test.com/path?query=string#frag', 'Userinfo')")
//    testFoldConst("select PARSE_URL('http://user:pwd@www.test.com/path?query=string#frag', 'Port')")
    testFoldConst("select PARSE_URL('http://user:pwd@www.test.com/path?query=string#frag', 'Query')")
    testFoldConst("select PARSE_URL('', 'HOST')")
    testFoldConst("select PARSE_URL(null, 'HOST')")
    testFoldConst("select PARSE_URL('not a url', 'HOST')")
    testFoldConst("select PARSE_URL('http://www.test.com', 'HOST')")
    testFoldConst("select PARSE_URL('https://www.test.com', 'protocol')")
    testFoldConst("select PARSE_URL('ftp://username:password@hostname/path/to/file', 'userinfo')")
//    testFoldConst("select PARSE_URL('http://user:pwd@www.test.com:8080/path/to/file', 'port')")
    testFoldConst("select PARSE_URL('http://www.test.com/path/to/file?query=string', 'query')")
    testFoldConst("select PARSE_URL('http://www.test.com/path/to/file#fragment', 'ref')")
    testFoldConst("select PARSE_URL('http://user:pwd@www.test.com/path/to/file', 'authority')")
    testFoldConst("select PARSE_URL('http://www.test.com/path/to/file', 'file')")
    testFoldConst("select PARSE_URL('http://www.test.com/', 'path')")
    testFoldConst("select PARSE_URL('http://user:pwd@www.test.com:8080/path/to/file?query=string#fragment', 'protocol')")
    testFoldConst("select PARSE_URL('http://user:pwd@www.test.com:8080/path/to/file?query=string#fragment', 'host')")
    testFoldConst("select PARSE_URL('http://user:pwd@www.test.com:8080/path/to/file?query=string#fragment', 'path')")
    testFoldConst("select PARSE_URL('http://user:pwd@www.test.com:8080/path/to/file?query=string#fragment', 'ref')")
    testFoldConst("select PARSE_URL('http://user:pwd@www.test.com:8080/path/to/file?query=string#fragment', 'authority')")
    testFoldConst("select PARSE_URL('http://user:pwd@www.test.com:8080/path/to/file?query=string#fragment', 'file')")
    testFoldConst("select PARSE_URL('http://user:pwd@www.test.com:8080/path/to/file?query=string#fragment', 'userinfo')")
//    testFoldConst("select PARSE_URL('http://user:pwd@www.test.com:8080/path/to/file?query=string#fragment', 'port')")
    testFoldConst("select PARSE_URL('http://user:pwd@www.test.com:8080/path/to/file?query=string#fragment', 'query')")
    testFoldConst("select PARSE_URL('http://user:pwd@www.test.com:8080/path/to/file?query=string#fragment', 'PROTOcol')")
    testFoldConst("select PARSE_URL('http://user:pwd@www.test.com:8080/path/to/file?query=string#fragment', 'HOST')")
    testFoldConst("select PARSE_URL('http://user:pwd@www.test.com:8080/path/to/file?query=string#fragment', 'PATH')")
    testFoldConst("select PARSE_URL('http://user:pwd@www.test.com:8080/path/to/file?query=string#fragment', 'REF')")
    testFoldConst("select PARSE_URL('http://user:pwd@www.test.com:8080/path/to/file?query=string#fragment', 'AUTHORITY')")
    testFoldConst("select PARSE_URL('http://user:pwd@www.test.com:8080/path/to/file?query=string#fragment', 'FILE')")
    testFoldConst("select PARSE_URL('http://user:pwd@www.test.com:8080/path/to/file?query=string#fragment', 'USERINFO')")
//    testFoldConst("select PARSE_URL('http://user:pwd@www.test.com:8080/path/to/file?query=string#fragment', 'PORT')")
    testFoldConst("select PARSE_URL('http://user:pwd@www.test.com:8080/path/to/file?query=string#fragment', 'QUERY')")

    // repeat
    testFoldConst("select repeat('a', 0)")
    testFoldConst("select repeat('a', -1)")
    testFoldConst("select repeat('a', 3)")
    testFoldConst("select repeat('a',null)")
    testFoldConst("select repeat(cast('a' as string), 0)")
    testFoldConst("select repeat(cast('a' as string), -1)")
    testFoldConst("select repeat(cast('a' as string), 3)")
    testFoldConst("select repeat(cast('Hello' as string), -3)")
    testFoldConst("select repeat(cast('Hello' as string), 3)")
    testFoldConst("select repeat('Hello', -3)")
    testFoldConst("select repeat('Hello', 3)")
    testFoldConst("select repeat(NULL, 1)")
    testFoldConst("select repeat('', 3)")
    testFoldConst("select repeat(' ', 3)")
    testFoldConst("select repeat('前进',4)")

    // replace
    testFoldConst("select replace(cast('Hello World' as string), '', cast('Everyone' as string))")
    testFoldConst("select replace(cast('Hello World' as string), cast('World' as string), '')")
    testFoldConst("select replace(cast('Hello World' as string), cast('World' as string), cast('Everyone' as string))")
    testFoldConst("select replace(cast('https://doris.apache.org:9090' as string), cast(':9090' as string), cast('' as string))")
    testFoldConst("select replace(cast('https://doris.apache.org:9090' as string), cast('' as string), cast('new_str' as string))")
    testFoldConst("select replace('Hello World', '', 'Everyone')")
    testFoldConst("select replace('Hello World', 'World', '')")
    testFoldConst("select replace('Hello World', 'World', 'Everyone')")
    testFoldConst("select replace('https://doris.apache.org:9090', ':9090', '')")
    testFoldConst("select replace('https://doris.apache.org:9090', '', 'new_str')")
    testFoldConst("select replace('https://doris.apache.org:9090', './*', 'new_str')")

    // reverse
    testFoldConst("select reverse('Hello')")
    testFoldConst("select reverse('')")
    testFoldConst("select reverse('こんにちは')")

    // right
    testFoldConst("select right(CAST('good morning' AS STRING), NULL)")
    testFoldConst("select right(cast('Hello' as string), 10)")
    testFoldConst("select right(CAST('Hello doris' AS STRING), 120)")
    testFoldConst("select right(cast('Hello doris' as string), 5)")
    testFoldConst("select right(CAST('Hello doris' AS STRING), 5)")
    testFoldConst("select right(CAST('Hello doris' AS STRING), -6)")
    testFoldConst("select right(cast('Hello World' as string), 5)")
    testFoldConst("select right(CAST(NULL AS STRING), 1)")
    testFoldConst("select right('good morning', NULL)")
    testFoldConst("select right('Hello', 10)")
    testFoldConst("select right('Hello doris', 120)")
    testFoldConst("select right('Hello doris', 5)")
    testFoldConst("select right('Hello doris',5)")
    testFoldConst("select right('Hello doris', -6)")
    testFoldConst("select right('Hello World', 5)")
    testFoldConst("select right('Hello World', 0)")
    testFoldConst("select right(NULL, 1)")
    testFoldConst("select right('🐼abc🐼', 100)")
    testFoldConst("select right('你好世界',5)")
    // rpad
    testFoldConst("select rpad(cast('hi' as string), 1, cast('xy' as string))")
    testFoldConst("select rpad(cast('hi' as string), 5, cast('xy' as string))")
    testFoldConst("select rpad('hi', 1, 'xy')")
    testFoldConst("select rpad('hi', 5, 'xy')")

    // rtrim
    testFoldConst("select rtrim(' 11111', 11)")
    testFoldConst("select rtrim('11111 ', 11)")
    testFoldConst("select rtrim(cast(' 11111' as string), cast(11 as string))")
    testFoldConst("select rtrim(cast('11111 ' as string), cast(11 as string))")
    testFoldConst("select rtrim(cast('Hello' as string))")
    testFoldConst("select rtrim(cast('  Hello World  ' as string))")
    testFoldConst("select rtrim('Hello')")
    testFoldConst("select rtrim('  Hello World  ')")
    testFoldConst("select rtrim('abc ')")
    testFoldConst("select rtrim('abc,,,', ',')")
    testFoldConst("select rtrim('Aaabc', 'A')")
    testFoldConst("select rtrim('Aaabc', 'c')")
    testFoldConst("select rtrim('abc;;;', ';')")
    testFoldConst("select rtrim('abc, ', ' ,')")
    testFoldConst("select rtrim(null)")
    testFoldConst("select rtrim('abc', null)")
    testFoldConst("select rtrim(null, null)")
    testFoldConst("select rtrim('abcxyz', 'xyz')")
    testFoldConst("select rtrim('abcxyxzy', 'xyz')")
    testFoldConst("select rtrim('')")
    testFoldConst("select rtrim('', 'a')")
    testFoldConst("select rtrim(123)")
    testFoldConst("select rtrim(0)")
    testFoldConst("select rtrim(true)")
    testFoldConst("select rtrim('aaaa', 'a')")
    testFoldConst("select rtrim(' ', ' ')")
    testFoldConst("select rtrim(substring('abcxx', 1, 4), 'x')")
    testFoldConst("select rtrim(concat('abc', ' '), ' ')")
    testFoldConst("select rtrim('中文中', '中')")
    testFoldConst("select rtrim('中文 ', ' ')")
    testFoldConst("select rtrim('abc<d83d><dc3c>', '<d83d><dc3c>')")
    testFoldConst("select rtrim('abc!!!', '!')")
    testFoldConst("select rtrim('abc123', '123')")
    testFoldConst("select rtrim('abxyd', 'xy')")
    testFoldConst("select rtrim('abcabc', 'abc')")
    testFoldConst("select rtrim(' abc ')")
    testFoldConst("select rtrim('a bc ', 'c')")
    testFoldConst("select rtrim('a bc ', ' c')")
    testFoldConst("select rtrim('abcabab', 'ab')")
    testFoldConst("select rtrim('abc', 'x')")
    testFoldConst("select rtrim('abc', 'c')")
    testFoldConst("select rtrim('a1!B2@c3#', '3#')")
    testFoldConst("select rtrim(' test ')")
    testFoldConst("select rtrim('xyzzyxxyz', 'xyz')")
    testFoldConst("select rtrim('123456123', '123')")
    testFoldConst("select rtrim('abc,.,', '.,')")
    testFoldConst("select rtrim('abc[][]', '[]')")
    testFoldConst("select rtrim('aAaaA', 'A')")
    testFoldConst("select rtrim('abc', '')")
    testFoldConst("select rtrim('abc', 'bc')")
    testFoldConst("select rtrim('abcxyx', 'xy')")
    testFoldConst("select rtrim('abbaexampleabba', 'ab')")
    testFoldConst("select rtrim('aBcAb', 'Ab')")
    testFoldConst("select rtrim('12123412', '12')")
    testFoldConst("select rtrim('abc', 'abc')")
    testFoldConst("select rtrim('aaaa', 'a')")
    testFoldConst("select rtrim('a', 'a')")
    testFoldConst("select rtrim('aaaa', 'aa')")
    testFoldConst("select rtrim(';;abc;;', ';')")
    testFoldConst("select rtrim(' test ')")
    testFoldConst("select rtrim('xyzzyxxyz', 'xyz')")
    testFoldConst("select rtrim('123456123', '123')")
    testFoldConst("select rtrim('.,abc,.,', '.,')")
    testFoldConst("select rtrim('[][abc][]', '[]')")
    testFoldConst("select rtrim('<d83d><dc3c>abc<d83d><dc3c>', '<d83d><dc3c>')")
    testFoldConst("select rtrim('aAaaA', 'a')")
    testFoldConst("SELECT RTRIM('こんにちは！😊😊', '😊')")
    testFoldConst("SELECT RTRIM('안녕하세요.ㅎㅎ', 'ㅎ')")
    testFoldConst("SELECT RTRIM('¡Hola!😎😎', '😎')")
    testFoldConst("SELECT RTRIM('Bonjour.ée', 'é')")
    testFoldConst("SELECT RTRIM('こんにちは! Hello! 😀😀 你好呀~呀', '呀😀')")

    // space
    testFoldConst("select space(-5)")
    testFoldConst("select space(5)")
    testFoldConst("select space(0)")

    // split_by_string
    testFoldConst("select split_by_string('::', 'abc')")
    testFoldConst("select split_by_string('a::b::c', '::')")
    testFoldConst("select split_by_string(cast('a::b::c' as string), cast('::' as string))")
    testFoldConst("select split_by_string(cast('abc' as string), cast('::' as string))")
    testFoldConst("select split_by_string('上海天津北京杭州', '北')")
    testFoldConst("select split_by_string('abccccc', 'c')")
    testFoldConst("select split_by_string('abcde','')")
    //testFoldConst("select split_by_string('你a好b世c界','')")
    testFoldConst("select split_by_string('12553','')")
    testFoldConst("select split_by_string('','')")
    testFoldConst("select split_by_string('',',')")
    testFoldConst("select split_by_string('','a')")
    testFoldConst("select split_by_string('','abc')")
    testFoldConst("select split_by_string('abc','')")
    testFoldConst("select split_by_string('a1b1c1d','1')")
    testFoldConst("select split_by_string(',,,',',')")
    testFoldConst("select split_by_string('a,b,c,abcde',',')")
    testFoldConst("select split_by_string(',,a,b,c,',',')")
    testFoldConst("select split_by_string('null',',')")
    testFoldConst("select split_by_string('1,,2,3,,4,5,,abcde', ',,')")
    testFoldConst("select split_by_string('abcde','')")
    testFoldConst("select split_by_string('1,,2,3,,,,,,4,5, abcde', ',,')")
    testFoldConst("select split_by_string(',,,,',',,')")
    testFoldConst("select split_by_string('a,,b,,c',',,')")
    testFoldConst("select split_by_string('a,,b,,c,,',',,')")
    testFoldConst("select split_by_string(',,a,,b,,c,,',',,')")
    testFoldConst("SELECT split_by_string('a..b\$\$c||d((e))f[[g{{h^^i??j**k++l\\\\m','..')")
    testFoldConst("SELECT split_by_string('a..b\$\$c||d((e))f[[g{{h^^i??j**k++l\\\\m','\$\$')")
    testFoldConst("SELECT split_by_string('a..b\$\$c||d((e))f[[g{{h^^i??j**k++l\\\\m','||')")
    testFoldConst("SELECT split_by_string('a..b\$\$c||d((e))f[[g{{h^^i??j**k++l\\\\m','((')")
    testFoldConst("SELECT split_by_string('a..b\$\$c||d((e))f[[g{{h^^i??j**k++l\\\\m','))')")
    testFoldConst("SELECT split_by_string('a..b\$\$c||d((e))f[[g{{h^^i??j**k++l\\\\m','[[')")
    testFoldConst("SELECT split_by_string('a..b\$\$c||d((e))f[[g{{h^^i??j**k++l\\\\m','{{')")
    testFoldConst("SELECT split_by_string('a..b\$\$c||d((e))f[[g{{h^^i??j**k++l\\\\m','^^')")
    testFoldConst("SELECT split_by_string('a..b\$\$c||d((e))f[[g{{h^^i??j**k++l\\\\m','??')")
    testFoldConst("SELECT split_by_string('a..b\$\$c||d((e))f[[g{{h^^i??j**k++l\\\\m','**')")
    testFoldConst("SELECT split_by_string('a..b\$\$c||d((e))f[[g{{h^^i??j**k++l\\\\m','++')")
    testFoldConst("SELECT split_by_string('a..b\$\$c||d((e))f[[g{{h^^i??j**k++l\\\\m','\\\\')")

    // split_part
    testFoldConst("select split_part('a,b,c', '', -2)")
    testFoldConst("select split_part('a,b,c', '', -1)")
    testFoldConst("select split_part('a,b,c', '', 0)")
    testFoldConst("select split_part('a,b,c', '', 1)")
    testFoldConst("select split_part('a,b,c', '', 2)")
    testFoldConst("select split_part('', '', -2)")
    testFoldConst("select split_part('', '', -1)")
    testFoldConst("select split_part('', '', 0)")
    testFoldConst("select split_part('', '', 1)")
    testFoldConst("select split_part('', '', 2)")
    testFoldConst("select split_part('', 'abc', -2)")
    testFoldConst("select split_part('', 'abc', -1)")
    testFoldConst("select split_part('', 'abc', 0)")
    testFoldConst("select split_part('', 'abc', 1)")
    testFoldConst("select split_part('', 'abc', 2)")
    testFoldConst("select split_part('abc##123###xyz', '##', -10)")
    testFoldConst("select split_part('abc##123###xyz', '##', -4)")
    testFoldConst("select split_part('abc##123###xyz', '##', -3)")
    testFoldConst("select split_part('abc##123###xyz', '##', -2)")
    testFoldConst("select split_part('abc##123###xyz', '##', -1)")
    testFoldConst("select split_part('abc##123###xyz', '##', 0)")
    testFoldConst("select split_part('abc##123###xyz', '##', 1)")
    testFoldConst("select split_part('abc##123###xyz', '##', 2)")
    testFoldConst("select split_part('abc##123###xyz', '##', 3)")
    testFoldConst("select split_part('abc##123###xyz', '##', 4)")
    testFoldConst("select split_part('abc##123###xyz', '##', 10)")
    testFoldConst("select split_part('a,b,c', ',', -100)")
    testFoldConst("select split_part('a,b,c', ',', -5)")
    testFoldConst("select split_part('a,b,c', ',', -4)")
    testFoldConst("select split_part('a,b,c', ',', -3)")
    testFoldConst("select split_part('a,b,c', ',', -2)")
    testFoldConst("select split_part('a,b,c', ',', -1)")
    testFoldConst("select split_part('a,b,c', ',', -0)")
    testFoldConst("select split_part('a,b,c', ',', 0)")
    testFoldConst("select split_part('a,b,c', ',', 1)")
    testFoldConst("select split_part('a,b,c', ',', 2)")
    testFoldConst("select split_part('a,b,c', ',', 3)")
    testFoldConst("select split_part('a,b,c', ',', 4)")
    testFoldConst("select split_part('a,b,c', ',', 5)")
    testFoldConst("select split_part('a,b,c', ',', 100)")
    testFoldConst("select split_part(cast('a,b,c' as string), cast(',' as string), -1)")
    testFoldConst("select split_part(cast('a,b,c' as string), cast(',' as string), 2)")
    testFoldConst("select split_part(cast('a,b,c' as string), cast(',' as string), 5)")
    testFoldConst("select split_part(cast('hello world' as string), cast(' ' as string), 1)")
    testFoldConst("select split_part(cast('hello world' as string), cast(' ' as string), 2)")
    testFoldConst("select split_part(cast('hello world' as string), cast(' ' as string), 3)")
    testFoldConst("select split_part('hello world', ' ', 0)")
    testFoldConst("select split_part('hello world', ' ', -1)")
    testFoldConst("select split_part('hello world', ' ', 1)")
    testFoldConst("select split_part('hello world', ' ', -2)")
    testFoldConst("select split_part('hello world', ' ', 2)")
    testFoldConst("select split_part('hello world', ' ', -3)")
    testFoldConst("select split_part('hello world', ' ', -3)")
    testFoldConst("SELECT split_part('哈哈哈AAA','A', -5)")
    testFoldConst("SELECT split_part('哈哈哈AAA','A', -4)")
    testFoldConst("SELECT split_part('哈哈哈AAA','A', -3)")
    testFoldConst("SELECT split_part('哈哈哈AAA','A', -2)")
    testFoldConst("SELECT split_part('哈哈哈AAA','A', -1)")
    testFoldConst("SELECT split_part('哈哈哈AAA','A', 0)")
    testFoldConst("SELECT split_part('哈哈哈AAA','A', 1)")
    testFoldConst("SELECT split_part('哈哈哈AAA','A', 2)")
    testFoldConst("SELECT split_part('哈哈哈AAA','A', 3)")
    testFoldConst("SELECT split_part('哈哈哈AAA','A', 4)")
    testFoldConst("SELECT split_part('哈哈哈AAA','A', 5)")
    testFoldConst("SELECT split_part('哈哈哈AA+','A', -4)")
    testFoldConst("SELECT split_part('哈哈哈AA+','A', -3)")
    testFoldConst("SELECT split_part('哈哈哈AA+','A', -2)")
    testFoldConst("SELECT split_part('哈哈哈AA+','A', -1)")
    testFoldConst("SELECT split_part('哈哈哈AA+','A', 0)")
    testFoldConst("SELECT split_part('哈哈哈AA+','A', 1)")
    testFoldConst("SELECT split_part('哈哈哈AA+','A', 2)")
    testFoldConst("SELECT split_part('哈哈哈AA+','A', 3)")
    testFoldConst("SELECT split_part('哈哈哈AA+','A', 4)")
    testFoldConst("SELECT split_part('a..b\$\$c||d((e))f[[g{{h^^i??j**k++l\\\\m','..', 1)")
    testFoldConst("SELECT split_part('a..b\$\$c||d((e))f[[g{{h^^i??j**k++l\\\\m','\$\$', 1)")
    testFoldConst("SELECT split_part('a..b\$\$c||d((e))f[[g{{h^^i??j**k++l\\\\m','||', 1)")
    testFoldConst("SELECT split_part('a..b\$\$c||d((e))f[[g{{h^^i??j**k++l\\\\m','((', 1)")
    testFoldConst("SELECT split_part('a..b\$\$c||d((e))f[[g{{h^^i??j**k++l\\\\m','))', 1)")
    testFoldConst("SELECT split_part('a..b\$\$c||d((e))f[[g{{h^^i??j**k++l\\\\m','[[', 1)")
    testFoldConst("SELECT split_part('a..b\$\$c||d((e))f[[g{{h^^i??j**k++l\\\\m','{{', 1)")
    testFoldConst("SELECT split_part('a..b\$\$c||d((e))f[[g{{h^^i??j**k++l\\\\m','^^', 1)")
    testFoldConst("SELECT split_part('a..b\$\$c||d((e))f[[g{{h^^i??j**k++l\\\\m','??', 1)")
    testFoldConst("SELECT split_part('a..b\$\$c||d((e))f[[g{{h^^i??j**k++l\\\\m','**', 1)")
    testFoldConst("SELECT split_part('a..b\$\$c||d((e))f[[g{{h^^i??j**k++l\\\\m','++', 1)")
    testFoldConst("SELECT split_part('a..b\$\$c||d((e))f[[g{{h^^i??j**k++l\\\\m','\\\\', 1)")
    testFoldConst("SELECT split_part('a..b\$\$c||d((e))f[[g{{h^^i??j**k++l\\\\m','..', 2)")
    testFoldConst("SELECT split_part('a..b\$\$c||d((e))f[[g{{h^^i??j**k++l\\\\m','\$\$', 2)")
    testFoldConst("SELECT split_part('a..b\$\$c||d((e))f[[g{{h^^i??j**k++l\\\\m','||', 2)")
    testFoldConst("SELECT split_part('a..b\$\$c||d((e))f[[g{{h^^i??j**k++l\\\\m','((', 2)")
    testFoldConst("SELECT split_part('a..b\$\$c||d((e))f[[g{{h^^i??j**k++l\\\\m','))', 2)")
    testFoldConst("SELECT split_part('a..b\$\$c||d((e))f[[g{{h^^i??j**k++l\\\\m','[[', 2)")
    testFoldConst("SELECT split_part('a..b\$\$c||d((e))f[[g{{h^^i??j**k++l\\\\m','{{', 2)")
    testFoldConst("SELECT split_part('a..b\$\$c||d((e))f[[g{{h^^i??j**k++l\\\\m','^^', 2)")
    testFoldConst("SELECT split_part('a..b\$\$c||d((e))f[[g{{h^^i??j**k++l\\\\m','??', 2)")
    testFoldConst("SELECT split_part('a..b\$\$c||d((e))f[[g{{h^^i??j**k++l\\\\m','**', 2)")
    testFoldConst("SELECT split_part('a..b\$\$c||d((e))f[[g{{h^^i??j**k++l\\\\m','++', 2)")
    testFoldConst("SELECT split_part('a..b\$\$c||d((e))f[[g{{h^^i??j**k++l\\\\m','\\\\', 2)")
    testFoldConst("select split_part('abc', ':', -1)")
    testFoldConst("select split_part('abc', ':', 0)")
    testFoldConst("select split_part('abc', ':', 1)")

    // starts_with
    testFoldConst("select starts_with('hello world','hello')")
    testFoldConst("select starts_with('hello world',null)")
    testFoldConst("select starts_with('hello world','world')")
    testFoldConst("select starts_with(' hello world','world')")
    testFoldConst("select starts_with('上海天津北京杭州','上海')")
    testFoldConst("select starts_with('上海天津北京杭州','北京')")

    // strcmp
    testFoldConst("select strcmp('a', 'abc')")
    testFoldConst("select strcmp('abc', 'abc')")
    testFoldConst("select strcmp('abc', 'abc')")
    testFoldConst("select strcmp('abc', 'abd')")
    testFoldConst("select strcmp('abcd', 'abc')")
    testFoldConst("select strcmp('abc', NULL)")
    testFoldConst("select strcmp(CAST('a' AS STRING), CAST('abc' AS STRING))")
    testFoldConst("select strcmp(cast('abc' as string), cast('abc' as string))")
    testFoldConst("select strcmp(CAST('abc' AS STRING), CAST('abc' AS STRING))")
    testFoldConst("select strcmp(cast('abc' as string), cast('abd' as string))")
    testFoldConst("select strcmp(cast('abc' as string), NULL)")
    testFoldConst("select strcmp(CAST('abcd' AS STRING), CAST('abc' AS STRING))")

    // strleft
    testFoldConst("select strleft('good morning', 120)")
    testFoldConst("select strleft('good morning', -5)")
    testFoldConst("select strleft('good morning', NULL)")
    testFoldConst("select strleft('Hello doris', 5)")
    testFoldConst("select strleft('Hello World', 5)")
    testFoldConst("select strleft(' Hello World', 5)")
    testFoldConst("select strleft('Hello World ', 50)")
    testFoldConst("select strleft(NULL, 1)")
    testFoldConst("select strleft('😊😉👍', 2)")
    testFoldConst("select strleft('αβγδ', 3)")
    testFoldConst("select strleft('你好世界', 4)")
    testFoldConst("select strleft('こんにちは世界', 5)")
    testFoldConst("select strleft('안녕하세요', 3)")
    testFoldConst("select strleft('привет', 4)")
    testFoldConst("select strleft('שלום', 3)")
    testFoldConst("select strleft('😊😉👍😊😉', 4)")
    testFoldConst("select strleft('αβγδεζ', 4)")
    testFoldConst("select strleft('你好呀，世界', 6)")
    testFoldConst("select strleft('こんにちは、素晴らしい一日', 7)")
    testFoldConst("select strleft('안녕하세요 여러분', 5)")
    testFoldConst("select strleft('привет мир', 6)")
    testFoldConst("select strleft('שלום עולם', 4)")
    testFoldConst("select strleft(null, 2)")
    testFoldConst("select strleft('😊😉👍😊😉👍', 0)")
    testFoldConst("select strleft('αβγδεζη', -1)")
    testFoldConst("select strleft('你好，美好的一天', -2)")
    testFoldConst("select strleft('こんにちは、素晴らしい一日', -3)")
    testFoldConst("select strleft('안녕하세요 여러분 안녕히가세요', -4)")
    testFoldConst("select strleft('привет всем друзьям', -5)")
    testFoldConst("select strleft('שלום לכל החברים', -3)")
    testFoldConst("select strleft('', 2)")
    testFoldConst("select strleft('😊😉', -1)")
    testFoldConst("select strleft('αβ', 0)")
    testFoldConst("select strleft('你好', -1)")
    testFoldConst("select strleft('こんにちは', 0)")
    testFoldConst("select strleft('안녕하세요', -1)")
    testFoldConst("select strleft('привет', 0)")
    testFoldConst("select strleft('שלום', -1)")
    testFoldConst("select strleft('😊😉👍😊😉👍😊', 5)")
    testFoldConst("select strleft('αβγδεζηθ', 5)")
    testFoldConst("select strleft('你好，世界！欢迎', 6)")
    testFoldConst("select strleft('こんにちは、世界！ようこそ', 7)")
    testFoldConst("select strleft('안녕하세요 세계!', 5)")
    testFoldConst("select strleft('привет, мир!', 6)")
    testFoldConst("select strleft('שלום עולם!', 4)")
    testFoldConst("select strleft('😊😉👍😊😉👍😊😉', 6)")
    testFoldConst("select strleft('αβγδεζηθι', 6)")
    testFoldConst("select strleft('你好呀，美好的世界', 7)")
    testFoldConst("select strleft('こんにちは、素晴らしい世界よ', 8)")
    testFoldConst("select strleft('안녕하세요, 아름다운 세상', 7)")
    testFoldConst("select strleft('привет, прекрасный мир', 8)")
    testFoldConst("select strleft('שלום לעולם יפה', 5)")
    testFoldConst("select strleft('', -1)")
    testFoldConst("select strleft('😊😉', 0)")
    testFoldConst("select strleft('αβ', -1)")
    testFoldConst("select strleft('你好', 0)")
    testFoldConst("select strleft('こんにちは', -1)")
    testFoldConst("select strleft('안녕하세요', 0)")
    testFoldConst("select strleft('привет', -1)")
    testFoldConst("select strleft('שלום', 0)")
    testFoldConst("select strleft('привет', 2147483647)")
    testFoldConst("select strleft('привет', 2147483648)")

    // strright
    testFoldConst("select strright('good morning', NULL)")
    testFoldConst("select strright('Hello doris', 120)")
    testFoldConst("select strright('Hello doris', -5)")
    testFoldConst("select strright('Hello doris', 5)")
    testFoldConst("select strright('Hello World', 5)")
    testFoldConst("select strright(' Hello World', 5)")
    testFoldConst("select strright('Hello World  ', 5)")
    testFoldConst("select strright(NULL, 1)")
    testFoldConst("select strright('😊😉👍', 2)")
    testFoldConst("select strright('αβγδ', 3)")
    testFoldConst("select strright('你好世界', 2)")
    testFoldConst("select strright('こんにちは世界', 3)")
    testFoldConst("select strright('안녕하세요', 3)")
    testFoldConst("select strright('привет', 4)")
    testFoldConst("select strright('שלום', 3)")
    testFoldConst("select strright('😊😉👍😊😉', 4)")
    testFoldConst("select strright('αβγδεζ', 4)")
    testFoldConst("select strright('你好呀，世界', 6)")
    testFoldConst("select strright('こんにちは、素晴らしい一日', 7)")
    testFoldConst("select strright('안녕하세요 여러분', 5)")
    testFoldConst("select strright('привет мир', 6)")
    testFoldConst("select strright('שלום לכל החברים', 10)")
    testFoldConst("select strright(null, 2)")
    testFoldConst("select strright('😊😉👍😊😉👍', 0)")
//    testFoldConst("select strright('αβγδεζη', -1)")
    testFoldConst("select strright('你好，美好的一天', -2)")
    testFoldConst("select strright('こんにちは、素晴らしい一日', -3)")
    testFoldConst("select strright('안녕하세요 여러분 안녕히가세요', -4)")
    testFoldConst("select strright('привет всем друзьям', -5)")
    testFoldConst("select strright('שלום עולם!', -3)")
    testFoldConst("select strright('', 2)")
//    testFoldConst("select strright('😊😉', -1)")
    testFoldConst("select strright('αβ', 0)")
//    testFoldConst("select strright('你好', -1)")
    testFoldConst("select strright('こんにちは', 0)")
//    testFoldConst("select strright('안녕하세요', -1)")
    testFoldConst("select strright('привет', 0)")
//    testFoldConst("select strright('שלום', -1)")
    testFoldConst("select strright('😊😉👍😊😉👍😊', 5)")
    testFoldConst("select strright('αβγδεζηθ', 5)")
    testFoldConst("select strright('你好，世界！欢迎', 6)")
    testFoldConst("select strright('こんにちは、世界！ようこそ', 7)")
    testFoldConst("select strright('안녕하세요 세계!', 5)")
    testFoldConst("select strright('привет, мир!', 6)")
    testFoldConst("select strright('שלום עולם!', 4)")
    testFoldConst("select strright('😊😉👍😊😉👍😊😉', 6)")
    testFoldConst("select strright('αβγδεζηθι', 6)")
    testFoldConst("select strright('你好呀，美好的世界', 7)")
    testFoldConst("select strright('こんにちは、素晴らしい世界よ', 8)")
    testFoldConst("select strright('안녕하세요, 아름다운 세상', 7)")
    testFoldConst("select strright('привет, прекрасный мир', 8)")
    testFoldConst("select strright('שלום לעולם יפה', 5)")
    testFoldConst("select strright('', -1)")
    testFoldConst("select strright('😊😉', 0)")
//    testFoldConst("select strright('αβ', -1)")
    testFoldConst("select strright('你好', 0)")
//    testFoldConst("select strright('こんにちは', -1)")
    testFoldConst("select strright('안녕하세요', 0)")
//    testFoldConst("select strright('привет', -1)")
    testFoldConst("select strright('שלום', 0)")
//    testFoldConst("select strright('привет', 2147483647)")
//    testFoldConst("select strright('привет', 2147483648)")

    // sub_replace
    testFoldConst("select sub_replace(CAST('doris' AS STRING), CAST('***' AS STRING), 1, 2)")
    testFoldConst("select sub_replace(CAST('doris' AS STRING), CAST('***' AS STRING), 1, 2)")
    testFoldConst("select sub_replace(CAST('this is origin str' AS STRING), CAST('NEW-STR' AS STRING), 1)")
    testFoldConst("select sub_replace(CAST('this is origin str' AS STRING), CAST('NEW-STR' AS STRING), 1)")
    testFoldConst("select sub_replace('doris','***',1,2)")
    testFoldConst("select sub_replace('doris','***',1,2)")
    testFoldConst("select sub_replace('this is origin str','NEW-STR',1)")
    testFoldConst("select sub_replace('this is origin str','NEW-STR',1)")
    testFoldConst("select sub_replace(CAST('doris' AS STRING), CAST('***' AS STRING), -1, 2)")
    testFoldConst("select sub_replace('上海天津北京杭州', '天津', 3, 4)")
    testFoldConst("select sub_replace('上海天津北京杭州', '天津', 30, 4)")

    // substr
    testFoldConst("select substr('a',0,1)")
    testFoldConst("select substr('a',-1,1)")
    testFoldConst("select substr('a',1,1)")
    testFoldConst("select substr('a',-2,1)")
    testFoldConst("select substr('a',2,1)")
    testFoldConst("select substr('a',-3,1)")
    testFoldConst("select substr('a',3,1)")
    testFoldConst("select substr('abcdef',-3,-1)")
    testFoldConst("select substr('abcdef',3,-1)")
    testFoldConst("select substr('',3,-1)")
    testFoldConst("select substr('abcdef',3,10)")
    testFoldConst("select substr('abcdef',-3)")
    testFoldConst("select substr('abcdef',3)")
    testFoldConst("select substr('',3)")

    // substring
    testFoldConst("select substring('1', 1, 1)")
    testFoldConst("select substring('abc1', -2)")
    testFoldConst("select substring('abc1', 2)")
    testFoldConst("select substring('abc1', 5)")
    testFoldConst("select substring('abc1def', 2, 2)")
    testFoldConst("select substring('abcdef',10,1)")
    testFoldConst("select substring('abcdef',-3,-1)")
    testFoldConst("select substring('abcdef',3,-1)")
    testFoldConst("select substring(cast('1' as string), 1, 1)")
    testFoldConst("select substring(CAST('abc1' AS STRING), -2)")
    testFoldConst("select substring(CAST('abc1' AS STRING), 2)")
    testFoldConst("select substring(CAST('abc1' AS STRING), 5)")
    testFoldConst("select substring(CAST('abc1def' AS STRING), 2, 2)")
    testFoldConst("select substring(CAST('abcdef' AS STRING), 10, 1)")
    testFoldConst("select substring(CAST('abcdef' AS STRING), -3, -1)")
    testFoldConst("select substring(CAST('abcdef' AS STRING), 3, -1)")
    testFoldConst("select substring(cast('Hello' as string), 1, 10)")
    testFoldConst("select substring(cast('Hello World' as string), -1, 5)")
    testFoldConst("select substring(cast('Hello World' as string), 1, 5)")
    testFoldConst("select substring('Hello', 1, 10)")
    testFoldConst("select substring('Hello World', -1, 5)")
    testFoldConst("select substring('Hello World', 1, 5)")
    testFoldConst("select substring('', 1, 5)")
    testFoldConst("select substring('Hello World', 1, 50)")
    testFoldConst("select substring('abcdef',-3)")
    testFoldConst("select substring('abcdef',3)")
    testFoldConst("select substring('',3)")

    // substring_index
    testFoldConst("select substring_index('a,b,c', ',', 2)")
    testFoldConst("select substring_index('a,b,c', '', 2)")
    testFoldConst("select substring_index(cast('a,b,c' as string), cast(',' as string), 2)")
    testFoldConst("select substring_index(CAST('hello world' AS STRING), CAST(' ' AS STRING), -1)")
    testFoldConst("select substring_index(CAST('hello world' AS STRING), CAST(' ' AS STRING), 1)")
    testFoldConst("select substring_index(CAST('hello world' AS STRING), CAST(' ' AS STRING), -2)")
    testFoldConst("select substring_index(CAST('hello world' AS STRING), CAST(' ' AS STRING), 2)")
    testFoldConst("select substring_index(CAST('hello world' AS STRING), CAST(' ' AS STRING), -3)")
    testFoldConst("select substring_index(CAST('hello world' AS STRING), CAST(' ' AS STRING), 3)")
    testFoldConst("select substring_index(CAST(NULL AS STRING), CAST('__' AS STRING), 1)")
    testFoldConst("select substring_index(CAST('prefix_string2' AS STRING), CAST('__' AS STRING), 1)")
    testFoldConst("select substring_index(CAST('prefix__string2' AS STRING), CAST('_' AS STRING), 2)")
    testFoldConst("select substring_index(CAST('prefix__string2' AS STRING), CAST('__' AS STRING), 2)")
    testFoldConst("select substring_index(CAST('prefix_string' AS STRING), CAST('__' AS STRING), -1)")
    testFoldConst("select substring_index(CAST('prefix_string' AS STRING), CAST('_' AS STRING), NULL)")
    testFoldConst("select substring_index(CAST('prefix_string' AS STRING), CAST(NULL AS STRING), 1)")
    testFoldConst("select substring_index('hello world', ' ', -1)")
    testFoldConst("select substring_index('hello world', ' ', 1)")
    testFoldConst("select substring_index('hello world', ' ', -2)")
    testFoldConst("select substring_index('hello world', ' ', 2)")
    testFoldConst("select substring_index('hello world', ' ', -3)")
    testFoldConst("select substring_index('hello world', ' ', 3)")
    testFoldConst("select substring_index(null, '__', 1)")
    testFoldConst("select substring_index('prefix_string', '__', -1)")
    testFoldConst("select substring_index('prefix_string2', '__', 1)")
    testFoldConst("select substring_index('prefix__string2', '_', 2)")
    testFoldConst("select substring_index('prefix__string2', '__', 2)")
    testFoldConst("select substring_index('prefix_string', '_', null)")
    testFoldConst("select substring_index('prefix_string', null, 1)")
    testFoldConst("SELECT substring_index('哈哈哈AAA','A', -5)")
    testFoldConst("SELECT substring_index('哈哈哈AAA','A', -4)")
    testFoldConst("SELECT substring_index('哈哈哈AAA','A', -3)")
    testFoldConst("SELECT substring_index('哈哈哈AAA','A', -2)")
    testFoldConst("SELECT substring_index('哈哈哈AAA','A', -1)")
    testFoldConst("SELECT substring_index('哈哈哈AAA','A', 0)")
    testFoldConst("SELECT substring_index('哈哈哈AAA','A', 1)")
    testFoldConst("SELECT substring_index('哈哈哈AAA','A', 2)")
    testFoldConst("SELECT substring_index('哈哈哈AAA','A', 3)")
    testFoldConst("SELECT substring_index('哈哈哈AAA','A', 4)")
    testFoldConst("SELECT substring_index('哈哈哈AAA','A', 5)")
    testFoldConst("SELECT substring_index('哈哈哈AA+','A', -4)")
    testFoldConst("SELECT substring_index('哈哈哈AA+','A', -3)")
    testFoldConst("SELECT substring_index('哈哈哈AA+','A', -2)")
    testFoldConst("SELECT substring_index('哈哈哈AA+','A', -1)")
    testFoldConst("SELECT substring_index('哈哈哈AA+','A', 0)")
    testFoldConst("SELECT substring_index('哈哈哈AA+','A', 1)")
    testFoldConst("SELECT substring_index('哈哈哈AA+','A', 2)")
    testFoldConst("SELECT substring_index('哈哈哈AA+','A', 3)")
    testFoldConst("SELECT substring_index('哈哈哈AA+','A', 4)")
    testFoldConst("SELECT substring_index('a..b\$\$c||d((e))f[[g{{h^^i??j**k++l\\\\m','..', 1)")
    testFoldConst("SELECT substring_index('a..b\$\$c||d((e))f[[g{{h^^i??j**k++l\\\\m','\$\$', 1)")
    testFoldConst("SELECT substring_index('a..b\$\$c||d((e))f[[g{{h^^i??j**k++l\\\\m','||', 1)")
    testFoldConst("SELECT substring_index('a..b\$\$c||d((e))f[[g{{h^^i??j**k++l\\\\m','((', 1)")
    testFoldConst("SELECT substring_index('a..b\$\$c||d((e))f[[g{{h^^i??j**k++l\\\\m','))', 1)")
    testFoldConst("SELECT substring_index('a..b\$\$c||d((e))f[[g{{h^^i??j**k++l\\\\m','[[', 1)")
    testFoldConst("SELECT substring_index('a..b\$\$c||d((e))f[[g{{h^^i??j**k++l\\\\m','{{', 1)")
    testFoldConst("SELECT substring_index('a..b\$\$c||d((e))f[[g{{h^^i??j**k++l\\\\m','^^', 1)")
    testFoldConst("SELECT substring_index('a..b\$\$c||d((e))f[[g{{h^^i??j**k++l\\\\m','??', 1)")
    testFoldConst("SELECT substring_index('a..b\$\$c||d((e))f[[g{{h^^i??j**k++l\\\\m','**', 1)")
    testFoldConst("SELECT substring_index('a..b\$\$c||d((e))f[[g{{h^^i??j**k++l\\\\m','++', 1)")
    testFoldConst("SELECT substring_index('a..b\$\$c||d((e))f[[g{{h^^i??j**k++l\\\\m','\\\\', 1)")
    testFoldConst("SELECT substring_index('a..b\$\$c||d((e))f[[g{{h^^i??j**k++l\\\\m','..', 2)")
    testFoldConst("SELECT substring_index('a..b\$\$c||d((e))f[[g{{h^^i??j**k++l\\\\m','\$\$', 2)")
    testFoldConst("SELECT substring_index('a..b\$\$c||d((e))f[[g{{h^^i??j**k++l\\\\m','||', 2)")
    testFoldConst("SELECT substring_index('a..b\$\$c||d((e))f[[g{{h^^i??j**k++l\\\\m','((', 2)")
    testFoldConst("SELECT substring_index('a..b\$\$c||d((e))f[[g{{h^^i??j**k++l\\\\m','))', 2)")
    testFoldConst("SELECT substring_index('a..b\$\$c||d((e))f[[g{{h^^i??j**k++l\\\\m','[[', 2)")
    testFoldConst("SELECT substring_index('a..b\$\$c||d((e))f[[g{{h^^i??j**k++l\\\\m','{{', 2)")
    testFoldConst("SELECT substring_index('a..b\$\$c||d((e))f[[g{{h^^i??j**k++l\\\\m','^^', 2)")
    testFoldConst("SELECT substring_index('a..b\$\$c||d((e))f[[g{{h^^i??j**k++l\\\\m','??', 2)")
    testFoldConst("SELECT substring_index('a..b\$\$c||d((e))f[[g{{h^^i??j**k++l\\\\m','**', 2)")
    testFoldConst("SELECT substring_index('a..b\$\$c||d((e))f[[g{{h^^i??j**k++l\\\\m','++', 2)")
    testFoldConst("SELECT substring_index('a..b\$\$c||d((e))f[[g{{h^^i??j**k++l\\\\m','\\\\', 2)")

    // trim
    testFoldConst("select trim('11111', 11)")
    testFoldConst("select trim(cast('11111' as string), cast(11 as string))")
    testFoldConst("select trim(cast('  Hello World  ' as string))")
    testFoldConst("select trim('  Hello World  ')")

    // unhex
    testFoldConst("select unhex('')")
    testFoldConst("select unhex('@')")
    testFoldConst("select unhex('41')")
    testFoldConst("select unhex('4142')")
    testFoldConst("select unhex('68656C6C6F2C646F726973')")
    testFoldConst("select unhex(cast('4142' as string))")
    testFoldConst("select unhex(cast('41' as string))")
    testFoldConst("select unhex(cast('68656C6C6F2C646F726973' as string))")
    testFoldConst("select unhex(cast('' as string))")
    testFoldConst("select unhex(cast('@' as string))")
    testFoldConst("select unhex(cast('FF' as string))")
    testFoldConst("select unhex(cast('GHIJ' as string))")
    testFoldConst("select unhex('FF')")
    testFoldConst("select unhex('GHIJ')")
    testFoldConst("select unhex(NULL)")
    testFoldConst("select unhex(NULL)")
    testFoldConst("select upper(cast('Hello World' as string))")
    testFoldConst("select upper('Hello World')")
    testFoldConst("select upper('àç')")
//    testFoldConst("SELECT UPPER('ﬃ')")
//    testFoldConst("SELECT UPPER('straße')")
    testFoldConst("SELECT UPPER('ǅ')")
    testFoldConst("SELECT UPPER('Ångström')")

    // url_decode url_encode
    testFoldConst("select url_decode(cast('http%3A%2F%2Fwww.apache.org%2Flicenses%2FLICENSE-2.0' as string))")
    testFoldConst("select url_decode('http%3A%2F%2Fwww.apache.org%2Flicenses%2FLICENSE-2.0')")
    testFoldConst("select url_decode('http%3A%2F%2Fwww.apache.org%2Flicenses%2FLICENSE-22.0')")
    testFoldConst("select url_encode('http://www.apache.org/licenses/LICENSE-2.0')")
    testFoldConst("select url_encode(' http://www.apache.org/licenses/LICENSE-2.0 ')")
    testFoldConst("select url_encode(' http://www.baidu.com/?a=中文日文韩文俄文希伯来文Emoji')")

    // Normal Usage Test Cases

    // Test Case 1: Append missing trailing character
    testFoldConst("select append_trailing_char_if_absent('hello', '!')")
    // Expected Output: 'hello!'

    // Test Case 2: Trailing character already present
    testFoldConst("select append_trailing_char_if_absent('hello!', '!')")
    // Expected Output: 'hello!'

    // Test Case 3: Append trailing space
    testFoldConst("select append_trailing_char_if_absent('hello', ' ')")
    // Expected Output: 'hello '

    // Test Case 4: Empty string input
    testFoldConst("select append_trailing_char_if_absent('', '!')")
    // Expected Output: '!'

    // Test Case 5: Append different character
    testFoldConst("select append_trailing_char_if_absent('hello', '?')")
    // Expected Output: 'hello?'

    // Test Case 6: String ends with a different character
    testFoldConst("select append_trailing_char_if_absent('hello?', '!')")
    // Expected Output: 'hello?!'

    // Edge and Unusual Usage Test Cases

    // Test Case 7: Input is NULL
    testFoldConst("select append_trailing_char_if_absent(NULL, '!')")
    // Expected Output: NULL

    // Test Case 8: Trailing character is NULL
    testFoldConst("select append_trailing_char_if_absent('hello', NULL)")
    // Expected Output: NULL

    // Test Case 9: Empty trailing character
    testFoldConst("select append_trailing_char_if_absent('hello', '')")
    // Expected Output: Error or no change depending on implementation

    // Test Case 10: Trailing character is more than 1 character long
    testFoldConst("select append_trailing_char_if_absent('hello', 'ab')")
    // Expected Output: Error

    // Test Case 11: Input string is a number
    testFoldConst("select append_trailing_char_if_absent(12345, '!')")
    // Expected Output: Error or '12345!'

    // Test Case 12: Trailing character is a number
    testFoldConst("select append_trailing_char_if_absent('hello', '1')")
    // Expected Output: 'hello1'

    // Test Case 13: Input is a single character
    testFoldConst("select append_trailing_char_if_absent('h', '!')")
    // Expected Output: 'h!'

    // Test Case 14: Unicode character as input and trailing character
    testFoldConst("select append_trailing_char_if_absent('こんにちは', '!')")
    // Expected Output: 'こんにちは!'

    // Test Case 15: Multibyte character as trailing character
    testFoldConst("select append_trailing_char_if_absent('hello', '😊')")
    // Expected Output: 'hello😊'

    // Test Case 16: Long string input
    testFoldConst("select append_trailing_char_if_absent('This is a very long string', '.')")
    // Expected Output: 'This is a very long string.'

    // Error Handling Test Cases

    // Test Case 17: Invalid trailing character data type (numeric)
    testFoldConst("select append_trailing_char_if_absent('hello', 1)")
    // Expected Output: Error

    // Test Case 18: Invalid input data type (integer)
    testFoldConst("select append_trailing_char_if_absent(12345, '!')")
    // Expected Output: Error or '12345!'

    // Test Case 19: Non-ASCII characters
    testFoldConst("select append_trailing_char_if_absent('Привет', '!')")
    // Expected Output: 'Привет!'

    // Test Case 20: Trailing character with whitespace
    testFoldConst("select append_trailing_char_if_absent('hello', ' ')")
    // Expected Output: 'hello '

    // extract_url_parameter
    testFoldConst("select extract_url_parameter('http://user:pwd@www.baidu.com?a=b', 'a')")
    testFoldConst("select extract_url_parameter('http://user:pwd@www.baidu.com?a=b', 'A')")
    testFoldConst("select extract_url_parameter('http://user:pwd@www.baidu.com?a=b', 'b')")
    testFoldConst("select extract_url_parameter('http://user:pwd@www.baidu.com?a=b', 'B')")
    testFoldConst("select extract_url_parameter('http://user:pwd@www.baidu.com?a=b', 'c')")
    testFoldConst("select extract_url_parameter('http://user:pwd@www.baidu.com?a=b', 'C')")
    testFoldConst("select extract_url_parameter('http://user:pwd@www.baidu.com?a=b', '')")
    testFoldConst("select extract_url_parameter('http://user:pwd@www.baidu.com?a=b', null)")
    testFoldConst("select extract_url_parameter(null, 'a')")
    testFoldConst("select extract_url_parameter('http://user:pwd@www.baidu.com?a=b', 'a&b')")
    testFoldConst("select extract_url_parameter('http://user:pwd@www.baidu.com?a=b&c=d', 'c')")
    testFoldConst("select extract_url_parameter('http://user:pwd@www.baidu.com?a=b&c=d', 'C')")
    testFoldConst("select extract_url_parameter('http://user:pwd@www.baidu.com?a=b&c=d', 'd')")
    testFoldConst("select extract_url_parameter('http://user:pwd@www.baidu.com?a=b&c=d', 'D')")
    testFoldConst("select extract_url_parameter('http://user:pwd@www.baidu.com?a=b&c=d', 'e')")
    testFoldConst("select extract_url_parameter('http://user:pwd@www.baidu.com?a=b&c=d', 'E')")
    testFoldConst("select extract_url_parameter('http://user:pwd@www.baidu.com?a=b&c=d', '')")
    testFoldConst("select extract_url_parameter('http://user:pwd@www.baidu.com?a=b&c=d', null)")
    testFoldConst("select extract_url_parameter('http://user:pwd@www.baidu.com?a=b&c=d&e=f', 'e')")
    testFoldConst("select extract_url_parameter('http://user:pwd@www.baidu.com?a=b&c=d&e=f', 'E')")
    testFoldConst("select extract_url_parameter('http://user:pwd@www.baidu.com?a=b&c=d&e=f', 'f')")
    testFoldConst("select extract_url_parameter('http://user:pwd@www.baidu.com?a=b&c=d&e=f', 'F')")
    testFoldConst("select extract_url_parameter('http://user:pwd@www.baidu.com?a=b&c=d&e=f', 'g')")
    testFoldConst("select extract_url_parameter('http://user:pwd@www.baidu.com?a=b&c=d&e=f', 'G')")
    testFoldConst("select extract_url_parameter('http://user:pwd@www.baidu.com?a=b&c=d&e=f', '')")
    testFoldConst("select extract_url_parameter('http://user:pwd@www.baidu.com?a=b&c=d&e=f', null)")
    testFoldConst("select extract_url_parameter('http://user:pwd@www.baidu.com?a=b&c=d&e=f&g=h', 'g')")
    testFoldConst("select extract_url_parameter('http://user:pwd@www.baidu.com?a=b&c=d&e=f&g=h', 'G')")
    testFoldConst("select extract_url_parameter('http://user:pwd@www.baidu.com?a=b&c=d&e=f&g=h', 'h')")
    testFoldConst("select extract_url_parameter('http://user:pwd@www.baidu.com?a=b&c=d&e=f&g=h', 'H')")
    testFoldConst("select extract_url_parameter('http://user:pwd@www.baidu.com?a=b&c=d&e=f&g=h', 'i')")
    testFoldConst("select extract_url_parameter('http://user:pwd@www.baidu.com?a=b&c=d&e=f&g=h', 'I')")
    testFoldConst("select extract_url_parameter('http://user:pwd@www.baidu.com?a=b&c=d&e=f&g=h', '')")
    testFoldConst("select extract_url_parameter('http://user:pwd@www.baidu.com?a=b&c=d&e=f&g=h', null)")
    testFoldConst("select extract_url_parameter('http://user:pwd@www.baidu.com?a=b&c=d&e=f&g=h&i=j', 'i')")
    testFoldConst("select extract_url_parameter('http://user:pwd@www.baidu.com?a=b&c=d&e=f&g=h&i=j', 'I')")
    testFoldConst("select extract_url_parameter('http://user:pwd@www.baidu.com?a=b&c=d&e=f&g=h&i=j', 'j')")
    testFoldConst("select extract_url_parameter('http://user:pwd@www.baidu.com?a=b&c=d&e=f&g=h&i=j', 'J')")
    testFoldConst("select extract_url_parameter('http://user:pwd@www.baidu.com?a=b&c=d&e=f&g=h&i=j', 'k')")
    testFoldConst("select extract_url_parameter('http://user:pwd@www.baidu.com?a=b&c=d&e=f&g=h&i=j', 'K')")
    testFoldConst("select extract_url_parameter('http://user:pwd@www.baidu.com?a=b&c=d&e=f&g=h&i=j', '')")
    testFoldConst("select extract_url_parameter('http://user:pwd@www.baidu.com?a=b&c=d&e=f&g=h&i=j', null)")
    testFoldConst("select extract_url_parameter('http://user:pwd@www.baidu.com?a=b&c=d&e=f&g=h&i=j&k=l', 'k')")
    testFoldConst("select extract_url_parameter('http://user:pwd@www.baidu.com?a=b&c=d&e=f&g=h&i=j&k=l', 'K')")
    testFoldConst("select extract_url_parameter('http://user:pwd@www.baidu.com?a=b&c=d&e=f&g=h&i=j&k=l', 'l')")
    testFoldConst("select extract_url_parameter('http://user:pwd@www.baidu.com?a=b&c=d&e=f&g=h&i=j&k=l', 'L')")
    testFoldConst("select extract_url_parameter('http://user:pwd@www.baidu.com?a=b&c=d&e=f&g=h&i=j&k=l', 'm')")
    testFoldConst("select extract_url_parameter('http://user:pwd@www.baidu.com?a=b&c=d&e=f&g=h&i=j&k=l', 'M')")
    testFoldConst("select extract_url_parameter('http://user:pwd@www.baidu.com?a=b&c=d&e=f&g=h&i=j&k=l', '')")
    testFoldConst("select extract_url_parameter('http://user:pwd@www.baidu.com?a=b&c=d&e=f&g=h&i=j&k=l', null)")
    testFoldConst("select extract_url_parameter('http://www.example.com?a=b', 'a')")
    testFoldConst("select extract_url_parameter('http://www.example.com?A=B', 'a')")
    testFoldConst("select extract_url_parameter('http://www.example.com?param=value&another=example', 'param')")
    testFoldConst("select extract_url_parameter('http://www.example.com?PARAM=value&ANOTHER=example', 'param')")
    testFoldConst("select extract_url_parameter('http://www.example.com/path/to/file?query=string', 'query')")
    testFoldConst("select extract_url_parameter('http://www.example.com/path/to/file?QUERY=string', 'Query')")
    testFoldConst("select extract_url_parameter('http://user:pwd@www.test.com/path?query=string#frag', 'query')")
    testFoldConst("select extract_url_parameter('http://user:pwd@www.test.com/path?QUERY=string#frag', 'Query')")
    testFoldConst("select extract_url_parameter('http://www.test.com/?key=value', 'key')")
    testFoldConst("select extract_url_parameter('http://www.test.com/?KEY=value', 'Key')")
    testFoldConst("select extract_url_parameter('http://www.test.com/', 'key')")
    testFoldConst("select extract_url_parameter('http://www.test.com/?key1=value1&key2=value2', 'key1')")
    testFoldConst("select extract_url_parameter('http://www.test.com/?KEY1=value1&KEY2=value2', 'Key1')")
    testFoldConst("select extract_url_parameter('', 'key')")
    testFoldConst("select extract_url_parameter(null, 'key')")
    testFoldConst("select extract_url_parameter('not a url', 'key')")
    testFoldConst("select extract_url_parameter('http://www.test.com/?key=', 'key')")
    testFoldConst("select extract_url_parameter('http://www.test.com/?key', 'key')")
    testFoldConst("select extract_url_parameter('http://www.test.com/?key=value&key=value2', 'key')")
    testFoldConst("select extract_url_parameter('http://www.test.com/?KEY=value&KEY=value2', 'Key')")
    testFoldConst("select extract_url_parameter('http://www.test.com/?key1=value1&key2=value2&key3=value3', 'key2')")
    testFoldConst("select extract_url_parameter('http://www.test.com/?KEY1=value1&KEY2=value2&KEY3=value3', 'Key2')")
    testFoldConst("select extract_url_parameter('http://www.test.com/path/to/resource?param1=value1&param2=value2', 'param1')")
    testFoldConst("select extract_url_parameter('http://www.test.com/path/to/resource?PARAM1=value1&PARAM2=value2', 'Param1')")
    testFoldConst("select extract_url_parameter('http://www.test.com/path/to/resource?param=value&another=example', 'param')")
    testFoldConst("select extract_url_parameter('http://www.test.com/path/to/resource?PARAM=value&ANOTHER=example', 'Param')")
    testFoldConst("select extract_url_parameter('http://www.test.com/path/to/resource?query=string#fragment', 'query')")
    testFoldConst("select extract_url_parameter('http://www.test.com/path/to/resource?QUERY=string#fragment', 'Query')")
    testFoldConst("select extract_url_parameter('http://www.test.com/path/to/resource?param1=value1&param2=value2#fragment', 'param2')")
    testFoldConst("select extract_url_parameter('http://www.test.com/path/to/resource?PARAM1=value1&PARAM2=value2#fragment', 'Param2')")
    testFoldConst("select extract_url_parameter('http://user:pwd@www.test.com:8080/path/to/file?query=string#frag', 'query')")
    testFoldConst("select extract_url_parameter('http://user:pwd@www.test.com:8080/path/to/file?QUERY=string#frag', 'Query')")
    testFoldConst("select extract_url_parameter('http://www.test.com/?key=value&key=value2', 'key')")
    testFoldConst("select extract_url_parameter('http://www.test.com/?KEY=value&KEY=value2', 'Key')")
    testFoldConst("select extract_url_parameter('http://www.test.com/?key=value&another=value2', 'another')")
    testFoldConst("select extract_url_parameter('http://www.test.com/?KEY=value&ANOTHER=value2', 'Another')")
    testFoldConst("select extract_url_parameter('http://www.test.com/path/to/file?query=string&query=string2', 'query')")
    testFoldConst("select extract_url_parameter('http://www.test.com/path/to/file?QUERY=string&QUERY=string2', 'Query')")
    testFoldConst("select extract_url_parameter('http://www.test.com/path/to/file?param=value&another=example&another=example2', 'another')")
    testFoldConst("select extract_url_parameter('http://www.test.com/path/to/file?PARAM=value&ANOTHER=example&ANOTHER=example2', 'Another')")
    testFoldConst("select extract_url_parameter('http://www.test.com/path/to/file?param=value&another=example&another=example2&param=value2', 'param')")
    testFoldConst("select extract_url_parameter('http://www.test.com/path/to/file?PARAM=value&ANOTHER=example&ANOTHER=example2&PARAM=value2', 'Param')")
    testFoldConst("select extract_url_parameter('http://www.test.com/path/to/file?param=value&another=example&another=example2&param=value2', 'missing')")
    testFoldConst("select extract_url_parameter('http://www.test.com/path/to/file?PARAM=value&ANOTHER=example&ANOTHER=example2&PARAM=value2', 'Missing')")
    testFoldConst("select extract_url_parameter('http://example.com?a=b', 'a')")
    testFoldConst("select extract_url_parameter('http://example.com?a=b', 'A')")
    testFoldConst("select extract_url_parameter('http://example.com?a=b', 'Aa')")
    testFoldConst("select extract_url_parameter('http://example.com?a=b&c=d', 'c')")
    testFoldConst("select extract_url_parameter('http://example.com?a=b&c=d', 'C')")
    testFoldConst("select extract_url_parameter('http://example.com?a=b&c=D', 'd')")
    testFoldConst("select extract_url_parameter('http://example.com/path/to/resource?a=b', 'a')")
    testFoldConst("select extract_url_parameter('http://example.com/path/to/resource?a=b', 'A')")
    testFoldConst("select extract_url_parameter('http://example.com/path/to/resource?a=b&c=d', 'c')")
    testFoldConst("select extract_url_parameter('http://example.com/path/to/resource?a=b&c=d', 'C')")
    testFoldConst("select extract_url_parameter('http://example.com/path/to/resource?a=b&c=D', 'd')")
    testFoldConst("select extract_url_parameter('http://user:pwd@example.com?a=b', 'a')")
    testFoldConst("select extract_url_parameter('http://user:pwd@example.com?a=b', 'A')")
    testFoldConst("select extract_url_parameter('http://user:pwd@example.com?a=b&c=d', 'c')")
    testFoldConst("select extract_url_parameter('http://user:pwd@example.com?a=b&c=d', 'C')")
    testFoldConst("select extract_url_parameter('http://user:pwd@example.com?a=b&c=D', 'd')")
    testFoldConst("select extract_url_parameter('http://example.com:8080/path/to/resource?a=b', 'a')")
    testFoldConst("select extract_url_parameter('http://example.com:8080/path/to/resource?a=b', 'A')")
    testFoldConst("select extract_url_parameter('http://example.com:8080/path/to/resource?a=b&c=d', 'c')")
    testFoldConst("select extract_url_parameter('http://example.com:8080/path/to/resource?a=b&c=d', 'C')")
    testFoldConst("select extract_url_parameter('http://example.com:8080/path/to/resource?a=b&c=D', 'd')")
    testFoldConst("select extract_url_parameter('invalid-url', 'a')")
    testFoldConst("select extract_url_parameter('invalid-url', 'A')")
    testFoldConst("select extract_url_parameter('', 'a')")
    testFoldConst("select extract_url_parameter(null, 'a')")
    testFoldConst("select extract_url_parameter('http://example.com', 'a')")
    testFoldConst("select extract_url_parameter('http://example.com', 'A')")
    testFoldConst("select extract_url_parameter('http://example.com/?a=b', 'a')")
    testFoldConst("select extract_url_parameter('http://example.com/?a=b', 'A')")
    testFoldConst("select extract_url_parameter('http://example.com/?a=b&c=d', 'c')")
    testFoldConst("select extract_url_parameter('http://example.com/?a=b&c=d', 'C')")
    testFoldConst("select extract_url_parameter('http://example.com/?a=b&c=D', 'd')")
    testFoldConst("select extract_url_parameter('http://example.com/path/to/resource', 'a')")
    testFoldConst("select extract_url_parameter('http://example.com/path/to/resource', 'A')")
    testFoldConst("select extract_url_parameter('http://example.com/path/to/resource?a=b', 'b')")
    testFoldConst("select extract_url_parameter('http://example.com/path/to/resource?a=b', 'B')")
    testFoldConst("select extract_url_parameter('http://example.com/path/to/resource?a=b&c=d', 'b')")
    testFoldConst("select extract_url_parameter('http://example.com/path/to/resource?a=b&c=d', 'B')")
    testFoldConst("select extract_url_parameter('http://example.com/path/to/resource?a=b&c=D', 'd')")
    testFoldConst("select extract_url_parameter('http://user:pwd@example.com/path/to/resource', 'a')")
    testFoldConst("select extract_url_parameter('http://user:pwd@example.com/path/to/resource', 'A')")
    testFoldConst("select extract_url_parameter('http://user:pwd@example.com/path/to/resource?a=b', 'b')")
    testFoldConst("select extract_url_parameter('http://user:pwd@example.com/path/to/resource?a=b', 'B')")
    testFoldConst("select extract_url_parameter('http://user:pwd@example.com/path/to/resource?a=b&c=d', 'b')")
    testFoldConst("select extract_url_parameter('http://user:pwd@example.com/path/to/resource?a=b&c=d', 'B')")
    testFoldConst("select extract_url_parameter('http://user:pwd@example.com/path/to/resource?a=b&c=D', 'd')")
    testFoldConst("select extract_url_parameter('http://example.com:8080/path/to/resource', 'a')")
    testFoldConst("select extract_url_parameter('http://example.com:8080/path/to/resource', 'A')")
    testFoldConst("select extract_url_parameter('http://example.com:8080/path/to/resource?a=b', 'b')")
    testFoldConst("select extract_url_parameter('http://example.com:8080/path/to/resource?a=b', 'B')")
    testFoldConst("select extract_url_parameter('http://example.com:8080/path/to/resource?a=b&c=d', 'b')")
    testFoldConst("select extract_url_parameter('http://example.com:8080/path/to/resource?a=b&c=d', 'B')")
    testFoldConst("select extract_url_parameter('http://example.com:8080/path/to/resource?a=b&c=D', 'd')")
    testFoldConst("select extract_url_parameter('invalid-url', 'b')")
    testFoldConst("select extract_url_parameter('invalid-url', 'B')")
    testFoldConst("select extract_url_parameter('', 'b')")
    testFoldConst("select extract_url_parameter(null, 'b')")
    testFoldConst("select extract_url_parameter('http://example.com', 'b')")
    testFoldConst("select extract_url_parameter('http://example.com', 'B')")
    testFoldConst("select extract_url_parameter('http://example.com/?a=b&c=d&e=f', 'e')")
    testFoldConst("select extract_url_parameter('http://example.com/?a=b&c=d&e=f', 'E')")
    testFoldConst("select extract_url_parameter('http://example.com/path/to/resource?a=b&c=d&e=f', 'e')")
    testFoldConst("select extract_url_parameter('http://example.com/path/to/resource?a=b&c=d&e=f', 'E')")
    testFoldConst("select extract_url_parameter('http://user:pwd@example.com/path/to/resource?a=b&c=d&e=f', 'e')")
    testFoldConst("select extract_url_parameter('http://user:pwd@example.com/path/to/resource?a=b&c=d&e=f', 'E')")
    testFoldConst("select extract_url_parameter('http://example.com:8080/path/to/resource?a=b&c=d&e=f', 'e')")
    testFoldConst("select extract_url_parameter('http://example.com:8080/path/to/resource?a=b&c=d&e=f', 'E')")
    testFoldConst("select extract_url_parameter('http://example.com?a=b', 'a')")
    testFoldConst("select extract_url_parameter('http://example.com?a=b', 'A')")
    testFoldConst("select extract_url_parameter('http://example.com?a=b', 'α')")
    testFoldConst("select extract_url_parameter('http://example.com?a=b', 'β')")
    testFoldConst("select extract_url_parameter('http://example.com?a=b', '中文')")
    testFoldConst("select extract_url_parameter('http://example.com?a=b', '日本語')")
    testFoldConst("select extract_url_parameter('http://example.com?a=b', '한국어')")
    testFoldConst("select extract_url_parameter('http://example.com?a=b', 'русский')")
    testFoldConst("select extract_url_parameter('http://example.com?a=b', 'עברית')")
    testFoldConst("select extract_url_parameter('http://example.com?a=b', '😀')")
    testFoldConst("select extract_url_parameter('http://example.com?a=b', 'a😀b')")
    testFoldConst("select extract_url_parameter('http://example.com?a=b&c=d', 'c')")
    testFoldConst("select extract_url_parameter('http://example.com?a=b&c=d', 'C')")
    testFoldConst("select extract_url_parameter('http://example.com?a=b&c=D', 'd')")
    testFoldConst("select extract_url_parameter('http://example.com/path/to/resource?a=b', 'a')")
    testFoldConst("select extract_url_parameter('http://example.com/path/to/resource?a=b', 'A')")
    testFoldConst("select extract_url_parameter('http://example.com/path/to/resource?a=b&c=d', 'c')")
    testFoldConst("select extract_url_parameter('http://example.com/path/to/resource?a=b&c=d', 'C')")
    testFoldConst("select extract_url_parameter('http://example.com/path/to/resource?a=b&c=D', 'd')")
    testFoldConst("select extract_url_parameter('http://user:pwd@example.com?a=b', 'a')")
    testFoldConst("select extract_url_parameter('http://user:pwd@example.com?a=b', 'A')")
    testFoldConst("select extract_url_parameter('http://user:pwd@example.com?a=b&c=d', 'c')")
    testFoldConst("select extract_url_parameter('http://user:pwd@example.com?a=b&c=d', 'C')")
    testFoldConst("select extract_url_parameter('http://user:pwd@example.com?a=b&c=D', 'd')")
    testFoldConst("select extract_url_parameter('http://example.com:8080/path/to/resource?a=b', 'a')")
    testFoldConst("select extract_url_parameter('http://example.com:8080/path/to/resource?a=b', 'A')")
    testFoldConst("select extract_url_parameter('http://example.com:8080/path/to/resource?a=b&c=d', 'c')")
    testFoldConst("select extract_url_parameter('http://example.com:8080/path/to/resource?a=b&c=d', 'C')")
    testFoldConst("select extract_url_parameter('http://example.com:8080/path/to/resource?a=b&c=D', 'd')")
    testFoldConst("select extract_url_parameter('invalid-url', 'a')")
    testFoldConst("select extract_url_parameter('invalid-url', 'A')")
    testFoldConst("select extract_url_parameter('', 'a')")
    testFoldConst("select extract_url_parameter(null, 'a')")
    testFoldConst("select extract_url_parameter('http://example.com', 'a')")
    testFoldConst("select extract_url_parameter('http://example.com', 'A')")
    testFoldConst("select extract_url_parameter('http://example.com/?a=b', 'a')")
    testFoldConst("select extract_url_parameter('http://example.com/?a=b', 'A')")
    testFoldConst("select extract_url_parameter('http://example.com/?a=b&c=d', 'c')")
    testFoldConst("select extract_url_parameter('http://example.com/?a=b&c=d', 'C')")
    testFoldConst("select extract_url_parameter('http://example.com/?a=b&c=D', 'd')")
    testFoldConst("select extract_url_parameter('http://example.com/path/to/resource', 'a')")
    testFoldConst("select extract_url_parameter('http://example.com/path/to/resource', 'A')")
    testFoldConst("select extract_url_parameter('http://example.com/path/to/resource?a=b', 'b')")
    testFoldConst("select extract_url_parameter('http://example.com/path/to/resource?a=b', 'B')")
    testFoldConst("select extract_url_parameter('http://example.com/path/to/resource?a=b&c=d', 'b')")
    testFoldConst("select extract_url_parameter('http://example.com/path/to/resource?a=b&c=d', 'B')")
    testFoldConst("select extract_url_parameter('http://example.com/path/to/resource?a=b&c=D', 'd')")
    testFoldConst("select extract_url_parameter('http://user:pwd@example.com/path/to/resource', 'a')")
    testFoldConst("select extract_url_parameter('http://user:pwd@example.com/path/to/resource', 'A')")
    testFoldConst("select extract_url_parameter('http://user:pwd@example.com/path/to/resource?a=b', 'b')")
    testFoldConst("select extract_url_parameter('http://user:pwd@example.com/path/to/resource?a=b', 'B')")
    testFoldConst("select extract_url_parameter('http://user:pwd@example.com/path/to/resource?a=b&c=d', 'b')")
    testFoldConst("select extract_url_parameter('http://user:pwd@example.com/path/to/resource?a=b&c=d', 'B')")
    testFoldConst("select extract_url_parameter('http://user:pwd@example.com/path/to/resource?a=b&c=D', 'd')")
    testFoldConst("select extract_url_parameter('http://example.com:8080/path/to/resource', 'a')")
    testFoldConst("select extract_url_parameter('http://example.com:8080/path/to/resource', 'A')")
    testFoldConst("select extract_url_parameter('http://example.com:8080/path/to/resource?a=b', 'b')")
    testFoldConst("select extract_url_parameter('http://example.com:8080/path/to/resource?a=b', 'B')")
    testFoldConst("select extract_url_parameter('http://example.com:8080/path/to/resource?a=b&c=d', 'b')")
    testFoldConst("select extract_url_parameter('http://example.com:8080/path/to/resource?a=b&c=d', 'B')")
    testFoldConst("select extract_url_parameter('http://example.com:8080/path/to/resource?a=b&c=D', 'd')")
    testFoldConst("select extract_url_parameter('invalid-url', 'b')")
    testFoldConst("select extract_url_parameter('invalid-url', 'B')")
    testFoldConst("select extract_url_parameter('', 'b')")
    testFoldConst("select extract_url_parameter(null, 'b')")
    testFoldConst("select extract_url_parameter('http://example.com', 'b')")
    testFoldConst("select extract_url_parameter('http://example.com', 'B')")
    testFoldConst("select extract_url_parameter('http://example.com/?a=b&c=d&e=f', 'e')")
    testFoldConst("select extract_url_parameter('http://example.com/?a=b&c=d&e=f', 'E')")
    testFoldConst("select extract_url_parameter('http://example.com/path/to/resource?a=b&c=d&e=f', 'e')")
    testFoldConst("select extract_url_parameter('http://example.com/path/to/resource?a=b&c=d&e=f', 'E')")
    testFoldConst("select extract_url_parameter('http://user:pwd@example.com/path/to/resource?a=b&c=d&e=f', 'e')")
    testFoldConst("select extract_url_parameter('http://user:pwd@example.com/path/to/resource?a=b&c=d&e=f', 'E')")
    testFoldConst("select extract_url_parameter('http://example.com:8080/path/to/resource?a=b&c=d&e=f', 'e')")
    testFoldConst("select extract_url_parameter('http://example.com:8080/path/to/resource?a=b&c=d&e=f', 'E')")
    testFoldConst("select extract_url_parameter('http://example.com/path/to/resource?a=😀b', '😀b')")
    testFoldConst("select extract_url_parameter('http://example.com/path/to/resource?a=😀b', '😀B')")
    testFoldConst("select extract_url_parameter('http://example.com/path/to/resource?a=αβγ', 'αβγ')")
    testFoldConst("select extract_url_parameter('http://example.com/path/to/resource?a=αβγ', 'ΑΒΓ')")
    testFoldConst("select extract_url_parameter('http://example.com/path/to/resource?a=中文', '中文')")
    testFoldConst("select extract_url_parameter('http://example.com/path/to/resource?a=中文', '中文')")
    testFoldConst("select extract_url_parameter('http://example.com/path/to/resource?a=日本語', '日本語')")
    testFoldConst("select extract_url_parameter('http://example.com/path/to/resource?a=日本語', '日本語')")
    testFoldConst("select extract_url_parameter('http://example.com/path/to/resource?a=한국어', '한국어')")
    testFoldConst("select extract_url_parameter('http://example.com/path/to/resource?a=한국어', '한국어')")
    testFoldConst("select extract_url_parameter('http://example.com/path/to/resource?a=русский', 'русский')")
    testFoldConst("select extract_url_parameter('http://example.com/path/to/resource?a=русский', 'русский')")
    testFoldConst("select extract_url_parameter('http://example.com/path/to/resource?a=עברית', 'עברית')")
    testFoldConst("select extract_url_parameter('http://example.com/path/to/resource?a=עברית', 'עברית')")
    testFoldConst("select extract_url_parameter('http://www.example.com?a=b', 'a')")
    testFoldConst("select extract_url_parameter('http://www.example.com?A=B', 'a')")
    testFoldConst("select extract_url_parameter('http://www.example.com?α=β', 'α')")
    testFoldConst("select extract_url_parameter('http://www.example.com?你=好', '你')")
    testFoldConst("select extract_url_parameter('http://www.example.com?こ=んにちは', 'こ')")
    testFoldConst("select extract_url_parameter('http://www.example.com?안녕=하세요', '안녕')")
    testFoldConst("select extract_url_parameter('http://www.example.com?привет=мир', 'привет')")
    testFoldConst("select extract_url_parameter('http://www.example.com?שָׁלוֹם=עֲלֵיכֶם', 'שָׁלוֹם')")
    testFoldConst("select extract_url_parameter('http://www.example.com?😊=👍', '😊')")
//    testFoldConst("select extract_url_parameter('http://www.example.com?%20key=value', '%20key')")
    testFoldConst("select extract_url_parameter('http://www.test.com/', 'key')")
    testFoldConst("select extract_url_parameter('', 'key')")
    testFoldConst("select extract_url_parameter(null, 'key')")
    testFoldConst("select extract_url_parameter('not a url', 'key')")
    testFoldConst("select extract_url_parameter('http://www.test.com/?key=', 'key')")
    testFoldConst("select extract_url_parameter('http://www.test.com/?key', 'key')")
    testFoldConst("select extract_url_parameter('http://www.test.com/?key=value&key=value2', 'key')")
    testFoldConst("select extract_url_parameter('http://www.test.com/?α=β&α=γ', 'α')")
    testFoldConst("select extract_url_parameter('http://www.test.com/?你=好&你=世界', '你')")
    testFoldConst("select extract_url_parameter('http://www.test.com/?こ=んにちは&こ=さようなら', 'こ')")
    testFoldConst("select extract_url_parameter('http://www.test.com/?안녕=하세요&안녕=감사합니다', '안녕')")
    testFoldConst("select extract_url_parameter('http://www.test.com/?привет=мир&привет=мир2', 'привет')")
    testFoldConst("select extract_url_parameter('http://www.test.com/?שָׁלוֹם=עֲלֵיכֶם&שָׁלוֹם=שלום', 'שָׁלוֹם')")
    testFoldConst("select extract_url_parameter('http://www.test.com/?😊=👍&😊=😊', '😊')")
//    testFoldConst("select extract_url_parameter('http://www.test.com/?%20key=value&%20key=value2', '%20key')")
    testFoldConst("select extract_url_parameter('http://www.test.com/?key1=value1&key2=value2', 'key1')")
    testFoldConst("select extract_url_parameter('http://www.test.com/?α=value1&β=value2', 'α')")
    testFoldConst("select extract_url_parameter('http://www.test.com/?你=value1&好=value2', '你')")
    testFoldConst("select extract_url_parameter('http://www.test.com/?こ=value1&んにちは=value2', 'こ')")
    testFoldConst("select extract_url_parameter('http://www.test.com/?안녕=value1&하세요=value2', '안녕')")
    testFoldConst("select extract_url_parameter('http://www.test.com/?привет=value1&мир=value2', 'привет')")
    testFoldConst("select extract_url_parameter('http://www.test.com/?שָׁלוֹם=value1&עֲלֵיכֶם=value2', 'שָׁלוֹם')")
    testFoldConst("select extract_url_parameter('http://www.test.com/?😊=value1&👍=value2', '😊')")
//    testFoldConst("select extract_url_parameter('http://www.test.com/?%20key=value1&key=value2', '%20key')")
    testFoldConst("select extract_url_parameter('http://www.test.com/path/to/resource?param=value&another=example', 'param')")
    testFoldConst("select extract_url_parameter('http://www.test.com/path/to/resource?PARAM=value&ANOTHER=example', 'Param')")
    testFoldConst("select extract_url_parameter('http://www.test.com/path/to/resource?α=value&β=example', 'α')")
    testFoldConst("select extract_url_parameter('http://www.test.com/path/to/resource?你=value&好=example', '你')")
    testFoldConst("select extract_url_parameter('http://www.test.com/path/to/resource?こ=value&んにちは=example', 'こ')")
    testFoldConst("select extract_url_parameter('http://www.test.com/path/to/resource?안녕=value&하세요=example', '안녕')")
    testFoldConst("select extract_url_parameter('http://www.test.com/path/to/resource?привет=value&мир=example', 'привет')")
    testFoldConst("select extract_url_parameter('http://www.test.com/path/to/resource?שָׁלוֹם=value&עֲלֵיכֶם=example', 'שָׁלוֹם')")
    testFoldConst("select extract_url_parameter('http://www.test.com/path/to/resource?😊=value&👍=example', '😊')")
//    testFoldConst("select extract_url_parameter('http://www.test.com/path/to/resource?%20key=value&query=string', '%20key')")
    testFoldConst("select extract_url_parameter('http://user:pwd@www.test.com:8080/path/to/file?query=string#frag', 'query')")
    testFoldConst("select extract_url_parameter('http://user:pwd@www.test.com:8080/path/to/file?QUERY=string#frag', 'Query')")
    testFoldConst("select extract_url_parameter('http://user:pwd@www.test.com:8080/path/to/file?α=value#frag', 'α')")
    testFoldConst("select extract_url_parameter('http://user:pwd@www.test.com:8080/path/to/file?你=value#frag', '你')")
    testFoldConst("select extract_url_parameter('http://user:pwd@www.test.com:8080/path/to/file?こ=value#frag', 'こ')")
    testFoldConst("select extract_url_parameter('http://user:pwd@www.test.com:8080/path/to/file?안녕=value#frag', '안녕')")
    testFoldConst("select extract_url_parameter('http://user:pwd@www.test.com:8080/path/to/file?привет=value#frag', 'привет')")
    testFoldConst("select extract_url_parameter('http://user:pwd@www.test.com:8080/path/to/file?שָׁלוֹם=value#frag', 'שָׁלוֹם')")
    testFoldConst("select extract_url_parameter('http://user:pwd@www.test.com:8080/path/to/file?😊=value#frag', '😊')")
    testFoldConst("select extract_url_parameter('http://user:pwd@www.baidu.com?a=b', 'a')")
    testFoldConst("select extract_url_parameter('http://user:pwd@www.baidu.com?a=b', 'A')")
    testFoldConst("select extract_url_parameter('http://user:pwd@www.baidu.com?a=b', 'b')")
    testFoldConst("select extract_url_parameter('http://user:pwd@www.baidu.com?a=b', 'B')")
    testFoldConst("select extract_url_parameter('http://user:pwd@www.baidu.com?a=b', 'c')")
    testFoldConst("select extract_url_parameter('http://user:pwd@www.baidu.com?a=b', 'C')")
    testFoldConst("select extract_url_parameter('http://user:pwd@www.baidu.com?a=b', '')")
    testFoldConst("select extract_url_parameter('http://user:pwd@www.baidu.com?a=b', null)")
    testFoldConst("select extract_url_parameter(null, 'a')")
    testFoldConst("select extract_url_parameter('http://user:pwd@www.baidu.com?a=b', 'a&b')")
    testFoldConst("select extract_url_parameter('http://user:pwd@www.baidu.com?a=b&c=d', 'c')")
    testFoldConst("select extract_url_parameter('http://user:pwd@www.baidu.com?a=b&c=d', 'C')")
    testFoldConst("select extract_url_parameter('http://user:pwd@www.baidu.com?a=b&c=d', 'd')")
    testFoldConst("select extract_url_parameter('http://user:pwd@www.baidu.com?a=b&c=d', 'D')")
    testFoldConst("select extract_url_parameter('http://user:pwd@www.baidu.com?a=b&c=d', 'e')")
    testFoldConst("select extract_url_parameter('http://user:pwd@www.baidu.com?a=b&c=d', 'E')")
    testFoldConst("select extract_url_parameter('http://user:pwd@www.baidu.com?a=b&c=d', '')")
    testFoldConst("select extract_url_parameter('http://user:pwd@www.baidu.com?a=b&c=d', null)")
    testFoldConst("select extract_url_parameter('http://user:pwd@www.baidu.com?a=b&c=d&e=f', 'e')")
    testFoldConst("select extract_url_parameter('http://user:pwd@www.baidu.com?a=b&c=d&e=f', 'E')")
    testFoldConst("select extract_url_parameter('http://user:pwd@www.baidu.com?a=b&c=d&e=f', 'f')")
    testFoldConst("select extract_url_parameter('http://user:pwd@www.baidu.com?a=b&c=d&e=f', 'F')")
    testFoldConst("select extract_url_parameter('http://user:pwd@www.baidu.com?a=b&c=d&e=f', 'g')")
    testFoldConst("select extract_url_parameter('http://user:pwd@www.baidu.com?a=b&c=d&e=f', 'G')")
    testFoldConst("select extract_url_parameter('http://user:pwd@www.baidu.com?a=b&c=d&e=f', '')")
    testFoldConst("select extract_url_parameter('http://user:pwd@www.baidu.com?a=b&c=d&e=f', null)")
    testFoldConst("select extract_url_parameter('http://user:pwd@www.baidu.com?a=b&c=d&e=f&g=h', 'g')")
    testFoldConst("select extract_url_parameter('http://user:pwd@www.baidu.com?a=b&c=d&e=f&g=h', 'G')")
    testFoldConst("select extract_url_parameter('http://user:pwd@www.baidu.com?a=b&c=d&e=f&g=h', 'h')")
    testFoldConst("select extract_url_parameter('http://user:pwd@www.baidu.com?a=b&c=d&e=f&g=h', 'H')")
    testFoldConst("select extract_url_parameter('http://user:pwd@www.baidu.com?a=b&c=d&e=f&g=h', 'i')")
    testFoldConst("select extract_url_parameter('http://user:pwd@www.baidu.com?a=b&c=d&e=f&g=h', 'I')")
    testFoldConst("select extract_url_parameter('http://user:pwd@www.baidu.com?a=b&c=d&e=f&g=h', '')")
    testFoldConst("select extract_url_parameter('http://user:pwd@www.baidu.com?a=b&c=d&e=f&g=h', null)")
    testFoldConst("select extract_url_parameter('http://user:pwd@www.baidu.com?a=b&c=d&e=f&g=h&i=j', 'i')")
    testFoldConst("select extract_url_parameter('http://user:pwd@www.baidu.com?a=b&c=d&e=f&g=h&i=j', 'I')")
    testFoldConst("select extract_url_parameter('http://user:pwd@www.baidu.com?a=b&c=d&e=f&g=h&i=j', 'j')")
    testFoldConst("select extract_url_parameter('http://user:pwd@www.baidu.com?a=b&c=d&e=f&g=h&i=j', 'J')")
    testFoldConst("select extract_url_parameter('http://user:pwd@www.baidu.com?a=b&c=d&e=f&g=h&i=j', 'k')")
    testFoldConst("select extract_url_parameter('http://user:pwd@www.baidu.com?a=b&c=d&e=f&g=h&i=j', 'K')")
    testFoldConst("select extract_url_parameter('http://user:pwd@www.baidu.com?a=b&c=d&e=f&g=h&i=j', '')")
    testFoldConst("select extract_url_parameter('http://user:pwd@www.baidu.com?a=b&c=d&e=f&g=h&i=j', null)")
    testFoldConst("select extract_url_parameter('http://user:pwd@www.baidu.com?a=b&c=d&e=f&g=h&i=j&k=l', 'k')")
    testFoldConst("select extract_url_parameter('http://user:pwd@www.baidu.com?a=b&c=d&e=f&g=h&i=j&k=l', 'K')")
    testFoldConst("select extract_url_parameter('http://user:pwd@www.baidu.com?a=b&c=d&e=f&g=h&i=j&k=l', 'l')")
    testFoldConst("select extract_url_parameter('http://user:pwd@www.baidu.com?a=b&c=d&e=f&g=h&i=j&k=l', 'L')")
    testFoldConst("select extract_url_parameter('http://user:pwd@www.baidu.com?a=b&c=d&e=f&g=h&i=j&k=l', 'm')")
    testFoldConst("select extract_url_parameter('http://user:pwd@www.baidu.com?a=b&c=d&e=f&g=h&i=j&k=l', 'M')")
    testFoldConst("select extract_url_parameter('http://user:pwd@www.baidu.com?a=b&c=d&e=f&g=h&i=j&k=l', '')")
    testFoldConst("select extract_url_parameter('http://user:pwd@www.baidu.com?a=b&c=d&e=f&g=h&i=j&k=l', null)")
    testFoldConst("select extract_url_parameter('http://user:pwd@www.baidu.com?🌍=b', '🌍')")
    testFoldConst("select extract_url_parameter('http://user:pwd@www.baidu.com?🌍=b', '🌎')")
    testFoldConst("select extract_url_parameter('http://user:pwd@www.baidu.com?α=b', 'α')")
    testFoldConst("select extract_url_parameter('http://user:pwd@www.baidu.com?α=b', 'Α')")
    testFoldConst("select extract_url_parameter('http://user:pwd@www.baidu.com?中文=b', '中文')")
    testFoldConst("select extract_url_parameter('http://user:pwd@www.baidu.com?日本語=b', '日本語')")
    testFoldConst("select extract_url_parameter('http://user:pwd@www.baidu.com?한글=b', '한글')")
    testFoldConst("select extract_url_parameter('http://user:pwd@www.baidu.com?русский=b', 'русский')")
    testFoldConst("select extract_url_parameter('http://user:pwd@www.baidu.com?עברית=b', 'עברית')")
    testFoldConst("select extract_url_parameter('http://user:pwd@www.baidu.com?🌍=b&c=d', '🌍')")
    testFoldConst("select extract_url_parameter('http://user:pwd@www.baidu.com?🌍=b&c=d', 'c')")
    testFoldConst("select extract_url_parameter('http://user:pwd@www.baidu.com?🌍=b&c=d', 'C')")
    testFoldConst("select extract_url_parameter('http://user:pwd@www.baidu.com?🌍=b&c=d', 'd')")
    testFoldConst("select extract_url_parameter('http://user:pwd@www.baidu.com?🌍=b&c=d', 'D')")
    testFoldConst("select extract_url_parameter('http://user:pwd@www.baidu.com?🌍=b&c=d', 'e')")
    testFoldConst("select extract_url_parameter('http://user:pwd@www.baidu.com?🌍=b&c=d', 'E')")
    testFoldConst("select extract_url_parameter('http://user:pwd@www.baidu.com?🌍=b&c=d', '')")
    testFoldConst("select extract_url_parameter('http://user:pwd@www.baidu.com?🌍=b&c=d', null)")
    testFoldConst("select extract_url_parameter('http://user:pwd@www.baidu.com?🌍=b&c=d&e=f', 'e')")
    testFoldConst("select extract_url_parameter('http://user:pwd@www.baidu.com?🌍=b&c=d&e=f', 'E')")
    testFoldConst("select extract_url_parameter('http://user:pwd@www.baidu.com?🌍=b&c=d&e=f', 'f')")
    testFoldConst("select extract_url_parameter('http://user:pwd@www.baidu.com?🌍=b&c=d&e=f', 'F')")
    testFoldConst("select extract_url_parameter('http://user:pwd@www.baidu.com?🌍=b&c=d&e=f', 'g')")
    testFoldConst("select extract_url_parameter('http://user:pwd@www.baidu.com?🌍=b&c=d&e=f', 'G')")
    testFoldConst("select extract_url_parameter('http://user:pwd@www.baidu.com?🌍=b&c=d&e=f', '')")
    testFoldConst("select extract_url_parameter('http://user:pwd@www.baidu.com?🌍=b&c=d&e=f', null)")
    testFoldConst("select extract_url_parameter('http://user:pwd@www.baidu.com?🌍=b&c=d&e=f&g=h', 'g')")
    testFoldConst("select extract_url_parameter('http://user:pwd@www.baidu.com?🌍=b&c=d&e=f&g=h', 'G')")
    testFoldConst("select extract_url_parameter('http://user:pwd@www.baidu.com?🌍=b&c=d&e=f&g=h', 'h')")
    testFoldConst("select extract_url_parameter('http://user:pwd@www.baidu.com?🌍=b&c=d&e=f&g=h', 'H')")
    testFoldConst("select extract_url_parameter('http://user:pwd@www.baidu.com?🌍=b&c=d&e=f&g=h', 'i')")
    testFoldConst("select extract_url_parameter('http://user:pwd@www.baidu.com?🌍=b&c=d&e=f&g=h', 'I')")
    testFoldConst("select extract_url_parameter('http://user:pwd@www.baidu.com?🌍=b&c=d&e=f&g=h', '')")
    testFoldConst("select extract_url_parameter('http://user:pwd@www.baidu.com?🌍=b&c=d&e=f&g=h', null)")
    testFoldConst("select extract_url_parameter('http://user:pwd@www.baidu.com?🌍=b&c=d&e=f&g=h&i=j', 'i')")
    testFoldConst("select extract_url_parameter('http://user:pwd@www.baidu.com?🌍=b&c=d&e=f&g=h&i=j', 'I')")
    testFoldConst("select extract_url_parameter('http://user:pwd@www.baidu.com?🌍=b&c=d&e=f&g=h&i=j', 'j')")
    testFoldConst("select extract_url_parameter('http://user:pwd@www.baidu.com?🌍=b&c=d&e=f&g=h&i=j', 'J')")
    testFoldConst("select extract_url_parameter('http://user:pwd@www.baidu.com?🌍=b&c=d&e=f&g=h&i=j', 'k')")
    testFoldConst("select extract_url_parameter('http://user:pwd@www.baidu.com?🌍=b&c=d&e=f&g=h&i=j', 'K')")
    testFoldConst("select extract_url_parameter('http://user:pwd@www.baidu.com?🌍=b&c=d&e=f&g=h&i=j', '')")
    testFoldConst("select extract_url_parameter('http://user:pwd@www.baidu.com?🌍=b&c=d&e=f&g=h&i=j', null)")
    testFoldConst("select extract_url_parameter('http://user:pwd@www.baidu.com?🌍=b&c=d&e=f&g=h&i=j&k=l', 'k')")
    testFoldConst("select extract_url_parameter('http://user:pwd@www.baidu.com?🌍=b&c=d&e=f&g=h&i=j&k=l', 'K')")
    testFoldConst("select extract_url_parameter('http://user:pwd@www.baidu.com?🌍=b&c=d&e=f&g=h&i=j&k=l', 'l')")
    testFoldConst("select extract_url_parameter('http://user:pwd@www.baidu.com?🌍=b&c=d&e=f&g=h&i=j&k=l', 'L')")
    testFoldConst("select extract_url_parameter('http://user:pwd@www.baidu.com?🌍=b&c=d&e=f&g=h&i=j&k=l', 'm')")
    testFoldConst("select extract_url_parameter('http://user:pwd@www.baidu.com?🌍=b&c=d&e=f&g=h&i=j&k=l', 'M')")
    testFoldConst("select extract_url_parameter('http://user:pwd@www.baidu.com?🌍=b&c=d&e=f&g=h&i=j&k=l', '')")
    testFoldConst("select extract_url_parameter('http://user:pwd@www.baidu.com?🌍=b&c=d&e=f&g=h&i=j&k=l', null)")

    // emoji
    //testFoldConst("select replace_empty('😀abc', '', 'def')")
    //testFoldConst("select split_by_string('a😁a😁a', '')")
    testFoldConst("select character_length('a😁a😁a')")
    //testFoldConst("select replace_empty('a😁a😁a', '', '2')")

    // cast double to string like
    testFoldConst("select cast(cast(0 as double) as varchar(65533))")
    testFoldConst("select cast(cast(0 as double) as string)")
    testFoldConst("select cast(cast(0.0 as double) as varchar(65533))")
    testFoldConst("select cast(cast(0.0 as double) as string)")
    testFoldConst("select cast(cast(1 as double) as varchar(65533))")
    testFoldConst("select cast(cast(1 as double) as string)")
    testFoldConst("select cast(cast(1.0 as double) as varchar(65533))")
    testFoldConst("select cast(cast(1.0 as double) as string)")
    testFoldConst("select cast(cast(0.1 as double) as varchar(65533))")
    testFoldConst("select cast(cast(0.1 as double) as string)")
    testFoldConst("select cast(cast(1.1 as double) as varchar(65533))")
    testFoldConst("select cast(cast(1.1 as double) as string)")
    testFoldConst("select cast(cast(100000 as double) as string)")
    testFoldConst("select cast(cast(1000000000000000 as double) as string)")
    testFoldConst("select cast(cast(10000000000000000 as double) as string)")
    testFoldConst("select cast(cast(100000000000000000 as double) as string)")
    testFoldConst("select cast(cast(1000000000000000000 as double) as string)")
    testFoldConst("select cast(cast(1.888 as double) as string)")
    testFoldConst("select cast(cast(1.888777888777888 as double) as string)")
    testFoldConst("select cast(cast(1.8887778887778887 as double) as string)")
    testFoldConst("select cast(cast(1.888777888777888777 as double) as string)")
    testFoldConst("select cast(cast(55556666.888777888777888777 as double) as string)")
    testFoldConst("select cast(cast(555566667777.888777888777888777 as double) as string)")
    testFoldConst("select cast(cast(5555666677778888.888777888777888777 as double) as string)")
    testFoldConst("select cast(cast(55556666777788889.888777888777888777 as double) as string)")
    testFoldConst("select cast(cast(55556666777788889999.888777888777888777 as double) as string)")
    testFoldConst("select cast(cast(0.001 as double) as string)")
    testFoldConst("select cast(cast(0.0001 as double) as string)")
    testFoldConst("select cast(cast(0.00001 as double) as string)")
    testFoldConst("select cast(cast(0.000001 as double) as string)")
    testFoldConst("select cast(cast(0.0000001 as double) as string)")
    testFoldConst("select cast(cast(0.00000001 as double) as string)")
    testFoldConst("select cast(cast(0.00000001 as double) as string)")
    testFoldConst("select cast(cast(0.000000000000001 as double) as string)")
    testFoldConst("select cast(cast(0.0000000000000001 as double) as string)")
    testFoldConst("select cast(cast(0.00000000000000001 as double) as string)")
    testFoldConst("select cast(cast(0.000000000000000001 as double) as string)")
    testFoldConst("select cast(cast(0.0000000000000000001 as double) as string)")
    testFoldConst("select cast(cast(1e308 as double) as string)")
    testFoldConst("select cast(cast(1e309 as double) as string)")
    testFoldConst("select cast(cast(1e-308 as double) as string)")
    testFoldConst("select cast(cast(1e-309 as double) as string)")
    testFoldConst("select cast(cast(10000000000000001 as double) as string)")
    testFoldConst("select cast(cast(10000000000000010 as double) as string)")
    testFoldConst("select cast(cast(10000000000000100 as double) as string)")

    testFoldConst("select cast(cast(-0 as double) as varchar(65533))")
    testFoldConst("select cast(cast(-0 as double) as string)")
    testFoldConst("select cast(cast(-0.0 as double) as varchar(65533))")
    testFoldConst("select cast(cast(-0.0 as double) as string)")
    testFoldConst("select cast(cast(-1 as double) as varchar(65533))")
    testFoldConst("select cast(cast(-1 as double) as string)")
    testFoldConst("select cast(cast(-1.0 as double) as varchar(65533))")
    testFoldConst("select cast(cast(-1.0 as double) as string)")
    testFoldConst("select cast(cast(-0.1 as double) as varchar(65533))")
    testFoldConst("select cast(cast(-0.1 as double) as string)")
    testFoldConst("select cast(cast(-1.1 as double) as varchar(65533))")
    testFoldConst("select cast(cast(-1.1 as double) as string)")
    testFoldConst("select cast(cast(-100000 as double) as string)")
    testFoldConst("select cast(cast(-1000000000000000 as double) as string)")
    testFoldConst("select cast(cast(-10000000000000000 as double) as string)")
    testFoldConst("select cast(cast(-100000000000000000 as double) as string)")
    testFoldConst("select cast(cast(-1000000000000000000 as double) as string)")
    testFoldConst("select cast(cast(-1.888 as double) as string)")
    testFoldConst("select cast(cast(-1.888777888777888 as double) as string)")
    testFoldConst("select cast(cast(-1.8887778887778887 as double) as string)")
    testFoldConst("select cast(cast(-1.888777888777888777 as double) as string)")
    testFoldConst("select cast(cast(-55556666.888777888777888777 as double) as string)")
    testFoldConst("select cast(cast(-555566667777.888777888777888777 as double) as string)")
    testFoldConst("select cast(cast(-5555666677778888.888777888777888777 as double) as string)")
    testFoldConst("select cast(cast(-55556666777788889.888777888777888777 as double) as string)")
    testFoldConst("select cast(cast(-55556666777788889999.888777888777888777 as double) as string)")
    testFoldConst("select cast(cast(-0.001 as double) as string)")
    testFoldConst("select cast(cast(-0.0001 as double) as string)")
    testFoldConst("select cast(cast(-0.00001 as double) as string)")
    testFoldConst("select cast(cast(-0.000001 as double) as string)")
    testFoldConst("select cast(cast(-0.0000001 as double) as string)")
    testFoldConst("select cast(cast(-0.00000001 as double) as string)")
    testFoldConst("select cast(cast(-0.00000001 as double) as string)")
    testFoldConst("select cast(cast(-0.000000000000001 as double) as string)")
    testFoldConst("select cast(cast(-0.0000000000000001 as double) as string)")
    testFoldConst("select cast(cast(-0.00000000000000001 as double) as string)")
    testFoldConst("select cast(cast(-0.000000000000000001 as double) as string)")
    testFoldConst("select cast(cast(-0.0000000000000000001 as double) as string)")
    testFoldConst("select cast(cast(-1e308 as double) as string)")
    testFoldConst("select cast(cast(-1e309 as double) as string)")
    testFoldConst("select cast(cast(-1e-308 as double) as string)")
    testFoldConst("select cast(cast(-1e-309 as double) as string)")
    testFoldConst("select cast(cast(-10000000000000001 as double) as string)")
    testFoldConst("select cast(cast(-10000000000000010 as double) as string)")
    testFoldConst("select cast(cast(-10000000000000100 as double) as string)")
    testFoldConst("select cast(cast('nan' as double) as string)")
    testFoldConst("select cast(cast('inf' as double) as string)")
    testFoldConst("select cast(cast('-inf' as double) as string)")
}
