/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.kll;

import org.apache.datasketches.quantilescommon.QuantilesGenericSketchIterator;

public final class KllItemsSketchIterator<T>
implements QuantilesGenericSketchIterator<T> {
    private final Object[] quantiles;
    private final int[] levelsArr;
    private final int numLevels;
    private int level;
    private int index;
    private long weight;
    private boolean isInitialized_;

    KllItemsSketchIterator(Object[] quantiles, int[] levelsArr, int numLevels) {
        this.quantiles = quantiles;
        this.levelsArr = levelsArr;
        this.numLevels = numLevels;
        this.isInitialized_ = false;
    }

    @Override
    public T getQuantile() {
        return (T)this.quantiles[this.index];
    }

    @Override
    public long getWeight() {
        return this.weight;
    }

    @Override
    public boolean next() {
        if (!this.isInitialized_) {
            this.level = 0;
            this.index = this.levelsArr[this.level];
            this.weight = 1L;
            this.isInitialized_ = true;
        } else {
            ++this.index;
        }
        if (this.index < this.levelsArr[this.level + 1]) {
            return true;
        }
        do {
            ++this.level;
            if (this.level == this.numLevels) {
                return false;
            }
            this.weight *= 2L;
        } while (this.levelsArr[this.level] == this.levelsArr[this.level + 1]);
        this.index = this.levelsArr[this.level];
        return true;
    }
}

