/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common.task.batch.parallel;

import com.google.common.annotations.VisibleForTesting;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.druid.data.input.InputSplit;
import org.apache.druid.indexing.common.TaskToolbox;
import org.apache.druid.indexing.common.task.batch.parallel.ParallelIndexPhaseRunner;
import org.apache.druid.indexing.common.task.batch.parallel.ParallelIndexTuningConfig;
import org.apache.druid.indexing.common.task.batch.parallel.PartialGenericSegmentMergeTask;
import org.apache.druid.indexing.common.task.batch.parallel.PartialSegmentMergeIOConfig;
import org.apache.druid.indexing.common.task.batch.parallel.PartialSegmentMergeIngestionSpec;
import org.apache.druid.indexing.common.task.batch.parallel.PushedSegmentsReport;
import org.apache.druid.indexing.common.task.batch.parallel.SubTaskSpec;
import org.apache.druid.segment.indexing.DataSchema;

class PartialGenericSegmentMergeParallelIndexTaskRunner
extends ParallelIndexPhaseRunner<PartialGenericSegmentMergeTask, PushedSegmentsReport> {
    private static final String PHASE_NAME = "partial segment merge";
    private final DataSchema dataSchema;
    private final List<PartialSegmentMergeIOConfig> mergeIOConfigs;

    PartialGenericSegmentMergeParallelIndexTaskRunner(TaskToolbox toolbox, String taskId, String groupId, String baseSubtaskSpecName, DataSchema dataSchema, List<PartialSegmentMergeIOConfig> mergeIOConfigs, ParallelIndexTuningConfig tuningConfig, Map<String, Object> context) {
        super(toolbox, taskId, groupId, baseSubtaskSpecName, tuningConfig, context);
        this.dataSchema = dataSchema;
        this.mergeIOConfigs = mergeIOConfigs;
    }

    @Override
    public String getName() {
        return PHASE_NAME;
    }

    @Override
    Iterator<SubTaskSpec<PartialGenericSegmentMergeTask>> subTaskSpecIterator() {
        return this.mergeIOConfigs.stream().map(this::newTaskSpec).iterator();
    }

    @Override
    int estimateTotalNumSubTasks() {
        return this.mergeIOConfigs.size();
    }

    @VisibleForTesting
    SubTaskSpec<PartialGenericSegmentMergeTask> newTaskSpec(PartialSegmentMergeIOConfig ioConfig) {
        final PartialSegmentMergeIngestionSpec ingestionSpec = new PartialSegmentMergeIngestionSpec(this.dataSchema, ioConfig, this.getTuningConfig());
        final String subtaskSpecId = this.getBaseSubtaskSpecName() + "_" + this.getAndIncrementNextSpecId();
        return new SubTaskSpec<PartialGenericSegmentMergeTask>(subtaskSpecId, this.getGroupId(), this.getTaskId(), this.getContext(), new InputSplit(ioConfig.getPartitionLocations())){

            @Override
            public PartialGenericSegmentMergeTask newSubTask(int numAttempts) {
                return new PartialGenericSegmentMergeTask(null, this.getGroupId(), null, this.getSupervisorTaskId(), subtaskSpecId, numAttempts, ingestionSpec, this.getContext());
            }
        };
    }
}

