/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common.task.batch.parallel;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.druid.indexer.granularity.GranularitySpec;
import org.apache.druid.indexer.partitions.HashedPartitionsSpec;
import org.apache.druid.indexer.report.TaskReport;
import org.apache.druid.indexing.common.TaskToolbox;
import org.apache.druid.indexing.common.actions.SurrogateTaskActionClient;
import org.apache.druid.indexing.common.actions.TaskActionClient;
import org.apache.druid.indexing.common.task.SegmentAllocatorForBatch;
import org.apache.druid.indexing.common.task.SegmentAllocators;
import org.apache.druid.indexing.common.task.TaskResource;
import org.apache.druid.indexing.common.task.batch.parallel.GeneratedPartitionsMetadataReport;
import org.apache.druid.indexing.common.task.batch.parallel.ParallelIndexIngestionSpec;
import org.apache.druid.indexing.common.task.batch.parallel.ParallelIndexSupervisorTaskClient;
import org.apache.druid.indexing.common.task.batch.parallel.ParallelIndexTuningConfig;
import org.apache.druid.indexing.common.task.batch.parallel.PartialSegmentGenerateTask;
import org.apache.druid.indexing.common.task.batch.parallel.PartitionStat;
import org.apache.druid.indexing.common.task.batch.parallel.SupervisorTaskAccess;
import org.apache.druid.indexing.common.task.batch.parallel.iterator.DefaultIndexTaskInputRowIteratorBuilder;
import org.apache.druid.indexing.common.task.batch.partition.HashPartitionAnalysis;
import org.apache.druid.server.security.Action;
import org.apache.druid.server.security.Resource;
import org.apache.druid.server.security.ResourceAction;
import org.apache.druid.timeline.DataSegment;
import org.joda.time.Interval;

public class PartialHashSegmentGenerateTask
extends PartialSegmentGenerateTask<GeneratedPartitionsMetadataReport> {
    public static final String TYPE = "partial_index_generate";
    private static final String PROP_SPEC = "spec";
    private final int numAttempts;
    private final ParallelIndexIngestionSpec ingestionSchema;
    private final String subtaskSpecId;
    @Nullable
    private final Map<Interval, Integer> intervalToNumShardsOverride;

    @JsonCreator
    public PartialHashSegmentGenerateTask(@JsonProperty(value="id") @Nullable String id, @JsonProperty(value="groupId") String groupId, @JsonProperty(value="resource") TaskResource taskResource, @JsonProperty(value="supervisorTaskId") String supervisorTaskId, @JsonProperty(value="subtaskSpecId") @Nullable String subtaskSpecId, @JsonProperty(value="numAttempts") int numAttempts, @JsonProperty(value="spec") ParallelIndexIngestionSpec ingestionSchema, @JsonProperty(value="context") Map<String, Object> context, @JsonProperty(value="intervalToNumShardsOverride") @Nullable Map<Interval, Integer> intervalToNumShardsOverride) {
        super(PartialHashSegmentGenerateTask.getOrMakeId(id, TYPE, ingestionSchema.getDataSchema().getDataSource()), groupId, taskResource, supervisorTaskId, ingestionSchema, context, new DefaultIndexTaskInputRowIteratorBuilder());
        this.subtaskSpecId = subtaskSpecId;
        this.numAttempts = numAttempts;
        this.ingestionSchema = ingestionSchema;
        this.intervalToNumShardsOverride = intervalToNumShardsOverride;
    }

    @JsonProperty
    public int getNumAttempts() {
        return this.numAttempts;
    }

    @JsonProperty(value="spec")
    public ParallelIndexIngestionSpec getIngestionSchema() {
        return this.ingestionSchema;
    }

    @Override
    @JsonProperty
    public String getSubtaskSpecId() {
        return this.subtaskSpecId;
    }

    @Nullable
    @JsonProperty
    public Map<Interval, Integer> getIntervalToNumShardsOverride() {
        return this.intervalToNumShardsOverride;
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    @Nonnull
    @JsonIgnore
    public Set<ResourceAction> getInputSourceResources() {
        return this.getIngestionSchema().getIOConfig().getInputSource() != null ? this.getIngestionSchema().getIOConfig().getInputSource().getTypes().stream().map(i -> new ResourceAction(new Resource(i, "EXTERNAL"), Action.READ)).collect(Collectors.toSet()) : ImmutableSet.of();
    }

    @Override
    public boolean isReady(TaskActionClient taskActionClient) throws Exception {
        return this.tryTimeChunkLock(new SurrogateTaskActionClient(this.getSupervisorTaskId(), taskActionClient), this.getIngestionSchema().getDataSchema().getGranularitySpec().inputIntervals());
    }

    @Override
    SegmentAllocatorForBatch createSegmentAllocator(TaskToolbox toolbox, ParallelIndexSupervisorTaskClient taskClient) throws IOException {
        GranularitySpec granularitySpec = this.ingestionSchema.getDataSchema().getGranularitySpec();
        ParallelIndexTuningConfig tuningConfig = this.ingestionSchema.getTuningConfig();
        HashedPartitionsSpec partitionsSpec = (HashedPartitionsSpec)tuningConfig.getGivenOrDefaultPartitionsSpec();
        return SegmentAllocators.forNonLinearPartitioning(toolbox, this.getDataSource(), this.getSubtaskSpecId(), granularitySpec, new SupervisorTaskAccess(this.getSupervisorTaskId(), taskClient), PartialHashSegmentGenerateTask.createHashPartitionAnalysisFromPartitionsSpec(granularitySpec, partitionsSpec, this.intervalToNumShardsOverride));
    }

    @Override
    GeneratedPartitionsMetadataReport createGeneratedPartitionsReport(TaskToolbox toolbox, List<DataSegment> segments, TaskReport.ReportMap taskReport) {
        List<PartitionStat> partitionStats = segments.stream().map(segment -> toolbox.getIntermediaryDataManager().generatePartitionStat(toolbox, (DataSegment)segment)).collect(Collectors.toList());
        return new GeneratedPartitionsMetadataReport(this.getId(), partitionStats, taskReport);
    }

    public static HashPartitionAnalysis createHashPartitionAnalysisFromPartitionsSpec(GranularitySpec granularitySpec, @Nonnull HashedPartitionsSpec partitionsSpec, @Nullable Map<Interval, Integer> intervalToNumShardsOverride) {
        HashPartitionAnalysis partitionAnalysis = new HashPartitionAnalysis(partitionsSpec);
        if (intervalToNumShardsOverride != null) {
            intervalToNumShardsOverride.forEach(partitionAnalysis::updateBucket);
        } else {
            Iterable intervals = granularitySpec.sortedBucketIntervals();
            int numBucketsPerInterval = partitionsSpec.getNumShards() == null ? 1 : partitionsSpec.getNumShards();
            intervals.forEach(interval -> partitionAnalysis.updateBucket((Interval)interval, numBucketsPerInterval));
        }
        return partitionAnalysis;
    }
}

