/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common.task.batch.parallel;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.apache.druid.indexer.TaskState;
import org.apache.druid.indexer.TaskStatusPlus;
import org.apache.druid.indexing.common.task.Task;
import org.apache.druid.indexing.common.task.batch.parallel.SubTaskSpec;

class TaskHistory<T extends Task> {
    private final SubTaskSpec<T> spec;
    private final List<TaskStatusPlus> attemptHistory;

    TaskHistory(SubTaskSpec<T> spec, List<TaskStatusPlus> attemptHistory) {
        attemptHistory.forEach(status -> Preconditions.checkState((status.getStatusCode() == TaskState.SUCCESS || status.getStatusCode() == TaskState.FAILED ? 1 : 0) != 0, (String)"Complete tasks should be recorded, but the state of task[%s] is [%s]", (Object)status.getId(), (Object)status.getStatusCode()));
        this.spec = spec;
        this.attemptHistory = ImmutableList.copyOf(attemptHistory);
    }

    SubTaskSpec<T> getSpec() {
        return this.spec;
    }

    List<TaskStatusPlus> getAttemptHistory() {
        return this.attemptHistory;
    }

    boolean isEmpty() {
        return this.attemptHistory.isEmpty();
    }
}

