/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.overlord;

import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.druid.error.DruidException;
import org.apache.druid.indexer.TaskInfo;
import org.apache.druid.indexer.TaskStatus;
import org.apache.druid.indexer.TaskStatusPlus;
import org.apache.druid.indexing.common.TaskLock;
import org.apache.druid.indexing.common.actions.TaskAction;
import org.apache.druid.indexing.common.config.TaskStorageConfig;
import org.apache.druid.indexing.common.task.Task;
import org.apache.druid.indexing.overlord.TaskStorage;
import org.apache.druid.indexing.overlord.TaskStorageUtils;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.lifecycle.LifecycleStart;
import org.apache.druid.java.util.common.lifecycle.LifecycleStop;
import org.apache.druid.java.util.emitter.EmittingLogger;
import org.apache.druid.metadata.MetadataStorageActionHandler;
import org.apache.druid.metadata.MetadataStorageActionHandlerFactory;
import org.apache.druid.metadata.MetadataStorageActionHandlerTypes;
import org.apache.druid.metadata.MetadataStorageConnector;
import org.apache.druid.metadata.TaskLookup;
import org.joda.time.ReadableDuration;

public class MetadataTaskStorage
implements TaskStorage {
    private static final MetadataStorageActionHandlerTypes<Task, TaskStatus, TaskAction, TaskLock> TASK_TYPES = new MetadataStorageActionHandlerTypes<Task, TaskStatus, TaskAction, TaskLock>(){

        public TypeReference<Task> getEntryType() {
            return new TypeReference<Task>(){};
        }

        public TypeReference<TaskStatus> getStatusType() {
            return new TypeReference<TaskStatus>(){};
        }

        public TypeReference<TaskLock> getLockType() {
            return new TypeReference<TaskLock>(){};
        }
    };
    private final MetadataStorageConnector metadataStorageConnector;
    private final TaskStorageConfig config;
    private final MetadataStorageActionHandler<Task, TaskStatus, TaskAction, TaskLock> handler;
    private static final EmittingLogger log = new EmittingLogger(MetadataTaskStorage.class);

    @Inject
    public MetadataTaskStorage(MetadataStorageConnector metadataStorageConnector, TaskStorageConfig config, MetadataStorageActionHandlerFactory factory) {
        this.metadataStorageConnector = metadataStorageConnector;
        this.config = config;
        this.handler = factory.create("task", TASK_TYPES);
    }

    @LifecycleStart
    public void start() {
        this.metadataStorageConnector.createTaskTables();
        this.handler.populateTaskTypeAndGroupIdAsync();
    }

    @LifecycleStop
    public void stop() {
    }

    @Override
    public void insert(Task task, TaskStatus status) {
        Preconditions.checkNotNull((Object)task, (Object)"task");
        Preconditions.checkNotNull((Object)status, (Object)"status");
        Preconditions.checkArgument((boolean)task.getId().equals(status.getId()), (String)"Task/Status ID mismatch[%s/%s]", (Object)task.getId(), (Object)status.getId());
        log.info("Inserting task [%s] with status [%s].", new Object[]{task.getId(), status});
        try {
            this.handler.insert(task.getId(), DateTimes.nowUtc(), task.getDataSource(), (Object)task, status.isRunnable(), (Object)status, task.getType(), task.getGroupId());
        }
        catch (DruidException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void setStatus(TaskStatus status) {
        Preconditions.checkNotNull((Object)status, (Object)"status");
        String taskId = status.getId();
        log.info("Updating status of task [%s] to [%s].", new Object[]{taskId, status});
        boolean set = this.handler.setStatus(taskId, status.isRunnable(), (Object)status);
        if (!set) {
            throw new ISE("No active task for id [%s]", new Object[]{taskId});
        }
    }

    @Override
    public Optional<Task> getTask(String taskId) {
        return this.handler.getEntry(taskId);
    }

    @Override
    public Optional<TaskStatus> getStatus(String taskId) {
        return this.handler.getStatus(taskId);
    }

    @Override
    @Nullable
    public TaskInfo<Task, TaskStatus> getTaskInfo(String taskId) {
        return this.handler.getTaskInfo(taskId);
    }

    @Override
    public List<Task> getActiveTasks() {
        return this.handler.getTaskInfos(Collections.singletonMap(TaskLookup.TaskLookupType.ACTIVE, TaskLookup.ActiveTaskLookup.getInstance()), null).stream().filter(taskInfo -> ((TaskStatus)taskInfo.getStatus()).isRunnable() && taskInfo.getTask() != null).map(TaskInfo::getTask).collect(Collectors.toList());
    }

    @Override
    public List<Task> getActiveTasksByDatasource(String datasource) {
        List activeTaskInfos = this.handler.getTaskInfos(Collections.singletonMap(TaskLookup.TaskLookupType.ACTIVE, TaskLookup.ActiveTaskLookup.getInstance()), datasource);
        ImmutableList.Builder tasksBuilder = ImmutableList.builder();
        for (TaskInfo taskInfo : activeTaskInfos) {
            if (!((TaskStatus)taskInfo.getStatus()).isRunnable() || taskInfo.getTask() == null) continue;
            tasksBuilder.add((Object)((Task)taskInfo.getTask()));
        }
        return tasksBuilder.build();
    }

    @Override
    public List<TaskInfo<Task, TaskStatus>> getTaskInfos(Map<TaskLookup.TaskLookupType, TaskLookup> taskLookups, @Nullable String datasource) {
        Map<TaskLookup.TaskLookupType, TaskLookup> theTaskLookups = TaskStorageUtils.processTaskLookups(taskLookups, DateTimes.nowUtc().minus((ReadableDuration)this.config.getRecentlyFinishedThreshold()));
        return Collections.unmodifiableList(this.handler.getTaskInfos(theTaskLookups, datasource));
    }

    @Override
    public List<TaskStatusPlus> getTaskStatusPlusList(Map<TaskLookup.TaskLookupType, TaskLookup> taskLookups, @Nullable String datasource) {
        Map<TaskLookup.TaskLookupType, TaskLookup> processedTaskLookups = TaskStorageUtils.processTaskLookups(taskLookups, DateTimes.nowUtc().minus((ReadableDuration)this.config.getRecentlyFinishedThreshold()));
        return Collections.unmodifiableList(this.handler.getTaskStatusList(processedTaskLookups, datasource).stream().map(TaskStatusPlus::fromTaskIdentifierInfo).collect(Collectors.toList()));
    }

    @Override
    public void addLock(String taskid, TaskLock taskLock) {
        Preconditions.checkNotNull((Object)taskid, (Object)"taskid");
        Preconditions.checkNotNull((Object)taskLock, (Object)"taskLock");
        log.info("Adding lock on interval[%s] version[%s] for task [%s].", new Object[]{taskLock.getInterval(), taskLock.getVersion(), taskid});
        this.handler.addLock(taskid, (Object)taskLock);
    }

    @Override
    public void replaceLock(String taskid, TaskLock oldLock, TaskLock newLock) {
        Preconditions.checkNotNull((Object)taskid, (Object)"taskid");
        Preconditions.checkNotNull((Object)oldLock, (Object)"oldLock");
        Preconditions.checkNotNull((Object)newLock, (Object)"newLock");
        log.info("Replacing an existing lock[%s] with a new lock[%s] for task [%s].", new Object[]{oldLock, newLock, taskid});
        Long oldLockId = this.handler.getLockId(taskid, (Object)oldLock);
        if (oldLockId == null) {
            throw new ISE("Cannot find lock[%s] for task [%s]", new Object[]{oldLock, taskid});
        }
        this.handler.replaceLock(taskid, oldLockId.longValue(), (Object)newLock);
    }

    @Override
    public void removeLock(String taskid, TaskLock taskLockToRemove) {
        Preconditions.checkNotNull((Object)taskid, (Object)"taskid");
        Preconditions.checkNotNull((Object)taskLockToRemove, (Object)"taskLockToRemove");
        Long lockId = this.handler.getLockId(taskid, (Object)taskLockToRemove);
        if (lockId == null) {
            log.warn("Cannot find lock[%s]", new Object[]{taskLockToRemove});
        } else {
            log.info("Deleting TaskLock with id[%d]: %s", new Object[]{lockId, taskLockToRemove});
            this.handler.removeLock(lockId.longValue());
        }
    }

    @Override
    public void removeTasksOlderThan(long timestamp) {
        this.handler.removeTasksOlderThan(timestamp);
    }

    @Override
    public List<TaskLock> getLocks(String taskid) {
        return ImmutableList.copyOf((Iterable)Iterables.transform(this.getLocksWithIds(taskid).entrySet(), Map.Entry::getValue));
    }

    private Map<Long, TaskLock> getLocksWithIds(String taskid) {
        return this.handler.getLocks(taskid);
    }
}

