/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.overlord.duty;

import com.google.inject.Inject;
import org.apache.druid.indexing.overlord.TaskStorage;
import org.apache.druid.indexing.overlord.duty.DutySchedule;
import org.apache.druid.indexing.overlord.duty.OverlordDuty;
import org.apache.druid.indexing.overlord.duty.TaskLogAutoCleanerConfig;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.tasklogs.TaskLogKiller;

public class TaskLogAutoCleaner
implements OverlordDuty {
    private static final Logger log = new Logger(TaskLogAutoCleaner.class);
    private final TaskLogKiller taskLogKiller;
    private final TaskLogAutoCleanerConfig config;
    private final TaskStorage taskStorage;

    @Inject
    public TaskLogAutoCleaner(TaskLogKiller taskLogKiller, TaskLogAutoCleanerConfig config, TaskStorage taskStorage) {
        this.taskLogKiller = taskLogKiller;
        this.config = config;
        this.taskStorage = taskStorage;
    }

    @Override
    public boolean isEnabled() {
        return this.config.isEnabled();
    }

    @Override
    public void run() throws Exception {
        long timestamp = System.currentTimeMillis() - this.config.getDurationToRetain();
        this.taskLogKiller.killOlderThan(timestamp);
        this.taskStorage.removeTasksOlderThan(timestamp);
    }

    @Override
    public DutySchedule getSchedule() {
        return new DutySchedule(this.config.getDelay(), this.config.getInitialDelay());
    }
}

