/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.seekablestream;

import com.google.common.base.Preconditions;
import java.io.InputStream;
import java.net.URI;
import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.druid.data.input.InputEntity;
import org.apache.druid.data.input.impl.ByteEntity;
import org.apache.druid.io.ByteBufferInputStream;
import org.apache.druid.java.util.common.IAE;

@NotThreadSafe
public class SettableByteEntity<T extends ByteEntity>
implements InputEntity {
    private T entity;

    public void setEntity(T entity) {
        this.entity = entity;
    }

    @Nullable
    public URI getUri() {
        return null;
    }

    public T getEntity() {
        return this.entity;
    }

    public InputStream open() {
        SettableByteBufferInputStream stream = new SettableByteBufferInputStream();
        stream.setBuffer(this.entity.getBuffer().duplicate());
        return stream;
    }

    public static final class SettableByteBufferInputStream
    extends InputStream {
        @Nullable
        private ByteBufferInputStream delegate;

        public void setBuffer(ByteBuffer newBuffer) {
            if (null != this.delegate && this.available() > 0) {
                throw new IAE("New data cannot be set in buffer till all the old data has been read", new Object[0]);
            }
            this.delegate = new ByteBufferInputStream(newBuffer);
        }

        @Override
        public int read() {
            Preconditions.checkNotNull((Object)this.delegate, (Object)"Buffer is not set");
            return this.delegate.read();
        }

        @Override
        public int read(byte[] bytes, int off, int len) {
            Preconditions.checkNotNull((Object)this.delegate, (Object)"Buffer is not set");
            return this.delegate.read(bytes, off, len);
        }

        @Override
        public int available() {
            Preconditions.checkNotNull((Object)this.delegate, (Object)"Buffer is not set");
            return this.delegate.available();
        }
    }
}

