/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.data.input.protobuf;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import com.google.protobuf.Descriptors;
import com.google.protobuf.DynamicMessage;
import io.confluent.kafka.schemaregistry.client.CachedSchemaRegistryClient;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.confluent.kafka.schemaregistry.client.rest.exceptions.RestClientException;
import io.confluent.kafka.schemaregistry.protobuf.ProtobufSchema;
import io.confluent.kafka.schemaregistry.protobuf.ProtobufSchemaProvider;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.druid.data.input.protobuf.ProtobufBytesDecoder;
import org.apache.druid.guice.annotations.Json;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.java.util.common.parsers.ParseException;
import org.apache.druid.utils.DynamicConfigProviderUtils;

public class SchemaRegistryBasedProtobufBytesDecoder
implements ProtobufBytesDecoder {
    private static final Logger LOGGER = new Logger(SchemaRegistryBasedProtobufBytesDecoder.class);
    private final SchemaRegistryClient registry;
    private final String url;
    private final int capacity;
    private final List<String> urls;
    private final Map<String, Object> config;
    private final Map<String, Object> headers;
    private final ObjectMapper jsonMapper;
    public static final String DRUID_DYNAMIC_CONFIG_PROVIDER_KEY = "druid.dynamic.config.provider";

    @JsonCreator
    public SchemaRegistryBasedProtobufBytesDecoder(@JsonProperty(value="url") @Deprecated String url, @JsonProperty(value="capacity") Integer capacity, @JsonProperty(value="urls") @Nullable List<String> urls, @JsonProperty(value="config") @Nullable Map<String, Object> config, @JsonProperty(value="headers") @Nullable Map<String, Object> headers, @JacksonInject @Json ObjectMapper jsonMapper) {
        this.url = url;
        this.capacity = capacity == null ? Integer.MAX_VALUE : capacity;
        this.urls = urls;
        this.config = config;
        this.headers = headers;
        this.jsonMapper = jsonMapper;
        this.registry = url != null && !url.isEmpty() ? new CachedSchemaRegistryClient(Collections.singletonList(this.url), this.capacity, Collections.singletonList(new ProtobufSchemaProvider()), DynamicConfigProviderUtils.extraConfigAndSetObjectMap(config, (String)DRUID_DYNAMIC_CONFIG_PROVIDER_KEY, (ObjectMapper)this.jsonMapper), (Map<String, String>)DynamicConfigProviderUtils.extraConfigAndSetStringMap(headers, (String)DRUID_DYNAMIC_CONFIG_PROVIDER_KEY, (ObjectMapper)this.jsonMapper)) : new CachedSchemaRegistryClient(this.urls, this.capacity, Collections.singletonList(new ProtobufSchemaProvider()), DynamicConfigProviderUtils.extraConfigAndSetObjectMap(config, (String)DRUID_DYNAMIC_CONFIG_PROVIDER_KEY, (ObjectMapper)this.jsonMapper), (Map<String, String>)DynamicConfigProviderUtils.extraConfigAndSetStringMap(headers, (String)DRUID_DYNAMIC_CONFIG_PROVIDER_KEY, (ObjectMapper)this.jsonMapper));
    }

    @JsonProperty
    public String getUrl() {
        return this.url;
    }

    @JsonProperty
    public int getCapacity() {
        return this.capacity;
    }

    @JsonProperty
    public List<String> getUrls() {
        return this.urls;
    }

    @JsonProperty
    public Map<String, Object> getConfig() {
        return this.config;
    }

    @JsonProperty
    public Map<String, Object> getHeaders() {
        return this.headers;
    }

    @VisibleForTesting
    int getIdentityMapCapacity() {
        return this.capacity;
    }

    @VisibleForTesting
    SchemaRegistryBasedProtobufBytesDecoder(SchemaRegistryClient registry) {
        this.url = null;
        this.capacity = Integer.MAX_VALUE;
        this.urls = null;
        this.config = null;
        this.headers = null;
        this.registry = registry;
        this.jsonMapper = new ObjectMapper();
    }

    @Override
    public DynamicMessage parse(ByteBuffer bytes) {
        Descriptors.Descriptor descriptor;
        bytes.get();
        int id = bytes.getInt();
        bytes.get();
        int length = bytes.limit() - 2 - 4;
        try {
            ProtobufSchema schema = (ProtobufSchema)this.registry.getSchemaById(id);
            descriptor = schema.toDescriptor();
        }
        catch (RestClientException e) {
            LOGGER.error(e.getMessage(), new Object[0]);
            throw new ParseException(null, (Throwable)e, "Fail to get protobuf schema because of can not connect to registry or failed http request!", new Object[0]);
        }
        catch (IOException e) {
            LOGGER.error(e.getMessage(), new Object[0]);
            throw new ParseException(null, (Throwable)e, "Fail to get protobuf schema because of invalid schema!", new Object[0]);
        }
        try {
            byte[] rawMessage = new byte[length];
            bytes.get(rawMessage, 0, length);
            DynamicMessage message = DynamicMessage.parseFrom(descriptor, rawMessage);
            return message;
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), new Object[0]);
            throw new ParseException(null, (Throwable)e, "Fail to decode protobuf message!", new Object[0]);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SchemaRegistryBasedProtobufBytesDecoder that = (SchemaRegistryBasedProtobufBytesDecoder)o;
        return Objects.equals(this.url, that.url) && Objects.equals(this.capacity, that.capacity) && Objects.equals(this.urls, that.urls) && Objects.equals(this.config, that.config) && Objects.equals(this.headers, that.headers);
    }

    public int hashCode() {
        int result = this.url != null ? this.url.hashCode() : 0;
        result = 31 * result + this.capacity;
        result = 31 * result + (this.urls != null ? this.urls.hashCode() : 0);
        result = 31 * result + (this.config != null ? this.config.hashCode() : 0);
        result = 31 * result + (this.headers != null ? this.headers.hashCode() : 0);
        return result;
    }
}

