/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.histogram;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Objects;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.StringUtils;

public class FixedBucketsHistogram {
    public static final byte SERIALIZATION_VERSION = 1;
    public static final int SERDE_HEADER_SIZE = 2;
    public static final int COMMON_FIELDS_SIZE = 69;
    public static final byte FULL_ENCODING_MODE = 1;
    public static final byte SPARSE_ENCODING_MODE = 2;
    @JsonIgnore
    private final OutlierHandler outlierHandler;
    @JsonIgnore
    private final ReadWriteLock readWriteLock;
    private double lowerLimit;
    private double upperLimit;
    private int numBuckets;
    private long upperOutlierCount = 0L;
    private long lowerOutlierCount = 0L;
    private long missingValueCount = 0L;
    private long[] histogram;
    private double bucketSize;
    private OutlierHandlingMode outlierHandlingMode;
    private long count = 0L;
    private double max = Double.NEGATIVE_INFINITY;
    private double min = Double.POSITIVE_INFINITY;

    public FixedBucketsHistogram(double lowerLimit, double upperLimit, int numBuckets, OutlierHandlingMode outlierHandlingMode) {
        Preconditions.checkArgument((upperLimit > lowerLimit ? 1 : 0) != 0, (String)"Upper limit [%s] must be greater than lower limit [%s].", (Object)upperLimit, (Object)lowerLimit);
        Preconditions.checkArgument((numBuckets > 0 ? 1 : 0) != 0, (String)"numBuckets must be > 0, got [%s] instead.", (int)numBuckets);
        this.lowerLimit = lowerLimit;
        this.upperLimit = upperLimit;
        this.numBuckets = numBuckets;
        this.outlierHandlingMode = outlierHandlingMode;
        this.histogram = new long[numBuckets];
        this.bucketSize = (upperLimit - lowerLimit) / (double)numBuckets;
        this.readWriteLock = new ReentrantReadWriteLock(true);
        this.outlierHandler = this.makeOutlierHandler();
    }

    @VisibleForTesting
    protected FixedBucketsHistogram(double lowerLimit, double upperLimit, int numBuckets, OutlierHandlingMode outlierHandlingMode, long[] histogram, long count, double max, double min, long lowerOutlierCount, long upperOutlierCount, long missingValueCount) {
        this.lowerLimit = lowerLimit;
        this.upperLimit = upperLimit;
        this.numBuckets = numBuckets;
        this.outlierHandlingMode = outlierHandlingMode;
        this.histogram = histogram;
        this.count = count;
        this.max = max;
        this.min = min;
        this.upperOutlierCount = upperOutlierCount;
        this.lowerOutlierCount = lowerOutlierCount;
        this.missingValueCount = missingValueCount;
        this.bucketSize = (upperLimit - lowerLimit) / (double)numBuckets;
        this.readWriteLock = new ReentrantReadWriteLock(true);
        this.outlierHandler = this.makeOutlierHandler();
    }

    @VisibleForTesting
    public FixedBucketsHistogram getCopy() {
        return new FixedBucketsHistogram(this.lowerLimit, this.upperLimit, this.numBuckets, this.outlierHandlingMode, Arrays.copyOf(this.histogram, this.histogram.length), this.count, this.max, this.min, this.lowerOutlierCount, this.upperOutlierCount, this.missingValueCount);
    }

    @JsonProperty
    public double getLowerLimit() {
        return this.lowerLimit;
    }

    @JsonProperty
    public double getUpperLimit() {
        return this.upperLimit;
    }

    @JsonProperty
    public int getNumBuckets() {
        return this.numBuckets;
    }

    @JsonProperty
    public long getUpperOutlierCount() {
        return this.upperOutlierCount;
    }

    @JsonProperty
    public long getLowerOutlierCount() {
        return this.lowerOutlierCount;
    }

    @JsonProperty
    public long getMissingValueCount() {
        return this.missingValueCount;
    }

    @JsonProperty
    public long[] getHistogram() {
        return this.histogram;
    }

    @JsonProperty
    public double getBucketSize() {
        return this.bucketSize;
    }

    @JsonProperty
    public long getCount() {
        return this.count;
    }

    @JsonProperty
    public double getMax() {
        return this.max;
    }

    @JsonProperty
    public double getMin() {
        return this.min;
    }

    @JsonProperty
    public OutlierHandlingMode getOutlierHandlingMode() {
        return this.outlierHandlingMode;
    }

    public String toString() {
        return "{lowerLimit=" + this.lowerLimit + ", upperLimit=" + this.upperLimit + ", numBuckets=" + this.numBuckets + ", upperOutlierCount=" + this.upperOutlierCount + ", lowerOutlierCount=" + this.lowerOutlierCount + ", missingValueCount=" + this.missingValueCount + ", histogram=" + Arrays.toString(this.histogram) + ", outlierHandlingMode=" + String.valueOf((Object)this.outlierHandlingMode) + ", count=" + this.count + ", max=" + this.max + ", min=" + this.min + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FixedBucketsHistogram that = (FixedBucketsHistogram)o;
        return Double.compare(that.getLowerLimit(), this.getLowerLimit()) == 0 && Double.compare(that.getUpperLimit(), this.getUpperLimit()) == 0 && this.getNumBuckets() == that.getNumBuckets() && this.getUpperOutlierCount() == that.getUpperOutlierCount() && this.getLowerOutlierCount() == that.getLowerOutlierCount() && this.getMissingValueCount() == that.getMissingValueCount() && Double.compare(that.getBucketSize(), this.getBucketSize()) == 0 && this.getCount() == that.getCount() && Double.compare(that.getMax(), this.getMax()) == 0 && Double.compare(that.getMin(), this.getMin()) == 0 && Arrays.equals(this.getHistogram(), that.getHistogram()) && this.getOutlierHandlingMode() == that.getOutlierHandlingMode();
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.getLowerLimit(), this.getUpperLimit(), this.getNumBuckets(), this.getUpperOutlierCount(), this.getLowerOutlierCount(), this.getMissingValueCount(), Arrays.hashCode(this.getHistogram()), this.getBucketSize(), this.getOutlierHandlingMode(), this.getCount(), this.getMax(), this.getMin()});
    }

    public ReadWriteLock getReadWriteLock() {
        return this.readWriteLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(double value) {
        this.readWriteLock.writeLock().lock();
        try {
            double valueRelativeToRange;
            int targetBucket;
            if (value < this.lowerLimit) {
                this.outlierHandler.handleOutlierAdd(false);
                return;
            }
            if (value >= this.upperLimit) {
                this.outlierHandler.handleOutlierAdd(true);
                return;
            }
            ++this.count;
            if (value > this.max) {
                this.max = value;
            }
            if (value < this.min) {
                this.min = value;
            }
            if ((targetBucket = (int)((valueRelativeToRange = value - this.lowerLimit) / this.bucketSize)) >= this.histogram.length) {
                targetBucket = this.histogram.length - 1;
            }
            int n = targetBucket;
            this.histogram[n] = this.histogram[n] + 1L;
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
    }

    public void incrementMissing() {
        this.readWriteLock.writeLock().lock();
        try {
            ++this.missingValueCount;
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
    }

    @VisibleForTesting
    public void combine(@Nullable Object val) {
        if (val == null) {
            this.incrementMissing();
        } else if (val instanceof String) {
            this.combineHistogram(FixedBucketsHistogram.fromBase64((String)val));
        } else if (val instanceof FixedBucketsHistogram) {
            this.combineHistogram((FixedBucketsHistogram)val);
        } else if (val instanceof Number) {
            this.add(((Number)val).doubleValue());
        } else {
            throw new ISE("Unknown class for object: " + String.valueOf(val.getClass()), new Object[0]);
        }
    }

    public void combineHistogram(FixedBucketsHistogram otherHistogram) {
        if (otherHistogram == null) {
            return;
        }
        this.readWriteLock.writeLock().lock();
        otherHistogram.getReadWriteLock().readLock().lock();
        try {
            this.missingValueCount += otherHistogram.getMissingValueCount();
            if (this.bucketSize == otherHistogram.getBucketSize() && this.lowerLimit == otherHistogram.getLowerLimit() && this.upperLimit == otherHistogram.getUpperLimit()) {
                this.combineHistogramSameBuckets(otherHistogram);
            } else {
                this.combineHistogramDifferentBuckets(otherHistogram);
            }
        }
        finally {
            this.readWriteLock.writeLock().unlock();
            otherHistogram.getReadWriteLock().readLock().unlock();
        }
    }

    private void combineHistogramSameBuckets(FixedBucketsHistogram otherHistogram) {
        long[] otherHistogramArray = otherHistogram.getHistogram();
        for (int i = 0; i < this.numBuckets; ++i) {
            int n = i;
            this.histogram[n] = this.histogram[n] + otherHistogramArray[i];
        }
        this.count += otherHistogram.getCount();
        this.max = Math.max(this.max, otherHistogram.getMax());
        this.min = Math.min(this.min, otherHistogram.getMin());
        this.outlierHandler.handleOutliersForCombineSameBuckets(otherHistogram);
    }

    private void combineHistogramDifferentBuckets(FixedBucketsHistogram otherHistogram) {
        if (otherHistogram.getLowerLimit() >= this.upperLimit) {
            this.outlierHandler.handleOutliersCombineDifferentBucketsAllUpper(otherHistogram);
        } else if (otherHistogram.getUpperLimit() <= this.lowerLimit) {
            this.outlierHandler.handleOutliersCombineDifferentBucketsAllLower(otherHistogram);
        } else {
            this.simpleInterpolateMerge(otherHistogram);
        }
    }

    private double getCumulativeCount(double cutoff, boolean fromStart) {
        int cutoffBucket = (int)((cutoff - this.lowerLimit) / this.bucketSize);
        double count = 0.0;
        if (fromStart) {
            for (int i = 0; i <= cutoffBucket; ++i) {
                if (i == cutoffBucket) {
                    double bucketStart = (double)i * this.bucketSize + this.lowerLimit;
                    double partialCount = (cutoff - bucketStart) / this.bucketSize * (double)this.histogram[i];
                    count += partialCount;
                    continue;
                }
                count += (double)this.histogram[i];
            }
        } else {
            for (int i = cutoffBucket; i < this.histogram.length; ++i) {
                if (i == cutoffBucket) {
                    double bucketEnd = (double)(i + 1) * this.bucketSize + this.lowerLimit;
                    double partialCount = (bucketEnd - cutoff) / this.bucketSize * (double)this.histogram[i];
                    count += partialCount;
                    continue;
                }
                count += (double)this.histogram[i];
            }
        }
        return count;
    }

    private void simpleInterpolateMerge(FixedBucketsHistogram otherHistogram) {
        double rangeStart = Math.max(this.lowerLimit, otherHistogram.getLowerLimit());
        double rangeEnd = Math.min(this.upperLimit, otherHistogram.getUpperLimit());
        int myCurBucket = (int)((rangeStart - this.lowerLimit) / this.bucketSize);
        double myNextCursorBoundary = (double)(myCurBucket + 1) * this.bucketSize + this.lowerLimit;
        double myCursor = rangeStart;
        int theirCurBucket = (int)((rangeStart - otherHistogram.getLowerLimit()) / otherHistogram.getBucketSize());
        double theirNextCursorBoundary = (double)(theirCurBucket + 1) * otherHistogram.getBucketSize() + otherHistogram.getLowerLimit();
        double theirCursor = rangeStart;
        double intraBucketStride = otherHistogram.getBucketSize() / (double)otherHistogram.getHistogram()[theirCurBucket];
        myNextCursorBoundary = Math.min(myNextCursorBoundary, rangeEnd);
        theirNextCursorBoundary = Math.min(theirNextCursorBoundary, rangeEnd);
        this.outlierHandler.simpleInterpolateMergeHandleOutliers(otherHistogram, rangeStart, rangeEnd);
        double theirCurrentLowerBucketBoundary = (double)theirCurBucket * otherHistogram.getBucketSize() + otherHistogram.getLowerLimit();
        while (myCursor < rangeEnd) {
            double needToConsume = myNextCursorBoundary - myCursor;
            double canConsumeFromOtherBucket = theirNextCursorBoundary - theirCursor;
            double toConsume = Math.min(needToConsume, canConsumeFromOtherBucket);
            while (needToConsume > 0.0) {
                double fractional = toConsume / otherHistogram.getBucketSize();
                double fractionalCount = (double)otherHistogram.getHistogram()[theirCurBucket] * fractional;
                if (Math.round(fractionalCount) > 0L) {
                    double minStride = Math.ceil((theirCursor - ((double)theirCurBucket * otherHistogram.getBucketSize() + otherHistogram.getLowerLimit())) / intraBucketStride);
                    minStride *= intraBucketStride;
                    if ((minStride += theirCurrentLowerBucketBoundary) >= theirCursor) {
                        this.min = Math.min(minStride, this.min);
                        this.max = Math.max(minStride, this.max);
                    }
                    double maxStride = Math.floor((theirCursor + toConsume - ((double)theirCurBucket * otherHistogram.getBucketSize() + otherHistogram.getLowerLimit())) / intraBucketStride);
                    maxStride *= intraBucketStride;
                    if ((maxStride += theirCurrentLowerBucketBoundary) < theirCursor + toConsume) {
                        this.max = Math.max(maxStride, this.max);
                        this.min = Math.min(maxStride, this.min);
                    }
                }
                int n = myCurBucket;
                this.histogram[n] = this.histogram[n] + Math.round(fractionalCount);
                this.count += Math.round(fractionalCount);
                needToConsume -= toConsume;
                myCursor += toConsume;
                if ((theirCursor += toConsume) >= rangeEnd) break;
                if (theirCursor >= theirNextCursorBoundary) {
                    intraBucketStride = otherHistogram.getBucketSize() / (double)otherHistogram.getHistogram()[++theirCurBucket];
                    theirCurrentLowerBucketBoundary = (double)theirCurBucket * otherHistogram.getBucketSize() + otherHistogram.getLowerLimit();
                    theirNextCursorBoundary = (double)(theirCurBucket + 1) * otherHistogram.getBucketSize() + otherHistogram.getLowerLimit();
                    theirNextCursorBoundary = Math.min(theirNextCursorBoundary, rangeEnd);
                }
                canConsumeFromOtherBucket = theirNextCursorBoundary - theirCursor;
                toConsume = Math.min(needToConsume, canConsumeFromOtherBucket);
            }
            if (theirCursor >= rangeEnd) break;
            myNextCursorBoundary = (double)(++myCurBucket + 1) * this.bucketSize + this.lowerLimit;
            myNextCursorBoundary = Math.min(myNextCursorBoundary, rangeEnd);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float[] percentilesFloat(double[] pcts) {
        this.readWriteLock.readLock().lock();
        try {
            float[] results = new float[pcts.length];
            long total = this.count;
            int pctIdx = 0;
            long prev = 0L;
            double prevP = 0.0;
            double prevB = this.lowerLimit;
            for (int i = 0; i < this.numBuckets; ++i) {
                long next = prev + this.histogram[i];
                double nextP = 100.0 * (double)next / (double)total;
                double nextB = (double)(i + 1) * this.bucketSize + this.lowerLimit;
                while (pctIdx < pcts.length && nextP >= pcts[pctIdx]) {
                    double f = (pcts[pctIdx] - prevP) / (nextP - prevP);
                    results[pctIdx] = (float)(f * (nextB - prevB) + prevB);
                    ++pctIdx;
                }
                if (pctIdx >= pcts.length) break;
                prev = next;
                prevP = nextP;
                prevB = nextB;
            }
            float[] fArray = results;
            return fArray;
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }

    @JsonValue
    public String toBase64() {
        byte[] asBytes = this.toBytes();
        return StringUtils.fromUtf8((byte[])StringUtils.encodeBase64((byte[])asBytes));
    }

    public byte[] toBytes() {
        this.readWriteLock.readLock().lock();
        try {
            int nonEmptyBuckets = this.getNonEmptyBucketCount();
            if (nonEmptyBuckets < this.numBuckets / 2) {
                byte[] byArray = this.toBytesSparse(nonEmptyBuckets);
                return byArray;
            }
            byte[] byArray = this.toBytesFull(true);
            return byArray;
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }

    private void writeByteBufferSerdeHeader(ByteBuffer buf, byte mode) {
        buf.put((byte)1);
        buf.put(mode);
    }

    private void writeByteBufferCommonFields(ByteBuffer buf) {
        buf.putDouble(this.lowerLimit);
        buf.putDouble(this.upperLimit);
        buf.putInt(this.numBuckets);
        buf.put((byte)this.outlierHandlingMode.ordinal());
        buf.putLong(this.count);
        buf.putLong(this.lowerOutlierCount);
        buf.putLong(this.upperOutlierCount);
        buf.putLong(this.missingValueCount);
        buf.putDouble(this.max);
        buf.putDouble(this.min);
    }

    public byte[] toBytesFull(boolean withHeader) {
        int size = FixedBucketsHistogram.getFullStorageSize(this.numBuckets);
        if (withHeader) {
            size += 2;
        }
        ByteBuffer buf = ByteBuffer.allocate(size);
        this.writeByteBufferFull(buf, withHeader);
        return buf.array();
    }

    private void writeByteBufferFull(ByteBuffer buf, boolean withHeader) {
        if (withHeader) {
            this.writeByteBufferSerdeHeader(buf, (byte)1);
        }
        this.writeByteBufferCommonFields(buf);
        buf.asLongBuffer().put(this.histogram);
        buf.position(buf.position() + 8 * this.histogram.length);
    }

    public byte[] toBytesSparse(int nonEmptyBuckets) {
        int size = 2 + FixedBucketsHistogram.getSparseStorageSize(nonEmptyBuckets);
        ByteBuffer buf = ByteBuffer.allocate(size);
        this.writeByteBufferSparse(buf, nonEmptyBuckets);
        return buf.array();
    }

    public void writeByteBufferSparse(ByteBuffer buf, int nonEmptyBuckets) {
        this.writeByteBufferSerdeHeader(buf, (byte)2);
        this.writeByteBufferCommonFields(buf);
        buf.putInt(nonEmptyBuckets);
        int bucketsWritten = 0;
        for (int i = 0; i < this.numBuckets; ++i) {
            if (this.histogram[i] > 0L) {
                buf.putInt(i);
                buf.putLong(this.histogram[i]);
                ++bucketsWritten;
            }
            if (bucketsWritten == nonEmptyBuckets) break;
        }
    }

    public static FixedBucketsHistogram fromBase64(String encodedHistogram) {
        byte[] asBytes = StringUtils.decodeBase64((byte[])encodedHistogram.getBytes(StandardCharsets.UTF_8));
        return FixedBucketsHistogram.fromBytes(asBytes);
    }

    public static FixedBucketsHistogram fromBytes(byte[] bytes) {
        ByteBuffer buf = ByteBuffer.wrap(bytes);
        return FixedBucketsHistogram.fromByteBuffer(buf);
    }

    public static FixedBucketsHistogram fromByteBuffer(ByteBuffer buf) {
        byte serializationVersion = buf.get();
        Preconditions.checkArgument((serializationVersion == 1 ? 1 : 0) != 0, (Object)StringUtils.format((String)"Only serialization version %s is supported.", (Object[])new Object[]{(byte)1}));
        byte mode = buf.get();
        if (mode == 1) {
            return FixedBucketsHistogram.fromByteBufferFullNoSerdeHeader(buf);
        }
        if (mode == 2) {
            return FixedBucketsHistogram.fromBytesSparse(buf);
        }
        throw new ISE("Invalid histogram serde mode: %s", new Object[]{mode});
    }

    protected static FixedBucketsHistogram fromByteBufferFullNoSerdeHeader(ByteBuffer buf) {
        double lowerLimit = buf.getDouble();
        double upperLimit = buf.getDouble();
        int numBuckets = buf.getInt();
        OutlierHandlingMode outlierHandlingMode = OutlierHandlingMode.values()[buf.get()];
        long count = buf.getLong();
        long lowerOutlierCount = buf.getLong();
        long upperOutlierCount = buf.getLong();
        long missingValueCount = buf.getLong();
        double max = buf.getDouble();
        double min = buf.getDouble();
        long[] histogram = new long[numBuckets];
        buf.asLongBuffer().get(histogram);
        buf.position(buf.position() + 8 * histogram.length);
        return new FixedBucketsHistogram(lowerLimit, upperLimit, numBuckets, outlierHandlingMode, histogram, count, max, min, lowerOutlierCount, upperOutlierCount, missingValueCount);
    }

    private static FixedBucketsHistogram fromBytesSparse(ByteBuffer buf) {
        double lowerLimit = buf.getDouble();
        double upperLimit = buf.getDouble();
        int numBuckets = buf.getInt();
        OutlierHandlingMode outlierHandlingMode = OutlierHandlingMode.values()[buf.get()];
        long count = buf.getLong();
        long lowerOutlierCount = buf.getLong();
        long upperOutlierCount = buf.getLong();
        long missingValueCount = buf.getLong();
        double max = buf.getDouble();
        double min = buf.getDouble();
        int nonEmptyBuckets = buf.getInt();
        long[] histogram = new long[numBuckets];
        for (int i = 0; i < nonEmptyBuckets; ++i) {
            long bucketCount;
            int bucket = buf.getInt();
            histogram[bucket] = bucketCount = buf.getLong();
        }
        return new FixedBucketsHistogram(lowerLimit, upperLimit, numBuckets, outlierHandlingMode, histogram, count, max, min, lowerOutlierCount, upperOutlierCount, missingValueCount);
    }

    public static int getFullStorageSize(int numBuckets) {
        return 69 + 8 * numBuckets;
    }

    public static int getSparseStorageSize(int nonEmptyBuckets) {
        return 73 + 12 * nonEmptyBuckets;
    }

    @VisibleForTesting
    public int getNonEmptyBucketCount() {
        int count = 0;
        for (int i = 0; i < this.numBuckets; ++i) {
            if (this.histogram[i] == 0L) continue;
            ++count;
        }
        return count;
    }

    private OutlierHandler makeOutlierHandler() {
        switch (this.outlierHandlingMode) {
            case IGNORE: {
                return new IgnoreOutlierHandler();
            }
            case OVERFLOW: {
                return new OverflowOutlierHandler();
            }
            case CLIP: {
                return new ClipOutlierHandler();
            }
        }
        throw new ISE("Unknown outlier handling mode: %s", new Object[]{this.outlierHandlingMode});
    }

    public static enum OutlierHandlingMode {
        IGNORE,
        OVERFLOW,
        CLIP;


        @JsonValue
        public String toString() {
            return StringUtils.toLowerCase((String)this.name());
        }

        @JsonCreator
        public static OutlierHandlingMode fromString(String name) {
            return OutlierHandlingMode.valueOf(StringUtils.toUpperCase((String)name));
        }

        public byte[] getCacheKey() {
            return new byte[]{(byte)this.ordinal()};
        }
    }

    private static interface OutlierHandler {
        public void handleOutlierAdd(boolean var1);

        public void simpleInterpolateMergeHandleOutliers(FixedBucketsHistogram var1, double var2, double var4);

        public void handleOutliersForCombineSameBuckets(FixedBucketsHistogram var1);

        public void handleOutliersCombineDifferentBucketsAllUpper(FixedBucketsHistogram var1);

        public void handleOutliersCombineDifferentBucketsAllLower(FixedBucketsHistogram var1);
    }

    private static class IgnoreOutlierHandler
    implements OutlierHandler {
        private IgnoreOutlierHandler() {
        }

        @Override
        public void handleOutlierAdd(boolean exceededMax) {
        }

        @Override
        public void simpleInterpolateMergeHandleOutliers(FixedBucketsHistogram otherHistogram, double rangeStart, double rangeEnd) {
        }

        @Override
        public void handleOutliersForCombineSameBuckets(FixedBucketsHistogram otherHistogram) {
        }

        @Override
        public void handleOutliersCombineDifferentBucketsAllUpper(FixedBucketsHistogram otherHistogram) {
        }

        @Override
        public void handleOutliersCombineDifferentBucketsAllLower(FixedBucketsHistogram otherHistogram) {
        }
    }

    private class OverflowOutlierHandler
    implements OutlierHandler {
        private OverflowOutlierHandler() {
        }

        @Override
        public void handleOutlierAdd(boolean exceededMax) {
            if (exceededMax) {
                ++FixedBucketsHistogram.this.upperOutlierCount;
            } else {
                ++FixedBucketsHistogram.this.lowerOutlierCount;
            }
        }

        @Override
        public void simpleInterpolateMergeHandleOutliers(FixedBucketsHistogram otherHistogram, double rangeStart, double rangeEnd) {
            if (FixedBucketsHistogram.this.lowerLimit == rangeStart && FixedBucketsHistogram.this.upperLimit == rangeEnd) {
                long lowerCountFromOther = Math.round(otherHistogram.getCumulativeCount(rangeStart, true));
                long upperCountFromOther = Math.round(otherHistogram.getCumulativeCount(rangeEnd, false));
                FixedBucketsHistogram.this.upperOutlierCount += otherHistogram.getUpperOutlierCount() + upperCountFromOther;
                FixedBucketsHistogram.this.lowerOutlierCount += otherHistogram.getLowerOutlierCount() + lowerCountFromOther;
            } else if (rangeStart == FixedBucketsHistogram.this.lowerLimit) {
                long lowerCountFromOther = Math.round(otherHistogram.getCumulativeCount(rangeStart, true));
                FixedBucketsHistogram.this.lowerOutlierCount += lowerCountFromOther;
                FixedBucketsHistogram.this.lowerOutlierCount += otherHistogram.getLowerOutlierCount();
                FixedBucketsHistogram.this.upperOutlierCount += otherHistogram.getUpperOutlierCount();
            } else if (rangeEnd == FixedBucketsHistogram.this.upperLimit) {
                long upperCountFromOther = Math.round(otherHistogram.getCumulativeCount(rangeEnd, false));
                FixedBucketsHistogram.this.upperOutlierCount += upperCountFromOther;
                FixedBucketsHistogram.this.upperOutlierCount += otherHistogram.getUpperOutlierCount();
                FixedBucketsHistogram.this.lowerOutlierCount += otherHistogram.getLowerOutlierCount();
            } else if (rangeStart > FixedBucketsHistogram.this.lowerLimit && rangeEnd < FixedBucketsHistogram.this.upperLimit) {
                FixedBucketsHistogram.this.upperOutlierCount += otherHistogram.getUpperOutlierCount();
                FixedBucketsHistogram.this.lowerOutlierCount += otherHistogram.getLowerOutlierCount();
            }
        }

        @Override
        public void handleOutliersForCombineSameBuckets(FixedBucketsHistogram otherHistogram) {
            FixedBucketsHistogram.this.lowerOutlierCount += otherHistogram.getLowerOutlierCount();
            FixedBucketsHistogram.this.upperOutlierCount += otherHistogram.getUpperOutlierCount();
        }

        @Override
        public void handleOutliersCombineDifferentBucketsAllUpper(FixedBucketsHistogram otherHistogram) {
            FixedBucketsHistogram.this.upperOutlierCount += otherHistogram.getCount() + otherHistogram.getUpperOutlierCount();
        }

        @Override
        public void handleOutliersCombineDifferentBucketsAllLower(FixedBucketsHistogram otherHistogram) {
            FixedBucketsHistogram.this.lowerOutlierCount += otherHistogram.getCount() + otherHistogram.getLowerOutlierCount();
        }
    }

    private class ClipOutlierHandler
    implements OutlierHandler {
        private ClipOutlierHandler() {
        }

        @Override
        public void handleOutlierAdd(boolean exceededMax) {
            double clippedValue;
            ++FixedBucketsHistogram.this.count;
            if (exceededMax) {
                clippedValue = FixedBucketsHistogram.this.upperLimit;
                int n = FixedBucketsHistogram.this.histogram.length - 1;
                FixedBucketsHistogram.this.histogram[n] = FixedBucketsHistogram.this.histogram[n] + 1L;
            } else {
                clippedValue = FixedBucketsHistogram.this.lowerLimit;
                FixedBucketsHistogram.this.histogram[0] = FixedBucketsHistogram.this.histogram[0] + 1L;
            }
            if (clippedValue > FixedBucketsHistogram.this.max) {
                FixedBucketsHistogram.this.max = clippedValue;
            }
            if (clippedValue < FixedBucketsHistogram.this.min) {
                FixedBucketsHistogram.this.min = clippedValue;
            }
        }

        @Override
        public void simpleInterpolateMergeHandleOutliers(FixedBucketsHistogram otherHistogram, double rangeStart, double rangeEnd) {
            if (FixedBucketsHistogram.this.lowerLimit == rangeStart && FixedBucketsHistogram.this.upperLimit == rangeEnd) {
                long lowerCountFromOther = Math.round(otherHistogram.getCumulativeCount(rangeStart, true));
                long upperCountFromOther = Math.round(otherHistogram.getCumulativeCount(rangeEnd, false));
                int n = FixedBucketsHistogram.this.histogram.length - 1;
                FixedBucketsHistogram.this.histogram[n] = FixedBucketsHistogram.this.histogram[n] + (otherHistogram.getUpperOutlierCount() + upperCountFromOther);
                FixedBucketsHistogram.this.histogram[0] = FixedBucketsHistogram.this.histogram[0] + (otherHistogram.getLowerOutlierCount() + lowerCountFromOther);
                FixedBucketsHistogram.this.count += otherHistogram.getUpperOutlierCount() + otherHistogram.getLowerOutlierCount();
                FixedBucketsHistogram.this.count += upperCountFromOther + lowerCountFromOther;
                if (otherHistogram.getUpperOutlierCount() + upperCountFromOther > 0L) {
                    FixedBucketsHistogram.this.max = Math.max(FixedBucketsHistogram.this.max, FixedBucketsHistogram.this.upperLimit);
                }
                if (otherHistogram.getLowerOutlierCount() + lowerCountFromOther > 0L) {
                    FixedBucketsHistogram.this.min = Math.min(FixedBucketsHistogram.this.min, FixedBucketsHistogram.this.lowerLimit);
                }
            } else if (rangeStart == FixedBucketsHistogram.this.lowerLimit) {
                long lowerCountFromOther = Math.round(otherHistogram.getCumulativeCount(rangeStart, true));
                FixedBucketsHistogram.this.histogram[0] = FixedBucketsHistogram.this.histogram[0] + lowerCountFromOther;
                FixedBucketsHistogram.this.histogram[0] = FixedBucketsHistogram.this.histogram[0] + otherHistogram.getLowerOutlierCount();
                int n = FixedBucketsHistogram.this.histogram.length - 1;
                FixedBucketsHistogram.this.histogram[n] = FixedBucketsHistogram.this.histogram[n] + otherHistogram.getUpperOutlierCount();
                FixedBucketsHistogram.this.count += lowerCountFromOther + otherHistogram.getLowerOutlierCount() + otherHistogram.getUpperOutlierCount();
                if (lowerCountFromOther + otherHistogram.getLowerOutlierCount() > 0L) {
                    FixedBucketsHistogram.this.min = FixedBucketsHistogram.this.lowerLimit;
                }
                if (otherHistogram.getUpperOutlierCount() > 0L) {
                    FixedBucketsHistogram.this.max = FixedBucketsHistogram.this.upperLimit;
                }
            } else if (rangeEnd == FixedBucketsHistogram.this.upperLimit) {
                long upperCountFromOther = Math.round(otherHistogram.getCumulativeCount(rangeEnd, false));
                int n = FixedBucketsHistogram.this.histogram.length - 1;
                FixedBucketsHistogram.this.histogram[n] = FixedBucketsHistogram.this.histogram[n] + upperCountFromOther;
                int n2 = FixedBucketsHistogram.this.histogram.length - 1;
                FixedBucketsHistogram.this.histogram[n2] = FixedBucketsHistogram.this.histogram[n2] + otherHistogram.getUpperOutlierCount();
                FixedBucketsHistogram.this.histogram[0] = FixedBucketsHistogram.this.histogram[0] + otherHistogram.getLowerOutlierCount();
                FixedBucketsHistogram.this.count += upperCountFromOther + otherHistogram.getLowerOutlierCount() + otherHistogram.getUpperOutlierCount();
                if (upperCountFromOther + otherHistogram.getUpperOutlierCount() > 0L) {
                    FixedBucketsHistogram.this.max = FixedBucketsHistogram.this.upperLimit;
                }
                if (otherHistogram.getLowerOutlierCount() > 0L) {
                    FixedBucketsHistogram.this.min = FixedBucketsHistogram.this.lowerLimit;
                }
            } else if (rangeStart > FixedBucketsHistogram.this.lowerLimit && rangeEnd < FixedBucketsHistogram.this.upperLimit) {
                int n = FixedBucketsHistogram.this.histogram.length - 1;
                FixedBucketsHistogram.this.histogram[n] = FixedBucketsHistogram.this.histogram[n] + otherHistogram.getUpperOutlierCount();
                FixedBucketsHistogram.this.histogram[0] = FixedBucketsHistogram.this.histogram[0] + otherHistogram.getLowerOutlierCount();
                FixedBucketsHistogram.this.count += otherHistogram.getUpperOutlierCount() + otherHistogram.getLowerOutlierCount();
                if (otherHistogram.getUpperOutlierCount() > 0L) {
                    FixedBucketsHistogram.this.max = Math.max(FixedBucketsHistogram.this.max, FixedBucketsHistogram.this.upperLimit);
                } else if (otherHistogram.getCount() > 0L) {
                    FixedBucketsHistogram.this.max = Math.max(FixedBucketsHistogram.this.max, otherHistogram.getMax());
                }
                if (otherHistogram.getLowerOutlierCount() > 0L) {
                    FixedBucketsHistogram.this.min = Math.min(FixedBucketsHistogram.this.min, FixedBucketsHistogram.this.lowerLimit);
                } else if (otherHistogram.getCount() > 0L) {
                    FixedBucketsHistogram.this.min = Math.min(FixedBucketsHistogram.this.min, otherHistogram.getMin());
                }
            }
        }

        @Override
        public void handleOutliersForCombineSameBuckets(FixedBucketsHistogram otherHistogram) {
            if (otherHistogram.getLowerOutlierCount() > 0L) {
                FixedBucketsHistogram.this.histogram[0] = FixedBucketsHistogram.this.histogram[0] + otherHistogram.getLowerOutlierCount();
                FixedBucketsHistogram.this.count += otherHistogram.getLowerOutlierCount();
                FixedBucketsHistogram.this.min = Math.min(FixedBucketsHistogram.this.lowerLimit, FixedBucketsHistogram.this.min);
            }
            if (otherHistogram.getUpperOutlierCount() > 0L) {
                int n = FixedBucketsHistogram.this.histogram.length - 1;
                FixedBucketsHistogram.this.histogram[n] = FixedBucketsHistogram.this.histogram[n] + otherHistogram.getUpperOutlierCount();
                FixedBucketsHistogram.this.count += otherHistogram.getUpperOutlierCount();
                FixedBucketsHistogram.this.max = Math.max(FixedBucketsHistogram.this.upperLimit, FixedBucketsHistogram.this.max);
            }
        }

        @Override
        public void handleOutliersCombineDifferentBucketsAllUpper(FixedBucketsHistogram otherHistogram) {
            long otherCount = otherHistogram.getCount() + otherHistogram.getUpperOutlierCount();
            int n = FixedBucketsHistogram.this.histogram.length - 1;
            FixedBucketsHistogram.this.histogram[n] = FixedBucketsHistogram.this.histogram[n] + otherCount;
            FixedBucketsHistogram.this.count += otherCount;
            if (otherCount > 0L) {
                FixedBucketsHistogram.this.max = Math.max(FixedBucketsHistogram.this.max, FixedBucketsHistogram.this.upperLimit);
            }
        }

        @Override
        public void handleOutliersCombineDifferentBucketsAllLower(FixedBucketsHistogram otherHistogram) {
            long otherCount = otherHistogram.getCount() + otherHistogram.getLowerOutlierCount();
            FixedBucketsHistogram.this.histogram[0] = FixedBucketsHistogram.this.histogram[0] + otherCount;
            FixedBucketsHistogram.this.count += otherCount;
            if (otherCount > 0L) {
                FixedBucketsHistogram.this.min = Math.min(FixedBucketsHistogram.this.min, FixedBucketsHistogram.this.lowerLimit);
            }
        }
    }
}

