/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.security.basic.authorization.db.cache;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import com.google.inject.Injector;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.apache.druid.client.coordinator.Coordinator;
import org.apache.druid.concurrent.LifecycleLock;
import org.apache.druid.discovery.DruidLeaderClient;
import org.apache.druid.guice.ManageLifecycle;
import org.apache.druid.guice.annotations.Smile;
import org.apache.druid.java.util.common.FileUtils;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.RetryUtils;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.concurrent.Execs;
import org.apache.druid.java.util.common.concurrent.ScheduledExecutors;
import org.apache.druid.java.util.common.lifecycle.LifecycleStart;
import org.apache.druid.java.util.common.lifecycle.LifecycleStop;
import org.apache.druid.java.util.emitter.EmittingLogger;
import org.apache.druid.java.util.http.client.Request;
import org.apache.druid.java.util.http.client.response.BytesFullResponseHandler;
import org.apache.druid.java.util.http.client.response.BytesFullResponseHolder;
import org.apache.druid.java.util.http.client.response.HttpResponseHandler;
import org.apache.druid.security.basic.BasicAuthCommonCacheConfig;
import org.apache.druid.security.basic.BasicAuthUtils;
import org.apache.druid.security.basic.authorization.BasicRoleBasedAuthorizer;
import org.apache.druid.security.basic.authorization.db.cache.BasicAuthorizerCacheManager;
import org.apache.druid.security.basic.authorization.entity.BasicAuthorizerGroupMapping;
import org.apache.druid.security.basic.authorization.entity.BasicAuthorizerRole;
import org.apache.druid.security.basic.authorization.entity.BasicAuthorizerUser;
import org.apache.druid.security.basic.authorization.entity.GroupMappingAndRoleMap;
import org.apache.druid.security.basic.authorization.entity.UserAndRoleMap;
import org.apache.druid.server.security.Authorizer;
import org.apache.druid.server.security.AuthorizerMapper;
import org.jboss.netty.handler.codec.http.HttpMethod;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;
import org.joda.time.Duration;

@ManageLifecycle
public class CoordinatorPollingBasicAuthorizerCacheManager
implements BasicAuthorizerCacheManager {
    private static final EmittingLogger LOG = new EmittingLogger(CoordinatorPollingBasicAuthorizerCacheManager.class);
    private final ConcurrentHashMap<String, Map<String, BasicAuthorizerUser>> cachedUserMaps;
    private final ConcurrentHashMap<String, Map<String, BasicAuthorizerRole>> cachedRoleMaps;
    private final ConcurrentHashMap<String, Map<String, BasicAuthorizerGroupMapping>> cachedGroupMappingMaps;
    private final ConcurrentHashMap<String, Map<String, BasicAuthorizerRole>> cachedGroupMappingRoleMaps;
    private final Set<String> authorizerPrefixes;
    private final Injector injector;
    private final ObjectMapper objectMapper;
    private final LifecycleLock lifecycleLock = new LifecycleLock();
    private final DruidLeaderClient druidLeaderClient;
    private final BasicAuthCommonCacheConfig commonCacheConfig;
    private final ScheduledExecutorService exec = Execs.scheduledSingleThreaded((String)"CoordinatorPollingBasicAuthorizerCacheManager-Exec--%d");

    @Inject
    public CoordinatorPollingBasicAuthorizerCacheManager(Injector injector, BasicAuthCommonCacheConfig commonCacheConfig, @Smile ObjectMapper objectMapper, @Coordinator DruidLeaderClient druidLeaderClient) {
        this.injector = injector;
        this.commonCacheConfig = commonCacheConfig;
        this.objectMapper = objectMapper;
        this.cachedUserMaps = new ConcurrentHashMap();
        this.cachedRoleMaps = new ConcurrentHashMap();
        this.cachedGroupMappingMaps = new ConcurrentHashMap();
        this.cachedGroupMappingRoleMaps = new ConcurrentHashMap();
        this.authorizerPrefixes = new HashSet<String>();
        this.druidLeaderClient = druidLeaderClient;
    }

    @LifecycleStart
    public void start() {
        if (!this.lifecycleLock.canStart()) {
            throw new ISE("can't start.", new Object[0]);
        }
        LOG.info("Starting CoordinatorPollingBasicAuthorizerCacheManager.", new Object[0]);
        try {
            this.initUserMaps();
            ScheduledExecutors.scheduleWithFixedDelay((ScheduledExecutorService)this.exec, (Duration)new Duration(this.commonCacheConfig.getPollingPeriod()), (Duration)new Duration(this.commonCacheConfig.getPollingPeriod()), () -> {
                try {
                    long randomDelay = ThreadLocalRandom.current().nextLong(0L, this.commonCacheConfig.getMaxRandomDelay());
                    LOG.debug("Inserting random polling delay of [%s] ms", new Object[]{randomDelay});
                    Thread.sleep(randomDelay);
                    LOG.debug("Scheduled userMap cache poll is running", new Object[0]);
                    for (String authorizerPrefix : this.authorizerPrefixes) {
                        UserAndRoleMap userAndRoleMap = this.fetchUserAndRoleMapFromCoordinator(authorizerPrefix, false);
                        if (userAndRoleMap == null) continue;
                        this.cachedUserMaps.put(authorizerPrefix, userAndRoleMap.getUserMap());
                        this.cachedRoleMaps.put(authorizerPrefix, userAndRoleMap.getRoleMap());
                    }
                    LOG.debug("Scheduled userMap cache poll is done", new Object[0]);
                }
                catch (Throwable t) {
                    LOG.makeAlert(t, "Error occurred while polling for cachedUserMaps.", new Object[0]).emit();
                }
            });
            ScheduledExecutors.scheduleWithFixedDelay((ScheduledExecutorService)this.exec, (Duration)new Duration(this.commonCacheConfig.getPollingPeriod()), (Duration)new Duration(this.commonCacheConfig.getPollingPeriod()), () -> {
                try {
                    long randomDelay = ThreadLocalRandom.current().nextLong(0L, this.commonCacheConfig.getMaxRandomDelay());
                    LOG.debug("Inserting random polling delay of [%s] ms", new Object[]{randomDelay});
                    Thread.sleep(randomDelay);
                    LOG.debug("Scheduled groupMappingMap cache poll is running", new Object[0]);
                    for (String authorizerPrefix : this.authorizerPrefixes) {
                        GroupMappingAndRoleMap groupMappingAndRoleMap = this.fetchGroupAndRoleMapFromCoordinator(authorizerPrefix, false);
                        if (groupMappingAndRoleMap == null) continue;
                        this.cachedGroupMappingMaps.put(authorizerPrefix, groupMappingAndRoleMap.getGroupMappingMap());
                        this.cachedGroupMappingRoleMaps.put(authorizerPrefix, groupMappingAndRoleMap.getRoleMap());
                    }
                    LOG.debug("Scheduled groupMappingMap cache poll is done", new Object[0]);
                }
                catch (Throwable t) {
                    LOG.makeAlert(t, "Error occurred while polling for cachedGroupMappingMaps.", new Object[0]).emit();
                }
            });
            this.lifecycleLock.started();
            LOG.info("Started CoordinatorPollingBasicAuthorizerCacheManager.", new Object[0]);
        }
        finally {
            this.lifecycleLock.exitStart();
        }
    }

    @LifecycleStop
    public void stop() {
        if (!this.lifecycleLock.canStop()) {
            throw new ISE("can't stop.", new Object[0]);
        }
        LOG.info("CoordinatorPollingBasicAuthorizerCacheManager is stopping.", new Object[0]);
        this.exec.shutdown();
        LOG.info("CoordinatorPollingBasicAuthorizerCacheManager is stopped.", new Object[0]);
    }

    @Override
    public void handleAuthorizerUserUpdate(String authorizerPrefix, byte[] serializedUserAndRoleMap) {
        LOG.debug("Received userMap cache update for authorizer [%s].", new Object[]{authorizerPrefix});
        Preconditions.checkState((boolean)this.lifecycleLock.awaitStarted(1L, TimeUnit.MILLISECONDS));
        try {
            UserAndRoleMap userAndRoleMap = (UserAndRoleMap)this.objectMapper.readValue(serializedUserAndRoleMap, BasicAuthUtils.AUTHORIZER_USER_AND_ROLE_MAP_TYPE_REFERENCE);
            this.cachedUserMaps.put(authorizerPrefix, userAndRoleMap.getUserMap());
            this.cachedRoleMaps.put(authorizerPrefix, userAndRoleMap.getRoleMap());
            if (this.commonCacheConfig.getCacheDirectory() != null) {
                this.writeUserMapToDisk(authorizerPrefix, serializedUserAndRoleMap);
            }
        }
        catch (Exception e) {
            LOG.makeAlert((Throwable)e, "Could not deserialize user/role map received from coordinator", new Object[0]).emit();
        }
    }

    @Override
    public void handleAuthorizerGroupMappingUpdate(String authorizerPrefix, byte[] serializedGroupMappingAndRoleMap) {
        LOG.debug("Received groupMappingMap cache update for authorizer [%s].", new Object[]{authorizerPrefix});
        Preconditions.checkState((boolean)this.lifecycleLock.awaitStarted(1L, TimeUnit.MILLISECONDS));
        try {
            GroupMappingAndRoleMap groupMappingAndRoleMap = (GroupMappingAndRoleMap)this.objectMapper.readValue(serializedGroupMappingAndRoleMap, BasicAuthUtils.AUTHORIZER_GROUP_MAPPING_AND_ROLE_MAP_TYPE_REFERENCE);
            this.cachedGroupMappingMaps.put(authorizerPrefix, groupMappingAndRoleMap.getGroupMappingMap());
            this.cachedGroupMappingRoleMaps.put(authorizerPrefix, groupMappingAndRoleMap.getRoleMap());
            if (this.commonCacheConfig.getCacheDirectory() != null) {
                this.writeGroupMappingMapToDisk(authorizerPrefix, serializedGroupMappingAndRoleMap);
            }
        }
        catch (Exception e) {
            LOG.makeAlert((Throwable)e, "Could not deserialize groupMapping/role map received from coordinator.", new Object[0]).emit();
        }
    }

    @Override
    public Map<String, BasicAuthorizerUser> getUserMap(String authorizerPrefix) {
        return this.cachedUserMaps.get(authorizerPrefix);
    }

    @Override
    public Map<String, BasicAuthorizerRole> getRoleMap(String authorizerPrefix) {
        return this.cachedRoleMaps.get(authorizerPrefix);
    }

    @Override
    public Map<String, BasicAuthorizerGroupMapping> getGroupMappingMap(String authorizerPrefix) {
        return this.cachedGroupMappingMaps.get(authorizerPrefix);
    }

    @Override
    public Map<String, BasicAuthorizerRole> getGroupMappingRoleMap(String authorizerPrefix) {
        return this.cachedGroupMappingRoleMaps.get(authorizerPrefix);
    }

    private String getUserRoleMapFilename(String prefix) {
        return StringUtils.format((String)"%s.authorizer.userRole.cache", (Object[])new Object[]{prefix});
    }

    private String getGroupMappingRoleMapFilename(String prefix) {
        return StringUtils.format((String)"%s.authorizer.groupMappingRole.cache", (Object[])new Object[]{prefix});
    }

    @Nullable
    private UserAndRoleMap loadUserAndRoleMapFromDisk(String prefix) throws IOException {
        File userAndRoleMapFile = new File(this.commonCacheConfig.getCacheDirectory(), this.getUserRoleMapFilename(prefix));
        if (!userAndRoleMapFile.exists()) {
            return null;
        }
        return (UserAndRoleMap)this.objectMapper.readValue(userAndRoleMapFile, BasicAuthUtils.AUTHORIZER_USER_AND_ROLE_MAP_TYPE_REFERENCE);
    }

    @Nullable
    private GroupMappingAndRoleMap loadGroupMappingAndRoleMapFromDisk(String prefix) throws IOException {
        File groupMappingAndRoleMapFile = new File(this.commonCacheConfig.getCacheDirectory(), this.getGroupMappingRoleMapFilename(prefix));
        if (!groupMappingAndRoleMapFile.exists()) {
            return null;
        }
        return (GroupMappingAndRoleMap)this.objectMapper.readValue(groupMappingAndRoleMapFile, BasicAuthUtils.AUTHORIZER_GROUP_MAPPING_AND_ROLE_MAP_TYPE_REFERENCE);
    }

    private void writeUserMapToDisk(String prefix, byte[] userMapBytes) throws IOException {
        File cacheDir = new File(this.commonCacheConfig.getCacheDirectory());
        FileUtils.mkdirp((File)cacheDir);
        File userMapFile = new File(this.commonCacheConfig.getCacheDirectory(), this.getUserRoleMapFilename(prefix));
        FileUtils.writeAtomically((File)userMapFile, out -> {
            out.write(userMapBytes);
            return null;
        });
    }

    private void writeGroupMappingMapToDisk(String prefix, byte[] groupMappingBytes) throws IOException {
        File cacheDir = new File(this.commonCacheConfig.getCacheDirectory());
        FileUtils.mkdirp((File)cacheDir);
        File groupMapFile = new File(this.commonCacheConfig.getCacheDirectory(), this.getGroupMappingRoleMapFilename(prefix));
        FileUtils.writeAtomically((File)groupMapFile, out -> {
            out.write(groupMappingBytes);
            return null;
        });
    }

    @Nullable
    private UserAndRoleMap fetchUserAndRoleMapFromCoordinator(String prefix, boolean isInit) {
        try {
            return (UserAndRoleMap)RetryUtils.retry(() -> this.tryFetchUserMapsFromCoordinator(prefix), e -> true, (int)this.commonCacheConfig.getMaxSyncRetries());
        }
        catch (Exception e2) {
            LOG.makeAlert((Throwable)e2, "Encountered exception while fetching user and role map for authorizer [%s]", new Object[]{prefix}).emit();
            if (isInit && this.commonCacheConfig.getCacheDirectory() != null) {
                try {
                    LOG.info("Attempting to load user map snapshot from disk.", new Object[0]);
                    return this.loadUserAndRoleMapFromDisk(prefix);
                }
                catch (Exception e22) {
                    e22.addSuppressed(e2);
                    LOG.makeAlert((Throwable)e22, "Encountered exception while loading user-role map snapshot for authorizer [%s]", new Object[]{prefix}).emit();
                }
            }
            return null;
        }
    }

    @Nullable
    private GroupMappingAndRoleMap fetchGroupAndRoleMapFromCoordinator(String prefix, boolean isInit) {
        try {
            return (GroupMappingAndRoleMap)RetryUtils.retry(() -> this.tryFetchGroupMappingMapsFromCoordinator(prefix), e -> true, (int)this.commonCacheConfig.getMaxSyncRetries());
        }
        catch (Exception e2) {
            LOG.makeAlert((Throwable)e2, "Encountered exception while fetching group and role map for authorizer [%s]", new Object[]{prefix}).emit();
            if (isInit && this.commonCacheConfig.getCacheDirectory() != null) {
                try {
                    LOG.info("Attempting to load group map snapshot from disk.", new Object[0]);
                    return this.loadGroupMappingAndRoleMapFromDisk(prefix);
                }
                catch (Exception e22) {
                    e22.addSuppressed(e2);
                    LOG.makeAlert((Throwable)e22, "Encountered exception while loading group-role map snapshot for authorizer [%s]", new Object[]{prefix}).emit();
                }
            }
            return null;
        }
    }

    private UserAndRoleMap tryFetchUserMapsFromCoordinator(String prefix) throws Exception {
        Request req = this.druidLeaderClient.makeRequest(HttpMethod.GET, StringUtils.format((String)"/druid-ext/basic-security/authorization/db/%s/cachedSerializedUserMap", (Object[])new Object[]{prefix}));
        BytesFullResponseHolder responseHolder = (BytesFullResponseHolder)this.druidLeaderClient.go(req, (HttpResponseHandler)new BytesFullResponseHandler());
        byte[] userRoleMapBytes = responseHolder.getContent();
        UserAndRoleMap userAndRoleMap = (UserAndRoleMap)this.objectMapper.readValue(userRoleMapBytes, BasicAuthUtils.AUTHORIZER_USER_AND_ROLE_MAP_TYPE_REFERENCE);
        if (userAndRoleMap != null && this.commonCacheConfig.getCacheDirectory() != null) {
            this.writeUserMapToDisk(prefix, userRoleMapBytes);
        }
        return userAndRoleMap;
    }

    private GroupMappingAndRoleMap tryFetchGroupMappingMapsFromCoordinator(String prefix) throws Exception {
        byte[] groupRoleMapBytes;
        GroupMappingAndRoleMap groupMappingAndRoleMap;
        Request req = this.druidLeaderClient.makeRequest(HttpMethod.GET, StringUtils.format((String)"/druid-ext/basic-security/authorization/db/%s/cachedSerializedGroupMappingMap", (Object[])new Object[]{prefix}));
        BytesFullResponseHolder responseHolder = (BytesFullResponseHolder)this.druidLeaderClient.go(req, (HttpResponseHandler)new BytesFullResponseHandler());
        HttpResponseStatus status = responseHolder.getStatus();
        if (HttpResponseStatus.NOT_FOUND.equals((Object)status)) {
            LOG.warn("cachedSerializedGroupMappingMap is not available from the coordinator, skipping fetch of group mappings for now.", new Object[0]);
            return null;
        }
        if (!HttpResponseStatus.OK.equals((Object)status)) {
            LOG.warn("Got an unexpected response status[%s] when loading group mappings.", new Object[]{status});
        }
        if ((groupMappingAndRoleMap = (GroupMappingAndRoleMap)this.objectMapper.readValue(groupRoleMapBytes = responseHolder.getContent(), BasicAuthUtils.AUTHORIZER_GROUP_MAPPING_AND_ROLE_MAP_TYPE_REFERENCE)) != null && this.commonCacheConfig.getCacheDirectory() != null) {
            this.writeGroupMappingMapToDisk(prefix, groupRoleMapBytes);
        }
        return groupMappingAndRoleMap;
    }

    private void initUserMaps() {
        AuthorizerMapper authorizerMapper = (AuthorizerMapper)this.injector.getInstance(AuthorizerMapper.class);
        if (authorizerMapper == null || authorizerMapper.getAuthorizerMap() == null) {
            return;
        }
        for (Map.Entry entry : authorizerMapper.getAuthorizerMap().entrySet()) {
            GroupMappingAndRoleMap groupMappingAndRoleMap;
            Authorizer authorizer = (Authorizer)entry.getValue();
            if (!(authorizer instanceof BasicRoleBasedAuthorizer)) continue;
            String authorizerName = (String)entry.getKey();
            this.authorizerPrefixes.add(authorizerName);
            UserAndRoleMap userAndRoleMap = this.fetchUserAndRoleMapFromCoordinator(authorizerName, true);
            if (userAndRoleMap != null) {
                this.cachedUserMaps.put(authorizerName, userAndRoleMap.getUserMap());
                this.cachedRoleMaps.put(authorizerName, userAndRoleMap.getRoleMap());
            }
            if ((groupMappingAndRoleMap = this.fetchGroupAndRoleMapFromCoordinator(authorizerName, true)) == null) continue;
            this.cachedGroupMappingMaps.put(authorizerName, groupMappingAndRoleMap.getGroupMappingMap());
            this.cachedGroupMappingRoleMaps.put(authorizerName, groupMappingAndRoleMap.getRoleMap());
        }
    }
}

