/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.Request;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.AddIpamOperatingRegion;
import com.amazonaws.services.ec2.model.DryRunSupportedRequest;
import com.amazonaws.services.ec2.model.IpamTier;
import com.amazonaws.services.ec2.model.TagSpecification;
import com.amazonaws.services.ec2.model.transform.CreateIpamRequestMarshaller;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class CreateIpamRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable,
DryRunSupportedRequest<CreateIpamRequest> {
    private String description;
    private SdkInternalList<AddIpamOperatingRegion> operatingRegions;
    private SdkInternalList<TagSpecification> tagSpecifications;
    private String clientToken;
    private String tier;

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public CreateIpamRequest withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public List<AddIpamOperatingRegion> getOperatingRegions() {
        if (this.operatingRegions == null) {
            this.operatingRegions = new SdkInternalList();
        }
        return this.operatingRegions;
    }

    public void setOperatingRegions(Collection<AddIpamOperatingRegion> operatingRegions) {
        if (operatingRegions == null) {
            this.operatingRegions = null;
            return;
        }
        this.operatingRegions = new SdkInternalList(operatingRegions);
    }

    public CreateIpamRequest withOperatingRegions(AddIpamOperatingRegion ... operatingRegions) {
        if (this.operatingRegions == null) {
            this.setOperatingRegions((Collection<AddIpamOperatingRegion>)new SdkInternalList(operatingRegions.length));
        }
        for (AddIpamOperatingRegion ele : operatingRegions) {
            this.operatingRegions.add((Object)ele);
        }
        return this;
    }

    public CreateIpamRequest withOperatingRegions(Collection<AddIpamOperatingRegion> operatingRegions) {
        this.setOperatingRegions(operatingRegions);
        return this;
    }

    public List<TagSpecification> getTagSpecifications() {
        if (this.tagSpecifications == null) {
            this.tagSpecifications = new SdkInternalList();
        }
        return this.tagSpecifications;
    }

    public void setTagSpecifications(Collection<TagSpecification> tagSpecifications) {
        if (tagSpecifications == null) {
            this.tagSpecifications = null;
            return;
        }
        this.tagSpecifications = new SdkInternalList(tagSpecifications);
    }

    public CreateIpamRequest withTagSpecifications(TagSpecification ... tagSpecifications) {
        if (this.tagSpecifications == null) {
            this.setTagSpecifications((Collection<TagSpecification>)new SdkInternalList(tagSpecifications.length));
        }
        for (TagSpecification ele : tagSpecifications) {
            this.tagSpecifications.add((Object)ele);
        }
        return this;
    }

    public CreateIpamRequest withTagSpecifications(Collection<TagSpecification> tagSpecifications) {
        this.setTagSpecifications(tagSpecifications);
        return this;
    }

    public void setClientToken(String clientToken) {
        this.clientToken = clientToken;
    }

    public String getClientToken() {
        return this.clientToken;
    }

    public CreateIpamRequest withClientToken(String clientToken) {
        this.setClientToken(clientToken);
        return this;
    }

    public void setTier(String tier) {
        this.tier = tier;
    }

    public String getTier() {
        return this.tier;
    }

    public CreateIpamRequest withTier(String tier) {
        this.setTier(tier);
        return this;
    }

    public CreateIpamRequest withTier(IpamTier tier) {
        this.tier = tier.toString();
        return this;
    }

    @Override
    public Request<CreateIpamRequest> getDryRunRequest() {
        Request<CreateIpamRequest> request = new CreateIpamRequestMarshaller().marshall(this);
        request.addParameter("DryRun", Boolean.toString(true));
        return request;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription()).append(",");
        }
        if (this.getOperatingRegions() != null) {
            sb.append("OperatingRegions: ").append(this.getOperatingRegions()).append(",");
        }
        if (this.getTagSpecifications() != null) {
            sb.append("TagSpecifications: ").append(this.getTagSpecifications()).append(",");
        }
        if (this.getClientToken() != null) {
            sb.append("ClientToken: ").append(this.getClientToken()).append(",");
        }
        if (this.getTier() != null) {
            sb.append("Tier: ").append(this.getTier());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateIpamRequest)) {
            return false;
        }
        CreateIpamRequest other = (CreateIpamRequest)obj;
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getOperatingRegions() == null ^ this.getOperatingRegions() == null) {
            return false;
        }
        if (other.getOperatingRegions() != null && !other.getOperatingRegions().equals(this.getOperatingRegions())) {
            return false;
        }
        if (other.getTagSpecifications() == null ^ this.getTagSpecifications() == null) {
            return false;
        }
        if (other.getTagSpecifications() != null && !other.getTagSpecifications().equals(this.getTagSpecifications())) {
            return false;
        }
        if (other.getClientToken() == null ^ this.getClientToken() == null) {
            return false;
        }
        if (other.getClientToken() != null && !other.getClientToken().equals(this.getClientToken())) {
            return false;
        }
        if (other.getTier() == null ^ this.getTier() == null) {
            return false;
        }
        return other.getTier() == null || other.getTier().equals(this.getTier());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getOperatingRegions() == null ? 0 : this.getOperatingRegions().hashCode());
        hashCode = 31 * hashCode + (this.getTagSpecifications() == null ? 0 : this.getTagSpecifications().hashCode());
        hashCode = 31 * hashCode + (this.getClientToken() == null ? 0 : this.getClientToken().hashCode());
        hashCode = 31 * hashCode + (this.getTier() == null ? 0 : this.getTier().hashCode());
        return hashCode;
    }

    public CreateIpamRequest clone() {
        return (CreateIpamRequest)super.clone();
    }
}

