/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.collections.bitmap;

import com.google.common.annotations.VisibleForTesting;
import it.unimi.dsi.fastutil.ints.IntIterators;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import java.nio.ByteBuffer;
import java.util.Arrays;
import javax.annotation.Nullable;
import org.apache.druid.collections.bitmap.ImmutableBitmap;
import org.apache.druid.collections.bitmap.MutableBitmap;
import org.apache.druid.collections.bitmap.PeekableIteratorAdapter;
import org.apache.druid.collections.bitmap.WrappedImmutableRoaringBitmap;
import org.apache.druid.extendedset.intset.EmptyIntIterator;
import org.roaringbitmap.IntIterator;
import org.roaringbitmap.PeekableIntIterator;
import org.roaringbitmap.RoaringBitmapWriter;
import org.roaringbitmap.buffer.ImmutableRoaringBitmap;
import org.roaringbitmap.buffer.MutableRoaringBitmap;

public class WrappedRoaringBitmap
implements MutableBitmap {
    private static final int ARRAY_SIZE = 4;
    private static final int NOT_SET = -1;
    @Nullable
    private RoaringBitmapWriter<MutableRoaringBitmap> writer;
    @Nullable
    private int[] smallArray;

    @VisibleForTesting
    public ImmutableBitmap toImmutableBitmap() {
        this.initializeWriterIfNeeded();
        MutableRoaringBitmap bitmap = ((MutableRoaringBitmap)this.writer.get()).clone();
        bitmap.runOptimize();
        return new WrappedImmutableRoaringBitmap(bitmap.toImmutableRoaringBitmap());
    }

    @Override
    public byte[] toBytes() {
        this.initializeWriterIfNeeded();
        try {
            MutableRoaringBitmap bitmap = (MutableRoaringBitmap)this.writer.get();
            bitmap.runOptimize();
            ByteBuffer buffer = ByteBuffer.allocate(bitmap.serializedSizeInBytes());
            bitmap.serialize(buffer);
            return buffer.array();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void clear() {
        this.writer = null;
        this.smallArray = null;
    }

    @Override
    public void or(MutableBitmap mutableBitmap) {
        this.initializeWriterIfNeeded();
        WrappedRoaringBitmap other = (WrappedRoaringBitmap)mutableBitmap;
        other.initializeWriterIfNeeded();
        MutableRoaringBitmap unwrappedOtherBitmap = (MutableRoaringBitmap)other.writer.get();
        ((MutableRoaringBitmap)this.writer.get()).or((ImmutableRoaringBitmap)unwrappedOtherBitmap);
    }

    @Override
    public int getSizeInBytes() {
        this.initializeWriterIfNeeded();
        MutableRoaringBitmap bitmap = (MutableRoaringBitmap)this.writer.get();
        bitmap.runOptimize();
        return bitmap.serializedSizeInBytes();
    }

    @Override
    public void add(int entry) {
        if (entry < 0) {
            throw new IllegalArgumentException("Cannot add negative ints");
        }
        if (this.writer != null) {
            this.writer.add(entry);
        } else {
            if (this.smallArray == null) {
                this.smallArray = new int[4];
                Arrays.fill(this.smallArray, -1);
            }
            for (int i = 0; i < this.smallArray.length; ++i) {
                if (this.smallArray[i] != -1) continue;
                if (i > 0 && entry <= this.smallArray[i - 1]) break;
                this.smallArray[i] = entry;
                return;
            }
            this.initializeWriterIfNeeded();
            this.smallArray = null;
            this.writer.add(entry);
        }
    }

    @Override
    public int size() {
        if (this.writer != null) {
            return ((MutableRoaringBitmap)this.writer.get()).getCardinality();
        }
        if (this.smallArray != null) {
            for (int i = 0; i < this.smallArray.length; ++i) {
                if (this.smallArray[i] != -1) continue;
                return i;
            }
            return 4;
        }
        return 0;
    }

    public void serialize(ByteBuffer buffer) {
        this.initializeWriterIfNeeded();
        MutableRoaringBitmap bitmap = (MutableRoaringBitmap)this.writer.get();
        bitmap.runOptimize();
        bitmap.serialize(buffer);
    }

    public String toString() {
        if (this.writer != null) {
            return this.getClass().getSimpleName() + String.valueOf(this.writer.getUnderlying());
        }
        if (this.smallArray != null) {
            return this.getClass().getSimpleName() + Arrays.toString(this.smallArray);
        }
        return this.getClass().getSimpleName() + "[]";
    }

    @Override
    public void remove(int entry) {
        this.initializeWriterIfNeeded();
        ((MutableRoaringBitmap)this.writer.get()).remove(entry);
    }

    @Override
    public IntIterator iterator() {
        if (this.writer != null) {
            return ((MutableRoaringBitmap)this.writer.get()).getIntIterator();
        }
        if (this.smallArray != null) {
            int sz = this.size();
            class SmallArrayIterator
            implements IntIterator {
                private final IntListIterator iterator;
                final /* synthetic */ int val$sz;

                public SmallArrayIterator(IntListIterator iterator) {
                    this.val$sz = n;
                    this.iterator = iterator;
                }

                public IntIterator clone() {
                    return new SmallArrayIterator(IntIterators.wrap((int[])WrappedRoaringBitmap.this.smallArray, (int)0, (int)this.val$sz));
                }

                public boolean hasNext() {
                    return this.iterator.hasNext();
                }

                public int next() {
                    return this.iterator.nextInt();
                }
            }
            return new SmallArrayIterator(IntIterators.wrap((int[])this.smallArray, (int)0, (int)sz));
        }
        return EmptyIntIterator.instance();
    }

    @Override
    public PeekableIntIterator peekableIterator() {
        if (this.writer != null) {
            return ((MutableRoaringBitmap)this.writer.get()).getIntIterator();
        }
        return new PeekableIteratorAdapter<IntIterator>(this.iterator());
    }

    @Override
    public boolean isEmpty() {
        if (this.writer != null) {
            return ((MutableRoaringBitmap)this.writer.get()).isEmpty();
        }
        return this.smallArray == null;
    }

    @Override
    public ImmutableBitmap intersection(ImmutableBitmap otherBitmap) {
        this.initializeWriterIfNeeded();
        WrappedRoaringBitmap other = (WrappedRoaringBitmap)otherBitmap;
        other.initializeWriterIfNeeded();
        MutableRoaringBitmap unwrappedOtherBitmap = (MutableRoaringBitmap)other.writer.get();
        return new WrappedImmutableRoaringBitmap((ImmutableRoaringBitmap)MutableRoaringBitmap.and((MutableRoaringBitmap)((MutableRoaringBitmap)this.writer.get()), (MutableRoaringBitmap)unwrappedOtherBitmap));
    }

    @Override
    public ImmutableBitmap union(ImmutableBitmap otherBitmap) {
        this.initializeWriterIfNeeded();
        WrappedRoaringBitmap other = (WrappedRoaringBitmap)otherBitmap;
        other.initializeWriterIfNeeded();
        MutableRoaringBitmap unwrappedOtherBitmap = (MutableRoaringBitmap)other.writer.get();
        return new WrappedImmutableRoaringBitmap((ImmutableRoaringBitmap)MutableRoaringBitmap.or((MutableRoaringBitmap)((MutableRoaringBitmap)this.writer.get()), (MutableRoaringBitmap)unwrappedOtherBitmap));
    }

    @Override
    public boolean get(int value) {
        if (value < 0) {
            return false;
        }
        if (this.writer != null) {
            return ((MutableRoaringBitmap)this.writer.get()).contains(value);
        }
        if (this.smallArray != null) {
            for (int i : this.smallArray) {
                if (i != value) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    private void initializeWriterIfNeeded() {
        if (this.writer == null) {
            this.writer = RoaringBitmapWriter.bufferWriter().get();
            if (this.smallArray != null) {
                for (int i : this.smallArray) {
                    if (i == -1) continue;
                    this.writer.add(i);
                }
                this.smallArray = null;
            }
        }
    }
}

