/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexer.report;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.druid.indexer.IngestionState;
import org.apache.druid.indexer.report.TaskReport;

public class IngestionStatsAndErrors {
    private final IngestionState ingestionState;
    private final Map<String, Object> unparseableEvents;
    private final Map<String, Object> rowStats;
    private final String errorMsg;
    private final boolean segmentAvailabilityConfirmed;
    private final long segmentAvailabilityWaitTimeMs;
    private final Map<String, Long> recordsProcessed;
    private final Long segmentsRead;
    private final Long segmentsPublished;

    public IngestionStatsAndErrors(@JsonProperty(value="ingestionState") IngestionState ingestionState, @JsonProperty(value="unparseableEvents") Map<String, Object> unparseableEvents, @JsonProperty(value="rowStats") Map<String, Object> rowStats, @JsonProperty(value="errorMsg") @Nullable String errorMsg, @JsonProperty(value="segmentAvailabilityConfirmed") boolean segmentAvailabilityConfirmed, @JsonProperty(value="segmentAvailabilityWaitTimeMs") long segmentAvailabilityWaitTimeMs, @JsonProperty(value="recordsProcessed") Map<String, Long> recordsProcessed, @Nullable @JsonProperty(value="segmentsRead") Long segmentsRead, @Nullable @JsonProperty(value="segmentsPublished") Long segmentsPublished) {
        this.ingestionState = ingestionState;
        this.unparseableEvents = unparseableEvents;
        this.rowStats = rowStats;
        this.errorMsg = errorMsg;
        this.segmentAvailabilityConfirmed = segmentAvailabilityConfirmed;
        this.segmentAvailabilityWaitTimeMs = segmentAvailabilityWaitTimeMs;
        this.recordsProcessed = recordsProcessed;
        this.segmentsRead = segmentsRead;
        this.segmentsPublished = segmentsPublished;
    }

    @JsonProperty
    public IngestionState getIngestionState() {
        return this.ingestionState;
    }

    @JsonProperty
    public Map<String, Object> getUnparseableEvents() {
        return this.unparseableEvents;
    }

    @JsonProperty
    public Map<String, Object> getRowStats() {
        return this.rowStats;
    }

    @JsonProperty
    @Nullable
    public String getErrorMsg() {
        return this.errorMsg;
    }

    @JsonProperty
    public boolean isSegmentAvailabilityConfirmed() {
        return this.segmentAvailabilityConfirmed;
    }

    @JsonProperty
    public long getSegmentAvailabilityWaitTimeMs() {
        return this.segmentAvailabilityWaitTimeMs;
    }

    @JsonProperty
    @Nullable
    public Map<String, Long> getRecordsProcessed() {
        return this.recordsProcessed;
    }

    @JsonProperty
    @Nullable
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Long getSegmentsRead() {
        return this.segmentsRead;
    }

    @JsonProperty
    @Nullable
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Long getSegmentsPublished() {
        return this.segmentsPublished;
    }

    public static IngestionStatsAndErrors getPayloadFromTaskReports(Map<String, TaskReport> taskReports) {
        return (IngestionStatsAndErrors)taskReports.get("ingestionStatsAndErrors").getPayload();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IngestionStatsAndErrors that = (IngestionStatsAndErrors)o;
        return this.getIngestionState() == that.getIngestionState() && Objects.equals(this.getUnparseableEvents(), that.getUnparseableEvents()) && Objects.equals(this.getRowStats(), that.getRowStats()) && Objects.equals(this.getErrorMsg(), that.getErrorMsg()) && Objects.equals(this.isSegmentAvailabilityConfirmed(), that.isSegmentAvailabilityConfirmed()) && Objects.equals(this.getSegmentAvailabilityWaitTimeMs(), that.getSegmentAvailabilityWaitTimeMs()) && Objects.equals(this.getRecordsProcessed(), that.getRecordsProcessed()) && Objects.equals(this.getSegmentsRead(), that.getSegmentsRead()) && Objects.equals(this.getSegmentsPublished(), that.getSegmentsPublished());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.getIngestionState(), this.getUnparseableEvents(), this.getRowStats(), this.getErrorMsg(), this.isSegmentAvailabilityConfirmed(), this.getSegmentAvailabilityWaitTimeMs(), this.getRecordsProcessed(), this.getSegmentsRead(), this.getSegmentsPublished()});
    }

    public String toString() {
        return "IngestionStatsAndErrorsTaskReportData{ingestionState=" + String.valueOf((Object)this.ingestionState) + ", unparseableEvents=" + String.valueOf(this.unparseableEvents) + ", rowStats=" + String.valueOf(this.rowStats) + ", errorMsg='" + this.errorMsg + "', segmentAvailabilityConfoirmed=" + this.segmentAvailabilityConfirmed + ", segmentAvailabilityWaitTimeMs=" + this.segmentAvailabilityWaitTimeMs + ", recordsProcessed=" + String.valueOf(this.recordsProcessed) + ", segmentsRead=" + this.segmentsRead + ", segmentsPublished=" + this.segmentsPublished + "}";
    }
}

