/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexer.report;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import org.apache.druid.indexer.report.TaskReport;

public class KillTaskReport
implements TaskReport {
    public static final String REPORT_KEY = "killUnusedSegments";
    private final String taskId;
    private final Stats stats;

    @JsonCreator
    public KillTaskReport(@JsonProperty(value="taskId") String taskId, @JsonProperty(value="payload") Stats stats) {
        this.taskId = taskId;
        this.stats = stats;
    }

    @Override
    @JsonProperty
    public String getTaskId() {
        return this.taskId;
    }

    @Override
    public String getReportKey() {
        return REPORT_KEY;
    }

    @Override
    @JsonProperty
    public Object getPayload() {
        return this.stats;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KillTaskReport that = (KillTaskReport)o;
        return Objects.equals(this.taskId, that.taskId) && Objects.equals(this.stats, that.stats);
    }

    public int hashCode() {
        return Objects.hash(this.taskId, this.stats);
    }

    public static class Stats {
        private final int numSegmentsKilled;
        private final int numBatchesProcessed;

        @JsonCreator
        public Stats(@JsonProperty(value="numSegmentsKilled") int numSegmentsKilled, @JsonProperty(value="numBatchesProcessed") int numBatchesProcessed) {
            this.numSegmentsKilled = numSegmentsKilled;
            this.numBatchesProcessed = numBatchesProcessed;
        }

        @JsonProperty
        public int getNumSegmentsKilled() {
            return this.numSegmentsKilled;
        }

        @JsonProperty
        public int getNumBatchesProcessed() {
            return this.numBatchesProcessed;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Stats that = (Stats)o;
            return this.numSegmentsKilled == that.numSegmentsKilled && this.numBatchesProcessed == that.numBatchesProcessed;
        }

        public int hashCode() {
            return Objects.hash(this.numSegmentsKilled, this.numBatchesProcessed);
        }

        public String toString() {
            return "Stats{numSegmentsKilled=" + this.numSegmentsKilled + ", numBatchesProcessed=" + this.numBatchesProcessed + "}";
        }
    }
}

