/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.math.expr;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.druid.math.expr.Expr;
import org.apache.druid.math.expr.ExpressionType;
import org.apache.druid.math.expr.InputBindings;

public class SettableObjectBinding
implements Expr.ObjectBinding {
    private final Map<String, Object> bindings;
    private Expr.InputBindingInspector inspector = InputBindings.nilBindings();

    public SettableObjectBinding() {
        this.bindings = new HashMap<String, Object>();
    }

    public SettableObjectBinding(int expectedSize) {
        this.bindings = Maps.newHashMapWithExpectedSize((int)expectedSize);
    }

    @Override
    @Nullable
    public Object get(String name) {
        return this.bindings.get(name);
    }

    @Override
    @Nullable
    public ExpressionType getType(String name) {
        return this.inspector.getType(name);
    }

    public SettableObjectBinding withBinding(String name, @Nullable Object value) {
        this.bindings.put(name, value);
        return this;
    }

    public SettableObjectBinding withInspector(Expr.InputBindingInspector inspector) {
        this.inspector = inspector;
        return this;
    }

    @VisibleForTesting
    public Map<String, Object> asMap() {
        return this.bindings;
    }
}

