/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query;

import com.google.inject.Inject;
import java.util.IdentityHashMap;
import java.util.Map;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryToolChest;
import org.apache.druid.query.QueryToolChestWarehouse;

public class MapQueryToolChestWarehouse
implements QueryToolChestWarehouse {
    private final Map<Class<? extends Query>, QueryToolChest> toolchests;

    @Inject
    public MapQueryToolChestWarehouse(Map<Class<? extends Query>, QueryToolChest> toolchests) {
        this.toolchests = new IdentityHashMap<Class<? extends Query>, QueryToolChest>(toolchests);
    }

    @Override
    public <T, QueryType extends Query<T>> QueryToolChest<T, QueryType> getToolChest(QueryType query) {
        return this.toolchests.get(query.getClass());
    }
}

