/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation;

import com.google.common.base.Supplier;
import it.unimi.dsi.fastutil.Hash;
import java.nio.ByteBuffer;
import java.util.Comparator;
import javax.annotation.Nullable;
import org.apache.druid.collections.SerializablePair;
import org.apache.druid.data.input.InputRow;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.query.aggregation.SerializablePairLongString;
import org.apache.druid.query.aggregation.SerializablePairLongStringColumnSerializer;
import org.apache.druid.query.aggregation.SerializablePairLongStringComplexColumn;
import org.apache.druid.query.aggregation.SerializablePairLongStringSimpleStagedSerde;
import org.apache.druid.segment.GenericColumnSerializer;
import org.apache.druid.segment.IndexSpec;
import org.apache.druid.segment.column.ColumnBuilder;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.ComplexColumn;
import org.apache.druid.segment.column.ObjectStrategyComplexTypeStrategy;
import org.apache.druid.segment.column.TypeStrategy;
import org.apache.druid.segment.data.GenericIndexed;
import org.apache.druid.segment.data.ObjectStrategy;
import org.apache.druid.segment.serde.ComplexColumnPartSupplier;
import org.apache.druid.segment.serde.ComplexMetricExtractor;
import org.apache.druid.segment.serde.ComplexMetricSerde;
import org.apache.druid.segment.serde.LargeColumnSupportedComplexColumnSerializer;
import org.apache.druid.segment.serde.cell.NativeClearedByteBufferProvider;
import org.apache.druid.segment.writeout.SegmentWriteOutMedium;

public class SerializablePairLongStringComplexMetricSerde
extends ComplexMetricSerde {
    private static final boolean COMPRESSION_ENABLED = Boolean.parseBoolean(System.getProperty("druid.columns.pairLongString.compressed", "false"));
    public static final int EXPECTED_VERSION = 3;
    public static final String TYPE_NAME = "serializablePairLongString";
    private static final Comparator<SerializablePairLongString> COMPARATOR = Comparator.nullsFirst(Comparator.comparingLong(SerializablePair::getLhs).thenComparing(SerializablePair::getRhs, Comparator.nullsFirst(Comparator.naturalOrder())));
    private static final SerializablePairLongStringSimpleStagedSerde SERDE = new SerializablePairLongStringSimpleStagedSerde();
    private final boolean compressionEnabled;
    private static final ObjectStrategy<SerializablePairLongString> LEGACY_STRATEGY = new ObjectStrategy<SerializablePairLongString>(){

        @Override
        public int compare(@Nullable SerializablePairLongString o1, @Nullable SerializablePairLongString o2) {
            return COMPARATOR.compare(o1, o2);
        }

        @Override
        public Class<? extends SerializablePairLongString> getClazz() {
            return SerializablePairLongString.class;
        }

        @Override
        public SerializablePairLongString fromByteBuffer(ByteBuffer buffer, int numBytes) {
            ByteBuffer readOnlyBuffer = buffer.asReadOnlyBuffer();
            long lhs = readOnlyBuffer.getLong();
            int stringSize = readOnlyBuffer.getInt();
            String lastString = null;
            if (stringSize > 0) {
                byte[] stringBytes = new byte[stringSize];
                readOnlyBuffer.get(stringBytes, 0, stringSize);
                lastString = StringUtils.fromUtf8(stringBytes);
            }
            return new SerializablePairLongString(lhs, lastString);
        }

        @Override
        public byte[] toBytes(SerializablePairLongString val) {
            ByteBuffer bbuf;
            String rhsString = (String)val.rhs;
            if (rhsString != null) {
                byte[] rhsBytes = StringUtils.toUtf8(rhsString);
                bbuf = ByteBuffer.allocate(12 + rhsBytes.length);
                bbuf.putLong((Long)val.lhs);
                bbuf.putInt(8, rhsBytes.length);
                bbuf.position(12);
                bbuf.put(rhsBytes);
            } else {
                bbuf = ByteBuffer.allocate(12);
                bbuf.putLong((Long)val.lhs);
                bbuf.putInt(8, 0);
            }
            return bbuf.array();
        }

        @Override
        public boolean readRetainsBufferReference() {
            return false;
        }
    };

    public SerializablePairLongStringComplexMetricSerde() {
        this(COMPRESSION_ENABLED);
    }

    public SerializablePairLongStringComplexMetricSerde(boolean compressionEnabled) {
        this.compressionEnabled = compressionEnabled;
    }

    @Override
    public String getTypeName() {
        return TYPE_NAME;
    }

    @Override
    public ComplexMetricExtractor<?> getExtractor() {
        return new ComplexMetricExtractor<Object>(){

            @Override
            public Class<SerializablePairLongString> extractedClass() {
                return SerializablePairLongString.class;
            }

            @Override
            public Object extractValue(InputRow inputRow, String metricName) {
                return inputRow.getRaw(metricName);
            }
        };
    }

    @Override
    public void deserializeColumn(ByteBuffer buffer, ColumnBuilder columnBuilder) {
        byte version = buffer.get(buffer.position());
        if (version == 0 || version == 1 || version == 2) {
            GenericIndexed<SerializablePairLongString> column = GenericIndexed.read(buffer, LEGACY_STRATEGY, columnBuilder.getFileMapper());
            columnBuilder.setComplexColumnSupplier(new ComplexColumnPartSupplier(this.getTypeName(), column));
        } else {
            SerializablePairLongStringComplexColumn.Builder builder = new SerializablePairLongStringComplexColumn.Builder(buffer).setByteBufferProvider(NativeClearedByteBufferProvider.INSTANCE);
            columnBuilder.setComplexColumnSupplier((Supplier<? extends ComplexColumn>)((Supplier)builder::build));
        }
    }

    @Override
    public ObjectStrategy<SerializablePairLongString> getObjectStrategy() {
        return new ObjectStrategy<SerializablePairLongString>(){

            @Override
            public int compare(@Nullable SerializablePairLongString o1, @Nullable SerializablePairLongString o2) {
                return COMPARATOR.compare(o1, o2);
            }

            @Override
            public Class<? extends SerializablePairLongString> getClazz() {
                return SerializablePairLongString.class;
            }

            @Override
            public SerializablePairLongString fromByteBuffer(ByteBuffer buffer, int numBytes) {
                ByteBuffer readOnlyByteBuffer = buffer.asReadOnlyBuffer().order(buffer.order());
                readOnlyByteBuffer.limit(buffer.position() + numBytes);
                return SERDE.deserialize(readOnlyByteBuffer);
            }

            @Override
            public byte[] toBytes(SerializablePairLongString val) {
                return SERDE.serialize(val);
            }
        };
    }

    public TypeStrategy<SerializablePairLongString> getTypeStrategy() {
        return new ObjectStrategyComplexTypeStrategy<SerializablePairLongString>(this.getObjectStrategy(), ColumnType.ofComplex(this.getTypeName()), new Hash.Strategy<SerializablePairLongString>(){

            public int hashCode(SerializablePairLongString o) {
                return o.hashCode();
            }

            public boolean equals(SerializablePairLongString a, SerializablePairLongString b) {
                return a.equals(b);
            }
        });
    }

    @Override
    public GenericColumnSerializer<?> getSerializer(SegmentWriteOutMedium segmentWriteOutMedium, String column, IndexSpec indexSpec) {
        if (this.compressionEnabled) {
            return new SerializablePairLongStringColumnSerializer(segmentWriteOutMedium, NativeClearedByteBufferProvider.INSTANCE);
        }
        return LargeColumnSupportedComplexColumnSerializer.create(segmentWriteOutMedium, column, LEGACY_STRATEGY);
    }
}

