/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.expression;

import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.granularity.PeriodGranularity;
import org.apache.druid.math.expr.Expr;
import org.apache.druid.math.expr.ExprEval;
import org.apache.druid.math.expr.ExprMacroTable;
import org.apache.druid.math.expr.ExpressionType;
import org.apache.druid.math.expr.InputBindings;
import org.apache.druid.math.expr.vector.CastToTypeVectorProcessor;
import org.apache.druid.math.expr.vector.ExprVectorProcessor;
import org.apache.druid.math.expr.vector.LongUnivariateLongFunctionVectorProcessor;
import org.apache.druid.query.expression.ExprUtils;
import org.joda.time.Period;

public class TimestampFloorExprMacro
implements ExprMacroTable.ExprMacro {
    private static final String FN_NAME = "timestamp_floor";

    public static String forQueryGranularity(Period period) {
        return "timestamp_floor(__time,'" + String.valueOf(period) + "')";
    }

    private static PeriodGranularity computeGranularity(Expr expr, List<Expr> args, Expr.ObjectBinding bindings) {
        return ExprUtils.toPeriodGranularity(expr, args.get(1), args.size() > 2 ? args.get(2) : null, args.size() > 3 ? args.get(3) : null, bindings);
    }

    @Override
    public String name() {
        return FN_NAME;
    }

    @Override
    public Expr apply(List<Expr> args) {
        this.validationHelperCheckArgumentRange(args, 2, 4);
        if (args.stream().skip(1L).allMatch(Expr::isLiteral)) {
            return new TimestampFloorExpr(this, args);
        }
        return new TimestampFloorDynamicExpr(this, args);
    }

    public static class TimestampFloorExpr
    extends ExprMacroTable.BaseScalarMacroFunctionExpr {
        private final PeriodGranularity granularity;

        TimestampFloorExpr(TimestampFloorExprMacro macro, List<Expr> args) {
            super(macro, args);
            this.granularity = TimestampFloorExprMacro.computeGranularity(this, args, InputBindings.nilBindings());
        }

        public Expr getArg() {
            return (Expr)this.args.get(0);
        }

        public PeriodGranularity getGranularity() {
            return this.granularity;
        }

        @Override
        @Nonnull
        public ExprEval eval(Expr.ObjectBinding bindings) {
            ExprEval eval = ((Expr)this.args.get(0)).eval(bindings);
            if (eval.isNumericNull()) {
                return ExprEval.of(null);
            }
            return ExprEval.of(this.granularity.bucketStart(eval.asLong()));
        }

        @Override
        @Nullable
        public ExpressionType getOutputType(Expr.InputBindingInspector inspector) {
            return ExpressionType.LONG;
        }

        @Override
        public boolean canVectorize(Expr.InputBindingInspector inspector) {
            return ((Expr)this.args.get(0)).canVectorize(inspector);
        }

        @Override
        public <T> ExprVectorProcessor<T> asVectorProcessor(Expr.VectorInputBindingInspector inspector) {
            LongUnivariateLongFunctionVectorProcessor processor = new LongUnivariateLongFunctionVectorProcessor(CastToTypeVectorProcessor.cast(((Expr)this.args.get(0)).asVectorProcessor(inspector), ExpressionType.LONG), this.granularity::bucketStart);
            return processor;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            TimestampFloorExpr that = (TimestampFloorExpr)o;
            return Objects.equals(this.granularity, that.granularity);
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.granularity);
        }
    }

    public static class TimestampFloorDynamicExpr
    extends ExprMacroTable.BaseScalarMacroFunctionExpr {
        TimestampFloorDynamicExpr(TimestampFloorExprMacro macro, List<Expr> args) {
            super(macro, args);
        }

        @Override
        @Nonnull
        public ExprEval eval(Expr.ObjectBinding bindings) {
            PeriodGranularity granularity = TimestampFloorExprMacro.computeGranularity(this, this.args, bindings);
            return ExprEval.of(granularity.bucketStart(((Expr)this.args.get(0)).eval(bindings).asLong()));
        }

        @Override
        @Nullable
        public ExpressionType getOutputType(Expr.InputBindingInspector inspector) {
            return ExpressionType.LONG;
        }
    }
}

