/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.groupby;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.io.Closeable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BinaryOperator;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.druid.collections.BlockingPool;
import org.apache.druid.collections.NonBlockingPool;
import org.apache.druid.collections.ReferenceCountingResourceHolder;
import org.apache.druid.collections.ResourceHolder;
import org.apache.druid.guice.annotations.Json;
import org.apache.druid.guice.annotations.Merging;
import org.apache.druid.guice.annotations.Smile;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.collect.Utils;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.java.util.common.granularity.Granularity;
import org.apache.druid.java.util.common.guava.LazySequence;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.java.util.common.guava.Sequences;
import org.apache.druid.java.util.common.io.Closer;
import org.apache.druid.query.DruidProcessingConfig;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryCapacityExceededException;
import org.apache.druid.query.QueryContext;
import org.apache.druid.query.QueryMetrics;
import org.apache.druid.query.QueryPlus;
import org.apache.druid.query.QueryProcessingPool;
import org.apache.druid.query.QueryRunner;
import org.apache.druid.query.QueryWatcher;
import org.apache.druid.query.ResourceLimitExceededException;
import org.apache.druid.query.ResultMergeQueryRunner;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.PostAggregator;
import org.apache.druid.query.context.ResponseContext;
import org.apache.druid.query.dimension.DefaultDimensionSpec;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.query.groupby.GroupByQuery;
import org.apache.druid.query.groupby.GroupByQueryConfig;
import org.apache.druid.query.groupby.GroupByQueryMetrics;
import org.apache.druid.query.groupby.GroupByQueryResources;
import org.apache.druid.query.groupby.GroupByResourcesReservationPool;
import org.apache.druid.query.groupby.GroupByStatsProvider;
import org.apache.druid.query.groupby.ResultRow;
import org.apache.druid.query.groupby.epinephelinae.BufferArrayGrouper;
import org.apache.druid.query.groupby.epinephelinae.GroupByMergingQueryRunner;
import org.apache.druid.query.groupby.epinephelinae.GroupByQueryEngine;
import org.apache.druid.query.groupby.epinephelinae.GroupByResultMergeFn;
import org.apache.druid.query.groupby.epinephelinae.GroupByRowProcessor;
import org.apache.druid.query.groupby.epinephelinae.GroupingSelector;
import org.apache.druid.query.groupby.epinephelinae.vector.VectorGroupByEngine;
import org.apache.druid.query.groupby.orderby.DefaultLimitSpec;
import org.apache.druid.query.groupby.orderby.LimitSpec;
import org.apache.druid.query.groupby.orderby.NoopLimitSpec;
import org.apache.druid.query.spec.MultipleIntervalSegmentSpec;
import org.apache.druid.segment.ColumnInspector;
import org.apache.druid.segment.CursorBuildSpec;
import org.apache.druid.segment.CursorFactory;
import org.apache.druid.segment.CursorHolder;
import org.apache.druid.segment.DimensionHandlerUtils;
import org.apache.druid.segment.TimeBoundaryInspector;
import org.apache.druid.segment.VirtualColumns;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.Types;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.segment.filter.Filters;
import org.apache.druid.segment.join.filter.AllNullColumnSelectorFactory;
import org.apache.druid.utils.CloseableUtils;
import org.joda.time.DateTime;
import org.joda.time.Interval;

public class GroupingEngine {
    public static final String CTX_KEY_FUDGE_TIMESTAMP = "fudgeTimestamp";
    public static final String CTX_KEY_OUTERMOST = "groupByOutermost";
    private final DruidProcessingConfig processingConfig;
    private final Supplier<GroupByQueryConfig> configSupplier;
    private final GroupByResourcesReservationPool groupByResourcesReservationPool;
    private final ObjectMapper jsonMapper;
    private final ObjectMapper spillMapper;
    private final QueryWatcher queryWatcher;
    private final GroupByStatsProvider groupByStatsProvider;

    @Inject
    public GroupingEngine(DruidProcessingConfig processingConfig, Supplier<GroupByQueryConfig> configSupplier, @Merging GroupByResourcesReservationPool groupByResourcesReservationPool, @Json ObjectMapper jsonMapper, @Smile ObjectMapper spillMapper, QueryWatcher queryWatcher, GroupByStatsProvider groupByStatsProvider) {
        this.processingConfig = processingConfig;
        this.configSupplier = configSupplier;
        this.groupByResourcesReservationPool = groupByResourcesReservationPool;
        this.jsonMapper = jsonMapper;
        this.spillMapper = spillMapper;
        this.queryWatcher = queryWatcher;
        this.groupByStatsProvider = groupByStatsProvider;
    }

    public static GroupByQueryResources prepareResource(GroupByQuery query, BlockingPool<ByteBuffer> mergeBufferPool, boolean usesGroupByMergingQueryRunner, GroupByQueryConfig groupByQueryConfig) {
        int requiredMergeBufferNumForMergingQueryRunner;
        int requiredMergeBufferNumForToolchestMerge = GroupByQueryResources.countRequiredMergeBufferNumForToolchestMerge(query);
        int requiredMergeBufferNum = requiredMergeBufferNumForToolchestMerge + (requiredMergeBufferNumForMergingQueryRunner = usesGroupByMergingQueryRunner ? GroupByQueryResources.countRequiredMergeBufferNumForMergingQueryRunner(groupByQueryConfig, query) : 0);
        if (requiredMergeBufferNum > mergeBufferPool.maxSize()) {
            throw new ResourceLimitExceededException("Query needs " + requiredMergeBufferNum + " merge buffers, but only " + mergeBufferPool.maxSize() + " merge buffers were configured");
        }
        if (requiredMergeBufferNum == 0) {
            return new GroupByQueryResources(null, null);
        }
        QueryContext context = query.context();
        List<ReferenceCountingResourceHolder<ByteBuffer>> mergeBufferHolders = context.hasTimeout() ? mergeBufferPool.takeBatch(requiredMergeBufferNum, context.getTimeout()) : mergeBufferPool.takeBatch(requiredMergeBufferNum);
        if (mergeBufferHolders.isEmpty()) {
            throw QueryCapacityExceededException.withErrorMessageAndResolvedHost(StringUtils.format("Cannot acquire %s merge buffers. Try again after current running queries are finished.", requiredMergeBufferNum));
        }
        return new GroupByQueryResources(mergeBufferHolders.subList(0, requiredMergeBufferNumForToolchestMerge), mergeBufferHolders.subList(requiredMergeBufferNumForToolchestMerge, requiredMergeBufferNum));
    }

    public Comparator<ResultRow> createResultComparator(Query<ResultRow> queryParam) {
        return ((GroupByQuery)queryParam).getRowOrdering(true);
    }

    public BinaryOperator<ResultRow> createMergeFn(Query<ResultRow> queryParam) {
        return new GroupByResultMergeFn((GroupByQuery)queryParam);
    }

    public GroupByQuery prepareGroupByQuery(GroupByQuery query) {
        boolean hasTimestampResultField;
        ImmutableMap.Builder context = ImmutableMap.builder();
        context.put((Object)"finalize", (Object)false);
        context.put((Object)CTX_KEY_OUTERMOST, (Object)false);
        Granularity granularity = query.getGranularity();
        List<DimensionSpec> dimensionSpecs = query.getDimensions();
        QueryContext queryContext = query.context();
        String timestampResultField = queryContext.getString("timestampResultField");
        boolean bl = hasTimestampResultField = timestampResultField != null && !timestampResultField.isEmpty() && queryContext.getBoolean(CTX_KEY_OUTERMOST, true) && !query.isApplyLimitPushDown();
        if (hasTimestampResultField) {
            Granularity timestampResultFieldGranularity = queryContext.getGranularity("timestampResultFieldGranularity", this.jsonMapper);
            dimensionSpecs = query.getDimensions().stream().filter(dimensionSpec -> !dimensionSpec.getOutputName().equals(timestampResultField)).collect(Collectors.toList());
            granularity = timestampResultFieldGranularity;
            int timestampResultFieldIndex = queryContext.getInt("timestampResultFieldInOriginalDimensions", 0);
            if (!query.getContextSortByDimsFirst() && timestampResultFieldIndex == query.getDimensions().size() - 1) {
                context.put((Object)"sortByDimsFirst", (Object)true);
            }
            if (query.getContextSortByDimsFirst() && timestampResultFieldIndex == 0) {
                context.put((Object)"sortByDimsFirst", (Object)false);
            }
        }
        if (query.getUniversalTimestamp() != null && !hasTimestampResultField) {
            context.put((Object)CTX_KEY_FUDGE_TIMESTAMP, (Object)String.valueOf(query.getUniversalTimestamp().getMillis()));
        }
        context.put((Object)"applyLimitPushDown", (Object)query.isApplyLimitPushDown());
        context.put((Object)"resultAsArray", (Object)true);
        return new GroupByQuery(query.getDataSource(), query.getQuerySegmentSpec(), query.getVirtualColumns(), query.getDimFilter(), granularity, dimensionSpecs, query.getAggregatorSpecs(), (List<PostAggregator>)ImmutableList.of(), null, query.isApplyLimitPushDown() ? ((DefaultLimitSpec)query.getLimitSpec()).withOffsetToLimit() : null, query.getSubtotalsSpec(), query.getContext()).withOverriddenContext((Map)context.build());
    }

    public Sequence<ResultRow> mergeResults(QueryRunner<ResultRow> baseRunner, GroupByQuery query, ResponseContext responseContext) {
        ResultMergeQueryRunner<ResultRow> mergingQueryRunner = new ResultMergeQueryRunner<ResultRow>(baseRunner, this::createResultComparator, this::createMergeFn);
        QueryContext queryContext = query.context();
        String timestampResultField = queryContext.getString("timestampResultField");
        boolean hasTimestampResultField = timestampResultField != null && !timestampResultField.isEmpty() && queryContext.getBoolean(CTX_KEY_OUTERMOST, true) && !query.isApplyLimitPushDown();
        int timestampResultFieldIndexInOriginalDimensions = hasTimestampResultField ? queryContext.getInt("timestampResultFieldInOriginalDimensions") : 0;
        GroupByQuery newQuery = this.prepareGroupByQuery(query);
        Sequence<ResultRow> mergedResults = mergingQueryRunner.run(QueryPlus.wrap(newQuery), responseContext);
        if (!queryContext.getBoolean(CTX_KEY_OUTERMOST, true) || queryContext.getBoolean("executingNestedQuery", false)) {
            return mergedResults;
        }
        if (query.getPostAggregatorSpecs().isEmpty()) {
            if (!hasTimestampResultField) {
                return mergedResults;
            }
            return Sequences.map(mergedResults, row -> {
                ResultRow resultRow = ResultRow.create(query.getResultRowSizeWithoutPostAggregators());
                this.moveOrReplicateTimestampInRow(query, timestampResultFieldIndexInOriginalDimensions, (ResultRow)row, resultRow);
                return resultRow;
            });
        }
        return Sequences.map(mergedResults, row -> {
            ResultRow rowWithPostAggregations = ResultRow.create(query.getResultRowSizeWithPostAggregators());
            if (hasTimestampResultField) {
                this.moveOrReplicateTimestampInRow(query, timestampResultFieldIndexInOriginalDimensions, (ResultRow)row, rowWithPostAggregations);
            } else {
                for (int i = 0; i < query.getResultRowPostAggregatorStart(); ++i) {
                    rowWithPostAggregations.set(i, row.get(i));
                }
            }
            Map<String, Object> mapForPostAggregationComputation = rowWithPostAggregations.toMap(query);
            for (int i = 0; i < query.getPostAggregatorSpecs().size(); ++i) {
                PostAggregator postAggregator = query.getPostAggregatorSpecs().get(i);
                Object value = postAggregator.compute(mapForPostAggregationComputation);
                rowWithPostAggregations.set(query.getResultRowPostAggregatorStart() + i, value);
                mapForPostAggregationComputation.put(postAggregator.getName(), value);
            }
            return rowWithPostAggregations;
        });
    }

    public QueryRunner<ResultRow> mergeRunners(QueryProcessingPool queryProcessingPool, Iterable<QueryRunner<ResultRow>> queryRunners) {
        return new GroupByMergingQueryRunner((GroupByQueryConfig)this.configSupplier.get(), this.processingConfig, queryProcessingPool, this.queryWatcher, queryRunners, this.groupByResourcesReservationPool, this.processingConfig.getNumThreads(), this.processingConfig.intermediateComputeSizeBytes(), this.spillMapper, this.processingConfig.getTmpDir(), this.groupByStatsProvider);
    }

    public Sequence<ResultRow> process(GroupByQuery query, CursorFactory cursorFactory, @Nullable TimeBoundaryInspector timeBoundaryInspector, NonBlockingPool<ByteBuffer> bufferPool, @Nullable GroupByQueryMetrics groupByQueryMetrics) {
        GroupByQueryConfig querySpecificConfig = ((GroupByQueryConfig)this.configSupplier.get()).withOverrides(query);
        if (cursorFactory == null) {
            throw new ISE("Null cursor factory found. Probably trying to issue a query against a segment being memory unmapped.", new Object[0]);
        }
        List<Interval> intervals = query.getQuerySegmentSpec().getIntervals();
        if (intervals.size() != 1) {
            throw new IAE("Should only have one interval, got[%s]", intervals);
        }
        ResourceHolder<ByteBuffer> bufferHolder = bufferPool.take();
        Closer closer = Closer.create();
        closer.register(bufferHolder);
        try {
            String fudgeTimestampString = query.context().getString(CTX_KEY_FUDGE_TIMESTAMP);
            DateTime fudgeTimestamp = fudgeTimestampString == null ? null : DateTimes.utc(Long.parseLong(fudgeTimestampString));
            CursorBuildSpec buildSpec = GroupingEngine.makeCursorBuildSpec(query, groupByQueryMetrics);
            CursorHolder cursorHolder = closer.register(cursorFactory.makeCursorHolder(buildSpec));
            if (cursorHolder.isPreAggregated()) {
                query = query.withAggregatorSpecs((List)Preconditions.checkNotNull(cursorHolder.getAggregatorsForPreAggregated()));
            }
            ColumnInspector inspector = query.getVirtualColumns().wrapInspector(cursorFactory);
            boolean canVectorize = cursorHolder.canVectorize() && VectorGroupByEngine.canVectorizeDimensions(inspector, query.getDimensions());
            boolean shouldVectorize = query.context().getVectorize().shouldVectorize(canVectorize);
            Sequence<ResultRow> result = shouldVectorize ? VectorGroupByEngine.process(query, timeBoundaryInspector, cursorHolder, bufferHolder.get(), fudgeTimestamp, buildSpec.getInterval(), querySpecificConfig, this.processingConfig) : GroupByQueryEngine.process(query, timeBoundaryInspector, cursorHolder, buildSpec, bufferHolder.get(), fudgeTimestamp, querySpecificConfig, this.processingConfig);
            return result.withBaggage(closer);
        }
        catch (Throwable e) {
            CloseableUtils.closeAndWrapExceptions(closer);
            throw e;
        }
    }

    public Sequence<ResultRow> applyPostProcessing(Sequence<ResultRow> results, GroupByQuery query) {
        results = GroupingEngine.wrapSummaryRowIfNeeded(query, results);
        if (query.context().getBoolean(CTX_KEY_OUTERMOST, true)) {
            return query.postProcess(results);
        }
        return results;
    }

    public Sequence<ResultRow> processSubqueryResult(GroupByQuery subquery, GroupByQuery query, GroupByQueryResources resource, Sequence<ResultRow> subqueryResult, boolean wasQueryPushedDown, GroupByStatsProvider.PerQueryStats perQueryStats) {
        GroupByRowProcessor.ResultSupplier resultSupplier = null;
        try {
            GroupByQuery queryToRun = wasQueryPushedDown ? query.withDimFilter(null).withQuerySegmentSpec(new MultipleIntervalSegmentSpec((List<Interval>)Intervals.ONLY_ETERNITY)) : query;
            if (queryToRun.getLimitSpec() instanceof DefaultLimitSpec) {
                queryToRun = queryToRun.withLimitSpec(((DefaultLimitSpec)queryToRun.getLimitSpec()).withOffsetToLimit());
            }
            GroupByRowProcessor.ResultSupplier finalResultSupplier = resultSupplier = GroupByRowProcessor.process(queryToRun, wasQueryPushedDown ? queryToRun : subquery, subqueryResult, (GroupByQueryConfig)this.configSupplier.get(), this.processingConfig, resource, this.spillMapper, this.processingConfig.getTmpDir(), this.processingConfig.intermediateComputeSizeBytes(), perQueryStats);
            return Sequences.withBaggage(this.mergeResults((queryPlus, responseContext) -> finalResultSupplier.results(null), query, ResponseContext.createEmpty()), finalResultSupplier);
        }
        catch (Throwable e) {
            throw CloseableUtils.closeAndWrapInCatch(e, resultSupplier);
        }
    }

    public Sequence<ResultRow> processSubtotalsSpec(GroupByQuery query, GroupByQueryResources resource, Sequence<ResultRow> queryResult, GroupByStatsProvider.PerQueryStats perQueryStats) {
        GroupByRowProcessor.ResultSupplier resultSupplierOne = null;
        try {
            Query baseSubtotalQuery = query.withDimensionSpecs(query.getDimensions().stream().map(dimSpec -> new DefaultDimensionSpec(dimSpec.getOutputName(), dimSpec.getOutputName(), dimSpec.getOutputType())).collect(Collectors.toList())).withAggregatorSpecs(query.getAggregatorSpecs().stream().map(AggregatorFactory::getCombiningFactory).collect(Collectors.toList())).withVirtualColumns(VirtualColumns.EMPTY).withDimFilter(null).withSubtotalsSpec(null).withOverriddenContext((Map)ImmutableMap.of((Object)"timestampResultField", (Object)""));
            resultSupplierOne = GroupByRowProcessor.process((GroupByQuery)baseSubtotalQuery, (GroupByQuery)baseSubtotalQuery, queryResult, (GroupByQueryConfig)this.configSupplier.get(), this.processingConfig, resource, this.spillMapper, this.processingConfig.getTmpDir(), this.processingConfig.intermediateComputeSizeBytes(), perQueryStats);
            List<String> queryDimNamesInOrder = ((GroupByQuery)baseSubtotalQuery).getDimensionNamesInOrder();
            Set<String> aggsAndPostAggs = null;
            if (!(((GroupByQuery)baseSubtotalQuery).getLimitSpec() instanceof NoopLimitSpec)) {
                aggsAndPostAggs = this.getAggregatorAndPostAggregatorNames((GroupByQuery)baseSubtotalQuery);
            }
            List<List<String>> subtotals = query.getSubtotalsSpec();
            ArrayList subtotalsResults = new ArrayList(subtotals.size());
            for (List<String> subtotalSpec : subtotals) {
                ImmutableSet dimsInSubtotalSpec = ImmutableSet.copyOf(subtotalSpec);
                ArrayList<DimensionSpec> subTotalDimensionSpec = new ArrayList<DimensionSpec>(dimsInSubtotalSpec.size());
                List<DimensionSpec> dimensions = query.getDimensions();
                for (DimensionSpec dimensionSpec : dimensions) {
                    if (!dimsInSubtotalSpec.contains((Object)dimensionSpec.getOutputName())) continue;
                    subTotalDimensionSpec.add(dimensionSpec);
                }
                LimitSpec subtotalQueryLimitSpec = NoopLimitSpec.instance();
                if (!(((GroupByQuery)baseSubtotalQuery).getLimitSpec() instanceof NoopLimitSpec)) {
                    HashSet<String> columns = new HashSet<String>(aggsAndPostAggs);
                    columns.addAll(subtotalSpec);
                    subtotalQueryLimitSpec = ((GroupByQuery)baseSubtotalQuery).getLimitSpec().filterColumns(columns);
                }
                GroupByQuery subtotalQuery = ((GroupByQuery)baseSubtotalQuery).withLimitSpec(subtotalQueryLimitSpec);
                GroupByRowProcessor.ResultSupplier resultSupplierOneFinal = resultSupplierOne;
                if (Utils.isPrefix(subtotalSpec, queryDimNamesInOrder)) {
                    subtotalsResults.add(this.processSubtotalsResultAndOptionallyClose((Supplier<GroupByRowProcessor.ResultSupplier>)((Supplier)() -> resultSupplierOneFinal), subTotalDimensionSpec, subtotalQuery, false));
                    continue;
                }
                Supplier resultSupplierTwo = () -> this.lambda$processSubtotalsSpec$6((GroupByQuery)baseSubtotalQuery, subtotalQuery, resultSupplierOneFinal, subTotalDimensionSpec, resource, perQueryStats);
                subtotalsResults.add(this.processSubtotalsResultAndOptionallyClose((Supplier<GroupByRowProcessor.ResultSupplier>)resultSupplierTwo, subTotalDimensionSpec, subtotalQuery, true));
            }
            return Sequences.withBaggage(query.postProcess(Sequences.concat(subtotalsResults)), resultSupplierOne);
        }
        catch (Throwable e) {
            throw CloseableUtils.closeAndWrapInCatch(e, resultSupplierOne);
        }
    }

    private Sequence<ResultRow> processSubtotalsResultAndOptionallyClose(Supplier<GroupByRowProcessor.ResultSupplier> baseResultsSupplier, List<DimensionSpec> dimsToInclude, GroupByQuery subtotalQuery, boolean closeOnSequenceRead) {
        try {
            Supplier memoizedSupplier = Suppliers.memoize(baseResultsSupplier);
            return this.mergeResults((queryPlus, responseContext) -> new LazySequence(() -> Sequences.withBaggage(((GroupByRowProcessor.ResultSupplier)memoizedSupplier.get()).results(dimsToInclude), closeOnSequenceRead ? () -> CloseableUtils.closeAndWrapExceptions((Closeable)memoizedSupplier.get()) : () -> {})), subtotalQuery, ResponseContext.createEmpty());
        }
        catch (Throwable e) {
            throw CloseableUtils.closeAndWrapInCatch(e, (Closeable)baseResultsSupplier.get());
        }
    }

    private void moveOrReplicateTimestampInRow(GroupByQuery query, int timestampResultFieldIndexInOriginalDimensions, ResultRow before, ResultRow after) {
        int i;
        Object theTimestamp = before.get(0);
        int expectedDimensionStartInAfterRow = 0;
        if (query.getResultRowHasTimestamp()) {
            expectedDimensionStartInAfterRow = 1;
            after.set(0, theTimestamp);
        }
        int timestampResultFieldIndexInAfterRow = timestampResultFieldIndexInOriginalDimensions + expectedDimensionStartInAfterRow;
        for (i = expectedDimensionStartInAfterRow; i < timestampResultFieldIndexInAfterRow; ++i) {
            after.set(i, before.get(i + 1));
        }
        after.set(timestampResultFieldIndexInAfterRow, theTimestamp);
        for (i = timestampResultFieldIndexInAfterRow + 1; i < before.length() + expectedDimensionStartInAfterRow; ++i) {
            after.set(i, before.get(i - expectedDimensionStartInAfterRow));
        }
    }

    private Set<String> getAggregatorAndPostAggregatorNames(GroupByQuery query) {
        HashSet<String> aggsAndPostAggs = new HashSet<String>();
        if (query.getAggregatorSpecs() != null) {
            for (AggregatorFactory af : query.getAggregatorSpecs()) {
                aggsAndPostAggs.add(af.getName());
            }
        }
        if (query.getPostAggregatorSpecs() != null) {
            for (PostAggregator pa : query.getPostAggregatorSpecs()) {
                aggsAndPostAggs.add(pa.getName());
            }
        }
        return aggsAndPostAggs;
    }

    public static CursorBuildSpec makeCursorBuildSpec(GroupByQuery query, @Nullable QueryMetrics<?> queryMetrics) {
        return Granularities.decorateCursorBuildSpec(query, CursorBuildSpec.builder().setInterval(query.getSingleInterval()).setFilter(Filters.convertToCNFFromQueryContext(query, Filters.toFilter(query.getFilter()))).setVirtualColumns(query.getVirtualColumns()).setPhysicalColumns(query.getRequiredColumns()).setGroupingColumns(query.getGroupingColumns()).setAggregators(query.getAggregatorSpecs()).setQueryContext(query.context()).setQueryMetrics(queryMetrics).build());
    }

    public static int getCardinalityForArrayAggregation(GroupByQueryConfig querySpecificConfig, GroupByQuery query, ColumnInspector columnInspector, List<? extends GroupingSelector> groupingSelectors, ByteBuffer buffer) {
        int cardinality;
        ColumnCapabilities columnCapabilities;
        if (querySpecificConfig.isForceHashAggregation()) {
            return -1;
        }
        List<DimensionSpec> dimensions = query.getDimensions();
        if (dimensions.isEmpty()) {
            columnCapabilities = null;
            cardinality = 1;
        } else if (dimensions.size() == 1) {
            if (query.getVirtualColumns().exists(((DimensionSpec)Iterables.getOnlyElement(dimensions)).getDimension())) {
                return -1;
            }
            if (dimensions.get(0).getOutputType().isArray()) {
                return -1;
            }
            String columnName = ((DimensionSpec)Iterables.getOnlyElement(dimensions)).getDimension();
            columnCapabilities = columnInspector.getColumnCapabilities(columnName);
            cardinality = groupingSelectors.get(0).getValueCardinality();
        } else {
            return -1;
        }
        if (Types.is(columnCapabilities, ValueType.STRING) && cardinality > 0) {
            AggregatorFactory[] aggregatorFactories = query.getAggregatorSpecs().toArray(new AggregatorFactory[0]);
            long requiredBufferCapacity = BufferArrayGrouper.requiredBufferCapacity(cardinality, aggregatorFactories);
            if (requiredBufferCapacity < 0L || requiredBufferCapacity > (long)buffer.capacity()) {
                return -1;
            }
            return cardinality;
        }
        return -1;
    }

    public static void convertRowTypesToOutputTypes(List<DimensionSpec> dimensionSpecs, ResultRow resultRow, int resultRowDimensionStart) {
        for (int i = 0; i < dimensionSpecs.size(); ++i) {
            DimensionSpec dimSpec = dimensionSpecs.get(i);
            int resultRowIndex = resultRowDimensionStart + i;
            ColumnType outputType = dimSpec.getOutputType();
            resultRow.set(resultRowIndex, DimensionHandlerUtils.convertObjectToType(resultRow.get(resultRowIndex), outputType));
        }
    }

    public static Sequence<ResultRow> wrapSummaryRowIfNeeded(GroupByQuery query, Sequence<ResultRow> process) {
        if (!GroupingEngine.summaryRowPreconditions(query)) {
            return process;
        }
        AtomicBoolean t = new AtomicBoolean();
        return Sequences.concat(Sequences.map(process, ent -> {
            t.set(true);
            return ent;
        }), Sequences.simple(() -> {
            if (t.get()) {
                return Collections.emptyIterator();
            }
            return GroupingEngine.summaryRowIterator(query);
        }));
    }

    public static boolean summaryRowPreconditions(GroupByQuery query) {
        DefaultLimitSpec limitSpec;
        LimitSpec limit = query.getLimitSpec();
        if (limit instanceof DefaultLimitSpec && ((limitSpec = (DefaultLimitSpec)limit).getLimit() == 0 || limitSpec.getOffset() > 0)) {
            return false;
        }
        if (!query.getDimensions().isEmpty() || query.hasDroppedDimensions()) {
            return false;
        }
        return !query.getGranularity().isFinerThan(Granularities.ALL);
    }

    private static Iterator<ResultRow> summaryRowIterator(GroupByQuery q) {
        List<AggregatorFactory> aggSpec = q.getAggregatorSpecs();
        ResultRow resultRow = ResultRow.create(q.getResultRowSizeWithPostAggregators());
        for (int i = 0; i < aggSpec.size(); ++i) {
            resultRow.set(q.getResultRowAggregatorStart() + i, aggSpec.get(i).factorize(new AllNullColumnSelectorFactory()).get());
        }
        Map<String, Object> map = resultRow.toMap(q);
        for (int i = 0; i < q.getPostAggregatorSpecs().size(); ++i) {
            PostAggregator postAggregator = q.getPostAggregatorSpecs().get(i);
            Object value = postAggregator.compute(map);
            resultRow.set(q.getResultRowPostAggregatorStart() + i, value);
            map.put(postAggregator.getName(), value);
        }
        return Collections.singleton(resultRow).iterator();
    }

    private /* synthetic */ GroupByRowProcessor.ResultSupplier lambda$processSubtotalsSpec$6(GroupByQuery baseSubtotalQuery, GroupByQuery subtotalQuery, GroupByRowProcessor.ResultSupplier resultSupplierOneFinal, List subTotalDimensionSpec, GroupByQueryResources resource, GroupByStatsProvider.PerQueryStats perQueryStats) {
        return GroupByRowProcessor.process(baseSubtotalQuery, subtotalQuery, resultSupplierOneFinal.results(subTotalDimensionSpec), (GroupByQueryConfig)this.configSupplier.get(), this.processingConfig, resource, this.spillMapper, this.processingConfig.getTmpDir(), this.processingConfig.intermediateComputeSizeBytes(), perQueryStats);
    }
}

