/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.operator;

import com.google.common.base.Function;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.druid.error.DruidException;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.java.util.common.guava.Sequences;
import org.apache.druid.query.QueryProcessingPool;
import org.apache.druid.query.QueryRunner;
import org.apache.druid.query.QueryRunnerFactory;
import org.apache.druid.query.QueryToolChest;
import org.apache.druid.query.operator.LimitTimeIntervalOperator;
import org.apache.druid.query.operator.Operator;
import org.apache.druid.query.operator.OperatorFactory;
import org.apache.druid.query.operator.OperatorSequence;
import org.apache.druid.query.operator.SegmentToRowsAndColumnsOperator;
import org.apache.druid.query.operator.WindowOperatorQuery;
import org.apache.druid.query.operator.WindowOperatorQueryQueryToolChest;
import org.apache.druid.query.rowsandcols.LazilyDecoratedRowsAndColumns;
import org.apache.druid.query.rowsandcols.RowsAndColumns;
import org.apache.druid.query.rowsandcols.concrete.FrameRowsAndColumns;
import org.apache.druid.segment.Segment;
import org.joda.time.Interval;

public class WindowOperatorQueryQueryRunnerFactory
implements QueryRunnerFactory<RowsAndColumns, WindowOperatorQuery> {
    public static final WindowOperatorQueryQueryToolChest TOOLCHEST = new WindowOperatorQueryQueryToolChest();

    @Override
    public QueryRunner<RowsAndColumns> createRunner(Segment segment) {
        return (queryPlus, responseContext) -> new OperatorSequence(() -> {
            Operator op = new SegmentToRowsAndColumnsOperator(segment);
            List<Interval> intervals = queryPlus.getQuery().getIntervals();
            if (intervals.size() != 1) {
                throw DruidException.defensive("Can only handle a single interval, got [%s]", intervals);
            }
            Interval interval = intervals.get(0);
            if (!Intervals.isEternity(interval)) {
                op = new LimitTimeIntervalOperator(op, interval);
            }
            for (OperatorFactory leaf : ((WindowOperatorQuery)queryPlus.getQuery()).getLeafOperators()) {
                op = leaf.wrap(op);
            }
            return op;
        });
    }

    @Override
    public QueryRunner<RowsAndColumns> mergeRunners(QueryProcessingPool queryProcessingPool, Iterable<QueryRunner<RowsAndColumns>> queryRunners) {
        return (queryPlus, responseContext) -> Sequences.concat(Sequences.map(Sequences.simple(queryRunners), new Function<QueryRunner<RowsAndColumns>, Sequence<RowsAndColumns>>(){

            @Nullable
            public Sequence<RowsAndColumns> apply(@Nullable QueryRunner<RowsAndColumns> input) {
                return Sequences.map(input.run(queryPlus, responseContext), new Function<RowsAndColumns, RowsAndColumns>(){

                    @Nullable
                    public RowsAndColumns apply(@Nullable RowsAndColumns input) {
                        if (input instanceof LazilyDecoratedRowsAndColumns) {
                            return input.as(FrameRowsAndColumns.class);
                        }
                        return input;
                    }
                });
            }
        }));
    }

    @Override
    public QueryToolChest<RowsAndColumns, WindowOperatorQuery> getToolchest() {
        return TOOLCHEST;
    }
}

