/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment;

import java.util.Arrays;
import java.util.HashSet;
import javax.annotation.Nullable;
import org.apache.druid.collections.bitmap.ImmutableBitmap;
import org.apache.druid.collections.bitmap.MutableBitmap;
import org.apache.druid.collections.bitmap.RoaringBitmapFactory;
import org.apache.druid.collections.bitmap.WrappedImmutableRoaringBitmap;
import org.apache.druid.java.util.common.RE;
import org.apache.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.druid.segment.data.Offset;
import org.apache.druid.segment.data.ReadableOffset;
import org.roaringbitmap.IntIterator;

public class BitmapOffset
extends Offset {
    private static final int INVALID_VALUE = -1;
    private static final String DEFAULT_FULLNESS_FACTORIZATION_STOPS = "0.01,0.1,0.3,0.5,0.7,0.9,0.99";
    private static final double[] BITMAP_FULLNESS_FACTORIZATION_STOPS;
    private static final String[] FACTORIZED_FULLNESS;
    private final String fullness;
    private IntIterator iterator;
    private final IntIterator iteratorForReset;
    private final int valueForReset;
    private int value;
    @Nullable
    private IntIterator iteratorForMark;
    private int valueForMark;

    private static String factorizeFullness(long bitmapCardinality, long numRows) {
        if (bitmapCardinality == 0L) {
            return "0";
        }
        if (bitmapCardinality == numRows) {
            return "1";
        }
        double fullness = (double)bitmapCardinality / (double)numRows;
        int index = Arrays.binarySearch(BITMAP_FULLNESS_FACTORIZATION_STOPS, fullness);
        if (index < 0) {
            index ^= 0xFFFFFFFF;
        }
        return FACTORIZED_FULLNESS[index];
    }

    public static IntIterator getReverseBitmapOffsetIterator(ImmutableBitmap bitmapIndex) {
        ImmutableBitmap roaringBitmap = bitmapIndex;
        if (!(bitmapIndex instanceof WrappedImmutableRoaringBitmap)) {
            MutableBitmap bitmap = RoaringBitmapFactory.INSTANCE.makeEmptyMutableBitmap();
            IntIterator iterator = bitmapIndex.iterator();
            while (iterator.hasNext()) {
                bitmap.add(iterator.next());
            }
            roaringBitmap = RoaringBitmapFactory.INSTANCE.makeImmutableBitmap(bitmap);
        }
        return ((WrappedImmutableRoaringBitmap)roaringBitmap).getBitmap().getReverseIntIterator();
    }

    public static BitmapOffset of(ImmutableBitmap bitmapIndex, boolean descending, long numRows) {
        return new BitmapOffset(bitmapIndex, descending, numRows);
    }

    private BitmapOffset(ImmutableBitmap bitmapIndex, boolean descending, long numRows) {
        this.fullness = BitmapOffset.factorizeFullness(bitmapIndex.size(), numRows);
        this.iterator = this.newIterator(bitmapIndex, descending);
        this.increment();
        this.iteratorForReset = this.iterator.clone();
        this.valueForReset = this.value;
    }

    private IntIterator newIterator(ImmutableBitmap bitmapIndex, boolean descending) {
        if (!descending) {
            return bitmapIndex.iterator();
        }
        return BitmapOffset.getReverseBitmapOffsetIterator(bitmapIndex);
    }

    private BitmapOffset(String fullness, IntIterator iterator, int value, @Nullable IntIterator iteratorForMark, int markValue) {
        this.fullness = fullness;
        this.iterator = iterator;
        this.iteratorForReset = iterator.clone();
        this.valueForReset = value;
        this.value = value;
        this.iteratorForMark = iteratorForMark;
        this.valueForMark = markValue;
    }

    @Override
    public void increment() {
        this.value = this.iterator.hasNext() ? this.iterator.next() : -1;
    }

    @Override
    public boolean withinBounds() {
        return this.value > -1;
    }

    @Override
    public void reset() {
        this.iterator = this.iteratorForReset.clone();
        this.value = this.valueForReset;
        this.valueForMark = this.valueForReset;
        this.iteratorForMark = null;
    }

    @Override
    public ReadableOffset getBaseReadableOffset() {
        return this;
    }

    @Override
    public Offset clone() {
        return new BitmapOffset(this.fullness, this.iterator.clone(), this.value, this.iteratorForMark != null ? this.iteratorForMark.clone() : null, this.valueForMark);
    }

    @Override
    public int getOffset() {
        return this.value;
    }

    @Override
    public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
        inspector.visit("iterator", this.iterator);
        inspector.visit("fullness", this.fullness);
    }

    static {
        String stopString = System.getProperty("bitmapFullnessFactorizationStops", DEFAULT_FULLNESS_FACTORIZATION_STOPS);
        String[] stopsArray = stopString.split(",");
        if (stopsArray.length == 0) {
            throw new RE("Empty bitmapFullnessFactorizationStops: " + stopString, new Object[0]);
        }
        if (new HashSet<String>(Arrays.asList(stopsArray)).size() != stopsArray.length) {
            throw new RE("Non unique bitmapFullnessFactorizationStops: " + stopString, new Object[0]);
        }
        BITMAP_FULLNESS_FACTORIZATION_STOPS = new double[stopsArray.length];
        for (int i = 0; i < stopsArray.length; ++i) {
            String stop = stopsArray[i];
            BitmapOffset.BITMAP_FULLNESS_FACTORIZATION_STOPS[i] = Double.parseDouble(stop);
        }
        Arrays.sort(BITMAP_FULLNESS_FACTORIZATION_STOPS);
        double firstStop = BITMAP_FULLNESS_FACTORIZATION_STOPS[0];
        if (Double.isNaN(firstStop) || firstStop <= 0.0) {
            throw new RE("First bitmapFullnessFactorizationStop[%d] should be > 0", firstStop);
        }
        double lastStop = BITMAP_FULLNESS_FACTORIZATION_STOPS[stopsArray.length - 1];
        if (Double.isNaN(lastStop) || lastStop >= 1.0) {
            throw new RE("Last bitmapFullnessFactorizationStop[%d] should be < 1", lastStop);
        }
        String prevStop = "0";
        FACTORIZED_FULLNESS = new String[stopsArray.length + 1];
        for (int i = 0; i < stopsArray.length; ++i) {
            String stop = String.valueOf(BITMAP_FULLNESS_FACTORIZATION_STOPS[i]);
            BitmapOffset.FACTORIZED_FULLNESS[i] = "(" + prevStop + ", " + stop + "]";
            prevStop = stop;
        }
        BitmapOffset.FACTORIZED_FULLNESS[stopsArray.length] = "(" + prevStop + ", 1)";
    }
}

