/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.column;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.ColumnTypeFactory;
import org.apache.druid.segment.column.TypeSignature;
import org.apache.druid.segment.column.TypeStrategy;
import org.apache.druid.segment.column.ValueType;

public interface ColumnCapabilities
extends TypeSignature<ValueType> {
    public Capable isDictionaryEncoded();

    public Capable areDictionaryValuesSorted();

    public Capable areDictionaryValuesUnique();

    public Capable hasMultipleValues();

    public boolean hasBitmapIndexes();

    public boolean hasSpatialIndexes();

    public Capable hasNulls();

    default public ColumnType toColumnType() {
        return ColumnTypeFactory.ofType(this);
    }

    @Override
    default public <T> TypeStrategy<T> getStrategy() {
        return ColumnTypeFactory.getInstance().getTypeStrategy(this.toColumnType());
    }

    public static interface CoercionLogic {
        public boolean dictionaryEncoded();

        public boolean dictionaryValuesSorted();

        public boolean dictionaryValuesUnique();

        public boolean multipleValues();

        public boolean hasNulls();
    }

    public static enum Capable {
        FALSE,
        TRUE,
        UNKNOWN;


        public boolean isTrue() {
            return this == TRUE;
        }

        public boolean isMaybeTrue() {
            return this.isTrue() || this.isUnknown();
        }

        public boolean isFalse() {
            return this == FALSE;
        }

        public boolean isUnknown() {
            return this == UNKNOWN;
        }

        public Capable coerceUnknownToBoolean(boolean unknownIsTrue) {
            return this == UNKNOWN ? Capable.of(unknownIsTrue) : this;
        }

        public Capable and(Capable other) {
            if (this == UNKNOWN || other == UNKNOWN) {
                return UNKNOWN;
            }
            return this == TRUE && other == TRUE ? TRUE : FALSE;
        }

        public Capable or(Capable other) {
            if (this == TRUE) {
                return TRUE;
            }
            return other;
        }

        public static Capable of(boolean bool) {
            return bool ? TRUE : FALSE;
        }

        @JsonCreator
        public static Capable ofNullable(@Nullable Boolean bool) {
            return bool == null ? UNKNOWN : Capable.of(bool);
        }

        @JsonValue
        @Nullable
        public Boolean toJson() {
            return this == UNKNOWN ? null : Boolean.valueOf(this.isTrue());
        }

        public String toString() {
            return StringUtils.toLowerCase(super.toString());
        }
    }
}

