/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.column;

import javax.annotation.Nullable;
import org.apache.druid.query.extraction.ExtractionFn;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.DimensionSelector;
import org.apache.druid.segment.DoubleWrappingDimensionSelector;
import org.apache.druid.segment.FloatWrappingDimensionSelector;
import org.apache.druid.segment.LongWrappingDimensionSelector;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.segment.selector.settable.SettableColumnValueSelector;
import org.apache.druid.segment.selector.settable.SettableDimensionValueSelector;
import org.apache.druid.segment.selector.settable.SettableDoubleColumnValueSelector;
import org.apache.druid.segment.selector.settable.SettableFloatColumnValueSelector;
import org.apache.druid.segment.selector.settable.SettableLongColumnValueSelector;
import org.apache.druid.segment.selector.settable.SettableObjectColumnValueSelector;

public class ValueTypes {
    public static SettableColumnValueSelector<?> makeNewSettableColumnValueSelector(ValueType valueType) {
        switch (valueType) {
            case DOUBLE: {
                return new SettableDoubleColumnValueSelector();
            }
            case FLOAT: {
                return new SettableFloatColumnValueSelector();
            }
            case LONG: {
                return new SettableLongColumnValueSelector();
            }
            case STRING: {
                return new SettableDimensionValueSelector();
            }
        }
        return new SettableObjectColumnValueSelector();
    }

    public static DimensionSelector makeNumericWrappingDimensionSelector(ValueType valueType, ColumnValueSelector<?> numericColumnValueSelector, @Nullable ExtractionFn extractionFn) {
        switch (valueType) {
            case DOUBLE: {
                return new DoubleWrappingDimensionSelector(numericColumnValueSelector, extractionFn);
            }
            case FLOAT: {
                return new FloatWrappingDimensionSelector(numericColumnValueSelector, extractionFn);
            }
            case LONG: {
                return new LongWrappingDimensionSelector(numericColumnValueSelector, extractionFn);
            }
        }
        throw new UnsupportedOperationException("Not a numeric value type: " + valueType.name());
    }

    private ValueTypes() {
    }
}

