/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.incremental;

import com.google.common.annotations.VisibleForTesting;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.segment.incremental.IncrementalIndex;
import org.apache.druid.segment.incremental.IncrementalIndexSchema;

public abstract class AppendableIndexBuilder {
    @Nullable
    protected IncrementalIndexSchema incrementalIndexSchema = null;
    protected int maxRowCount = 0;
    protected long maxBytesInMemory = 0L;
    protected boolean preserveExistingMetrics = false;
    protected boolean useMaxMemoryEstimates = false;
    protected final Logger log = new Logger(this.getClass());

    public AppendableIndexBuilder setIndexSchema(IncrementalIndexSchema incrementalIndexSchema) {
        this.incrementalIndexSchema = incrementalIndexSchema;
        return this;
    }

    @VisibleForTesting
    public AppendableIndexBuilder setSimpleTestingIndexSchema(AggregatorFactory ... metrics) {
        return this.setSimpleTestingIndexSchema((Boolean)null, (Boolean)null, metrics);
    }

    @VisibleForTesting
    public AppendableIndexBuilder setSimpleTestingIndexSchema(@Nullable Boolean rollup, @Nullable Boolean preserveExistingMetrics, AggregatorFactory ... metrics) {
        IncrementalIndexSchema.Builder builder = new IncrementalIndexSchema.Builder().withMetrics(metrics);
        this.incrementalIndexSchema = rollup != null ? builder.withRollup(rollup).build() : builder.build();
        this.preserveExistingMetrics = preserveExistingMetrics != null ? preserveExistingMetrics : false;
        return this;
    }

    public AppendableIndexBuilder setMaxRowCount(int maxRowCount) {
        this.maxRowCount = maxRowCount;
        return this;
    }

    public AppendableIndexBuilder setMaxBytesInMemory(long maxBytesInMemory) {
        this.maxBytesInMemory = maxBytesInMemory;
        return this;
    }

    public AppendableIndexBuilder setPreserveExistingMetrics(boolean preserveExistingMetrics) {
        this.preserveExistingMetrics = preserveExistingMetrics;
        return this;
    }

    public AppendableIndexBuilder setUseMaxMemoryEstimates(boolean useMaxMemoryEstimates) {
        this.useMaxMemoryEstimates = useMaxMemoryEstimates;
        return this;
    }

    public void validate() {
        if (this.maxRowCount <= 0) {
            throw new IllegalArgumentException("Invalid max row count: " + this.maxRowCount);
        }
        if (this.incrementalIndexSchema == null) {
            throw new IllegalArgumentException("incrementIndexSchema cannot be null");
        }
    }

    public final IncrementalIndex build() {
        this.log.debug("Building appendable index.", new Object[0]);
        this.validate();
        return this.buildInner();
    }

    protected abstract IncrementalIndex buildInner();
}

