/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.nested;

import java.io.File;
import java.io.IOException;
import java.nio.ByteOrder;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.io.Closer;
import org.apache.druid.java.util.common.io.smoosh.FileSmoosher;
import org.apache.druid.math.expr.ExprEval;
import org.apache.druid.math.expr.ExpressionType;
import org.apache.druid.segment.IndexSpec;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.data.ColumnarDoublesSerializer;
import org.apache.druid.segment.data.CompressionFactory;
import org.apache.druid.segment.data.FixedIndexedWriter;
import org.apache.druid.segment.nested.DictionaryIdLookup;
import org.apache.druid.segment.nested.ScalarNestedCommonFormatColumnSerializer;
import org.apache.druid.segment.writeout.SegmentWriteOutMedium;

public class ScalarDoubleColumnSerializer
extends ScalarNestedCommonFormatColumnSerializer<Double> {
    private ColumnarDoublesSerializer doublesSerializer;

    public ScalarDoubleColumnSerializer(String name, IndexSpec indexSpec, SegmentWriteOutMedium segmentWriteOutMedium, Closer closer) {
        super(name, indexSpec, segmentWriteOutMedium, closer);
    }

    @Override
    protected int processValue(@Nullable Object rawValue) throws IOException {
        ExprEval eval = ExprEval.bestEffortOf(rawValue).castTo(ExpressionType.DOUBLE);
        double val = eval.asDouble();
        int dictId = eval.isNumericNull() ? 0 : this.dictionaryIdLookup.lookupDouble(val);
        this.doublesSerializer.add(dictId == 0 ? 0.0 : val);
        return dictId;
    }

    @Override
    public void openDictionaryWriter(File segmentBaseDir) throws IOException {
        this.dictionaryWriter = new FixedIndexedWriter(this.segmentWriteOutMedium, ColumnType.DOUBLE.getStrategy(), ByteOrder.nativeOrder(), 8, true);
        this.dictionaryWriter.open();
        this.dictionaryIdLookup = this.closer.register(new DictionaryIdLookup(this.name, segmentBaseDir, null, null, this.dictionaryWriter, null));
    }

    @Override
    protected void openValueColumnSerializer() throws IOException {
        this.doublesSerializer = CompressionFactory.getDoubleSerializer(this.name, this.segmentWriteOutMedium, StringUtils.format("%s.double_column", this.name), ByteOrder.nativeOrder(), this.indexSpec.getDimensionCompression(), this.segmentWriteOutMedium.getCloser());
        this.doublesSerializer.open();
    }

    @Override
    public void serializeDictionaries(Iterable<String> strings, Iterable<Long> longs, Iterable<Double> doubles, Iterable<int[]> arrays) throws IOException {
        if (this.dictionarySerialized) {
            throw new ISE("Double dictionary already serialized for column [%s], cannot serialize again", this.name);
        }
        this.dictionaryWriter.write(null);
        for (Double value : doubles) {
            if (value == null) continue;
            this.dictionaryWriter.write(value);
        }
        this.dictionarySerialized = true;
    }

    @Override
    protected void writeValueColumn(FileSmoosher smoosher) throws IOException {
        this.writeInternal(smoosher, this.doublesSerializer, "__doubleColumn");
    }

    @Override
    protected void writeDictionaryFile(FileSmoosher smoosher) throws IOException {
        if (this.dictionaryIdLookup.getDoubleBufferMapper() != null) {
            ScalarDoubleColumnSerializer.copyFromTempSmoosh(smoosher, this.dictionaryIdLookup.getDoubleBufferMapper());
        } else {
            this.writeInternal(smoosher, this.dictionaryWriter, "__doubleDictionary");
        }
    }

    @Override
    public int getCardinality() {
        if (this.writeDictionary) {
            return this.dictionaryWriter.getCardinality();
        }
        return this.dictionaryIdLookup.getDoubleCardinality();
    }
}

