/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.nested;

import com.google.common.primitives.Doubles;
import com.google.common.primitives.Floats;
import it.unimi.dsi.fastutil.ints.IntArraySet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.BitSet;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.apache.druid.collections.bitmap.BitmapFactory;
import org.apache.druid.collections.bitmap.ImmutableBitmap;
import org.apache.druid.common.guava.GuavaUtils;
import org.apache.druid.common.semantic.SemanticUtils;
import org.apache.druid.error.DruidException;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.math.expr.ExprEval;
import org.apache.druid.math.expr.ExpressionType;
import org.apache.druid.query.extraction.ExtractionFn;
import org.apache.druid.query.filter.DruidObjectPredicate;
import org.apache.druid.query.filter.DruidPredicateFactory;
import org.apache.druid.query.filter.StringPredicateDruidPredicateFactory;
import org.apache.druid.query.filter.ValueMatcher;
import org.apache.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.druid.segment.AbstractDimensionSelector;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.DimensionHandlerUtils;
import org.apache.druid.segment.DimensionSelector;
import org.apache.druid.segment.IdLookup;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.ColumnTypeFactory;
import org.apache.druid.segment.column.DictionaryEncodedColumn;
import org.apache.druid.segment.column.StringEncodingStrategies;
import org.apache.druid.segment.column.StringUtf8DictionaryEncodedColumn;
import org.apache.druid.segment.column.TypeSignature;
import org.apache.druid.segment.data.ColumnarInts;
import org.apache.druid.segment.data.FixedIndexed;
import org.apache.druid.segment.data.FrontCodedIntArrayIndexed;
import org.apache.druid.segment.data.Indexed;
import org.apache.druid.segment.data.IndexedInts;
import org.apache.druid.segment.data.ReadableOffset;
import org.apache.druid.segment.data.SingleIndexedInt;
import org.apache.druid.segment.historical.SingleValueHistoricalDimensionSelector;
import org.apache.druid.segment.nested.FieldTypeInfo;
import org.apache.druid.segment.nested.NestedCommonFormatColumn;
import org.apache.druid.segment.vector.BaseDoubleVectorValueSelector;
import org.apache.druid.segment.vector.MultiValueDimensionVectorSelector;
import org.apache.druid.segment.vector.ReadableVectorOffset;
import org.apache.druid.segment.vector.SingleValueDimensionVectorSelector;
import org.apache.druid.segment.vector.VectorObjectSelector;
import org.apache.druid.segment.vector.VectorSelectorUtils;
import org.apache.druid.segment.vector.VectorValueSelector;
import org.roaringbitmap.PeekableIntIterator;

public class VariantColumn<TStringDictionary extends Indexed<ByteBuffer>>
implements DictionaryEncodedColumn<String>,
NestedCommonFormatColumn {
    private static final Map<Class<?>, Function<VariantColumn, ?>> AS_MAP = SemanticUtils.makeAsMap(VariantColumn.class);
    private final TStringDictionary stringDictionary;
    private final FixedIndexed<Long> longDictionary;
    private final FixedIndexed<Double> doubleDictionary;
    private final FrontCodedIntArrayIndexed arrayDictionary;
    private final ColumnarInts encodedValueColumn;
    private final ImmutableBitmap nullValueBitmap;
    private final ColumnType logicalType;
    private final ExpressionType logicalExpressionType;
    @Nullable
    private final FieldTypeInfo.TypeSet variantTypes;
    private final BitmapFactory bitmapFactory;
    private final int adjustLongId;
    private final int adjustDoubleId;
    private final int adjustArrayId;

    public VariantColumn(TStringDictionary stringDictionary, FixedIndexed<Long> longDictionary, FixedIndexed<Double> doubleDictionary, FrontCodedIntArrayIndexed arrayDictionary, ColumnarInts encodedValueColumn, ImmutableBitmap nullValueBitmap, ColumnType logicalType, @Nullable Byte variantTypeSetByte, BitmapFactory bitmapFactory) {
        this.stringDictionary = stringDictionary;
        this.longDictionary = longDictionary;
        this.doubleDictionary = doubleDictionary;
        this.arrayDictionary = arrayDictionary;
        this.encodedValueColumn = encodedValueColumn;
        this.nullValueBitmap = nullValueBitmap;
        this.logicalExpressionType = ExpressionType.fromColumnTypeStrict(logicalType);
        this.variantTypes = variantTypeSetByte == null ? null : new FieldTypeInfo.TypeSet(variantTypeSetByte);
        this.bitmapFactory = bitmapFactory;
        if (variantTypeSetByte != null) {
            TypeSignature theType = null;
            for (ColumnType type : FieldTypeInfo.convertToSet(variantTypeSetByte)) {
                theType = ColumnType.leastRestrictiveType(theType, type);
            }
            if (theType != null) {
                if (variantTypeSetByte < 0 && !theType.isArray()) {
                    theType = ColumnTypeFactory.getInstance().ofArray((ColumnType)theType);
                }
                this.logicalType = theType;
            } else {
                this.logicalType = logicalType;
            }
        } else {
            this.logicalType = logicalType;
        }
        this.adjustLongId = stringDictionary.size();
        this.adjustDoubleId = this.adjustLongId + longDictionary.size();
        this.adjustArrayId = this.adjustDoubleId + doubleDictionary.size();
    }

    @Override
    public ColumnType getLogicalType() {
        return this.logicalType;
    }

    @Override
    public Indexed<String> getStringDictionary() {
        return new StringEncodingStrategies.Utf8ToStringIndexed((Indexed<ByteBuffer>)this.stringDictionary);
    }

    @Override
    public Indexed<Long> getLongDictionary() {
        return this.longDictionary;
    }

    @Override
    public Indexed<Double> getDoubleDictionary() {
        return this.doubleDictionary;
    }

    @Override
    public Indexed<Object[]> getArrayDictionary() {
        final Iterable arrays = () -> new Iterator<Object[]>(){
            final Iterator<int[]> delegate;
            {
                this.delegate = VariantColumn.this.arrayDictionary.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.delegate.hasNext();
            }

            @Override
            public Object[] next() {
                int[] next = this.delegate.next();
                Object[] nextArray = new Object[next.length];
                for (int i = 0; i < nextArray.length; ++i) {
                    nextArray[i] = this.lookupId(next[i]);
                }
                return nextArray;
            }

            @Nullable
            private Object lookupId(int id) {
                if (id == 0) {
                    return null;
                }
                int adjustLongId = VariantColumn.this.stringDictionary.size();
                int adjustDoubleId = VariantColumn.this.stringDictionary.size() + VariantColumn.this.longDictionary.size();
                if (id < adjustLongId) {
                    return StringUtils.fromUtf8Nullable((ByteBuffer)VariantColumn.this.stringDictionary.get(id));
                }
                if (id < adjustDoubleId) {
                    return VariantColumn.this.longDictionary.get(id - adjustLongId);
                }
                if (id < adjustDoubleId + VariantColumn.this.doubleDictionary.size()) {
                    return VariantColumn.this.doubleDictionary.get(id - adjustDoubleId);
                }
                throw new IAE("Unknown id [%s]", id);
            }
        };
        return new Indexed<Object[]>(){

            @Override
            public int size() {
                return VariantColumn.this.arrayDictionary.size();
            }

            @Override
            @Nullable
            public Object[] get(int index) {
                throw new UnsupportedOperationException("get not supported");
            }

            @Override
            public int indexOf(@Nullable Object[] value) {
                throw new UnsupportedOperationException("indexOf not supported");
            }

            @Override
            public Iterator<Object[]> iterator() {
                return arrays.iterator();
            }

            @Override
            public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
            }
        };
    }

    @Override
    public SortedMap<String, FieldTypeInfo.MutableTypeSet> getFieldTypeInfo() {
        if (this.variantTypes != null) {
            FieldTypeInfo.MutableTypeSet rootOnlyType = new FieldTypeInfo.MutableTypeSet(this.variantTypes.getByteValue());
            TreeMap<String, FieldTypeInfo.MutableTypeSet> fields = new TreeMap<String, FieldTypeInfo.MutableTypeSet>();
            fields.put("$", rootOnlyType);
            return fields;
        }
        FieldTypeInfo.MutableTypeSet rootOnlyType = new FieldTypeInfo.MutableTypeSet().add(this.getLogicalType());
        TreeMap<String, FieldTypeInfo.MutableTypeSet> fields = new TreeMap<String, FieldTypeInfo.MutableTypeSet>();
        fields.put("$", rootOnlyType);
        return fields;
    }

    @Override
    public int length() {
        return this.encodedValueColumn.size();
    }

    @Override
    public boolean hasMultipleValues() {
        return false;
    }

    @Override
    public int getSingleValueRow(int rowNum) {
        return this.encodedValueColumn.get(rowNum);
    }

    @Override
    public IndexedInts getMultiValueRow(int rowNum) {
        throw new IllegalStateException("Multi-value row not supported");
    }

    @Override
    @Nullable
    public String lookupName(int id) {
        if (id < this.stringDictionary.size()) {
            return StringUtils.fromUtf8Nullable((ByteBuffer)this.stringDictionary.get(id));
        }
        if (id < this.stringDictionary.size() + this.longDictionary.size()) {
            return String.valueOf(this.longDictionary.get(id - this.adjustLongId));
        }
        if (id < this.stringDictionary.size() + this.longDictionary.size() + this.doubleDictionary.size()) {
            return String.valueOf(this.doubleDictionary.get(id - this.adjustDoubleId));
        }
        return null;
    }

    @Override
    public int lookupId(String val) {
        if (val == null) {
            return 0;
        }
        int candidate = this.stringDictionary.indexOf((ByteBuffer)StringUtils.toUtf8ByteBuffer(val));
        if (candidate >= 0) {
            return candidate;
        }
        Long l = GuavaUtils.tryParseLong(val);
        if (l != null && (candidate = this.longDictionary.indexOf(l)) >= 0) {
            return candidate += this.adjustLongId;
        }
        Double d = Doubles.tryParse((String)val);
        if (d != null && (candidate = this.doubleDictionary.indexOf(d)) >= 0) {
            return candidate += this.adjustDoubleId;
        }
        return -1;
    }

    public IntSet lookupIds(String val) {
        Double d;
        Long l;
        IntArraySet intList = new IntArraySet(3);
        if (val == null) {
            intList.add(0);
            return intList;
        }
        int candidate = this.stringDictionary.indexOf((ByteBuffer)StringUtils.toUtf8ByteBuffer(val));
        if (candidate >= 0) {
            intList.add(candidate);
        }
        if ((l = GuavaUtils.tryParseLong(val)) != null && (candidate = this.longDictionary.indexOf(l)) >= 0) {
            intList.add(candidate += this.adjustLongId);
        }
        if ((d = Doubles.tryParse((String)val)) != null && (candidate = this.doubleDictionary.indexOf(d)) >= 0) {
            intList.add(candidate += this.adjustDoubleId);
        }
        return intList;
    }

    @Override
    public int getCardinality() {
        if (this.logicalType.isArray() && this.variantTypes == null) {
            return this.arrayDictionary.size();
        }
        return this.stringDictionary.size() + this.longDictionary.size() + this.doubleDictionary.size() + this.arrayDictionary.size();
    }

    @Override
    public DimensionSelector makeDimensionSelector(final ReadableOffset offset, final @Nullable ExtractionFn extractionFn) {
        if (this.variantTypes == null && this.logicalType.isArray()) {
            throw new IAE("Dimension selector is currently unsupported for [%s]", this.logicalType);
        }
        class StringDimensionSelector
        extends AbstractDimensionSelector
        implements SingleValueHistoricalDimensionSelector,
        IdLookup {
            private final SingleIndexedInt row = new SingleIndexedInt();

            StringDimensionSelector() {
            }

            @Override
            public IndexedInts getRow() {
                this.row.setValue(this.getRowValue());
                return this.row;
            }

            public int getRowValue() {
                return VariantColumn.this.encodedValueColumn.get(offset.getOffset());
            }

            @Override
            public float getFloat() {
                int id = this.getRowValue();
                if (id == 0) {
                    return 0.0f;
                }
                if (id < VariantColumn.this.adjustLongId) {
                    Float f = Floats.tryParse((String)StringUtils.fromUtf8((ByteBuffer)VariantColumn.this.stringDictionary.get(id)));
                    return f == null ? 0.0f : f.floatValue();
                }
                if (id < VariantColumn.this.adjustDoubleId) {
                    return VariantColumn.this.longDictionary.get(id - VariantColumn.this.adjustLongId).floatValue();
                }
                return VariantColumn.this.doubleDictionary.get(id - VariantColumn.this.adjustDoubleId).floatValue();
            }

            @Override
            public double getDouble() {
                int id = this.getRowValue();
                if (id == 0) {
                    return 0.0;
                }
                if (id < VariantColumn.this.adjustLongId) {
                    Double d = Doubles.tryParse((String)StringUtils.fromUtf8((ByteBuffer)VariantColumn.this.stringDictionary.get(id)));
                    return d == null ? 0.0 : d;
                }
                if (id < VariantColumn.this.adjustDoubleId) {
                    return VariantColumn.this.longDictionary.get(id - VariantColumn.this.adjustLongId).doubleValue();
                }
                return VariantColumn.this.doubleDictionary.get(id - VariantColumn.this.adjustDoubleId);
            }

            @Override
            public long getLong() {
                int id = this.getRowValue();
                if (id == 0) {
                    return 0L;
                }
                if (id < VariantColumn.this.adjustLongId) {
                    Long l = GuavaUtils.tryParseLong(StringUtils.fromUtf8((ByteBuffer)VariantColumn.this.stringDictionary.get(id)));
                    return l == null ? 0L : l;
                }
                if (id < VariantColumn.this.adjustDoubleId) {
                    return VariantColumn.this.longDictionary.get(id - VariantColumn.this.adjustLongId);
                }
                return VariantColumn.this.doubleDictionary.get(id - VariantColumn.this.adjustDoubleId).longValue();
            }

            @Override
            public boolean isNull() {
                if (this.getRowValue() == 0) {
                    return true;
                }
                return DimensionHandlerUtils.isNumericNull(this.getObject());
            }

            @Override
            public IndexedInts getRow(int offset2) {
                this.row.setValue(this.getRowValue(offset2));
                return this.row;
            }

            @Override
            public int getRowValue(int offset2) {
                return VariantColumn.this.encodedValueColumn.get(offset2);
            }

            @Override
            public ValueMatcher makeValueMatcher(@Nullable String value) {
                if (extractionFn == null) {
                    final IntSet valueIds = VariantColumn.this.lookupIds(value);
                    if (valueIds.size() > 0) {
                        return new ValueMatcher(){

                            @Override
                            public boolean matches(boolean includeUnknown) {
                                int rowId = this.getRowValue();
                                return includeUnknown && rowId == 0 || valueIds.contains(this.getRowValue());
                            }

                            @Override
                            public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                                inspector.visit("column", VariantColumn.this);
                            }
                        };
                    }
                    return new ValueMatcher(){

                        @Override
                        public boolean matches(boolean includeUnknown) {
                            return includeUnknown && this.getRowValue() == 0;
                        }

                        @Override
                        public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                            inspector.visit("column", VariantColumn.this);
                        }
                    };
                }
                return this.makeValueMatcher(StringPredicateDruidPredicateFactory.equalTo(value));
            }

            @Override
            public ValueMatcher makeValueMatcher(DruidPredicateFactory predicateFactory) {
                final BitSet checkedIds = new BitSet(VariantColumn.this.getCardinality());
                final BitSet matchingIds = new BitSet(VariantColumn.this.getCardinality());
                final DruidObjectPredicate<String> predicate = predicateFactory.makeStringPredicate();
                return new ValueMatcher(){

                    @Override
                    public boolean matches(boolean includeUnknown) {
                        int id = this.getRowValue();
                        if (checkedIds.get(id)) {
                            return matchingIds.get(id);
                        }
                        boolean matches = predicate.apply(this.lookupName(id)).matches(includeUnknown);
                        checkedIds.set(id);
                        if (matches) {
                            matchingIds.set(id);
                        }
                        return matches;
                    }

                    @Override
                    public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                        inspector.visit("column", VariantColumn.this);
                    }
                };
            }

            @Override
            public Object getObject() {
                return VariantColumn.this.lookupName(this.getRowValue());
            }

            @Override
            public Class classOfObject() {
                return String.class;
            }

            @Override
            public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                inspector.visit("column", VariantColumn.this.encodedValueColumn);
                inspector.visit("offset", offset);
                inspector.visit("extractionFn", extractionFn);
            }

            @Override
            public int getValueCardinality() {
                return VariantColumn.this.getCardinality();
            }

            @Override
            public String lookupName(int id) {
                String value = VariantColumn.this.lookupName(id);
                return extractionFn == null ? value : extractionFn.apply(value);
            }

            @Override
            public boolean nameLookupPossibleInAdvance() {
                return true;
            }

            @Override
            @Nullable
            public IdLookup idLookup() {
                return extractionFn == null ? this : null;
            }

            @Override
            public int lookupId(String name) {
                if (extractionFn == null) {
                    return VariantColumn.this.lookupId(name);
                }
                throw new UnsupportedOperationException("cannot perform lookup when applying an extraction function");
            }
        }
        return new StringDimensionSelector();
    }

    @Override
    public ColumnValueSelector<?> makeColumnValueSelector(final ReadableOffset offset) {
        return new ColumnValueSelector<Object>(){
            private PeekableIntIterator nullIterator;
            private int nullMark;
            private int offsetMark;
            {
                this.nullIterator = VariantColumn.this.nullValueBitmap.peekableIterator();
                this.nullMark = -1;
                this.offsetMark = -1;
            }

            @Override
            @Nullable
            public Object getObject() {
                int id = VariantColumn.this.encodedValueColumn.get(offset.getOffset());
                if (id < VariantColumn.this.adjustArrayId) {
                    return VariantColumn.this.lookupScalarValue(id);
                }
                int[] arr = VariantColumn.this.arrayDictionary.get(id - VariantColumn.this.adjustArrayId);
                if (arr == null) {
                    return null;
                }
                Object[] array = new Object[arr.length];
                for (int i = 0; i < arr.length; ++i) {
                    array[i] = VariantColumn.this.lookupScalarValue(arr[i]);
                }
                return array;
            }

            @Override
            public float getFloat() {
                int id = VariantColumn.this.encodedValueColumn.get(offset.getOffset());
                if (id == 0) {
                    return 0.0f;
                }
                if (id < VariantColumn.this.adjustLongId) {
                    Float f = Floats.tryParse((String)StringUtils.fromUtf8((ByteBuffer)VariantColumn.this.stringDictionary.get(id)));
                    return f == null ? 0.0f : f.floatValue();
                }
                if (id < VariantColumn.this.adjustDoubleId) {
                    return VariantColumn.this.longDictionary.get(id - VariantColumn.this.adjustLongId).floatValue();
                }
                if (id < VariantColumn.this.adjustArrayId) {
                    return VariantColumn.this.doubleDictionary.get(id - VariantColumn.this.adjustDoubleId).floatValue();
                }
                return 0.0f;
            }

            @Override
            public double getDouble() {
                int id = VariantColumn.this.encodedValueColumn.get(offset.getOffset());
                if (id == 0) {
                    return 0.0;
                }
                if (id < VariantColumn.this.adjustLongId) {
                    Double d = Doubles.tryParse((String)StringUtils.fromUtf8((ByteBuffer)VariantColumn.this.stringDictionary.get(id)));
                    return d == null ? 0.0 : d;
                }
                if (id < VariantColumn.this.adjustDoubleId) {
                    return VariantColumn.this.longDictionary.get(id - VariantColumn.this.adjustLongId).doubleValue();
                }
                if (id < VariantColumn.this.adjustArrayId) {
                    return VariantColumn.this.doubleDictionary.get(id - VariantColumn.this.adjustDoubleId);
                }
                return 0.0;
            }

            @Override
            public long getLong() {
                int id = VariantColumn.this.encodedValueColumn.get(offset.getOffset());
                if (id == 0) {
                    return 0L;
                }
                if (id < VariantColumn.this.adjustLongId) {
                    Long l = GuavaUtils.tryParseLong(StringUtils.fromUtf8((ByteBuffer)VariantColumn.this.stringDictionary.get(id)));
                    return l == null ? 0L : l;
                }
                if (id < VariantColumn.this.adjustDoubleId) {
                    return VariantColumn.this.longDictionary.get(id - VariantColumn.this.adjustLongId);
                }
                if (id < VariantColumn.this.adjustArrayId) {
                    return VariantColumn.this.doubleDictionary.get(id - VariantColumn.this.adjustDoubleId).longValue();
                }
                return 0L;
            }

            @Override
            public boolean isNull() {
                int i = offset.getOffset();
                if (i < this.offsetMark) {
                    this.nullMark = -1;
                    this.nullIterator = VariantColumn.this.nullValueBitmap.peekableIterator();
                }
                this.offsetMark = i;
                if (this.nullMark < i) {
                    this.nullIterator.advanceIfNeeded(this.offsetMark);
                    if (this.nullIterator.hasNext()) {
                        this.nullMark = this.nullIterator.next();
                    }
                }
                if (this.nullMark == this.offsetMark) {
                    return true;
                }
                int id = VariantColumn.this.encodedValueColumn.get(offset.getOffset());
                if (id == 0) {
                    return true;
                }
                if (id < VariantColumn.this.adjustLongId) {
                    String value = StringUtils.fromUtf8Nullable((ByteBuffer)VariantColumn.this.stringDictionary.get(id));
                    return GuavaUtils.tryParseLong(value) == null && Doubles.tryParse((String)value) == null;
                }
                return id >= VariantColumn.this.adjustArrayId;
            }

            @Override
            public Class<?> classOfObject() {
                return Object.class;
            }

            @Override
            public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                inspector.visit("encodedValueColumn", VariantColumn.this.encodedValueColumn);
            }
        };
    }

    @Override
    public SingleValueDimensionVectorSelector makeSingleValueDimensionVectorSelector(final ReadableVectorOffset offset) {
        final class StringVectorSelector
        extends StringUtf8DictionaryEncodedColumn.StringSingleValueDimensionVectorSelector {
            public StringVectorSelector() {
                super(VariantColumn.this.encodedValueColumn, readableVectorOffset);
            }

            @Override
            public int getValueCardinality() {
                return VariantColumn.this.getCardinality();
            }

            @Override
            @Nullable
            public String lookupName(int id) {
                return VariantColumn.this.lookupName(id);
            }

            @Override
            public int lookupId(@Nullable String name) {
                return VariantColumn.this.lookupId(name);
            }
        }
        return new StringVectorSelector();
    }

    @Override
    public MultiValueDimensionVectorSelector makeMultiValueDimensionVectorSelector(ReadableVectorOffset vectorOffset) {
        throw new UnsupportedOperationException();
    }

    @Override
    public VectorValueSelector makeVectorValueSelector(ReadableVectorOffset offset) {
        if (FieldTypeInfo.convertToSet(this.variantTypes.getByteValue()).stream().allMatch(x -> x.isNumeric())) {
            return new BaseDoubleVectorValueSelector(offset){
                private final double[] valueVector;
                private final int[] idVector;
                @Nullable
                private boolean[] nullVector;
                private int id;
                @Nullable
                private PeekableIntIterator nullIterator;
                private int offsetMark;
                {
                    this.valueVector = new double[this.offset.getMaxVectorSize()];
                    this.idVector = new int[this.offset.getMaxVectorSize()];
                    this.nullVector = null;
                    this.id = -1;
                    this.nullIterator = VariantColumn.this.nullValueBitmap != null ? VariantColumn.this.nullValueBitmap.peekableIterator() : null;
                    this.offsetMark = -1;
                }

                @Override
                public double[] getDoubleVector() {
                    this.computeVectorsIfNeeded();
                    return this.valueVector;
                }

                @Override
                @Nullable
                public boolean[] getNullVector() {
                    this.computeVectorsIfNeeded();
                    return this.nullVector;
                }

                private void computeVectorsIfNeeded() {
                    if (this.id == this.offset.getId()) {
                        return;
                    }
                    if (this.offset.isContiguous()) {
                        if (this.offset.getStartOffset() < this.offsetMark) {
                            this.nullIterator = VariantColumn.this.nullValueBitmap.peekableIterator();
                        }
                        this.offsetMark = this.offset.getStartOffset() + this.offset.getCurrentVectorSize();
                        VariantColumn.this.encodedValueColumn.get(this.idVector, this.offset.getStartOffset(), this.offset.getCurrentVectorSize());
                    } else {
                        int[] offsets = this.offset.getOffsets();
                        if (offsets[offsets.length - 1] < this.offsetMark) {
                            this.nullIterator = VariantColumn.this.nullValueBitmap.peekableIterator();
                        }
                        this.offsetMark = offsets[offsets.length - 1];
                        VariantColumn.this.encodedValueColumn.get(this.idVector, offsets, this.offset.getCurrentVectorSize());
                    }
                    for (int i = 0; i < this.offset.getCurrentVectorSize(); ++i) {
                        int dictId = this.idVector[i];
                        this.valueVector[i] = dictId == 0 ? 0.0 : (dictId < VariantColumn.this.adjustDoubleId ? VariantColumn.this.longDictionary.get(dictId - VariantColumn.this.adjustLongId).doubleValue() : VariantColumn.this.doubleDictionary.get(dictId - VariantColumn.this.adjustDoubleId).doubleValue());
                    }
                    if (this.nullIterator != null) {
                        this.nullVector = VectorSelectorUtils.populateNullVector(this.nullVector, this.offset, this.nullIterator);
                    }
                    this.id = this.offset.getId();
                }
            };
        }
        throw DruidException.defensive("Cannot make vector value selector for variant typed [%s] column", this.variantTypes);
    }

    @Override
    public VectorObjectSelector makeVectorObjectSelector(ReadableVectorOffset offset) {
        return new VariantVectorObjectSelector(offset, this.encodedValueColumn, this.arrayDictionary, this.logicalExpressionType, this.adjustArrayId){

            @Override
            public int adjustDictionaryId(int id) {
                return id;
            }

            @Override
            @Nullable
            public Object lookupScalarValue(int dictionaryId) {
                return VariantColumn.this.lookupScalarValue(dictionaryId);
            }

            @Override
            @Nullable
            public Object lookupScalarValueAndCast(int dictionaryId) {
                return VariantColumn.this.lookupScalarValueAndCast(dictionaryId);
            }
        };
    }

    @Override
    public void close() throws IOException {
        this.encodedValueColumn.close();
    }

    @Nullable
    private Object lookupScalarValueAndCast(int id) {
        if (id == 0) {
            return null;
        }
        if (this.variantTypes == null) {
            return this.lookupScalarValue(id);
        }
        ExprEval eval = ExprEval.ofType(this.logicalExpressionType, this.lookupScalarValue(id));
        return eval.value();
    }

    @Nullable
    private Object lookupScalarValue(int id) {
        if (id < this.adjustLongId) {
            return StringUtils.fromUtf8Nullable((ByteBuffer)this.stringDictionary.get(id));
        }
        if (id < this.adjustDoubleId) {
            return this.longDictionary.get(id - this.adjustLongId);
        }
        if (id < this.adjustArrayId) {
            return this.doubleDictionary.get(id - this.adjustDoubleId);
        }
        throw new IllegalArgumentException("not a scalar in the dictionary");
    }

    @Override
    @Nullable
    public <T> T as(Class<? extends T> clazz) {
        return (T)AS_MAP.getOrDefault(clazz, arg -> null).apply(this);
    }

    public static abstract class VariantVectorObjectSelector
    implements VectorObjectSelector {
        private final int[] vector;
        private final Object[] objects;
        private int offsetId = -1;
        private final ReadableVectorOffset offset;
        private final ColumnarInts encodedValueColumn;
        private final FrontCodedIntArrayIndexed arrayDictionary;
        private final ExpressionType logicalExpressionType;
        private final int adjustArrayId;

        protected VariantVectorObjectSelector(ReadableVectorOffset offset, ColumnarInts encodedValueColumn, FrontCodedIntArrayIndexed arrayDictionary, ExpressionType logicalExpressionType, int adjustArrayId) {
            this.offset = offset;
            this.encodedValueColumn = encodedValueColumn;
            this.arrayDictionary = arrayDictionary;
            this.logicalExpressionType = logicalExpressionType;
            this.adjustArrayId = adjustArrayId;
            this.objects = new Object[offset.getMaxVectorSize()];
            this.vector = new int[offset.getMaxVectorSize()];
        }

        public abstract int adjustDictionaryId(int var1);

        @Nullable
        public abstract Object lookupScalarValue(int var1);

        @Nullable
        public abstract Object lookupScalarValueAndCast(int var1);

        @Override
        public Object[] getObjectVector() {
            if (this.offsetId == this.offset.getId()) {
                return this.objects;
            }
            if (this.offset.isContiguous()) {
                this.encodedValueColumn.get(this.vector, this.offset.getStartOffset(), this.offset.getCurrentVectorSize());
            } else {
                this.encodedValueColumn.get(this.vector, this.offset.getOffsets(), this.offset.getCurrentVectorSize());
            }
            for (int i = 0; i < this.offset.getCurrentVectorSize(); ++i) {
                int dictionaryId = this.adjustDictionaryId(this.vector[i]);
                if (dictionaryId < this.adjustArrayId) {
                    this.objects[i] = this.lookupScalarValueAndCast(dictionaryId);
                    continue;
                }
                int[] arr = this.arrayDictionary.get(dictionaryId - this.adjustArrayId);
                if (arr == null) {
                    this.objects[i] = null;
                    continue;
                }
                Object[] array = new Object[arr.length];
                for (int j = 0; j < arr.length; ++j) {
                    array[j] = this.lookupScalarValue(arr[j]);
                }
                this.objects[i] = ExprEval.ofType(this.logicalExpressionType, array).asArray();
            }
            this.offsetId = this.offset.getId();
            return this.objects;
        }

        @Override
        public int getMaxVectorSize() {
            return this.offset.getMaxVectorSize();
        }

        @Override
        public int getCurrentVectorSize() {
            return this.offset.getCurrentVectorSize();
        }
    }
}

