/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.serde.cell;

import com.google.common.base.Preconditions;
import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.druid.java.util.common.io.Closer;
import org.apache.druid.segment.data.CompressionStrategy;
import org.apache.druid.segment.serde.cell.BlockCompressedPayloadSerializer;
import org.apache.druid.segment.serde.cell.BlockIndexWriter;
import org.apache.druid.segment.writeout.WriteOutBytes;

public class BlockCompressedPayloadBuffer
implements Closeable {
    private final ByteBuffer currentBlock;
    private final ByteBuffer compressedByteBuffer;
    private final BlockIndexWriter blockIndexWriter;
    private final WriteOutBytes dataOutBytes;
    private final Closer closer;
    private final CompressionStrategy.Compressor compressor;
    private boolean open = true;

    public BlockCompressedPayloadBuffer(ByteBuffer currentBlock, ByteBuffer compressedByteBuffer, BlockIndexWriter blockIndexWriter, WriteOutBytes dataOutBytes, Closer closer, CompressionStrategy.Compressor compressor) {
        currentBlock.clear();
        compressedByteBuffer.clear();
        this.currentBlock = currentBlock;
        this.compressedByteBuffer = compressedByteBuffer;
        this.closer = closer;
        this.blockIndexWriter = blockIndexWriter;
        this.dataOutBytes = dataOutBytes;
        this.compressor = compressor;
    }

    public void write(byte[] payload) throws IOException {
        Preconditions.checkNotNull((Object)payload);
        this.write(ByteBuffer.wrap(payload).order(ByteOrder.nativeOrder()));
    }

    public void write(ByteBuffer masterPayload) throws IOException {
        Preconditions.checkNotNull((Object)masterPayload);
        Preconditions.checkState((boolean)this.open, (Object)"cannot write to closed BlockCompressedPayloadWriter");
        ByteBuffer payload = masterPayload.asReadOnlyBuffer().order(masterPayload.order());
        while (payload.hasRemaining()) {
            int writeSize = Math.min(payload.remaining(), this.currentBlock.remaining());
            payload.limit(payload.position() + writeSize);
            this.currentBlock.put(payload);
            if (!this.currentBlock.hasRemaining()) {
                this.flush();
            }
            payload.limit(masterPayload.limit());
        }
    }

    @Override
    public void close() throws IOException {
        this.closer.close();
    }

    public BlockCompressedPayloadSerializer closeToSerializer() throws IOException {
        if (this.open) {
            if (this.currentBlock.position() > 0) {
                this.flush();
            }
            this.blockIndexWriter.close();
            this.closer.close();
            this.open = false;
        }
        return new BlockCompressedPayloadSerializer(this.blockIndexWriter, this.dataOutBytes);
    }

    private void flush() throws IOException {
        Preconditions.checkState((boolean)this.open, (Object)"flush() on closed BlockCompressedPayloadWriter");
        this.currentBlock.flip();
        ByteBuffer actualCompressedByteBuffer = this.compressor.compress(this.currentBlock, this.compressedByteBuffer);
        int compressedBlockSize = actualCompressedByteBuffer.limit();
        this.blockIndexWriter.persistAndIncrement(compressedBlockSize);
        this.dataOutBytes.write(actualCompressedByteBuffer);
        this.currentBlock.clear();
        this.compressedByteBuffer.clear();
    }
}

