/*
 * Decompiled with CFR 0.152.
 */
package org.skife.jdbi.v2;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.skife.jdbi.v2.BuiltInArgumentFactory;
import org.skife.jdbi.v2.StatementContext;
import org.skife.jdbi.v2.tweak.Argument;
import org.skife.jdbi.v2.tweak.ArgumentFactory;

class Foreman {
    private final List<ArgumentFactory> factories = new CopyOnWriteArrayList<ArgumentFactory>();
    private static final ArgumentFactory BUILT_INS = new BuiltInArgumentFactory();

    public Foreman() {
        this.factories.add(BUILT_INS);
    }

    public Foreman(List<ArgumentFactory> factories) {
        this.factories.addAll(factories);
    }

    Argument waffle(Class expectedType, Object it, StatementContext ctx) {
        ArgumentFactory candidate = null;
        for (int i = this.factories.size() - 1; i >= 0; --i) {
            ArgumentFactory factory = this.factories.get(i);
            if (factory.accepts(expectedType, it, ctx)) {
                return factory.build(expectedType, it, ctx);
            }
            if (candidate != null || !factory.accepts(Object.class, it, ctx)) continue;
            candidate = factory;
        }
        if (candidate != null) {
            return candidate.build(Object.class, it, ctx);
        }
        throw new IllegalStateException("Unbindable argument passed: " + String.valueOf(it));
    }

    public void register(ArgumentFactory<?> argumentFactory) {
        this.factories.add(argumentFactory);
    }

    public Foreman createChild() {
        return new Foreman(this.factories);
    }
}

