/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.dart.controller;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import it.unimi.dsi.fastutil.ints.Int2ObjectAVLTreeMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.druid.common.guava.FutureUtils;
import org.apache.druid.error.DruidException;
import org.apache.druid.indexer.TaskState;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.msq.dart.worker.DartWorkerClient;
import org.apache.druid.msq.exec.WorkerManager;
import org.apache.druid.msq.exec.WorkerStats;
import org.apache.druid.msq.indexing.WorkerCount;
import org.apache.druid.utils.CloseableUtils;

public class DartWorkerManager
implements WorkerManager {
    private static final Logger log = new Logger(DartWorkerManager.class);
    private final List<String> workerIds;
    private final DartWorkerClient workerClient;
    private final Object2IntMap<String> workerIdToNumber;
    private final AtomicReference<State> state = new AtomicReference<State>(State.NEW);
    private final SettableFuture<?> stopFuture = SettableFuture.create();

    public DartWorkerManager(List<String> workerIds, DartWorkerClient workerClient) {
        this.workerIds = workerIds;
        this.workerClient = workerClient;
        this.workerIdToNumber = new Object2IntOpenHashMap();
        this.workerIdToNumber.defaultReturnValue(-1);
        for (int i = 0; i < workerIds.size(); ++i) {
            this.workerIdToNumber.put((Object)workerIds.get(i), i);
        }
    }

    @Override
    public ListenableFuture<?> start() {
        if (!this.state.compareAndSet(State.NEW, State.STARTED)) {
            throw new ISE("Cannot start from state[%s]", new Object[]{this.state.get()});
        }
        return this.stopFuture;
    }

    @Override
    public void launchWorkersIfNeeded(int workerCount) {
        if (workerCount > this.workerIds.size()) {
            throw DruidException.defensive((String)"Desired workerCount[%s] must be less than or equal to actual workerCount[%s]", (Object[])new Object[]{workerCount, this.workerIds.size()});
        }
    }

    @Override
    public void waitForWorkers(Set<Integer> workerNumbers) {
        for (int workerNumber : workerNumbers) {
            if (workerNumber < this.workerIds.size()) continue;
            throw DruidException.defensive((String)"Desired workerNumber[%s] must be less than workerCount[%s]", (Object[])new Object[]{workerNumber, this.workerIds.size()});
        }
    }

    @Override
    public List<String> getWorkerIds() {
        return this.workerIds;
    }

    @Override
    public WorkerCount getWorkerCount() {
        return new WorkerCount(this.workerIds.size(), 0);
    }

    @Override
    public int getWorkerNumber(String workerId) {
        return this.workerIdToNumber.getInt((Object)workerId);
    }

    @Override
    public boolean isWorkerActive(String workerId) {
        return this.workerIdToNumber.containsKey((Object)workerId);
    }

    @Override
    public Map<Integer, List<WorkerStats>> getWorkerStats() {
        Int2ObjectAVLTreeMap retVal = new Int2ObjectAVLTreeMap();
        for (int i = 0; i < this.workerIds.size(); ++i) {
            retVal.put(i, Collections.singletonList(new WorkerStats(this.workerIds.get(i), TaskState.RUNNING, -1L, -1L)));
        }
        return retVal;
    }

    @Override
    public void stop(boolean interrupt) {
        if (this.state.compareAndSet(State.STARTED, State.STOPPED)) {
            if (interrupt) {
                ArrayList futures = new ArrayList();
                for (String workerId : this.workerIds) {
                    futures.add(this.workerClient.stopWorker(workerId));
                }
                try {
                    FutureUtils.getUnchecked((ListenableFuture)Futures.successfulAsList(futures), (boolean)false);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            CloseableUtils.closeAndSuppressExceptions((Closeable)this.workerClient, e -> log.warn(e, "Failed to close workerClient", new Object[0]));
            this.stopFuture.set(null);
        }
    }

    static enum State {
        NEW,
        STARTED,
        STOPPED;

    }
}

