/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.dart.worker;

import org.apache.druid.rpc.ServiceRetryPolicy;
import org.apache.druid.rpc.StandardRetryPolicy;
import org.jboss.netty.handler.codec.http.HttpResponse;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;

public class DartWorkerRetryPolicy
implements ServiceRetryPolicy {
    private final boolean retryOnWorkerUnavailable;

    public DartWorkerRetryPolicy(boolean retryOnWorkerUnavailable) {
        this.retryOnWorkerUnavailable = retryOnWorkerUnavailable;
    }

    public long maxAttempts() {
        return StandardRetryPolicy.unlimited().maxAttempts();
    }

    public long minWaitMillis() {
        return StandardRetryPolicy.unlimited().minWaitMillis();
    }

    public long maxWaitMillis() {
        return StandardRetryPolicy.unlimited().maxWaitMillis();
    }

    public boolean retryHttpResponse(HttpResponse response) {
        if (this.retryOnWorkerUnavailable) {
            return HttpResponseStatus.SERVICE_UNAVAILABLE.equals((Object)response.getStatus());
        }
        return false;
    }

    public boolean retryThrowable(Throwable t) {
        return StandardRetryPolicy.unlimited().retryThrowable(t);
    }

    public boolean retryLoggable() {
        return false;
    }

    public boolean retryNotAvailable() {
        return false;
    }
}

