/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.indexing;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import javax.annotation.Nullable;
import org.apache.druid.collections.ResourceHolder;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.msq.exec.DataServerQueryHandlerFactory;
import org.apache.druid.msq.exec.ProcessingBuffers;
import org.apache.druid.msq.exec.WorkerMemoryParameters;
import org.apache.druid.msq.exec.WorkerStorageParameters;
import org.apache.druid.msq.indexing.IndexerWorkerContext;
import org.apache.druid.msq.kernel.FrameContext;
import org.apache.druid.msq.kernel.StageId;
import org.apache.druid.msq.querykit.DataSegmentProvider;
import org.apache.druid.query.groupby.GroupingEngine;
import org.apache.druid.segment.IndexIO;
import org.apache.druid.segment.IndexMergerV9;
import org.apache.druid.segment.SegmentWrangler;
import org.apache.druid.segment.incremental.RowIngestionMeters;
import org.apache.druid.segment.loading.DataSegmentPusher;

public class IndexerFrameContext
implements FrameContext {
    private final StageId stageId;
    private final IndexerWorkerContext context;
    private final IndexIO indexIO;
    private final DataSegmentProvider dataSegmentProvider;
    @Nullable
    private final ResourceHolder<ProcessingBuffers> processingBuffers;
    private final WorkerMemoryParameters memoryParameters;
    private final WorkerStorageParameters storageParameters;
    private final DataServerQueryHandlerFactory dataServerQueryHandlerFactory;

    public IndexerFrameContext(StageId stageId, IndexerWorkerContext context, IndexIO indexIO, DataSegmentProvider dataSegmentProvider, @Nullable ResourceHolder<ProcessingBuffers> processingBuffers, DataServerQueryHandlerFactory dataServerQueryHandlerFactory, WorkerMemoryParameters memoryParameters, WorkerStorageParameters storageParameters) {
        this.stageId = stageId;
        this.context = context;
        this.indexIO = indexIO;
        this.dataSegmentProvider = dataSegmentProvider;
        this.processingBuffers = processingBuffers;
        this.memoryParameters = memoryParameters;
        this.storageParameters = storageParameters;
        this.dataServerQueryHandlerFactory = dataServerQueryHandlerFactory;
    }

    @Override
    public SegmentWrangler segmentWrangler() {
        return (SegmentWrangler)this.context.injector().getInstance(SegmentWrangler.class);
    }

    @Override
    public GroupingEngine groupingEngine() {
        return (GroupingEngine)this.context.injector().getInstance(GroupingEngine.class);
    }

    @Override
    public RowIngestionMeters rowIngestionMeters() {
        return this.context.toolbox().getRowIngestionMetersFactory().createRowIngestionMeters();
    }

    @Override
    public DataSegmentProvider dataSegmentProvider() {
        return this.dataSegmentProvider;
    }

    @Override
    public DataServerQueryHandlerFactory dataServerQueryHandlerFactory() {
        return this.dataServerQueryHandlerFactory;
    }

    @Override
    public File tempDir() {
        return new File(this.context.tempDir(), StringUtils.format((String)"stage_%06d", (Object[])new Object[]{this.stageId.getStageNumber()}));
    }

    @Override
    public ObjectMapper jsonMapper() {
        return this.context.jsonMapper();
    }

    @Override
    public IndexIO indexIO() {
        return this.indexIO;
    }

    @Override
    public File persistDir() {
        return this.context.toolbox().getPersistDir();
    }

    @Override
    public DataSegmentPusher segmentPusher() {
        return this.context.toolbox().getSegmentPusher();
    }

    @Override
    public IndexMergerV9 indexMerger() {
        return this.context.toolbox().getIndexMergerV9();
    }

    @Override
    public ProcessingBuffers processingBuffers() {
        if (this.processingBuffers != null) {
            return (ProcessingBuffers)this.processingBuffers.get();
        }
        throw new ISE("No processing buffers", new Object[0]);
    }

    @Override
    public WorkerMemoryParameters memoryParameters() {
        return this.memoryParameters;
    }

    @Override
    public WorkerStorageParameters storageParameters() {
        return this.storageParameters;
    }

    @Override
    public void close() {
        if (this.processingBuffers != null) {
            this.processingBuffers.close();
        }
    }
}

