/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.indexing.error;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.List;
import java.util.Objects;
import org.apache.druid.msq.indexing.error.BaseMSQFault;
import org.joda.time.Interval;

@JsonTypeName(value="InsertTimeOutOfBounds")
public class InsertTimeOutOfBoundsFault
extends BaseMSQFault {
    static final String CODE = "InsertTimeOutOfBounds";
    private final Interval interval;
    private final List<Interval> intervalBounds;

    public InsertTimeOutOfBoundsFault(@JsonProperty(value="interval") Interval interval, @JsonProperty(value="intervalBounds") List<Interval> intervalBounds) {
        super(CODE, "Inserted data contains time chunk[%s] outside of bounds specified by OVERWRITE WHERE[%s]. If you want to include this data, expand your OVERWRITE WHERE. If you do not want to include this data, use SELECT ... WHERE to filter it from your inserted data.", interval, intervalBounds);
        this.interval = interval;
        this.intervalBounds = intervalBounds;
    }

    @JsonProperty
    public Interval getInterval() {
        return this.interval;
    }

    @JsonProperty
    public List<Interval> getIntervalBounds() {
        return this.intervalBounds;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        InsertTimeOutOfBoundsFault that = (InsertTimeOutOfBoundsFault)o;
        return Objects.equals(this.interval, that.interval) && Objects.equals(this.intervalBounds, that.intervalBounds);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.interval, this.intervalBounds);
    }

    @Override
    public String toString() {
        return "InsertTimeOutOfBoundsFault{interval=" + String.valueOf(this.interval) + ", intervalBounds=" + String.valueOf(this.intervalBounds) + "}";
    }
}

