/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.input;

import com.google.common.base.Preconditions;
import java.util.Iterator;
import javax.annotation.Nullable;
import org.apache.druid.frame.read.FrameReader;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.msq.input.ReadableInput;

public class ReadableInputs
implements Iterable<ReadableInput> {
    private final Iterable<ReadableInput> iterable;
    @Nullable
    private final FrameReader frameReader;

    private ReadableInputs(Iterable<ReadableInput> iterable, @Nullable FrameReader frameReader) {
        this.iterable = (Iterable)Preconditions.checkNotNull(iterable, (Object)"iterable");
        this.frameReader = frameReader;
    }

    public static ReadableInputs channels(Iterable<ReadableInput> iterable, FrameReader frameReader) {
        return new ReadableInputs(iterable, (FrameReader)Preconditions.checkNotNull((Object)frameReader, (Object)"frameReader"));
    }

    public static ReadableInputs segments(Iterable<ReadableInput> iterable) {
        return new ReadableInputs(iterable, null);
    }

    @Override
    public Iterator<ReadableInput> iterator() {
        return this.iterable.iterator();
    }

    public FrameReader frameReader() {
        if (this.frameReader == null) {
            throw new ISE("No frame reader; check hasChannels() first", new Object[0]);
        }
        return this.frameReader;
    }

    public boolean isChannelBased() {
        return this.frameReader != null;
    }
}

