/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.kernel.controller;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import it.unimi.dsi.fastutil.ints.Int2IntAVLTreeMap;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectAVLTreeMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.IntAVLTreeSet;
import it.unimi.dsi.fastutil.ints.IntBidirectionalIterator;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.SortedSet;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.druid.frame.key.ClusterByPartitions;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.msq.exec.OutputChannelMode;
import org.apache.druid.msq.exec.QueryValidator;
import org.apache.druid.msq.indexing.error.MSQException;
import org.apache.druid.msq.indexing.error.MSQFault;
import org.apache.druid.msq.indexing.error.MSQFaultUtils;
import org.apache.druid.msq.indexing.error.WorkerFailedFault;
import org.apache.druid.msq.input.InputSpecSlicerFactory;
import org.apache.druid.msq.input.stage.ReadablePartitions;
import org.apache.druid.msq.kernel.ExtraInfoHolder;
import org.apache.druid.msq.kernel.QueryDefinition;
import org.apache.druid.msq.kernel.StageDefinition;
import org.apache.druid.msq.kernel.StageId;
import org.apache.druid.msq.kernel.WorkOrder;
import org.apache.druid.msq.kernel.WorkerAssignmentStrategy;
import org.apache.druid.msq.kernel.controller.ControllerQueryKernelConfig;
import org.apache.druid.msq.kernel.controller.ControllerQueryKernelUtils;
import org.apache.druid.msq.kernel.controller.ControllerStagePhase;
import org.apache.druid.msq.kernel.controller.ControllerStageTracker;
import org.apache.druid.msq.kernel.controller.StageGroup;
import org.apache.druid.msq.kernel.controller.WorkerInputs;
import org.apache.druid.msq.statistics.ClusterByStatisticsSnapshot;
import org.apache.druid.msq.statistics.CompleteKeyStatisticsInformation;
import org.apache.druid.msq.statistics.PartialKeyStatisticsInformation;

public class ControllerQueryKernel {
    private static final Logger log = new Logger(ControllerQueryKernel.class);
    private final QueryDefinition queryDef;
    private final ControllerQueryKernelConfig config;
    private final Map<StageId, ControllerStageTracker> stageTrackers = new HashMap<StageId, ControllerStageTracker>();
    private final ImmutableMap<StageId, Set<StageId>> inflowMap;
    private final ImmutableMap<StageId, Set<StageId>> outflowMap;
    private final Map<StageId, SortedSet<StageId>> pendingInflowMap;
    private final Map<StageId, SortedSet<StageId>> pendingOutflowMap;
    private final Queue<StageGroup> stageGroupQueue;
    private final Set<StageId> readyToRunStages = new HashSet<StageId>();
    private final Set<StageId> effectivelyFinishedStages = new HashSet<StageId>();
    private final Map<StageId, Int2ObjectMap<WorkOrder>> stageWorkOrders = new HashMap<StageId, Int2ObjectMap<WorkOrder>>();
    private final Map<StageId, OutputChannelMode> stageOutputChannelModes = new HashMap<StageId, OutputChannelMode>();
    private static final Set<String> RETRIABLE_ERROR_CODES = ImmutableSet.of((Object)"Canceled", (Object)"UnknownError", (Object)"WorkerRpcFailed");

    public ControllerQueryKernel(QueryDefinition queryDef, ControllerQueryKernelConfig config) {
        this.queryDef = queryDef;
        this.config = config;
        this.inflowMap = ImmutableMap.copyOf(ControllerQueryKernelUtils.computeStageInflowMap(queryDef));
        this.outflowMap = ImmutableMap.copyOf(ControllerQueryKernelUtils.computeStageOutflowMap(queryDef));
        this.pendingInflowMap = ControllerQueryKernelUtils.computeStageInflowMap(queryDef);
        this.pendingOutflowMap = ControllerQueryKernelUtils.computeStageOutflowMap(queryDef);
        this.stageGroupQueue = new ArrayDeque<StageGroup>(ControllerQueryKernelUtils.computeStageGroups(queryDef, config));
        this.initializeReadyToRunStages();
    }

    public List<StageId> createAndGetNewStageIds(InputSpecSlicerFactory slicerFactory, WorkerAssignmentStrategy assignmentStrategy, long maxInputBytesPerWorker) {
        this.createNewKernels(slicerFactory, assignmentStrategy, maxInputBytesPerWorker);
        return this.stageTrackers.values().stream().filter(controllerStageTracker -> controllerStageTracker.getPhase() == ControllerStagePhase.NEW).map(stageTracker -> stageTracker.getStageDefinition().getId()).collect(Collectors.toList());
    }

    public List<StageId> getEffectivelyFinishedStageIds() {
        return ImmutableList.copyOf(this.effectivelyFinishedStages);
    }

    public List<StageId> getActiveStages() {
        return ImmutableList.copyOf(this.stageTrackers.keySet());
    }

    public int getNonTerminalActiveStageCount() {
        int n = 0;
        for (ControllerStageTracker tracker : this.stageTrackers.values()) {
            if (tracker.getPhase().isTerminal() || tracker.getPhase() == ControllerStagePhase.RESULTS_READY) continue;
            ++n;
        }
        return n;
    }

    public StageId getStageId(int stageNumber) {
        return new StageId(this.queryDef.getQueryId(), stageNumber);
    }

    public boolean isDone() {
        return this.isSuccess() || this.stageTrackers.values().stream().anyMatch(tracker -> tracker.getPhase() == ControllerStagePhase.FAILED);
    }

    public void markSuccessfulTerminalStagesAsFinished() {
        for (StageId stageId : this.getActiveStages()) {
            ControllerStagePhase phase = this.getStagePhase(stageId);
            if (!phase.isSuccess() || phase != ControllerStagePhase.RESULTS_READY) continue;
            this.finishStage(stageId, false);
        }
    }

    public boolean isSuccess() {
        return this.stageTrackers.size() == this.queryDef.getStageDefinitions().size() && this.stageTrackers.values().stream().allMatch(tracker -> tracker.getPhase() == ControllerStagePhase.FINISHED);
    }

    public Int2ObjectMap<WorkOrder> createWorkOrders(int stageNumber, @Nullable Int2ObjectMap<Object> extraInfos) {
        Int2ObjectAVLTreeMap workerToWorkOrder = new Int2ObjectAVLTreeMap();
        ControllerStageTracker stageKernel = this.getStageTrackerOrThrow(this.getStageId(stageNumber));
        WorkerInputs workerInputs = stageKernel.getWorkerInputs();
        OutputChannelMode outputChannelMode = this.stageOutputChannelModes.get(stageKernel.getStageDefinition().getId());
        IntBidirectionalIterator intBidirectionalIterator = workerInputs.workers().iterator();
        while (intBidirectionalIterator.hasNext()) {
            int workerNumber = (Integer)intBidirectionalIterator.next();
            Object extraInfo = extraInfos != null ? extraInfos.get(workerNumber) : null;
            ExtraInfoHolder extraInfoHolder = stageKernel.getStageDefinition().getProcessorFactory().makeExtraInfoHolder(extraInfo);
            WorkOrder workOrder = new WorkOrder(this.queryDef, stageNumber, workerNumber, workerInputs.inputsForWorker(workerNumber), extraInfoHolder, this.config.getWorkerIds(), outputChannelMode, this.config.getWorkerContextMap());
            QueryValidator.validateWorkOrder(workOrder);
            workerToWorkOrder.put(workerNumber, (Object)workOrder);
        }
        this.stageWorkOrders.put(new StageId(this.queryDef.getQueryId(), stageNumber), (Int2ObjectMap<WorkOrder>)workerToWorkOrder);
        return workerToWorkOrder;
    }

    private void createNewKernels(InputSpecSlicerFactory slicerFactory, WorkerAssignmentStrategy assignmentStrategy, long maxInputBytesPerWorker) {
        StageGroup stageGroup;
        while ((stageGroup = this.stageGroupQueue.peek()) != null && this.readyToRunStages.contains(stageGroup.first()) && this.getNonTerminalActiveStageCount() + stageGroup.size() <= this.config.getMaxConcurrentStages()) {
            this.stageGroupQueue.poll();
            for (StageId stageId : stageGroup.stageIds()) {
                this.stageTrackers.put(stageId, this.createStageTracker(stageId, slicerFactory, assignmentStrategy, maxInputBytesPerWorker));
                this.stageOutputChannelModes.put(stageId, stageGroup.stageOutputChannelMode(stageId));
            }
            stageGroup.stageIds().forEach(this.readyToRunStages::remove);
        }
    }

    private ControllerStageTracker createStageTracker(StageId stageId, InputSpecSlicerFactory slicerFactory, WorkerAssignmentStrategy assignmentStrategy, long maxInputBytesPerWorker) {
        Int2IntAVLTreeMap stageWorkerCountMap = new Int2IntAVLTreeMap();
        Int2ObjectAVLTreeMap stagePartitionsMap = new Int2ObjectAVLTreeMap();
        Int2ObjectAVLTreeMap stageOutputChannelModeMap = new Int2ObjectAVLTreeMap();
        for (ControllerStageTracker stageTracker : this.stageTrackers.values()) {
            OutputChannelMode outputChannelMode;
            int stageNumber = stageTracker.getStageDefinition().getStageNumber();
            stageWorkerCountMap.put(stageNumber, stageTracker.getWorkerInputs().workerCount());
            if (stageTracker.hasResultPartitions()) {
                stagePartitionsMap.put(stageNumber, (Object)stageTracker.getResultPartitions());
            }
            if ((outputChannelMode = this.stageOutputChannelModes.get(stageTracker.getStageDefinition().getId())) == null) continue;
            stageOutputChannelModeMap.put(stageNumber, (Object)outputChannelMode);
        }
        return ControllerStageTracker.create(this.getStageDefinition(stageId), (Int2IntMap)stageWorkerCountMap, slicerFactory.makeSlicer((Int2ObjectMap<ReadablePartitions>)stagePartitionsMap, (Int2ObjectMap<OutputChannelMode>)stageOutputChannelModeMap), assignmentStrategy, this.config.getMaxRetainedPartitionSketchBytes(), maxInputBytesPerWorker);
    }

    private void initializeReadyToRunStages() {
        ArrayList<StageId> readyStages = new ArrayList<StageId>();
        Iterator<Map.Entry<StageId, SortedSet<StageId>>> pendingInflowIterator = this.pendingInflowMap.entrySet().iterator();
        while (pendingInflowIterator.hasNext()) {
            Map.Entry<StageId, SortedSet<StageId>> stageToInflowStages = pendingInflowIterator.next();
            if (!stageToInflowStages.getValue().isEmpty()) continue;
            readyStages.add(stageToInflowStages.getKey());
            pendingInflowIterator.remove();
        }
        this.readyToRunStages.addAll(readyStages);
    }

    public StageDefinition getStageDefinition(StageId stageId) {
        return this.queryDef.getStageDefinition(stageId);
    }

    public OutputChannelMode getStageOutputChannelMode(StageId stageId) {
        OutputChannelMode outputChannelMode = this.stageOutputChannelModes.get(stageId);
        if (outputChannelMode == null) {
            throw new ISE("No such stage[%s]", new Object[]{stageId});
        }
        return outputChannelMode;
    }

    public boolean canReadQueryResults() {
        StageId finalStageId = this.queryDef.getFinalStageDefinition().getId();
        ControllerStageTracker stageTracker = this.stageTrackers.get(finalStageId);
        if (stageTracker == null) {
            return false;
        }
        OutputChannelMode outputChannelMode = this.stageOutputChannelModes.get(finalStageId);
        if (outputChannelMode == OutputChannelMode.MEMORY) {
            return stageTracker.getPhase().isRunning();
        }
        return stageTracker.getPhase() == ControllerStagePhase.RESULTS_READY;
    }

    public ControllerStagePhase getStagePhase(StageId stageId) {
        return this.getStageTrackerOrThrow(stageId).getPhase();
    }

    public boolean isStageFinished(StageId stageId) {
        return this.getStagePhase(stageId) == ControllerStagePhase.FINISHED;
    }

    public boolean doesStageHaveResultPartitions(StageId stageId) {
        return this.getStageTrackerOrThrow(stageId).hasResultPartitions();
    }

    public ReadablePartitions getResultPartitionsForStage(StageId stageId) {
        return this.getStageTrackerOrThrow(stageId).getResultPartitions();
    }

    public IntSet getWorkersToSendPartitionBoundaries(StageId stageId) {
        return this.getStageTrackerOrThrow(stageId).getWorkersToSendPartitionBoundaries();
    }

    public void workOrdersSentForWorker(StageId stageId, int worker) {
        this.doWithStageTracker(stageId, stageTracker -> stageTracker.workOrderSentForWorker(worker));
    }

    public void partitionBoundariesSentForWorker(StageId stageId, int worker) {
        this.doWithStageTracker(stageId, stageTracker -> stageTracker.partitionBoundariesSentForWorker(worker));
    }

    public ClusterByPartitions getResultPartitionBoundariesForStage(StageId stageId) {
        return this.getStageTrackerOrThrow(stageId).getResultPartitionBoundaries();
    }

    public CompleteKeyStatisticsInformation getCompleteKeyStatisticsInformation(StageId stageId) {
        return this.getStageTrackerOrThrow(stageId).getCompleteKeyStatisticsInformation();
    }

    public boolean hasStageCollectorEncounteredAnyMultiValueField(StageId stageId) {
        return this.getStageTrackerOrThrow(stageId).collectorEncounteredAnyMultiValueField();
    }

    public Object getResultObjectForStage(StageId stageId) {
        return this.getStageTrackerOrThrow(stageId).getResultObject();
    }

    public void startStage(StageId stageId) {
        if (this.stageWorkOrders.get(stageId) == null) {
            throw new ISE("Work order not present for stage[%s]", new Object[]{stageId});
        }
        this.doWithStageTracker(stageId, stageTracker -> {
            if (stageTracker.getPhase() != ControllerStagePhase.NEW) {
                throw new ISE("Cannot start the stage: [%s]", new Object[]{stageId});
            }
            stageTracker.start();
        });
    }

    public void finishStage(StageId stageId, boolean strict) {
        if (strict && !this.effectivelyFinishedStages.contains(stageId)) {
            throw new IAE("Cannot mark the stage: [%s] finished", new Object[]{stageId});
        }
        this.doWithStageTracker(stageId, stageTracker -> {
            stageTracker.finish();
            this.effectivelyFinishedStages.remove(stageId);
        });
        this.stageWorkOrders.remove(stageId);
    }

    public WorkerInputs getWorkerInputsForStage(StageId stageId) {
        return this.getStageTrackerOrThrow(stageId).getWorkerInputs();
    }

    public void addPartialKeyStatisticsForStageAndWorker(StageId stageId, int workerNumber, PartialKeyStatisticsInformation partialKeyStatisticsInformation) {
        this.doWithStageTracker(stageId, stageTracker -> stageTracker.addPartialKeyInformationForWorker(workerNumber, partialKeyStatisticsInformation));
    }

    public void setDoneReadingInputForStageAndWorker(StageId stageId, int workerNumber) {
        this.doWithStageTracker(stageId, stageTracker -> stageTracker.setDoneReadingInputForWorker(workerNumber));
    }

    public void setResultsCompleteForStageAndWorker(StageId stageId, int workerNumber, Object resultObject) {
        this.doWithStageTracker(stageId, stageTracker -> stageTracker.setResultsCompleteForWorker(workerNumber, resultObject));
    }

    public MSQFault getFailureReasonForStage(StageId stageId) {
        return this.getStageTrackerOrThrow(stageId).getFailureReason();
    }

    public void failStage(StageId stageId) {
        this.doWithStageTracker(stageId, ControllerStageTracker::fail);
    }

    public IntSet getAllParticipatingWorkers() {
        IntAVLTreeSet retVal = new IntAVLTreeSet();
        for (ControllerStageTracker tracker : this.stageTrackers.values()) {
            retVal.addAll((IntCollection)tracker.getWorkerInputs().workers());
        }
        return retVal;
    }

    private ControllerStageTracker getStageTrackerOrThrow(StageId stageId) {
        ControllerStageTracker stageTracker = this.stageTrackers.get(stageId);
        if (stageTracker == null) {
            throw new IAE("Cannot find kernel corresponding to stage [%s] in query [%s]", new Object[]{stageId, this.queryDef.getQueryId()});
        }
        return stageTracker;
    }

    private WorkOrder getWorkOrder(int workerNumber, StageId stageId) {
        Int2ObjectMap<WorkOrder> stageWorkOrder = this.stageWorkOrders.get(stageId);
        if (stageWorkOrder == null) {
            throw new ISE("Stage[%d] work orders not found", new Object[]{stageId.getStageNumber()});
        }
        WorkOrder workOrder = (WorkOrder)stageWorkOrder.get(workerNumber);
        if (workOrder == null) {
            throw new ISE("Work order for worker[%d] not found for stage[%d]", new Object[]{workerNumber, stageId.getStageNumber()});
        }
        return workOrder;
    }

    private boolean readyToReadResults(StageId stageId, ControllerStagePhase newPhase) {
        if (this.stageOutputChannelModes.get(stageId) == OutputChannelMode.MEMORY) {
            if (this.getStageDefinition(stageId).doesSortDuringShuffle()) {
                return newPhase.isDoneReadingInput();
            }
            return newPhase == ControllerStagePhase.NEW;
        }
        return newPhase == ControllerStagePhase.RESULTS_READY;
    }

    private void doWithStageTracker(StageId stageId, Consumer<ControllerStageTracker> fn) {
        ControllerStageTracker stageTracker = this.getStageTrackerOrThrow(stageId);
        ControllerStagePhase phase = stageTracker.getPhase();
        fn.accept(stageTracker);
        if (phase != stageTracker.getPhase()) {
            this.registerStagePhaseChange(stageId, stageTracker.getPhase());
        }
    }

    private void registerStagePhaseChange(StageId stageId, ControllerStagePhase newPhase) {
        boolean hasDependentStages;
        if (this.readyToReadResults(stageId, newPhase)) {
            for (StageId dependentStageId : (Set)this.outflowMap.get((Object)stageId)) {
                if (!this.pendingInflowMap.containsKey(dependentStageId)) continue;
                this.pendingInflowMap.get(dependentStageId).remove(stageId);
                if (!this.pendingInflowMap.get(dependentStageId).isEmpty()) continue;
                this.readyToRunStages.add(dependentStageId);
                this.pendingInflowMap.remove(dependentStageId);
            }
        }
        if (newPhase.isSuccess() || !this.config.isFaultTolerant() && newPhase.isDoneReadingInput()) {
            for (StageId inputStage : (Set)this.inflowMap.get((Object)stageId)) {
                if (!this.pendingOutflowMap.containsKey(inputStage)) continue;
                this.pendingOutflowMap.get(inputStage).remove(stageId);
                if (!this.pendingOutflowMap.get(inputStage).isEmpty()) continue;
                this.pendingOutflowMap.remove(inputStage);
                if (!ControllerStagePhase.FINISHED.canTransitionFrom(this.stageTrackers.get(inputStage).getPhase())) continue;
                this.effectivelyFinishedStages.add(inputStage);
            }
        }
        boolean bl = hasDependentStages = this.pendingOutflowMap.containsKey(stageId) && !this.pendingOutflowMap.get(stageId).isEmpty();
        if (!hasDependentStages) {
            boolean isFinalStage = this.queryDef.getFinalStageDefinition().getId().equals(stageId);
            if (isFinalStage && newPhase == ControllerStagePhase.RESULTS_READY) {
                this.effectivelyFinishedStages.add(stageId);
            } else if (!isFinalStage && ControllerStagePhase.FINISHED.canTransitionFrom(newPhase)) {
                this.effectivelyFinishedStages.add(stageId);
            }
        }
    }

    @VisibleForTesting
    ControllerStageTracker getControllerStageTracker(int stageNumber) {
        return this.stageTrackers.get(new StageId(this.queryDef.getQueryId(), stageNumber));
    }

    public List<WorkOrder> getWorkInCaseWorkerEligibleForRetryElseThrow(int workerNumber, MSQFault msqFault) {
        if (ControllerQueryKernel.isRetriableFault(msqFault)) {
            return this.getWorkInCaseWorkerEligibleForRetry(workerNumber);
        }
        throw new MSQException(msqFault);
    }

    public static boolean isRetriableFault(MSQFault msqFault) {
        String errorCode = msqFault instanceof WorkerFailedFault ? MSQFaultUtils.getErrorCodeFromMessage(((WorkerFailedFault)msqFault).getErrorMsg()) : msqFault.getErrorCode();
        log.debug("Parsed out errorCode[%s] to check eligibility for retry", new Object[]{errorCode});
        return RETRIABLE_ERROR_CODES.contains(errorCode);
    }

    private List<WorkOrder> getWorkInCaseWorkerEligibleForRetry(int worker) {
        ArrayList<StageId> trackedSet = new ArrayList<StageId>(this.getActiveStages());
        trackedSet.removeAll(this.effectivelyFinishedStages);
        ArrayList<WorkOrder> workOrders = new ArrayList<WorkOrder>();
        for (StageId stageId : trackedSet) {
            this.doWithStageTracker(stageId, stageTracker -> {
                if (ControllerStagePhase.RETRYING.canTransitionFrom(stageTracker.getPhase()) && stageTracker.retryIfNeeded(worker)) {
                    workOrders.add(this.getWorkOrder(worker, stageId));
                }
            });
        }
        return workOrders;
    }

    public Map<StageId, Set<Integer>> getStagesAndWorkersToFetchClusterStats() {
        ArrayList<StageId> trackedSet = new ArrayList<StageId>(this.getActiveStages());
        trackedSet.removeAll(this.getEffectivelyFinishedStageIds());
        HashMap<StageId, Set<Integer>> stageToWorkers = new HashMap<StageId, Set<Integer>>();
        for (StageId stageId : trackedSet) {
            ControllerStageTracker controllerStageTracker = this.getStageTrackerOrThrow(stageId);
            if (!controllerStageTracker.getStageDefinition().mustGatherResultKeyStatistics()) continue;
            stageToWorkers.put(stageId, controllerStageTracker.getWorkersToFetchClusterStatisticsFrom());
        }
        return stageToWorkers;
    }

    public void startFetchingStatsFromWorker(StageId stageId, Set<Integer> workers) {
        this.doWithStageTracker(stageId, stageTracker -> {
            Iterator iterator = workers.iterator();
            while (iterator.hasNext()) {
                int worker = (Integer)iterator.next();
                stageTracker.startFetchingStatsFromWorker(worker);
            }
        });
    }

    public void mergeClusterByStatisticsCollectorForAllTimeChunks(StageId stageId, int workerNumber, ClusterByStatisticsSnapshot clusterByStatsSnapshot) {
        this.doWithStageTracker(stageId, stageTracker -> stageTracker.mergeClusterByStatisticsCollectorForAllTimeChunks(workerNumber, clusterByStatsSnapshot));
    }

    public void mergeClusterByStatisticsCollectorForTimeChunk(StageId stageId, int workerNumber, Long timeChunk, ClusterByStatisticsSnapshot clusterByStatsSnapshot) {
        this.doWithStageTracker(stageId, stageTracker -> stageTracker.mergeClusterByStatisticsCollectorForTimeChunk(workerNumber, timeChunk, clusterByStatsSnapshot));
    }

    public boolean allPartialKeyInformationPresent(StageId stageId) {
        return this.getStageTrackerOrThrow(stageId).allPartialKeyInformationFetched();
    }

    @Nullable
    public Boolean isStageOutputEmpty(StageId stageId) {
        CompleteKeyStatisticsInformation completeKeyStatistics = this.getCompleteKeyStatisticsInformation(stageId);
        if (completeKeyStatistics == null || !completeKeyStatistics.isComplete()) {
            return null;
        }
        return completeKeyStatistics.getTimeSegmentVsWorkerMap().size() == 0;
    }
}

